<?php
die('.');
include('includes/application_top.php');
$groupId = isset($_GET['group_id']) ? (int)$_GET['group_id'] : 28;
$categoryId = isset($_GET['category_id']) ? (int)$_GET['category_id'] : 46;
$languageId = 2;
if (isset($_GET['set']) && is_array($_GET['set'])) {
    foreach ($_GET['set'] as $val) {
        $val = (int) $val;
        if ($val > 0) {
            $selectedValues[] = $val;
        }
    }
}

// Alle Merkmale der Gruppe inkl. deutscher Bezeichnung laden
$merkmale = yes_query("SELECT pc.products_characteristic_id, pcd.title AS merkmal_title
	FROM products_characteristic pc
	JOIN products_characteristic_description pcd 
	ON pcd.products_characteristic_id = pc.products_characteristic_id
	WHERE pc.groups_id =:gid AND pcd.language_id =:lid AND pc.deny_filter = 0
	ORDER BY pc.sort_order", 
	['gid'=>$groupId,'lid'=>$languageId]
);

// Merkmalwerte pro Merkmal vorbereiten (nur wenn ein Artikel in der Kategorie damit verknüpft ist)
$werteProMerkmal = [];

$werteProMerkmal = [];

foreach ($merkmale as $merkmal) {
    $merkmalId = $merkmal['products_characteristic_id'];

    $sql = "SELECT DISTINCT pcs.products_characteristic_set_id, pcsd.title AS merkmalwert_title
        FROM products_characteristic_set pcs
        JOIN products_characteristic_set_description pcsd 
          ON pcsd.products_characteristic_set_id = pcs.products_characteristic_set_id
        JOIN products_to_characteristics ptc 
          ON ptc.products_characteristic_set_id = pcs.products_characteristic_set_id
        JOIN products p 
          ON p.products_id = ptc.products_id AND p.products_status = 1
        JOIN products_to_categories ptcat 
          ON ptcat.products_id = p.products_id
        WHERE pcs.products_characteristic_id =:pcid
          AND pcsd.language_id =:lid
          AND ptcat.categories_id = :catid";

    $params = ['pcid'=>$merkmalId, 'lid'=>$languageId, 'catid'=>$categoryId];

    // Filter anwenden: nur Artikel berücksichtigen, die alle gewählten Merkmalwerte besitzen
    if (!empty($selectedValues)) {
        // Aktuellen Merkmalwert ausschließen (nicht sich selbst filtern)
        $relevantFilter = array_filter($selectedValues, function($val) use ($merkmalId) {
            $stmt = yes_query("SELECT products_characteristic_id
                FROM products_characteristic_set
                WHERE products_characteristic_set_id =:id",
                ['id'=>$val],
                true
            );
            return $stmt['products_characteristic_id'] != $merkmalId;
        });

        if (!empty($relevantFilter)) {
		$namedPlaceholders = [];
		$namedParams = [];

		foreach (array_values($relevantFilter) as $index => $val) {
		    $key = ':rf' . str_pad($index + 1, 2, '0', STR_PAD_LEFT); // z. B. :rf01, :rf02, ...
		    $namedPlaceholders[] = $key;
		    $namedParams[$key] = $val;
		}

		$placeholdersString = implode(', ', $namedPlaceholders);

		$sql .= "
		    AND p.products_id IN (
			SELECT ptc2.products_id
			FROM products_to_characteristics ptc2
			WHERE ptc2.products_characteristic_set_id IN ($placeholdersString)
			GROUP BY ptc2.products_id
			HAVING COUNT(DISTINCT ptc2.products_characteristic_set_id) = " . count($relevantFilter) . "
		    )
		";
		$params = array_merge($params, $namedParams);
        }
    }

    $sql .= " ORDER BY pcs.sort_order, pcsd.title";
    try{
	    $werte = yes_query($sql,$params);
    }catch(Exception $e){
    	echo $e->getMessage();
    	yes_debug($params);
    	die($sql);
    }
    if ($werte) {
        $werteProMerkmal[] = [
            'merkmal_id' => $merkmalId,
            'merkmal_title' => $merkmal['merkmal_title'],
            'werte' => $werte
        ];
    }
}
if(!is_countable($selectedValues)){
	$selectedValues = [];
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Merkmal-Filter für Produktgruppe</title>
</head>
<body>

<h2>Merkmal-Filter</h2>

<form method="get">
    <input type="hidden" name="group_id" value="<?= $groupId ?>">
    <input type="hidden" name="category_id" value="<?= $categoryId ?>">

    <?php foreach ($werteProMerkmal as $merkmal): ?>
        <label><strong><?= htmlspecialchars($merkmal['merkmal_title']) ?>:</strong></label>
        <select name="set[]" onchange="this.form.submit()">
            <option value="">-- wählen --</option>
            <?php foreach ($merkmal['werte'] as $wert): ?>
                <option value="<?= $wert['products_characteristic_set_id'] ?>" 
                    <?= in_array($wert['products_characteristic_set_id'], $selectedValues) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($wert['merkmalwert_title']) ?>
                </option>
            <?php endforeach; ?>
        </select>
        <br><br>
    <?php endforeach; ?>
</form>

</body>
</html>


