<?php
/**

GEPRUEFT+OPTIMIERT - Keine Sicherheitsluecken

**/


// START configure the categories depth level

/* EXAMPLE CATEGORY STRUCT
   (X) = depth level
toys (0)
    boys (1)
        cars (2)
            porsche (3)
            bmw (3)
        weapons (2)
            pistols (3)
            guns (3)
    girls (1)
        dolls (2)
            barbies (3)
            other (3)
        handicrafts (2)
            jewelry (3)
            necklace (3)

   


- a depth of 0: only "toys"
- a depth of 1: only "toys", "boys" and "girls" 
    ...
*/ 
// the value -1: no depth restriction
define('CATEGORIES_STRUCT_MAX_DEPTH',5);

// END configure the categories depth level


class category_item
{
    var $categories_id;
    var $depth;
    var $categories_name;
    var $parent_id;
	var $link_id;

    function category_item($cat_id, $depth, $cat_title, $cat_parent_id,$cat_link_id)
    {
        $this->categories_id = $cat_id;
        $this->depth = $depth;
        $this->categories_name = 'A'.$cat_title;
        $this->parent_id = $cat_parent_id;
	$this->link_id = $cat_link_id;
    }
}

/*************************************************************/
// Builds the category list for the category select

$list = array();

function build_list($cat_array, $item = '', $depth = 0)
{
    global $template;
    global $list;

    foreach($cat_array as $category)
    {
        $loop_item = "$item$category[categories_name]";

        $category_item = new category_item($category['categories_id'], $depth, $category['categories_name'], $category['parent_id'], $category['link_id']);
        $list[] = $category_item;

        if(count($category['children']) > 0)
        {
            $depth++;
            build_list($category['children'], $loop_item." > ", $depth);
            $depth--;
        }

        $loop_item = '';
    }

    return $list;
}

/*************************************************************/
// Adds the object to the children array of the object with 
// a cat_id equal to $parent_id

function tree_add($tree, $parent_id, $object, $cat_id)
{
    // Only start from the given cat_id, ignore all other roots

    if($parent_id == 0 and $object['categories_id'] == $cat_id)
    {
        $tree[$object['categories_id']] = $object;
        return $tree;
    }
    if($tree)
    {
        foreach($tree as $key => $value)
        {
            $current = $tree[$key];
            // If this is the parent, add the object to it's children array
            if($current['categories_id'] == $parent_id)
            {
                $tree[$key]['children'][$object['categories_id']] = $object;
            }
            else
            {
                // If it's not in this level, look a level deeper on the current object.
                $tree[$key]['children'] = tree_add($current['children'], $parent_id, $object, $cat_id);
            }
        }
    }

    return $tree;
}

require_once(DIR_FS_INC.'yes_multisort.inc.php');
function _struct_get_categories($categories_array = '', $parent_id = '0',$level = 0) {
	$group_check = '';
	if (GROUP_CHECK == 'true') {
		$group_check = "and c.group_permission_".$_SESSION['customers_status']['customers_status_id']."=1 ";
	}
	$parent_id = xtc_db_prepare_input($parent_id);

	if (!is_array($categories_array)) $categories_array = array();

	$categories_query = "select
			              c.categories_id, cd.categories_name,c.categories_image,c.categories_additional_image,c.parent_id,c.link_id,c.sort_order 
			              from " . TABLE_CATEGORIES . " c left join " . TABLE_CATEGORIES_DESCRIPTION . " cd using(categories_id)
			               where parent_id = '" . xtc_db_input($parent_id) . "'
			               and c.categories_status != 0
			               and cd.language_id = '" . $_SESSION['languages_id'] . "' ".$group_check;
	$categories_query .= "                                   order by sort_order, cd.categories_name";
	$categories_query  = yes_db_query($categories_query,true);
	if(yes_db_num_rows($categories_query)){
	    foreach($categories_query as $categories) {
	      $categories['id'] = $categories['categories_id'];
	      $categories['text'] = $categories['categories_name'];
	      $categories['level'] = $level;
	      $categories_array[] = $categories;
	      if ($categories['categories_id'] != $parent_id) {
		if(CATEGORIES_STRUCT_MAX_DEPTH == -1 or CATEGORIES_STRUCT_MAX_DEPTH > $level){
			$categories_array = _struct_get_categories($categories_array, $categories['categories_id'], $level+1);
		}
	      }
	    }
	}

	return $categories_array;
}
$_categories = array();
$_categories_array = _struct_get_categories($_categories,0);
$_categories_array = yes_multisort($_categories_array,'level',true);
$level_num = 0;
foreach($_categories_array as $c){
	if($level_num < $c['level']){
		$level_num = $c['level'];
	}
}
$level = array();
for($i=0;$i<=$level_num;$i++){
	$level[$i] = array();
	foreach($_categories_array as $c){
		if($i == $c['level']){
			$level[$i][] = $c;
		}
	}
	// HIER ENTSCHEIDEN WIE INNERHALB DES LEVELS SORTIERT WIRD
	// $level[$i] = yes_multisort($level[$i],'text');
	$level[$i] = yes_multisort($level[$i],'sort_order');
}
$_cats = array();
foreach($level as $l){
	$_cats = array_merge($_cats,$l);
}
$_categories_array = $_cats;
$cat_tree = array();
foreach($_categories_array as $category){
    $children = array();

    $category['children'] = $children;

    $cat_id = $category['categories_id'];
    $cat_parent_id = $category['parent_id'];

    $cat_tree = tree_add($cat_tree, $cat_parent_id, $category, $cat_id);
}
$cat_list = build_list($cat_tree);
$smarty->assign('CATEGORIES_STRUCT', $cat_tree);






