<?php
/* -----------------------------------------------------------------------------------------
   $Id: shop_content.php,v 1.44 2020/08/03 07:54:43 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(conditions.php,v 1.21 2003/02/13); www.oscommerce.com 
   (c) 2003	 nextcommerce (shop_content.php,v 1.1 2003/08/19); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'yesCaptcha.php');
require_once(DIR_FS_INC.'yes_get_shop_content.inc.php');
$captcha_lang = (isset($_SESSION['language']) and $_SESSION['language'] == 'english') ? 'english' : 'german';
$captcha = new yesTextCaptcha($captcha_lang);
if(defined('MODULE_OTHER_TURNSTILE_STATUS') and constant('MODULE_OTHER_TURNSTILE_STATUS') == 'True'){
    require_once(DIR_WS_MODULES.'other/turnstile.php');
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/turnstile.php');
    $turnstile = true;
    $turnstile_class = new \turnstile();
}

function sanitize_name(string $name): string {
    // trim + Whitespaces normalisieren
    $name = trim($name);
    $name = preg_replace('/\s+/u', ' ', $name);

    // Header-/Control-Zeichen entfernen (gegen Header-Injection)
    $name = str_replace(["\r", "\n"], '', $name);
    $name = preg_replace('/\p{C}+/u', '', $name); // alle Steuerzeichen

    // HTML strikt verbieten
    if ($name !== strip_tags($name) || preg_match('/<[^>]+>/', $name)) {
        return '';
    }

    // Offensichtliche Spam-/URL-Muster verbieten
    if (preg_match('~https?://|www\.|@[A-Za-z0-9._-]+~i', $name)) {
        return '';
    }

    // Erlaubte Zeichen:
    // Buchstaben (alle Sprachen) + Kombimarks + Ziffern + Leerzeichen
    // plus unkritische Satzzeichen: - ' . , ( )
    // Länge 1–60
    if (!preg_match('/^[\p{L}\p{M}\p{N}\s\-\'.(),]{1,60}$/u', $name)) {
        return '';
    }

    // Optionale Feinheiten: doppelte Satzzeichen/Bindestriche glätten
    $name = preg_replace('/\s*([\-\'.,()])\s*/u', '$1 ', $name);
    $name = preg_replace('/\s{2,}/u', ' ', $name);

    return trim($name);
}
// create smarty elements
$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );
// include needed functions
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_textarea_field.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_email.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_render_vvcode.inc.php');
require_once(DIR_FS_INC . 'xtc_random_charcode.inc.php');
require_once(DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_password.inc.php');
$coID = yes_getIntFromRequest('coID');
if($coID < 1){
    xtc_redirect(FILENAME_DEFAULT);
}
$items = \YES4Trade\Model\content_manager::get_by_content_group_and_languages_id($coID, (int)$_SESSION['languages_id']);
if(!sizeOf($items)){
    xtc_redirect(xtc_href_link('index.php?error_msg=Shop%20Content%20Item%20not%20found'));
}
$item = current($items);
$shop_content_data = $item->toArray();
$breadcrumb->add($shop_content_data['content_title'], xtc_href_link(FILENAME_CONTENT.'?coID='.$coID));
if ($_GET['coID']!=7 and !isset($_REQUEST['popup'])) {
	require(DIR_WS_INCLUDES . 'header.php');
}
if ($coID==7 && $_GET['action']=='success') {
	require(DIR_WS_INCLUDES . 'header.php');
}
$smarty->assign('CONTENT_HEADING',$shop_content_data['content_heading']);
if ($_GET['coID']==7) {
	// KONTAKTFORM
	$error = false;
	$json_response = (isset($_REQUEST['json_response']) and $_REQUEST['json_response'] == 1) ? true : false;
	$json_return = array('error'=>'','success'=>false);
	if (isset($_GET['action']) && ($_GET['action'] == 'send')) {
            if(!$turnstile and defined('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS') and MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS == 'True'){
                require_once(DIR_WS_INCLUDES.'modules/other/google_recaptcha_v2.php');
                if(empty($_POST['g-recaptcha-response'])){
                    $error = true;
                    $smarty->assign('error_message',MODULE_OTHER_GOOGLE_RECAPTCHA_V2_ERROR_MESSAGE);
                }
                if(!$error){
                    $gr = new google_recaptcha_v2();
                    if(!$gr->validate( $_POST['g-recaptcha-response'] )){
                        $error = true;
                        $smarty->assign('error_message',MODULE_OTHER_GOOGLE_RECAPTCHA_V2_ERROR_MESSAGE);
                    }
                }
            }else{
                if(!$turnstile){
                    $msg = $captcha->check(false); // false = _POST
                    if(isset($_POST['captcha_result'])){
                        $captcha_success = ($msg == $captcha->lng['captcha_incorrect']) ? false : true;
                    }else{
                        if(!isset($_SESSION['vvcode']) or empty($_SESSION['vvcode'])){
                                $captcha_success = false;    		
                        }else{
                                $captcha_success = $_POST['vvcode'] == $_SESSION['vvcode'];
                        }
                    }
                }else{
                    $captcha_success = false;
                    if($turnstile_class->verify()){
                        $captcha_success = true;
                    }
                }
                if(!$captcha_success){
			        // error report hier einbauen
                    if($turnstile){
                        $errM = TEXT_CAPTCHA_FAILED;
                    }else{
                        if(isset($_POST['captcha_result'])){
                            $errM = $captcha->lng['captcha_incorrect'].'. '.$captcha->lng['captcha_no_input'];
                        }else{
                            $errM = ERROR_CAPTCHA;
                        }
                    }
                    $smarty->assign('error_message',$errM);
                    $json_return['error'] = yes_encode_string($errM);
                    $error = true;
        		}
            }
            if (!$error and xtc_validate_email(trim($_POST['email']))) {

                // BOF - EMAIL AN ANFRAGENDEN - TICKET 3569
                if(defined('CONTACT_US_CONFIRMATION_CONTENT_ID') and !empty(constant('CONTACT_US_CONFIRMATION_CONTENT_ID'))){
                    $send_confirmation = false;
                    $cuID = intval(constant('CONTACT_US_CONFIRMATION_CONTENT_ID'));
                    if($cuID > 0){
                        $content = yes_get_shop_content($cuID, $_SESSION['languages_id']);
                        if(is_countable($content) and isset($content['content_text']) and !empty($content['content_text'])){
                            $send_confirmation = true;
                        }
                    }
                }
                if($send_confirmation){

                    $send_name = sanitize_name($_POST['name']);
                    if(empty($send_name)){
                        $send_name = 'Kunde/Kundin';
                    }
                    
                    $anfrage_body = str_replace('{NAME}',$send_name,$content['content_text']);
                    $anfrage_body = str_replace('{EMAIL}',$_POST['email'],$anfrage_body);
                    xtc_php_mail(
                            CONTACT_US_EMAIL_ADDRESS,
                            CONTACT_US_NAME,
                            $_POST['email'],
                            $send_name,
                            '',
                            CONTACT_US_EMAIL_ADDRESS,
                            CONTACT_US_NAME,
                            '',
                            '',
                            CONTACT_US_EMAIL_SUBJECT,
                            nl2br($anfrage_body),
                            $anfrage_body
                    );
                }
                // EOF - EMAIL AN ANFRAGENDEN - TICKET 3569

                $message_body = sprintf(
                        "Name: %s, Email: %s schrieb folgende Kontaktanfrage:\r\n%s",
                        $send_name,$_POST['email'],
                        xtc_db_prepare_input($_POST['message_body'])
                );
                xtc_php_mail(
                        CONTACT_US_EMAIL_ADDRESS,
                        $send_name,
                        CONTACT_US_EMAIL_ADDRESS,
                        CONTACT_US_NAME,
                        CONTACT_US_FORWARDING_STRING,
                        $_POST['email'],
                        $send_name,
                        '',
                        '',
                        CONTACT_US_EMAIL_SUBJECT,
                        nl2br($message_body),
                        $message_body
                );
                if (empty($mail_error) and !$json_response) {
                    header('Location: '.FILENAME_CONTENT.'?action=success&coID='.$_GET['coID']);
                }else if(!empty($mail_error)){
                    $smarty->assign('error_message',$mail_error);
                    $error = true;
                    $json_return['error'] = yes_encode_string($mail_error);
                }
            }else{
                if(!$error){
                    // error report hier einbauen
                    $smarty->assign('error_message',ERROR_MAIL);
                    $json_return['error'] = yes_encode_string(ERROR_MAIL);
                    $error = true;
                }
            }
	}
	if($json_response){
	    if(!$error) 
		$json_return['success'] = true;
	    header('Content-Type: text/html; charset='.CHARSET);
	    die(json_encode($json_return));
	}
        
        if(defined('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS') and MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS == 'True'){
            $smarty->assign('GOOGLE_RECAPTCHA',true);
        }
	$smarty->assign(array(
            'CONTACT_HEADING'=>$shop_content_data['content_title'],
            'VVIMG'=>(!$turnstile)?'<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES) . '" />':'',
            'INPUT_CODE'=>(!$turnstile)?xtc_draw_input_field('vvcode','','size="6" maxlenght="6"',false,'',false):'',
            'YES_CAPTCHA'=>($turnstile)?$turnstile_class->create():$captcha->create()
        ));
	
	if (isset($_GET['action']) && ($_GET['action'] == 'success')) {
		$smarty->assign('success','1');
		$smarty->assign('BUTTON_CONTINUE','<a href="'.xtc_href_link(FILENAME_DEFAULT).'">'.xtc_image_button('button_continue.gif', IMAGE_BUTTON_CONTINUE).'</a>');
	}else{
		if ($shop_content_data['content_file']!=''){
			if (strpos($shop_content_data['content_file'],'.txt')) {
				echo '<pre>';
			}
			include(DIR_FS_CATALOG.'media/content/'.$shop_content_data['content_file']);
			if (strpos($shop_content_data['content_file'],'.txt')) {
				echo '</pre>';
			}
		}else{
			$contact_content= $shop_content_data['content_text'];
		}
		if(!isset($_REQUEST['popup'])){
			require(DIR_WS_INCLUDES . 'header.php');
		}
		$smarty->assign('CONTACT_CONTENT',$contact_content);
		$smarty->assign('FORM_ACTION',xtc_draw_form('contact_us', FILENAME_CONTENT.'?action=send&coID='.$_GET['coID'],'POST'));
		$smarty->assign('INPUT_NAME',xtc_draw_input_field('name', ($error ? $_POST['name'] : $first_name)));
		$smarty->assign('INPUT_EMAIL',xtc_draw_input_field('email', ($error ? $_POST['email'] : $email_address)));
		$smarty->assign('INPUT_TEXT',xtc_draw_textarea_field('message_body', 'soft', 50, 15, xtc_db_prepare_input($_POST['message_body'])));
                if(defined('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS') and MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS == 'True'){
                    $smarty->assign(array(
                        'BUTTON_SUBMIT'=>'<input type="submit" value="'.IMAGE_BUTTON_CONTINUE.'" />',
                        'GOOGLE_RECAPTCHA_V2_SITE_KEY'=>MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SITE_KEY
                    ));
                }else{
                    $smarty->assign('BUTTON_SUBMIT',xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));
                }
		if(isset($_SESSION['customer_id']) and $_SESSION['customer_id'] > 0){
                    $customer_data_query = xtc_db_query(sprintf(
                        "SELECT customers_email_address FROM customers WHERE customers_id='%s'",
                        $_SESSION['customer_id']
                    ));
                    $customer_data = xtc_db_fetch_array($customer_data_query);
                    $smarty->assign('CUSTOMER_DATA',array(
                        'customer_first_name' => $_SESSION['customer_first_name'],
                        'customer_last_name' => $_SESSION['customer_last_name'],
                        'customers_email_address' => $customer_data['customers_email_address']
                    ));
		}
	}
	$smarty->assign('language', $_SESSION['language']);
	$smarty->caching = 0;
	$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/contact_us.html');
}else{
	if (!empty($shop_content_data['content_file'])){
            ob_start();

            if (strpos($shop_content_data['content_file'],'.txt')){
                    echo '<pre>';
            }
            $ext = current(array_reverse(explode('.',strtolower($shop_content_data['content_file']))));
            $allowed = ['php','htm','html'];
            if(in_array($ext,$allowed)){
                include(DIR_FS_CATALOG.'media/content/'.$shop_content_data['content_file']);
            }else{
                xtc_redirect(HTTPS_SERVER.'media/content/'.$shop_content_data['content_file']);
            }
            if (strpos($shop_content_data['content_file'],'.txt')){
                    echo '</pre>';
            }
            $smarty->assign('file',ob_get_contents());
            ob_end_clean();
	} else {
		$content_body = $shop_content_data['content_text'];
	}
	$smarty->assign('CONTENT_BODY',$content_body);

	$smarty->assign('BUTTON_CONTINUE','<a href="javascript:history.back(1)">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>');
	$smarty->assign('language', $_SESSION['language']);
	$smarty->assign('CONTENT_ID',$coID);
	// set cache ID
	if (USE_CACHE=='false') {
            $smarty->caching = 0;
            $main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/content.html');
	} else {
            $smarty->caching = 1;
            $smarty->cache_lifetime=CACHE_LIFETIME;
            $smarty->cache_modified_check=CACHE_CHECK;
            $cache_id = $_SESSION['language'].$shop_content_data['content_id'];
            $main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/content.html',$cache_id);
	}
}

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')){
	$smarty->load_filter('output', 'note');
}
if(!isset($_REQUEST['popup'])){
	$smarty->display(CURRENT_TEMPLATE . '/index.html');
}else{
	echo $main_content;
}
include ('includes/application_bottom.php');
