<?php

/**
 * This file takes hash as request and changes the status of the order
 */
include ('includes/application_top.php');
if (file_exists(DIR_WS_CLASSES . 'secupay_api.php')) {
    require_once(DIR_WS_CLASSES . 'secupay_api.php');
} else {
    require_once("../" . DIR_WS_CLASSES . 'secupay_api.php');
}

$json = file_get_contents('php://input');
$data = json_decode($json);
if($data->action == 'check_status'){
    $language = 'de_DE';	
    $sp_log = strcmp(MODULE_PAYMENT_SPINV_LOGGING, 'Ja') == 0 ? true : false;
    $requestData = array(
            'data'=>array(
                    'apikey'=>MODULE_PAYMENT_SECUPAY_APIKEY,
                    'hash'=>$data->hash
            )
    );
    $sp_api = new secupay_api($requestData, 'status', 'application/json', $sp_log, $language);
    $api_return = $sp_api->request();
    die(json_encode($api_return->data));
}


try {
    include ('secupay_conf.php');
    $hash = xtc_db_input($_POST['hash']);
    $api_key = xtc_db_input($_POST['apikey']);
    $payment_status = xtc_db_input($_POST['payment_status']);
    $comment = xtc_db_input($_POST['hint']);
    $payment_type = xtc_db_input($_REQUEST['payment_type']);
    $referer = parse_url($_SERVER['HTTP_REFERER']);

    if (isset($referer['host']) && (strpos($referer['host'],'secupay-ag.de')>-1 or strpos($referer['host'],'api.secupay.ag')>-1) ) {
		if (isset($api_key) && $api_key === MODULE_PAYMENT_SECUPAY_APIKEY) {
			// select from secupay_transaction_order table
			try {
                            $order_nr_row = yes_query(
                                "SELECT ordernr FROM secupay_transaction_order WHERE `hash` =:hash",
                                ['hash'=> $hash],
                                true
                            );
                            $order_id = $order_nr_row['ordernr'];
			} catch (Exception $e) {
                            secupay_log(SECUPAY_PUSH_LOG, ' status_push - get ordernr - EXCEPTION: ' . $e->getMessage());			
			}

			if (!isset($order_id) || !is_numeric($order_id)) {
                            $response = 'ack=Disapproved&error=no+matching+order+found+for+hash';
			} else {

				switch ($payment_type) {
					case "debit":
						$order_status_waiting = MODULE_PAYMENT_SPLS_ORDER_STATUS_ID;
						$order_status_accepted = MODULE_PAYMENT_SPLS_ORDER_STATUS_ACCEPTED_ID;
						$order_status_denied = MODULE_PAYMENT_SPLS_ORDER_STATUS_DENIED_ID;
						$order_status_issue = MODULE_PAYMENT_SPLS_ORDER_STATUS_ISSUE_ID;
						$order_status_void = MODULE_PAYMENT_SPLS_ORDER_STATUS_VOID_ID;
						$order_status_authorized = MODULE_PAYMENT_SPLS_ORDER_STATUS_AUTHORIZED_ID;
						break;
					case "creditcard":
						$order_status_waiting = MODULE_PAYMENT_SPKK_ORDER_STATUS_ID;
						$order_status_accepted = MODULE_PAYMENT_SPKK_ORDER_STATUS_ACCEPTED_ID;
						$order_status_denied = MODULE_PAYMENT_SPKK_ORDER_STATUS_DENIED_ID;
						$order_status_issue = MODULE_PAYMENT_SPKK_ORDER_STATUS_ISSUE_ID;
						$order_status_void = MODULE_PAYMENT_SPKK_ORDER_STATUS_VOID_ID;
						$order_status_authorized = MODULE_PAYMENT_SPKK_ORDER_STATUS_AUTHORIZED_ID;
						break;
					case "invoice":
						$order_status_waiting = MODULE_PAYMENT_SPINV_ORDER_STATUS_ID;
						$order_status_accepted = MODULE_PAYMENT_SPINV_ORDER_STATUS_ACCEPTED_ID;
						$order_status_denied = MODULE_PAYMENT_SPINV_ORDER_STATUS_DENIED_ID;
						$order_status_issue = MODULE_PAYMENT_SPINV_ORDER_STATUS_ISSUE_ID;
						$order_status_void = MODULE_PAYMENT_SPINV_ORDER_STATUS_VOID_ID;
						$order_status_authorized = MODULE_PAYMENT_SPINV_ORDER_STATUS_AUTHORIZED_ID;
						break;
					default :
						$response = 'ack=Disapproved&error=payment_type+not+supported';
						break;
				}

				if (isset($order_status_accepted)) {

					//get order status
					try {
                                            $status_query_row = yes_query(sprintf(
                                                "SELECT orders_status FROM %s WHERE orders_id =:orders_id",
                                                    TABLE_ORDERS
                                                ),['orders_id'=> $order_id],
                                                true
                                            );
                                            $original_order_status_id = $status_query_row['orders_status'];
                                            secupay_log(SECUPAY_PUSH_LOG, ' status_push - original_order_status_id: ' . $original_order_status_id);
					} catch (Exception $e) {
                                            secupay_log(SECUPAY_PUSH_LOG, ' status_push - get orderstatus - EXCEPTION: ' . $e->getMessage());			
					}
				
					switch ($payment_status) {
						case 'accepted':
                                                if ($original_order_status_id !== $order_status_waiting) {
                                                    //don't overwrite, order status changed from other source
                                                    try {
                                                        $orders_status_name_row = yes_query(sprintf(
                                                            "SELECT orders_status_name FROM %s WHERE orders_status_id =:status_id LIMIT 1",
                                                                TABLE_ORDERS_STATUS
                                                            ),['status_id'=>$original_order_status_id],
                                                            true
                                                        );
                                                        $orders_status_name = $orders_status_name_row['orders_status_name'];
                                                    } catch (Exception $e) {
                                                        secupay_log(SECUPAY_PUSH_LOG, ' status_push - get orderstatus name - EXCEPTION: ' . $e->getMessage());
                                                        $orders_status_name = "unkown";
                                                    }

                                                    $response = 'ack=Disapproved&error=order+status+not+waiting&original_status_id='.$original_order_status_id.'&original_status='.$orders_status_name;
                                                } else {
                                                    $order_status = $order_status_accepted;						
                                                }
                                                $insert_id = $order_id;
							require_once(DIR_WS_CLASSES.'order.php');
							require_once(DIR_FS_INC.'xtc_php_mail.inc.php');
							$smarty = new yesSmarty;
							include('send_order.php');
							break;
						case 'denied':
							$order_status = $order_status_denied;
							break;
						case 'issue':
							$order_status = $order_status_issue;
							break;
						case 'void':
							$order_status = $order_status_void;
							break;
						case 'authorized':
                                                        $order_status = $order_status_authorized;
							break;
						default:
							$response = 'ack=Disapproved&error=payment_status+not+supported';
							break;
					}
				}
			}

			if (isset($order_status) && is_numeric($order_status) && $order_status != 0) {
				//update order status
				try {
					$comment = "secupay status push (".$payment_status."): " . $comment;
                                        
                                        $yes_status_query_row = yes_query(sprintf(
                                            "SELECT orders_status FROM %s WHERE orders_id=:orders_id",
                                                TABLE_ORDERS
                                            ),['orders_id'=>$order_id],
                                            true
                                        );
                                        $yes_original_order_status_id = $yes_status_query_row['orders_status'];
                                        if($yes_original_order_status_id == ORDERS_STATUS_ABGESCHLOSSEN){
                                            $comment .= ' - [YES-SYSTEM] ACHTUNG: Auftragsstatus wurde NICHT aktualisiert, da Auftrag bereits als Abgeschlossen markiert ist. Bitte Vorgang manuell pruefen.';
                                            if(!function_exists('yes_write_notice')){
                                                require_once(DIR_FS_INC.'yes_write_notice.inc.php');
                                            }
                                            $recipients_array = main::get_notice_recipients('orders');
                                            yes_write_notice('Secupay PUSH Statusproblem Auftrag #'.$order_id,$comment,0,$recipients_array);
                                            //update order status history
                                            $insert_sql_array = [
                                                'orders_id'=>$order_id, 
                                                'orders_status_id'=>$yes_original_order_status_id, 
                                                'date_added'=>'now()', 
                                                'comments'=>$comment
                                            ];
                                            yes_db_perform(TABLE_ORDERS_STATUS_HISTORY,$insert_sql_array);
                                        }else{
                                            $update_sql_array = [
                                                'orders_status'=>$order_status
                                            ];
                                            yes_db_perform(TABLE_ORDERS, $update_sql_array, 'update', [
                                                'orders_id'=>$order_id
                                            ]);
                                            //update order status history
                                            $insert_sql_array = [
                                                'orders_id'=>$order_id, 
                                                'orders_status_id'=>$order_status, 
                                                'date_added'=>'now()', 
                                                'comments'=>$comment
                                            ];
                                            yes_db_perform(TABLE_ORDERS_STATUS_HISTORY,$insert_sql_array);
                                        }
					$response = 'ack=Approved';
				} catch (Exception $e) {
					secupay_log(SECUPAY_PUSH_LOG, ' status_push - get orderstatus - EXCEPTION: ' . $e->getMessage());
					$response = 'ack=Disapproved&error=order+status+not+changed';
				}
			} elseif (!isset($response)) {

				$response = 'ack=Disapproved&error=order+status+not+updated';
			}
		} else {

			$response = 'ack=Disapproved&error=apikey+invalid';
		}
	} else {
		secupay_log(SECUPAY_PUSH_LOG, ' status_push invalid Referer: ' . $_SERVER['HTTP_REFERER']);
		secupay_log(SECUPAY_PUSH_LOG, ' status_push invalid host: ' . $referer['host']);
		$response = 'ack=Disapproved&error=request+invalid';
	}
} catch (Exception $e) {
	$response = 'ack=Disapproved&error=unexpected+error';
	secupay_log(SECUPAY_PUSH_LOG, ' status_push EXCEPTION: ' . $e->getMessage());
}	
secupay_log(SECUPAY_PUSH_LOG, ' status_push RESPONSE: ' . $response . '&' . http_build_query($_POST));
//append original request (post) data to response
echo $response . '&' . http_build_query($_POST);
