<?php
/* -----------------------------------------------------------------------------------------
   $Id: reviews.php,v 1.3 2011/08/22 07:15:00 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(reviews.php,v 1.48 2003/05/27); www.oscommerce.com
   (c) 2003	 nextcommerce (reviews.php,v 1.12 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');
$smarty = new yesSmarty;
// include boxes
$YesBoxes->load( $smarty, basename(__FILE__) );
// include needed functions
require_once(DIR_FS_INC . 'xtc_word_count.inc.php');
require_once(DIR_FS_INC . 'xtc_date_long.inc.php');
$breadcrumb->add(NAVBAR_TITLE_REVIEWS, xtc_href_link(FILENAME_REVIEWS));
require(DIR_WS_INCLUDES . 'header.php');
$page = max(0,yes_getIntFromRequest('page'));
$reviews_query_raw = "select r.reviews_id, left(rd.reviews_text, 250) as reviews_text, r.reviews_rating, r.date_added, p.products_id, p.products_image, r.customers_name from " . TABLE_REVIEWS . " r LEFT JOIN " . TABLE_REVIEWS_DESCRIPTION . " rd USING(reviews_id) LEFT JOIN " . TABLE_PRODUCTS . " p USING(products_id) where p.products_status = '1' and rd.languages_id = '" . (int)$_SESSION['languages_id'] . "' order by r.reviews_id DESC";
$reviews_split = new splitPageResults($reviews_query_raw, $page, MAX_DISPLAY_NEW_REVIEWS);
if (($reviews_split->number_of_rows > 0) && ((defined('PREV_NEXT_BAR_LOCATION') and PREV_NEXT_BAR_LOCATION == '1') || (defined('PREV_NEXT_BAR_LOCATION') and PREV_NEXT_BAR_LOCATION == '3'))) {

  $smarty->assign('NAVBAR','

   <table border="0" width="100%" cellspacing="0" cellpadding="2">
          <tr>
            <td class="smallText">'. $reviews_split->display_count(TEXT_DISPLAY_NUMBER_OF_REVIEWS).'</td>
            <td align="right" class="smallText">'.TEXT_RESULT_PAGE . ' ' . $reviews_split->display_links(MAX_DISPLAY_PAGE_LINKS, xtc_get_all_get_params(array('page', 'info', 'x', 'y'))).'</td>
          </tr>
        </table>
  ');

  }

$module_data=array();
if ($reviews_split->number_of_rows > 0) {
    $reviews_query = xtc_db_query($reviews_split->sql_query);
    while ($reviews = xtc_db_fetch_array($reviews_query)) {
        $reviews['products_name'] = xtc_get_products_name( $reviews['products_id'] );
        $module_data[]=array(
            'PRODUCTS_IMAGE' =>(!empty($reviews['products_image']))?DIR_WS_THUMBNAIL_IMAGES . $reviews['products_image']:'',
            'PRODUCTS_LINK' => xtc_href_link(FILENAME_PRODUCT_REVIEWS_INFO, 'products_id=' . $reviews['products_id'] . '&reviews_id=' . $reviews['reviews_id']),
            'PRODUCTS_NAME' => $reviews['products_name'],
            'AUTHOR' => $reviews['customers_name'],
            'TEXT' => sprintf(TEXT_REVIEW_WORD_COUNT, xtc_word_count($reviews['reviews_text'], ' ')) . ')<br>' . htmlspecialchars($reviews['reviews_text']) . '..',
            'RATING' => xtc_image(DIR_WS_IMAGES . 'stars_' . $reviews['reviews_rating'] . '.gif', sprintf(BOX_REVIEWS_TEXT_OF_5_STARS, $reviews['reviews_rating']))
        );
    }
    $smarty->assign('module_content',$module_data);
  }

  $smarty->assign('language', $_SESSION['language']);

  // set cache ID
  if (USE_CACHE=='false') {
  $smarty->caching = 0;
  $main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/reviews.html');
  } else {
  $smarty->caching = 1;
  $smarty->cache_lifetime=CACHE_LIFETIME;
  $smarty->cache_modified_check=CACHE_CHECK;
  $cache_id = $_SESSION['language'];
  $main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/reviews.html',$cache_id);
  }

  $smarty->assign('language', $_SESSION['language']);
  $smarty->assign('main_content',$main_content);
  $smarty->caching = 0;
  if (!defined('RM')) $smarty->load_filter('output', 'note');
  $smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
