<?php
/* -----------------------------------------------------------------------------------------
   $Id: print_order.php,v 1.58 2018/03/16 06:32:00 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (print_order.php,v 1.5 2003/08/24); www.nextcommerce.org
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');
// include needed functions
require_once(DIR_FS_INC . 'xtc_get_orders_ebay_seller.inc.php');
require_once(DIR_FS_INC . 'xtc_get_ebay_seller_data.inc.php');
require_once(DIR_FS_INC . 'xtc_get_order_data.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_get_payment_method_title.inc.php');
require_once(DIR_FS_INC . 'xtc_get_customers_status_export_note.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_get_short_description.inc.php');
require_once(DIR_FS_INC . 'xtc_get_vpe_name.inc.php');
require_once(DIR_WS_CLASSES.'product.php');
if(defined('BARCODE_PACKINGSLIP_ACTIVE') and BARCODE_PACKINGSLIP_ACTIVE == 'True'){
	require_once(DIR_FS_INC .'xtc_generate_packingslip_barcode.inc.php');
}
$smarty = new yesSmarty;
$check_customer = true;
  
$oID = yes_getIntFromRequest('oID');
if($oID === 0){
        throw new Exception('Invalid request');
}

// GAB EINEN FEHLER, WEISS JETZT NICHT WO DAS INCLUDED WIRD
// 2025/07
if(!defined('TEXT_ORDER')){
        if($_SESSION['language'] != 'german'){
                define('TEXT_ORDER','Order');
        }else{
                define('TEXT_ORDER','Auftrag');
        }       
}
// check if custmer is allowed to see this order!
$access = false;
if($check_customer){
    $order_check = yes_query(sprintf("SELECT customers_id FROM %s WHERE orders_id=:orders_id",
        TABLE_ORDERS
        ),[
            'orders_id'=>$oID
        ],true
    );
    if (isset($order_check['customers_id']) and $_SESSION['customer_id'] == $order_check['customers_id']){
        $access = true;
    }
}else{
    $access = true;
}
if(!$access){
        $smarty->assign('ERROR','You are not allowed to view this order!');
        $smarty->display(CURRENT_TEMPLATE . '/module/error_message.html');
        include( 'includes/application_bottom.php');
        exit;
}
include(DIR_WS_CLASSES . 'order.php');
$order = new order($oID,$xtPrice);
$smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br />'));
$smarty->assign('address_label_shipping',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br />'));
$smarty->assign('address_label_payment',xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br />'));
$smarty->assign('csID',$order->customer['csID']);
$smarty->assign('CUSTOMERS_EMAIL_ADDRESS',$order->customer['email_address']);
$payi = $order->get_paymentinstructions();
if(sizeOf($order->get_paymentinstructions())){
        $smarty->assign('PAYMENTINSTRUCTIONS',current($payi));
}

$ebay_seller = xtc_get_orders_ebay_seller($order->info['id']);
if($ebay_seller != ''){
        $smarty->assign('EBAY_SELLER_DATA',xtc_get_ebay_seller_data($ebay_seller));
}

if(is_countable($order->ebay_id_array) and sizeOf($order->ebay_id_array)){
        $smarty->assign('EBAY_ID_ARRAY',$order->ebay_id_array);
}

if($order->info['ebay_id'] != ''){
        $smarty->assign('EBAY_ID',$order->info['ebay_id']);
}

$order_data = $order->getOrderData($order->info['id']);

$total_products_netto = 0;
for($i=0;$i<sizeOf($order_data);$i++){
        $pID = $order_data[$i]['PRODUCTS_ID'];
        $product = new product($pID);
        $order_data[$i]['INFO'] = $product->buildDataArray($product->data);
        $total_products_netto += $order_data[$i]['PRODUCTS_PRICE_NETTO'];

        $order_data[$i]['PRODUCTS_VPE'] = '';
        if ($product->data['products_vpe_status'] == 1 && $product->data['products_vpe_value'] != 0.0){
                $order_data[$i]['PRODUCTS_VPE'] = $xtPrice->xtcFormat($order_data[$i]['PRODUCTS_PRICE']  * (1 / $product->data['products_vpe_value']), true).TXT_PER.xtc_get_vpe_name($product->data['products_vpe']);
        }


        $order_data[$i]['PRODUCTS_SHORT_DESCRIPTION'] = $product->data['products_short_description'];
        $order_data[$i]['PRODUCTS_PRICE_NETTO'] = $xtPrice->xtcFormat($order_data[$i]['PRODUCTS_PRICE_NETTO'],true);
        $order_data[$i]['PRODUCTS_SINGLE_PRICE_NETTO'] = $xtPrice->xtcFormat($order_data[$i]['PRODUCTS_SINGLE_PRICE_NETTO'],true);
        $order_data[$i]['PRODUCTS_WEIGHT'] = xtc_get_ext_products_weight($pID)*$order_data[$i]['PRODUCTS_QTY'];
        $order_data[$i]['PROPERTIES'] = $order_data[$i]['PROPERTIES'];
        $collies = xtc_get_product_collies($pID);
        $collies_array = array();
        if(sizeOf($collies)>0){
                foreach($collies as $ck=>$collie){

                        $collie_title_query = xtc_db_query(sprintf(
                                "SELECT slave_title,products_name FROM products_description WHERE products_id=%s AND language_id=%s",
                                $collie['collie_products_id'],$_SESSION['languages_id']
                        ));
                        $collie_title = xtc_db_fetch_array($collie_title_query);
                        $collies_array[] = array(
                                'products_id'=>$collie['collie_products_id'],
                                'slave_title'=>$collie_title['slave_title'],
                                'products_name'=>$collie_title['products_name']
                        );
                }
        }
        $order_data[$i]['COLLIS'] = $collies_array;
}
$smarty->assign('order_data', $order_data);
$smarty->assign('TOTAL_PRODUCTS_NETTO',$xtPrice->xtcFormat($total_products_netto,true));

$total_netto = 0;
$total_tax = 0;
$shipping_costs_netto = 0;
$total = 0;
$order_total=array();
for($i=0;$i<sizeOf($order->totals);$i++){
        if ($order->totals[$i]['class']=='ot_total'){
                $total=$order->totals[$i]['value'];
        }
        if ($order->totals[$i]['class']=='ot_tax'){
                $total_tax=$order->totals[$i]['value'];
        }
        if ($order->totals[$i]['class']=='ot_shipping'){
                $scn = $order->totals[$i]['value'];
                if(xtc_not_null($order->info['shipping_class']) and !$order->is_netto()){
                                $shipping_class = strtoupper(current(explode('_',$order->info['shipping_class'])));
                                if(defined('MODULE_SHIPPING_'.$shipping_class.'_TAX_CLASS')){
                                        $tax_rate = xtc_get_tax_rate(constant('MODULE_SHIPPING_'.$shipping_class.'_TAX_CLASS'));
                                        $scn = $xtPrice->xtcRemoveTax($scn, $tax_rate);
                                }
                }
                $shipping_costs_netto += $scn;

        }
        $order_total[]=array(
                        'TITLE' => $order->totals[$i]['title'],
                        'CLASS' => $order->totals[$i]['class'],
                        'VALUE' => $order->totals[$i]['value'],
                        'TEXT'  => $order->totals[$i]['text']
        );
}
$smarty->assign('SHIPPING_COSTS_NETTO',$xtPrice->xtcFormat($shipping_costs_netto,true));

if(!$order->is_netto()){
        $total_netto = $total - $total_tax;
}
$smarty->assign('TOTAL_NETTO',$xtPrice->xtcFormat($total_netto,true));
$smarty->assign('order_total', $order_total);

$smarty->assign('YESORDER', $order->get_order_positions() );

// assign language to template for caching
$smarty->assign('language', $_SESSION['language']);	
$smarty->assign('oID',$order->info['id']);
$smarty->assign('vat_id',$order->info['vat_id']);
$smarty->assign('vatID',$order->info['vat_id']);
$record = main::get_customers_status($order->info['status'],$_SESSION['languages_id']);
$smarty->assign(array(
        'cID'=>(int)$order_check['customers_id'],
        'cgroup'=>$record['customers_status_name']
));

$smarty->assign('COMMENTS_VISIBLE',$order->info['comments_visible']);
// ALLE TELEFONDATEN
$tel_query = xtc_db_query("SELECT c.mobile,c.customers_telephone,c.customers_fax FROM customers c, orders o WHERE c.customers_id='".$order_check['customers_id']."'");
$tel = xtc_db_fetch_array($tel_query);
if($tel['mobile'] != ''){
        $smarty->assign('C_MOBILE',$tel['mobile']);
}
if($tel['customers_telephone'] != ''){
        $smarty->assign('C_TEL',$tel['customers_telephone']);
}
if($tel['customers_fax'] != ''){
        $smarty->assign('C_FAX',$tel['customers_fax']);
}
if($order->customer['telephone'] != ''){
        $smarty->assign('O_TEL',$order->customer['telephone']);
}
if($order->customer['mobile'] != ''){
        $smarty->assign('O_MOBILE',$order->customer['mobile']);
}
$payment_method = xtc_get_payment_method_title($order->info['payment_method']);

$smarty->assign('PAYMENT_METHOD',$payment_method);
$smarty->assign('PAYMENT_CLASS',$order->info['payment_class_raw']);

$smarty->assign('DATE',xtc_date_long($order->info['date_purchased']));
if($order->info['date_shipping'] > 0){
        $smarty->assign('DATE_SHIPPING',xtc_date_long($order->info['date_shipping']));
}
if($order->info['orders_status_id'] == ORDERS_STATUS_STORNIERT){
        $smarty->assign('IS_STORNO','1');
}
$smarty->assign('orders_status',$order->info['orders_status']);

$smarty->assign('STORE', STORE_NAME_ADDRESS);
$smarty->assign('BANK', MODULE_PAYMENT_MONEYORDER_PAYTO);
$smarty->assign('STORE_WRAP', STORE_WRAP);

// das muss kundengruppenabh. sein
$export_note = xtc_get_customers_status_export_note($_SESSION['customers_status']['customers_status_id'],$_SESSION['languages_id']);
if($export_note != ''){
        $smarty->assign('export_note',$export_note);
}

// FIBUNUMBER ADDON
$fibu_number = $order->get_fibunumber();
if(!empty($fibu_number) and strlen($fibu_number)>1){
        $smarty->assign('FIBU_NUMBER',$fibu_number);
}
$smarty->assign('ORDER_TYPE',$order->get_title($fibu_number));

$path = HTTP_SERVER.'templates/' . CURRENT_TEMPLATE . '/';
$smarty->assign('tpl_path', $path);
$smarty->assign('logo_path', $path.'img/');
if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
        $smarty->assign('BARCODE',xtc_generate_packingslip_barcode($order->info['id']));
}
// BOF Zahlungsziel
$customer_status = \YES4Trade\Model\customers_status::get_by_customers_status_id(intval($order->info['status']),[
        'customers_status_payment_target'
]);
if($customer_status !== null){
        $smarty->assign('CUSTOMERS_STATUS_PAYMENT_TARGET',$customer_status->customers_status_payment_target);
}
// EOF Zahlungsziel

// dont allow cache
$smarty->caching = false;
$smarty->display(CURRENT_TEMPLATE . '/module/print_order.html');	
include( 'includes/application_bottom.php');
