<?php
include( 'includes/application_top.php');
define('NO_XTC_FOOTER',1);
if(!function_exists('xtc_get_products_name')){
    require_once( DIR_FS_INC.'xtc_get_products_name.inc.php');
}
if(!function_exists('xtc_get_country_data_from_name')){
    require_once(DIR_FS_INC.'xtc_get_country_data_from_name.inc.php');
}
require_once( DIR_FS_INC.'xtc_collis.inc.php');
// create smarty elements
$smarty = new yesSmarty;

if(!isset($_GET['products_id'])){
      $smarty->assign('error_no_product',1);
}
$pID = yes_getIntFromRequest('products_id');
if($pID == 0 or !product::exists($pID)){
    die('Invalid item');
}

$smarty->assign('products_name',xtc_get_products_name($pID));

$parameters = [
    'products_id'=>$pID
];
$tax_query_raw = "SELECT products_price,shipping_extra_charge FROM products WHERE products_id=:products_id";
$tax = yes_query($tax_query_raw, $parameters,true);
$single_extra_charge = $tax['shipping_extra_charge'];

$country_id = yes_get_store_country_id();
$products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
    $pID, $country_id
);
$tax_value = xtc_get_tax_rate($products_tax_class_id, $country_id);

$smarty->assign('tax_value',$tax_value);
$smarty->assign('currency',DEFAULT_CURRENCY);
$pweight = xtc_get_ext_products_weight($pID);
$smarty->assign('weight',$pweight);
// TICKET 3292 Preis bereit stellen
$smarty->assign(array(
    'PRICE'=>$xtPrice->xtcGetPrice($pID, true, 1,$products_tax_class_id, $tax['products_price']),
    'PRICE_RAW'=>$xtPrice->xtcGetPrice($pID, false, 1,$products_tax_class_id, $tax['products_price']),
));

if(MODULE_SHIPPING_YES_STATUS == 'True'){
        $COUNTRY_GROUP_PRICES = []; // ALTERNATIV ZU EU OSS GRUPPIERUNG
	if(main::get_ext_shipping_costs_status($pID)){
            // WIR RUFEN OHNE ARGUMENT AUF, DANN WIRD AUTOMATISCH STORE_COUNTRY
            // VERWENDET ALS GRUNDLAGE
            $ext_additionalcosts = main::get_product_shipping_extra_charges($pID);
            $costs = main::get_ext_shipping_costs($pID);
            $values = array();
            foreach($costs as $group_id => $qty_array){
                    $price = main::calc_yes_modul($ext_additionalcosts+$qty_array[1],$group_id,$pweight,$pID);
                    $tax_price = ($price+MODULE_SHIPPING_YES_HANDLING) *(($tax_value+100)/100);
                    $c_array = main::get_group_countries($group_id);
                    if(sizeOf($c_array)>0){
                            $values[$group_id]['countries'] = $c_array;
                            $values[$group_id]['price'] = number_format($tax_price,2,',','.').DEFAULT_CURRENCY;
                            $values[$group_id]['netto'] = $price;
                    }
            }
            $values = array_reverse($values);
	}else{
            $values = array();
            $qty = 1;
            $grad_query = xtc_db_query("select * from shipping_graduation WHERE value=1");
            $grad = xtc_db_fetch_array($grad_query);
            $gID = $grad['shipping_graduation_id'];
            $groups_query = xtc_db_query("select * from shipping_graduation_groups ORDER BY shipping_graduation_groups_id");
            
            $EU_OSS = array();
            while($groups = xtc_db_fetch_array($groups_query)){
			$group_id = $groups['shipping_graduation_groups_id'];
                        $extra_charge = $single_extra_charge;
                        $extra_charge += main::get_product_shipping_extra_charges($pID,$group_id);
	
			// pweight nehmen wir fuer die kalkulation des Preises
			$weight_query = xtc_db_query("select * from shipping_graduation_weights order by weight DESC");
			while ($weight = xtc_db_fetch_array($weight_query)) {
				if((float)$pweight <= (float)$weight['weight']){
					$wID = $weight['shipping_graduation_weights_id'];
				}
			}
			$grad_query_raw = sprintf("SELECT grad_value FROM shipping_graduation_values WHERE shipping_graduation_weights_id='%s' and shipping_graduation_groups_id='%s' and shipping_graduation_id='%s'",$wID,$group_id,$gID);
			$grad_query = xtc_db_query($grad_query_raw);
			$grad = xtc_db_fetch_array($grad_query);

			$product_shipping = floatval($grad['grad_value']??0)+$extra_charge;
			$price = main::calc_yes_modul($product_shipping,$group_id,$pweight,$pID);
                        
			$c_array = main::get_group_countries($group_id);
                        $COUNTRY_GROUP_PRICES[] = [
                            'group_id'=>$group_id,
                            'price' =>($price+MODULE_SHIPPING_YES_HANDLING) *(($tax_value+100)/100),
                            'allow_cod' => $groups['allow_cod'],
                            'countries'=>$c_array,
                        ];
                        
			if(sizeOf($c_array)>0){
                            $countries_affected = [];
                            foreach($c_array as $c){
                                $cd = xtc_get_country_data_from_name($c);
                                $eu_oss_country_id = $cd['countries_id'];
                                // ist dieses Land EU OSS?
                                if(yes_eu_oss_use_country_handling($eu_oss_country_id)){
                                    $eu_oss_products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                                        $pID, $eu_oss_country_id
                                    );
                                    $eu_oss_tax_value = xtc_get_tax_rate($eu_oss_products_tax_class_id, $eu_oss_country_id);
                                    $tax_price = $price*(($eu_oss_tax_value+100)/100);
                                    $EU_OSS[$c]['countries'] = [$c];
                                    $EU_OSS[$c]['price'] = number_format($tax_price,2,',','.').DEFAULT_CURRENCY;
                                    $EU_OSS[$c]['netto'] = $price;
                                    $EU_OSS[$c]['allow_cod'] = $groups['allow_cod'];
                                    $eu_oss_tax_price = $groups['cod_fee']*(($eu_oss_tax_value+100)/100);
                                    $EU_OSS[$c]['cod_fee'] = number_format($eu_oss_tax_price,2,',','.').DEFAULT_CURRENCY;
                                    
                                }else{
                                    $countries_affected[] = $c;
                                }
                            }
                            if(sizeOf($countries_affected)){
        			$tax_price = $price*(($tax_value+100)/100);
				$values[$group_id]['countries'] = $countries_affected;
				$values[$group_id]['price'] = number_format($tax_price,2,',','.').DEFAULT_CURRENCY;
				$values[$group_id]['netto'] = $price;
				$values[$group_id]['allow_cod'] = $groups['allow_cod'];
				$tax_price = $groups['cod_fee']*(($tax_value+100)/100);
				$values[$group_id]['cod_fee'] = number_format($tax_price,2,',','.').DEFAULT_CURRENCY;
                            }
			}
		}
	}
	$char = 'A';
	foreach($values as $k=>$v){
	    $values[$k]['nr'] = $char;
	    $char = chr(ord($char) + 1);
	}
    if(is_countable($EU_OSS)){
        foreach(array_reverse($EU_OSS) as $euoss){
            array_unshift($values, $euoss);
        }
    }
	$smarty->assign([
            'costs'=>$values,
            'group_costs'=>$COUNTRY_GROUP_PRICES,
        ]);
  }
  
if(defined('MODULE_ORDER_TOTAL_SHIPPING_STATUS') and MODULE_ORDER_TOTAL_SHIPPING_STATUS == 'true'){
    if(defined('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING') and MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true'){
        $smarty->assign('FREE_SHIPPING_OVER',MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER);
    }
}
$smarty->assign('css_path',HTTP_SERVER.'templates/'.CURRENT_TEMPLATE.'/stylesheet.css');
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/module/shippingcosts.html');
