<?php
/* -----------------------------------------------------------------------------------------
   $Id: popup_coupon_help.php,v 1.6 2017/02/03 16:39:36 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(popup_coupon_help.php,v 1.1.2.5 2003/05/02); www.oscommerce.com


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/


require('includes/application_top.php');
require_once(DIR_FS_INC . 'xtc_date_short.inc.php');
$smarty = new yesSmarty;

include( 'includes/header.php');
$language = $_SESSION['language'];
require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_POPUP_COUPON_HELP);
$coupon_obj = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_GET['cID']));
if($coupon_obj === null){
    die('Invalid coupon');
}
$coupon = $coupon_obj->toArray();
$coupon_desc_obj = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
        intval($coupon['coupon_id']),intval($_SESSION['languages_id'])
);
$coupon_desc = $coupon_desc_obj->toArray();

$text_coupon_help = TEXT_COUPON_HELP_HEADER;
$text_coupon_help .= sprintf(TEXT_COUPON_HELP_NAME, $coupon_desc['coupon_name']);
if (xtc_not_null($coupon_desc['coupon_description'])) {
    $text_coupon_help .= sprintf(TEXT_COUPON_HELP_DESC, $coupon_desc['coupon_description']);
}
$coupon_amount = $coupon['coupon_amount'];
switch ($coupon['coupon_type']) {
    case 'F':
        $text_coupon_help .= sprintf(TEXT_COUPON_HELP_FIXED, $xtPrice->xtcFormat($coupon['coupon_amount'],true));
        break;
    case 'P':
        $text_coupon_help .= sprintf(TEXT_COUPON_HELP_FIXED, number_format($coupon['coupon_amount'],2). '%');
        break;
    case 'S':
        $text_coupon_help .= TEXT_COUPON_HELP_FREESHIP;
        break;
    default:
}

if ($coupon['coupon_minimum_order'] > 0 ) {
    $text_coupon_help .= sprintf(TEXT_COUPON_HELP_MINORDER, $xtPrice->xtcFormat($coupon['coupon_minimum_order'],true));
}
$text_coupon_help .= sprintf(TEXT_COUPON_HELP_DATE, xtc_date_short($coupon['coupon_start_date']),xtc_date_short($coupon['coupon_expire_date']));
$text_coupon_help .= '<b>' . TEXT_COUPON_HELP_RESTRICT . '</b>';
$text_coupon_help .= '<br /><br />' .  TEXT_COUPON_HELP_CATEGORIES;

$cat_ids = explode(",", $coupon['restrict_to_categories']);
$language_id = intval($_SESSION['languages_id']??2);
for ($i = 0; $i < count($cat_ids); $i++) {
    $cache_key = 'shop.categories-c'.$cat_ids[$i].'-l'.$language_id;
    $cache_group = 'categories';
    $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);


    $CachedString = $InstanceCache->getItem($key); // cache group
    if (!$CachedString->isHit()) {
        $catd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($cat_ids[$i]), $language_id,['categories_name']
        );
        $categories_data = [
            'categories_id'=>$cat_ids[$i],
            'categories_name'=> $catd->categories_name??''
        ];
        $CachedString->set($categories_data)->expiresAfter(YES_CACHE_LIFETIME_LONG); // cat
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $categories_data = $CachedString->get();
    }
    $cats .= '<br />' . $categories_data["categories_name"];
}
if (!isset($cats) or $cats=='') {
    $cats = '<br />NONE';
}
$text_coupon_help .= $cats;
$text_coupon_help .= '<br /><br />' .  TEXT_COUPON_HELP_PRODUCTS;
$pr_ids = explode(",", $coupon['restrict_to_products']);
for ($i = 0; $i < count($pr_ids); $i++) {
    $result = xtc_db_query(sprintf(
        "SELECT pd.products_name FROM products p LEFT JOIN products_description pd USING(products_id) WHERE pd.language_id = '%d' and p.products_id = '%d'",
        $_SESSION['languages_id'],intval($pr_ids[$i])
    ));
    if (xtc_db_num_rows($result)) {
        $row = xtc_db_fetch_array($result);
        $prods .= '<br />' . $row["products_name"];
    }
}
if ($prods=='') {
    $prods = '<br />NONE';
}
$text_coupon_help .= $prods;

$smarty->assign('TEXT_HELP',$text_coupon_help);
$smarty->assign('link_close','javascript:window.close()');
$smarty->assign('language', $_SESSION['language']);

$smarty->caching = 0;
$smarty->display(CURRENT_TEMPLATE.'/module/popup_coupon_help.html');