<?php
/* YES SMARTY INCLUDES GLOBAL */
function smarty_function_products_groups_filter($params,&$smarty){
    $gSmarty = new yesSmarty;
    if(!is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/products_groups_filter.tpl')){
        die('Error: Cant find templates/'.CURRENT_TEMPLATE.'/module/module/products_groups_filter.tpl');
    }
    if(!isset($params['group']) and !isset($params['categories_id'])){
        return '';
    }
    if(isset($param['group'])){
        $group = $params['group'];
    }else{
        if((int)$params['categories_id'] < 1){
            return '';
        }
        $cat_alloc = \YES4Trade\Model\groups_categories::get_by_categories_id( (int)xtc_db_input($params['categories_id']) );
        if($cat_alloc === false){
            return '';
        }
        $group = $cat_alloc->groups_id;
        if($group < 1){
            return '';
        }
    }
    $groupId = $group;
    $categoryId = $params['categories_id'];
    $languageId = $_SESSION['languages_id']??2;;
    if (isset($_GET['set']) && is_array($_GET['set'])) {
        foreach ($_GET['set'] as $val) {
            $val = (int) $val;
            if ($val > 0) {
                $selectedValues[] = $val;
            }
        }
    }

    // Alle Merkmale der Gruppe inkl. deutscher Bezeichnung laden
    $merkmale = yes_query("SELECT pc.products_characteristic_id, pcd.title AS merkmal_title
        FROM products_characteristic pc
        JOIN products_characteristic_description pcd 
        ON pcd.products_characteristic_id = pc.products_characteristic_id
        WHERE pc.groups_id =:gid AND pcd.language_id =:lid AND pc.deny_filter = 0
        ORDER BY pc.sort_order", 
        ['gid'=>$groupId,'lid'=>$languageId]
    );

    // Merkmalwerte pro Merkmal vorbereiten (nur wenn ein Artikel in der Kategorie damit verknüpft ist)
    $werteProMerkmal = [];

    $werteProMerkmal = [];

    foreach ($merkmale as $merkmal) {
        $merkmalId = $merkmal['products_characteristic_id'];

        $sql = "SELECT DISTINCT pcs.products_characteristic_set_id, pcsd.title AS merkmalwert_title
            FROM products_characteristic_set pcs
            JOIN products_characteristic_set_description pcsd 
            ON pcsd.products_characteristic_set_id = pcs.products_characteristic_set_id
            JOIN products_to_characteristics ptc 
            ON ptc.products_characteristic_set_id = pcs.products_characteristic_set_id
            JOIN products p 
            ON p.products_id = ptc.products_id AND p.products_status = 1
            JOIN products_to_categories ptcat 
            ON ptcat.products_id = p.products_id
            WHERE pcs.products_characteristic_id =:pcid
            AND pcsd.language_id =:lid
            AND ptcat.categories_id = :catid";

        $params = ['pcid'=>$merkmalId, 'lid'=>$languageId, 'catid'=>$categoryId];

        // Filter anwenden: nur Artikel berücksichtigen, die alle gewählten Merkmalwerte besitzen
        if (!empty($selectedValues)) {
            // Aktuellen Merkmalwert ausschließen (nicht sich selbst filtern)
            $relevantFilter = array_filter($selectedValues, function($val) use ($merkmalId) {
                $stmt = yes_query("SELECT products_characteristic_id
                    FROM products_characteristic_set
                    WHERE products_characteristic_set_id =:id",
                    ['id'=>$val],
                    true
                );
                return $stmt['products_characteristic_id'] != $merkmalId;
            });

            if (!empty($relevantFilter)) {
            $namedPlaceholders = [];
            $namedParams = [];

            foreach (array_values($relevantFilter) as $index => $val) {
                $key = ':rf' . str_pad($index + 1, 2, '0', STR_PAD_LEFT); // z. B. :rf01, :rf02, ...
                $namedPlaceholders[] = $key;
                $namedParams[$key] = $val;
            }

            $placeholdersString = implode(', ', $namedPlaceholders);

            $sql .= "
                AND p.products_id IN (
                SELECT ptc2.products_id
                FROM products_to_characteristics ptc2
                WHERE ptc2.products_characteristic_set_id IN ($placeholdersString)
                GROUP BY ptc2.products_id
                HAVING COUNT(DISTINCT ptc2.products_characteristic_set_id) = " . count($relevantFilter) . "
                )
            ";
            $params = array_merge($params, $namedParams);
            }
        }

        $sql .= " ORDER BY pcs.sort_order, pcsd.title";
        try{
            $werte = yes_query($sql,$params);
        }catch(Exception $e){
            die($e->getMessage());
        }
        if ($werte) {
            $werteProMerkmal[] = [
                'merkmal_id' => $merkmalId,
                'merkmal_title' => $merkmal['merkmal_title'],
                'werte' => $werte
            ];
        }
    }
    $set_select = $werteProMerkmal??[];
    $set_select_inputs = [];
    foreach($set_select as $ss){
        $options = [
            ['id'=>'','text'=>PULL_DOWN_DEFAULT],
        ];
        foreach($ss['werte'] as $wertpaar){
            if(is_countable($selectedValues)){
                $selected = in_array($wertpaar['products_characteristic_set_id'],$selectedValues);
            }else{
                $selected = false;
            }
            $options[] = [
                'id'=>$wertpaar['products_characteristic_set_id'],
                'text'=>$wertpaar['merkmalwert_title'],
                'selected'=>$selected
            ];
        }
        $set_select_inputs[] = [
            'id'=>$ss['merkmal_id'],
            'input'=>xtc_draw_pull_down_menu('set[]',$options,$default),
            'title'=>$ss['merkmal_title'],
            'sets'=>$options
        ];
    }
    if($set_select_inputs !== null and is_countable($set_select_inputs) and sizeOf($set_select_inputs)>0){
        $gSmarty->assign('GROUP_CHARACTERISTICS_SETS',$set_select_inputs);
    }
    $G = \YES4Trade\Model\groups::get_by_groups_id($groupId, $languageId);
    
    $gSmarty->assign(array(
        'GROUP_NAME'=>$G->groups_title,
        'BASELINK'=>xtc_href_link('index.php',xtc_get_all_get_params(array($excluded_get_params??[])))
    ));
    $gSmarty->caching = false;
    $gSmarty->display(CURRENT_TEMPLATE.'/module/products_groups_filter.tpl');
}
