<?php
$euoss_action = (isset($_GET['euoss']))?$_GET['euoss']:'';
$tpl_path = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/';
$tpl_name = 'eu_oss.html';
function euoss_log($msg){
    printf('<div style="background-color: red; color: white;">YES EU-OSS: %s</div>',
        $msg
    );
}
if(!is_file( $tpl_path.$tpl_name )){
    euoss_log('Missing template file');
    $error = true;
}
if(!$error){
    $smarty = new yesSmarty;
    switch($euoss_action){
        case 'product_prices':
            $products_id = (int)xtc_db_input($_GET['pID']);
            if($products_id < 1){
                euoss_log('Missing parameter');
            }else{
                $query = yes_query(sprintf(
                        "SELECT pd.products_name FROM %s p LEFT JOIN %s pd USING(products_id) WHERE p.products_id=:products_id AND pd.language_id=:language_id",
                        TABLE_PRODUCTS,
                        TABLE_PRODUCTS_DESCRIPTION,
                    ),[
                        'products_id'=>$products_id,
                        'language_id'=>(int)$_SESSION['languages_id']
                    ]
                );

                if(!sizeOf($query)){
                    euoss_log('Unknown item');
                }else{
                    $record = current($query);
                    $countries = main::get_allowed_delivery_countries();
                    $tax_class_names = []; // ein paar queries einsparen
                    foreach($countries as $k=>$country){
                        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($products_id, $country['id']);
                        if(isset($tax_class_names[ $products_tax_class_id ])){
                            $tax_class_title = $tax_class_names[ $products_tax_class_id ];
                        }else{
                            $tax_class = yes_query(sprintf(
                                "SELECT tax_class_title FROM %s WHERE tax_class_id=:class_id",
                                    TABLE_TAX_CLASS
                                ),[
                                    'class_id'=>(int)$products_tax_class_id
                                ],true
                            );
                            $tax_class_title = $tax_class['tax_class_title'];
                            $tax_class_names[ $products_tax_class_id ] = $tax_class_title;
                        }
                        
                        $products_tax_rate = xtc_get_tax_rate($products_tax_class_id, $country['id']);
                        $xtPrice = new xtcPrice($_SESSION['currency'], $_SESSION['customers_status']['customers_status_id']);
                        if(yes_eu_oss_use_country_handling($country['id'])){
                            $zone_id = 0;
                            $xtPrice->setCountryZone($country['id'],$zone_id);
                        }
                        $countries[$k]['price'] = $xtPrice->xtcGetPrice($products_id, true, 1, $products_tax_class_id);
                        $countries[$k]['tax_class_desc'] = $tax_class_title;
                        $countries[$k]['tax_rate'] = number_format($products_tax_rate,2,',','.');
                    }
                    $smarty->assign([
                        'PRODUCTS_NAME'=>$record['products_name'],
                        'COUNTRIES'=> $countries,
                    ]);
                    $smarty->display($tpl_path.$tpl_name);
    //            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($products_id, $country_id);
                }
            }
            break;
    }
}
exit;