<?php

/*
 Copyright (c) 2010 Patrick Kuendinger for Klarna 

 Released under the GNU General Public License
*/


// INCLUDE THE LANGUAGE SUPPORT FILE
if(strpos($_SERVER['SCRIPT_FILENAME'],'admin'))
    @include_once '../'.DIR_WS_CLASSES . 'kreditor_lang.php';
else
    @include_once DIR_WS_CLASSES . 'kreditor_lang.php';


class pckreditor_de {
  var $code, $title, $description, $enabled;
  var $display_pc_threshold = 100;
  var $ma_minimum = 6.95;

  // class constructor
  function __construct() {
    global $order, $currency, $cart, $currencies;

    $this->code = 'pckreditor_de';
    $this->title = MODULE_PAYMENT_PCKREDITOR_DE_TEXT_TITLE;
    $this->description = MODULE_PAYMENT_PCKREDITOR_DE_TEXT_DESCRIPTION;
    $this->sort_order = (defined('MODULE_PAYMENT_PCKREDITOR_DE_SORT_ORDER')) ? MODULE_PAYMENT_PCKREDITOR_DE_SORT_ORDER : 0;
    $this->enabled = ((defined('MODULE_PAYMENT_PCKREDITOR_DE_STATUS') and MODULE_PAYMENT_PCKREDITOR_DE_STATUS == 'True' ) ? true : false);
    if($this->enabled === true){
        $this->currency = $_SESSION['currency'];
        $this->customers_id = $_SESSION[customer_id];
       
        if ($this->currency != "EU" && $this->currency != "eu" && $this->currency != "EUR" && $this->currency != "eur") {
            $this->enabled = false;
	} else {
            if(is_array($order->customer['customer'])) {
                if($order->customer['country']['iso_code_2'] != "DE"){
                    $this->enabled = false;
                }
            } else {
                $result = main::get_country_values((int)$GLOBALS['customer_country_id']);
                if(isset($result['countries_iso_code_2'])) {
                    if($result['countries_iso_code_2'] != "DE") {
                        $this->enabled = false;
                    }
                } //end if is array result
            } // end else array customer
	} //end else euro
        if(is_object($currencies)){
          $er = $currencies->get_value($currency);
        }else{
          $er = 1;
        }

        if ((int)$cart->total*$er <= 100 && (int)MODULE_PAYMENT_PCKREDITOR_DE_PCLASS_DEFAULT == 0)
                $this->enabled = false;

        if ($order->info['total'] > MODULE_PAYMENT_PCKREDITOR_DE_ORDER_LIMIT){
          $this->enabled = false;
        }
        $this->form_action_url = xtc_href_link(FILENAME_CHECKOUT_PROCESS,'', 'SSL', false);
        if ((int)MODULE_PAYMENT_PCKREDITOR_DE_ORDER_STATUS_ID > 0) {
          $this->order_status = MODULE_PAYMENT_PCKREDITOR_DE_ORDER_STATUS_ID;
        }
    }
    if (is_object($order)){
      $this->update_status();
    }
  }

  // class methods
  function update_status() {
    global $order;


    //Zahlung ist nur moeglich wenn Rechnungs- und Lieferanschrift identisch
        if ($order->billing != $order->delivery)
        {
            $this->enabled = false;
        }
   
        if ($order->customer['country']['id'] != '81' )
        {
           $this->enabled = false;
	    }
  
  //Pruefen ob wir im Limit sind
        if (($order->info['total'] > MODULE_PAYMENT_PCKREDITOR_DE_ORDER_LIMIT) || ($order->info['total'] < MODULE_PAYMENT_PCKREDITOR_DE_ORDER_MINLIMIT))
        {
            $this->enabled = false;
        }
  
  }

  function javascript_validation() {
    return false;
  }

    function selection()
    {
        require_once (DIR_WS_CLASSES . 'kreditor.php');
        global $order, $customer_id, $currencies, $KRED_ISO3166_FI, $currency;

        $eid = MODULE_PAYMENT_PCKREDITOR_DE_EID;
        $secret = MODULE_PAYMENT_PCKREDITOR_DE_SECRET;

        if ($has_ysalary)
    {
        $customer_query =
            xtc_db_query("select customers_ysalary from " .
                TABLE_CUSTOMERS . " where customers_id = '".
                (int)$customer_id."'");
        $customer = xtc_db_fetch_array($customer_query);
        $ysalary = $customer['customers_ysalary'];
    }

	// Check if Klarna konto is active
	if(strlen(MODULE_PAYMENT_PCKREDITOR_DE_PCLASS_DEFAULT) > 0 && (int)MODULE_PAYMENT_PCKREDITOR_DE_PCLASS_DEFAULT != 0)
	{
		$pclass = MODULE_PAYMENT_PCKREDITOR_DE_PCLASS_DEFAULT;
		$months = "24";
		}


	if(strlen(MODULE_PAYMENT_PCKREDITOR_DE_PCLASS) > 0) {
		$pclass .= $months != "24" ? MODULE_PAYMENT_PCKREDITOR_DE_PCLASS : ";".MODULE_PAYMENT_PCKREDITOR_DE_PCLASS;
	}
	if(strlen(MODULE_PAYMENT_PCKREDITOR_DE_MONTH) > 0) {
		$months .= $months != "24" ? MODULE_PAYMENT_PCKREDITOR_DE_MONTH : ";".MODULE_PAYMENT_PCKREDITOR_DE_MONTH;
	}
	$pclassArr = array(
		"pclass" => explode(";", $pclass),
		"months" => explode(";", $months));

    $currencies_query =
            xtc_db_query("select value, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places from " .
                TABLE_CURRENCIES . " where code = '".
                $_SESSION['currency']."'");
        $currencies = xtc_db_fetch_array($currencies_query);
    
    $er = $currencies['value'];
    $total = $order->info['total']*100*$er;

	$default = "";
	$costpermonth = 0;
    $ma_minimum = 695;
    
	for ($i=0 ; $i<sizeof($pclassArr['pclass']); $i++)
    {
        $this->pc($eid, $total , $pclassArr['pclass'][$i],
            $KRED_ISO3166_DE, $flags, $secret,  $result);

		// calculate the amount to pay and round up
		// Add currency symbols and the chosen number of decimal digits
        $rate = (xtc_not_null($currency_value)) ? $currency_value : $currencies['value'];
        $format_string = $currencies['symbol_left'] . number_format(round($number * $rate, $currencies['decimal_places']), $currencies['decimal_places'], $currencies['decimal_point'], $currencies['thousands_point']) . $currencies['symbol_right'];
        $pc = $format_string;

        if($pclassArr['pclass'][$i] == MODULE_PAYMENT_PCKREDITOR_DE_PCLASS_DEFAULT)
		{
			// Calculate the monthly cost
			monthly_cost($total, 22, $months, 395, 0, $KRED_EUR, $result);
			$costpermonth = $result*$er;
			if($result >= $ma_minimum)
			{
				// Format the value with the chosen currency symbol and digits
				$pc = number_format(round($result/100),0) . $currencies['symbol_right'];
			}
			else
			{
				$pc = ($ma_minimum/100) . $currencies['symbol_right'];
			}

			$default = $pclassArr['pclass'][$i];
			$kontoarray[] = array('id' => $pclassArr['pclass'][$i], 'text' => sprintf(KREDITOR_LANG_INFO_DE_KLARNA, $pc));

			$pclasses .= xtc_draw_radio_field(
				"pckreditor_de_pclass",
				$pclassArr['pclass'][$i],
				($i < 1));
			$pclasses .= "&nbsp;&nbsp;" . sprintf(KREDITOR_LANG_INFO_DE_KLARNA, $pc) . "<br />";
		}
		elseif($result >= 700 && $total >= 10000)
        {
					// xxx Check and see which alt. has the lowest monthly cost
					if($result < $costpermonth || $costpermonth == 0)
					{
						$costpermonth = $result;
						$default = $pclassArr['pclass'][$i];
					}
					// xxx Add the item to our array of listitems
					$listitems[] = array('id' => $pclassArr['pclass'][$i], 'text' => $pclassArr['months'][$i] . KREDITOR_LANG_INFO_DE_PAYMENTTEXT3_MONTH .
KREDITOR_LANG_INFO_DE_PAYMENTTEXT1_PAY . $pc .
						KREDITOR_LANG_INFO_DE_PAYMENTTEXT2_EACH);

            $pclasses .= xtc_draw_radio_field('pckreditor_de_pclass',
                $pclassArr['pclass'][$i],
                ($i < 1) ? true : false) . '&nbsp; ' .

$pclassArr['months'][$i] .  KREDITOR_LANG_INFO_DE_PAYMENTTEXT3_MONTH .
  KREDITOR_LANG_INFO_DE_PAYMENTTEXT1_PAY . $pc .
KREDITOR_LANG_INFO_DE_PAYMENTTEXT2_EACH . ' ' .

			 ' &nbsp;';
                $pclasses .= '<br />';
        }
    }

	if(isset($listitems))
		{
		// xxx Sort the items so that they will be presented 36 -> 24 and so on.
		sort($listitems, SORT_NUMERIC);
		}

		// xxx Check which arrays we should use to display the dropdown
		if(isset($listitems) && isset($kontoarray))
		// xxx Merge the array so that konto will be presented at the top
			$listarray = array_merge($kontoarray, $listitems);
		else if(isset($listitems))
			$listarray = $listitems;
		else
			$listarray = $kontoarray;

			$addr_array = explode(" ", $order->billing['street_address']);
			if(sizeof($addr_array) > 1) {
       			$housenum = array_pop($addr_array);
			}
            else {
                $addr_array = explode(".", $order->billing['street_address']);
				  if(sizeof($addr_array) > 1) {
          		     $housenum = array_pop($addr_array);
				     }
                  else {
                     $housenum = "";
                     }}

    
  
        
    	    
        if($order->customer['gender'] == "m")
		{
		    $pcgender = 1;
		}
		else
		{
		    $pcgender = 0;
		}
	    
	    if(strlen($_SESSION["error_values"]["pno"]) > 0)
	    {
		$pcdt = $_SESSION["error_values"]["pno"];
		$pcdob = substr($pcdt,4,4) . "-" . substr($pcdt,2,2) . "-" . substr($pcdt,0,2);
		$pccustomers_dob = getdate(strtotime($pcdob));
	    }
	    else
	    {
                $cust = \YES4Trade\Model\customers::get_by_customers_id($this->customers_id,[
                    'customers_dob'
                ]);
    		$pccustomers_dob = getdate(strtotime($cust->customers_dob));
	    
                if ($cust->customers_dob == "0000-00-00 00:00:00"){
                    $pccustomers_dob = 1900;
            }
        }

	    
	
    
    
    
    $days = array();
	$months = array();
	$years = array();
	for ($i=1, $n=31; $i<=$n; $i++)
	{
	    $days[] = array('id'=>str_pad($i,2,0,STR_PAD_LEFT),'text'=>str_pad($i,2,0,STR_PAD_LEFT));
	}
	for ($i=1, $n=12; $i<=$n; $i++)
	{
	    $months[] = array('id'=>str_pad($i,2,0,STR_PAD_LEFT),'text'=>str_pad($i,2,0,STR_PAD_LEFT));
	}
	for ($i=1900, $n=(int)date('Y'); $i<=$n; $i++)
	{
	    $years[] = array('id'=>str_pad($i,2,0,STR_PAD_LEFT),'text'=>str_pad($i,2,0,STR_PAD_LEFT));
	}
    
    $fields = array(
                array('title' => KREDITOR_LANG_INFO_DE_IMGCONSUMERCREDIT,
			        'field' => ((MODULE_PAYMENT_PCKREDITOR_DE_IMAGEPOSITION == 'Block') ? xtc_image(DIR_WS_IMAGES . 'klarna_partpayment_de_logo.png') : "")),
		        array('title' => KREDITOR_LANG_INFO_DE_CHOOSECONSUMERCREDIT,
                    'field' => xtc_draw_pull_down_menu('pckreditor_de_pclass', $listarray, $default)),
				array('title' => KREDITOR_LANG_INFO_DE_GENDER,
			    'field' => "" . xtc_draw_radio_field('pckreditor_de_gender',
				    '0', $pcgender == 0) . " Frau<br> " . xtc_draw_radio_field('pckreditor_de_gender',
				    '1', $pcgender == 1) . " Mann"),
		        array('title' => KREDITOR_LANG_INFO_DE_PERSONALNUMBER,
			    'field' =>
				"Tag" . xtc_draw_pull_down_menu('pcdob_day',$days, (str_pad($pccustomers_dob['mday'],2,0,STR_PAD_LEFT))) .
				"Monat" . xtc_draw_pull_down_menu('pcdob_month',$months,(str_pad($pccustomers_dob['mon'],2,0,STR_PAD_LEFT))) .
				"Jahr" . xtc_draw_pull_down_menu('pcdob_year',$years,(str_pad($pccustomers_dob['year'],2,0,STR_PAD_LEFT)))
			),
                array('title' => KREDITOR_LANG_INFO_DE_PHONENUMBER,
			        'field' =>
			            xtc_draw_input_field('pckreditor_de_phone',
					        $order->customer['telephone'])),
		        array('title' => KREDITOR_LANG_INFO_DE_ACCEPTCONDITION1_ACCEPT . " " . KREDITOR_LANG_INFO_DE_ACCEPTCONDITION3_CONDITIONS,
			            'field' => xtc_draw_checkbox_field('pckreditor_de_check', " ") . "<script type=\"text/javascript\" src=\"https://integration.klarna.com/js/klarnapart.js\"></script>
                <script>
                    addKlarnaPartPaymentEvent(function() { InitKlarnaPartPaymentElements('klarna_partpayment'," . MODULE_PAYMENT_PCKREDITOR_DE_EID . ",'de', " . $total . "); });
                </script>
                    <a href=\"#\" id=\"klarna_partpayment\" onclick=\"ShowKlarnaPartPaymentPopup();return false;\"></a>"),
                
                array('field' => MODULE_PAYMENT_PCKREDITOR_DE_STREET_INFO),
                
                ); 

        return array('id' => $this->code,
            'module' => $this->title,
            'fields' => $fields);
    
    }

    function strpos_arr($haystack, $needle, $where) {
        $defpos = 10000;
        if(!is_array($needle)) $needle = array($needle);
        foreach($needle as $what) {
            if(($pos = strpos($haystack, $what, $where))!==false) {
                if ($pos < $defpos) $defpos = $pos;
            }
        }
        return $defpos;
    }

    function split_address($address) {
        $numbers = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
        $characters = array('-', '/', ' ', '#', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
                'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G',
                'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');
        $specialchars = array('-', '/', ' ', '#', '.');

        $numpos = $this->strpos_arr($address,$numbers,2); //Where do the numbers start? Allow for leading numbers
        $streetname = substr($address, 0, $numpos); //Get the streetname by splitting off the from the start of the numbers
        $streetname = trim($streetname); //Strip off spaces at the end

        $numberpart = substr($address, $numpos); //Get the housenumber+extension
        $numberpart = trim($numberpart); //and strip off spaces

        $extpos = $this->strpos_arr($numberpart, $characters, 0); //Get the start position of the extension
        if ($extpos != '') { //See if there is one, if so
            $housenumber = substr($numberpart, 0, $extpos); //get the housenumber
            $houseextension = substr($numberpart, $extpos); // and the extension
            $houseextension = str_replace ($specialchars, '', $houseextension); // and strip special characters from it
        }
        else {
            $housenumber = $numberpart; //Otherwise, we already have the housenumber
        }

        return array( $streetname, $housenumber, $houseextension );
    }
    
    function pre_confirmation_check() {
    require_once (DIR_WS_CLASSES . 'kreditor.php');
    global $order, $GA_OLD;
    if ($_POST['pckreditor_de_check'] != "on"){
      xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT,
				 'payment_error=pckreditor_de&error='.
				 urlencode(KREDITOR_LANG_INFO_DE_ERRORACCEPTCONDITION),
				 'SSL', true, false));
    }

    $pcpno = $_POST['pcdob_day'] . $_POST['pcdob_month'] . $_POST['pcdob_year'];

    $this->pckreditor_de_gender = $_POST['pckreditor_de_gender'];
    $this->pckreditor_de_pnum = $pcpno;

    if(isset($_POST['pcdob_year']) && $_POST['pcdob_year'] == '1900'){
xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=pckreditor_de&error=' . KREDITOR_LANG_INFO_DE_DATE, 'SSL', true, false));
	return;
}

    $eid = MODULE_PAYMENT_KREDITOR_DE_EID;
    $secret = MODULE_PAYMENT_KREDITOR_DE_SECRET;

    $pcaddr_array = $this->split_address($order->billing['street_address']);
    
    $this->pckreditor_de_fname = $order->billing['firstname'];
    $this->pckreditor_de_lname = $order->billing['lastname'];
    $this->pckreditor_de_housenum = $pcaddr_array[1].$pcaddr_array[2];
    $this->pckreditor_de_street = $pcaddr_array[0];
    $this->pckreditor_de_postno = $order->billing['postcode'];
    $this->pckreditor_de_city = $order->billing['city'];
    $this->pckreditor_de_phone2 = $order->customer['telephone'];
    $this->pckreditor_de_phone = $_POST['pckreditor_de_phone'];
    $order->delivery['telephone'] = $this->pckreditor_de_phone;
    $order->billing['telephone'] = $this->pckreditor_de_phone;
    $this->pckreditor_de_email = $order->customer['email_address'];

    $this->pckreditor_de_pclass = $_POST['pckreditor_de_pclass'];

  }

  function confirmation() {
    return array('title' => MODULE_PAYMENT_PCKREDITOR_DE_TEXT_CONFIRM_DESCRIPTION);
  }

  function process_button() {
    global $order, $order_total_modules, $pckreditor_de_ot;
    $counter = 1;
    $a=count($this->addrs);
    $process_button_string = "";
    if($a>1){
      $process_button_string .= "<div align='left'>";
      $process_button_string .=  "<table border='0' width='100%' cellspacing='1' cellpadding='2' class='infoBox'>";
      $process_button_string.=  "<tr><td class='main'><b>".KREDITOR_LANG_INFO_DE_CHOOSEALTERNATIVES."</b></td></tr>";
      $process_button_string .=  "<tr class='infoBoxContents'><td>";

      foreach ($this->addrs as $addr){
	$this->pckreditor_de_fname = $addr[0];
	$this->pckreditor_de_lname = $addr[1];
	$this->pckreditor_de_street = $addr[2];
	$this->pckreditor_de_postno = $addr[3];
	$this->pckreditor_de_city = $addr[4];   

	if($counter == 1){
	   $checked = true;
	  }else{
	   $checked = false;
	}

	$process_button_string .=
	  xtc_draw_radio_field('addr_num', $counter, $checked, '').
	  xtc_draw_hidden_field('pckreditor_de_gender',  $this->pckreditor_de_gender) .
      xtc_draw_hidden_field('pckreditor_de_pclass'.$counter,$this->pckreditor_de_pclass).
	  xtc_draw_hidden_field('pckreditor_de_pnum'.$counter,
				$this->pckreditor_de_pnum).
	  xtc_draw_hidden_field('pckreditor_de_fname'.$counter,
				$this->pckreditor_de_fname).
	  xtc_draw_hidden_field('pckreditor_de_lname'.$counter,
				$this->pckreditor_de_lname).
	  xtc_draw_hidden_field('pckreditor_de_street'.$counter,
				$this->pckreditor_de_street).
		xtc_draw_hidden_field('pckreditor_de_house'.$counter,
				$this->pckreditor_de_housenum).
	  $this->pckreditor_de_street." ".
	  xtc_draw_hidden_field('pckreditor_de_postno'.$counter,
				$this->pckreditor_de_postno).
	  $this->pckreditor_de_postno." ".
	  xtc_draw_hidden_field('pckreditor_de_city'.$counter,
				$this->pckreditor_de_city).
	  $this->pckreditor_de_city." ".
	  xtc_draw_hidden_field('pckreditor_de_phone2'.$counter,
				$this->pckreditor_de_phone2).
	  xtc_draw_hidden_field('pckreditor_de_phone'.$counter,
				$this->pckreditor_de_phone).
	  xtc_draw_hidden_field('pckreditor_de_email'.$counter,
				$this->pckreditor_de_email)."<br/>";
	$counter++;
      }
      $process_button_string .= "</td></tr></table><br/></div>";
    }else{ 
      $process_button_string =
	xtc_draw_hidden_field('addr_num', $counter, $checked, '').
	xtc_draw_hidden_field('pckreditor_de_gender',  $this->pckreditor_de_gender) .
    xtc_draw_hidden_field('pckreditor_de_pclass',$this->pckreditor_de_pclass).
	xtc_draw_hidden_field('pckreditor_de_pnum',$this->pckreditor_de_pnum).
	xtc_draw_hidden_field('pckreditor_de_fname',$this->pckreditor_de_fname).
	xtc_draw_hidden_field('pckreditor_de_lname',$this->pckreditor_de_lname).
	xtc_draw_hidden_field('pckreditor_de_street',
			      $this->pckreditor_de_street).
	xtc_draw_hidden_field('pckreditor_de_house',
				$this->pckreditor_de_housenum).
	xtc_draw_hidden_field('pckreditor_de_postno',
			      $this->pckreditor_de_postno).
	xtc_draw_hidden_field('pckreditor_de_city',$this->pckreditor_de_city).
	xtc_draw_hidden_field('pckreditor_de_phone2',$this->pckreditor_de_phone2).
	xtc_draw_hidden_field('pckreditor_de_phone',$this->pckreditor_de_phone).
	xtc_draw_hidden_field('pckreditor_de_email',$this->pckreditor_de_email);
    }

    // This is a bit of a hack. The problem is that we need access to
    // all additional charges, ie the order_totals list, later in
    // before_process(), but at that point order_totals->process hasn't
    // been run in that process. We cannot run it ourselves since
    // checkout_process.php will run it after running before_process.
    // Running it twice causes an error message since the classes
    // will be redefined.
    //
    // An alternative to this ugly code is to modify checkout_process.php
    // or order_total.php but we want to avoid that.
    //

    $order_totals = $order_total_modules->modules;

    if (is_array($order_totals)) {
      reset($order_totals);
      $j = 0;
      $table = split("[,]", MODULE_PAYMENT_PCKREDITOR_DE_ORDER_TOTAL_IGNORE);

      // php8 bugfix
      //while (list(, $value) = each($order_totals)) {
      foreach($order_totals as $egal => $value) {
	$class = substr($value, 0, strrpos($value, '.'));

	if (!$GLOBALS[$class]->enabled){
	  continue;
	}
	$code = $GLOBALS[$class]->code;
	$ignore=false;

	for ($i=0 ; $i<sizeof($table) && $ignore == false ; $i++) {
	  if ($table[$i] == $code){
	    $ignore = true;
	  }
	}

	$size = sizeof($GLOBALS[$class]->output);

	if ($ignore == false && $size > 0) {
		$pckreditor_de_ot['code_size_'.$j] = $size;
	  for ($i=0; $i<$size; $i++) {
		$pckreditor_de_ot['title_'.$j.'_'.$i] = $GLOBALS[$class]->output[$i]['title'];
		$pckreditor_de_ot['text_'.$j.'_'.$i] = $GLOBALS[$class]->output[$i]['text'];
	    if (is_numeric($GLOBALS[$class]->deduction) &&
		$GLOBALS[$class]->deduction > 0) {
		$pckreditor_de_ot['value_'.$j.'_'.$i] = -$GLOBALS[$class]->deduction;
	    }
	    else {
			$pckreditor_de_ot['value_'.$j.'_'.$i] = $GLOBALS[$class]->output[$i]['value'];
		}

			$pckreditor_de_ot['code_'.$j.'_'.$i] = $GLOBALS[$class]->code;
	  }
	  $j += 1;
	}
      }
	  $pckreditor_de_ot['code_entries'] = $j;
    } 

	//xtc_session_register('pckreditor_de_ot');

    $process_button_string .= xtc_draw_hidden_field(xtc_session_name(), xtc_session_id());
    return $process_button_string;
  
  }

  function before_process()
  {
    global $order, $customer_id, $xtPrice, $sendto, $billto, $AUTO_ACTIVATE;
	global $insert_id;


    require_once (DIR_WS_CLASSES . 'kreditor.php');
    $currency = $_SESSION['currency'];
    if ($currency != "EU" && $currency != "eu" && $currency != "EUR" && $currency != "eur")
    {
	xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=kreditor_de&error=' . KREDITOR_LANG_INFO_DE_ERRORCURRENCY, 'SSL', true, false));
	return;
    }

    $eid = MODULE_PAYMENT_PCKREDITOR_DE_EID;
    $estoreUser = $customer_id;
    $goodsList = array();
    $n = sizeof($order->products);

    // First all the ordinary items
    for ($i = 0 ; $i < $n ; $i++)
    {
	// Products price with tax
	if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 1)
	{
	    $price = $order->products[$i]['price'] * 100;
	}
	else
	{
	    $price = $order->products[$i]['price'] * (1 + $order->products[$i]['tax'] / 100) * 100;
	}


        if (MODULE_PAYMENT_PCKREDITOR_DE_ARTNO == 'id' || MODULE_PAYMENT_PCKREDITOR_DE_ARTNO == '')
        {
	    $goodsList[] =
		mk_goods_flags($order->products[$i]['qty'],
		xtc_get_prid($order->products[$i]['id']),
		strip_tags($order->products[$i]['name']),
		$price,
		$order->products[$i]['tax'],
		0,
		32);
        }
        else
        {
	    $goodsList[] =
		mk_goods_flags($order->products[$i]['qty'],
		$order->products[$i][MODULE_PAYMENT_PCKREDITOR_DE_ARTNO],
		strip_tags($order->products[$i]['name']),
		$price,
		$order->products[$i]['tax'],
		0,
		32);
      }
    }

    // Then the extra charges like shipping and invoicefee and
    // discount.

    $extra = $_SESSION['kreditor_de_ot']['code_entries'];
    $tod_rate = xtc_get_tax_rate(MODULE_PAYMENT_PCKREDITOR_DE_TAX_CLASS);
    for ($j=0 ; $j<$extra ; $j++)
    {
      $size = $_SESSION['kreditor_de_ot']["code_size_".$j];
      for ($i=0 ; $i<$size ; $i++)
      {
	$value = $_SESSION['kreditor_de_ot']["value_".$j."_".$i];
	$name = $_SESSION['kreditor_de_ot']["title_".$j."_".$i];
	$tax = $tod_rate*1;
	$name = rtrim($name, ":");
	if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 1)
	{
		$price_without_tax = $xtPrice->xtcFormat($value, false) * 100;
	}
	else
	{
		$price_without_tax = $xtPrice->xtcFormat($value, false) * 100 * (1 + $tax/ 100);
	}

	if ($value != "" && $value != 0)
	{
	  $goodsList[] = mk_goods_flags(1, "", $name, $price_without_tax, $tax, 0, 32);
	}
      }
    }

    // Add shipping
    //$goodsList[] = mk_goods_flags(1, "", $order->info['shipping_method'], $order->info['shipping_cost']*100*($tod_rate/100+1), $tod_rate, 0, 40);
    $module = substr($order->info['shipping_class'], 0, strpos($order->info['shipping_class'], '_'));
    $shipping_tax = xtc_get_tax_rate($GLOBALS[$module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
    $goodsList[] = mk_goods_flags(1, "", $order->info['shipping_method'], $order->info['shipping_cost']*100*(($shipping_tax/100)+1), $shipping_tax, 0, 40);

    //Rounding off error fix ends
    $secret = MODULE_PAYMENT_PCKREDITOR_DE_SECRET;
    $estoreOrderNo = "";
    $shipmentfee = 0;
    $shipmenttype = 1;
    $handlingfee = 0;
    $ready_date = "";

    // Make sure that all POST data are
    // encoded as ISO
    $_POST = $this->decode_data($_POST);

    // Fixes potential security problem
    $pno   = $_POST['pckreditor_de_pnum'.$addr_num];
    $fname = $_POST['pckreditor_de_fname'.$addr_num];
    $lname = $_POST['pckreditor_de_lname'.$addr_num];
    $addr = mk_addr_de("", $_POST['pckreditor_de_street'],
		       $_POST['pckreditor_de_postno'],
		       $_POST['pckreditor_de_city'],
		       $_POST['pckreditor_de_phone2'],
		       $_POST['pckreditor_de_phone'],
		       $_POST['pckreditor_de_email'], $_POST['pckreditor_de_house']);
    $passwd = "";
    $clientIp = $_SERVER["REMOTE_ADDR"];
    $newPasswd = "";

    $gender = $_POST["pckreditor_de_gender"];

    // Save the values so we do not have to enter them again in
    // the case of an error
    $_SESSION["error_values"] = array("pno" => $pno, "gender" => $gender, "address" => $addr, "fname" => $fname, "lname" => $lname);


    if (MODULE_PAYMENT_PCKREDITOR_DE_AUTO_ACTIVATE == 'True')
    {
      $flags = 1 ;
      if (MODULE_PAYMENT_PCKREDITOR_DE_AUTO_ACTIVATE_SEND_DELAY > 0)
      {
	$ready_date = date('Y-m-d', strtotime('now +'. MODULE_PAYMENT_PCKREDITOR_DE_AUTO_ACTIVATE_SEND_DELAY . ' days'));
      }
    }
    else
    {
      $flags = 0;
    } 

    $pclass =  $_POST['pckreditor_de_pclass'.$addr_num];
    $ysalary = "";

    $status =
      add_transaction_de($eid, $estoreUser, $secret, $estoreOrderNo,
     $this->decode_data($goodsList), $shipmentfee, $shipmenttype,
     $handlingfee, $pno . $gender, $fname, $lname, $addr,
     $passwd, $clientIp, $newPasswd, $flags,
     $comment, $ready_date, "", $pclass, $ysalary, $result);

    if ($status == 0)
    {
	
	//update_orderno($eid, utf8_decode($result), $secret, utf8_decode($insert_id), $result);
	// Reset the session in case of a successful purchase
	$_SESSION["error_values"] = null;

        // insert address in address book to get correct address in
        // confirmation mail (or fetch correct address from address book
        // if it exists)

        $q = "select countries_id from " . TABLE_COUNTRIES .  " where countries_iso_code_2 = 'DE'";

        $check_country_query = xtc_db_query($q);
        $check_country = xtc_db_fetch_array($check_country_query);

        $cid = $check_country['countries_id'];

        $where = [
            'entry_firstname'=>$order->delivery['firstname'],
            'entry_lastname'=>$order->delivery['lastname'],
            'entry_street_address'=>$order->delivery['street_address'],
            'entry_postcode'=>$order->delivery['postcode'],
            'entry_city'=>$order->delivery['city']
        ];
        $items = \YES4Trade\Model\address_book::get_by_customers_id((int)$customer_id, $where);
        if(sizeOf($items)){
            $item = current($items);
	    $sendto = $billto = $item->address_book_id;
        }else{
            $new = new \YES4Trade\Model\address_book([
                'customers_id' => (int)$customer_id,
		'entry_firstname' => $order->delivery['firstname'],
		'entry_lastname' => $order->delivery['lastname'],
		'entry_street_address' => $order->delivery['street_address'],
		'entry_postcode' => $order->delivery['postcode'],
		'entry_city' => $order->delivery['city'],
		'entry_country_id' => (int)$cid,
                'address_date_added'=>date('Y-m-d H:i:s')
            ]);
            $insID = $new->create();
	    $sendto = $billto = $insID;
        }
	
	
	$_SESSION["payref"] = $result;
	
      $payment['tan']=$result;

        xtc_session_unregister('kreditor_de_ot');
		
	

    }
    else
    {
	xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=pckreditor_de&error=' . urlencode($result), 'SSL', true, false));
    }
  }

   function decode_data($input)
    {
		if(is_array($input))
		{
			foreach($input as $key => $data)
			{
				$decoded_array[$key] = $this->decode_data($data);
			}
		}
		elseif(is_string($input))
		{
			if(mb_detect_encoding($input . "a", 'UTF-8, ISO-8859-1') == 'UTF-8')
			{
				return utf8_decode($input);
			}
			else
			{
				return $input;
			}
		}
		else
		{
		    return $input;
		}

		return $decoded_array;
    }

  function after_process() {
    global $insert_id, $order;

    $find_st_optional_field_query =
      xtc_db_query("show columns from " . TABLE_ORDERS);

    
    $this->order_status = MODULE_PAYMENT_KREDITOR_DE_ORDER_STATUS_ID;
    $invno = $_SESSION["payref"];
    
    $has_kreditor_de_ref = false;

    while($fields = xtc_db_fetch_array($find_st_optional_field_query)){
      if ( $fields['Field'] == "kreditor_de_ref" )
	$has_kreditor_de_ref = true;
    }

    if ($has_kreditor_de_ref){
      xtc_db_query("update " . TABLE_ORDERS . " set kreditor_de_ref='" .
		   $order->kreditor_de_ref . "' " . " where orders_id = '" .
		   $insert_id . "'");
    }

    // Insert transaction # into history file

    $sql_data_array = array('orders_id' => (int)$insert_id,
			    'orders_status_id' => (int)$this->order_status,
			    'date_added' => 'now()',
			    'customer_notified' => 0,
			    'comments' => ('Von Klarna akzeptiert ' .
					   date("Y-m-d G:i:s") .
					   ' Rechnungsnummer: ' .
					   $invno));

    yes_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
    $secret = MODULE_PAYMENT_PCKREDITOR_DE_SECRET;
    $eid = MODULE_PAYMENT_PCKREDITOR_DE_EID;
    $invno = $_SESSION["payref"];
    update_orderno($eid, utf8_decode($invno), $secret, utf8_decode($insert_id), $result);
    return false;
    }


  function get_error() {

    if (isset($_GET['message']) &&
	strlen($_GET['message']) > 0) {
      $error = stripslashes(urldecode($_GET['message']));
    } else {
      $error = $_GET['error'];
    }
    return array('title' => KREDITOR_LANG_INFO_DE_ERRORDIVIDE,
		 'error' => $error);
  }

  function check() {
    if (!isset($this->_check)) {
      $check_query = xtc_db_query("select configuration_value from " .
				  TABLE_CONFIGURATION .
				  " where configuration_key = " .
				  "'MODULE_PAYMENT_PCKREDITOR_DE_STATUS'");
      $this->_check = xtc_db_num_rows($check_query);
    }
    return $this->_check;
  }

  function pc($eid, $sum, $pclass, $country, $flags, $secret, &$result){

  require_once (DIR_WS_CLASSES . 'kreditor.php');

  $pclassArr = array('pclass' => explode(";",MODULE_PAYMENT_PCKREDITOR_DE_PCLASS),
		       'months' => explode(";",MODULE_PAYMENT_PCKREDITOR_DE_MONTH),
		       'monthfees' => explode(";",MODULE_PAYMENT_PCKREDITOR_DE_MONTH_FEE),
		       'startfees' => explode(";", MODULE_PAYMENT_PCKREDITOR_DE_START_FEE),
		       'rates' => explode(";", MODULE_PAYMENT_PCKREDITOR_DE_RATE));

    for ($i=0 ; $i<sizeof($pclassArr['pclass']); $i++)
	{
		if ($pclass == MODULE_PAYMENT_PCKREDITOR_DE_PCLASS_DEFAULT)
		{
			$months = 24;
			$monthfee = 195; // 29 * 100;
			$startfee = 0;
			$rate = 14.95;
			break;
		}
		elseif ($pclass == $pclassArr['pclass'][$i])
		{
			$months = $pclassArr['months'][$i];
			$monthfee = $pclassArr['monthfees'][$i]*100;
			$startfee = $pclassArr['startfees'][$i]*100;
			$rate = $pclassArr['rates'][$i];
			break;
		}
	}

    //  Make sure we have a float regardless of  separator
    $rate = ereg_replace("(^[0-9]*)(\\.|,)([0-9]*)(.*)", "\\1.\\3", $rate);
    if (!is_numeric($rate)) $rate = ereg_replace("(^[0-9]*)(.*)", "\\1", $rate);
    if (!is_numeric($rate)) $rate = 0;
    $rate = ((float) $rate)*100;
    $dailyrate  = daily_rate($rate);

    $monthpayment = calc_monthpayment($sum + $startfee, $dailyrate, $months);
	$result = round($monthpayment + $monthfee);

    return 0;
  }

  function install() {
    $extraString = '<b>Click <a href="?set=payment&module=pckreditor_de&get_pclasses=true">here</a> to update your pclasses</b><br><br>';
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_STATUS', 'True', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_ZONE', '0', '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_EID', '0', '6', '0', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_SECRET', '', '6', '0', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_AUTO_ACTIVATE', 'False', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_AUTO_ACTIVATE_SEND_DELAY', '0', '6', '2', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_ARTNO', 'model', '6', '2', 'xtc_cfg_select_option(array(\'id\', \'model\'),', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_IMAGEPOSITION', 'Block', '6', '2', 'xtc_cfg_select_option(array(\'Title\', \'Block\'),', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_ORDER_TOTAL_IGNORE', 'ot_tax,ot_total,ot_subtotal', '6', '2', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_ORDER_LIMIT', '1000000', '6', '2', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_SORT_ORDER', '0', '6', '0', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_ORDER_STATUS_ID', '0', '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_TAX_CLASS', '0', '6', '6', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_MINLIMIT', '0', '6', '2', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_PCLASS', '115;116;117;118;119', '6', '7', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_MONTH', '3;6;12;24;36', '6', '8', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_MONTH_FEE', '29;29;29;29;29', '6', '8', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_RATE', '0;0;0;9.95;9.95', '6', '9', now())");
    
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_START_FEE', '95;195;295;295;295', '6', '10', now())");
	
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_PCLASS_DEFAULT', '0', '6', '7', now())");
  
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_ALLOWED', '', '6', '0', now())");
  
   xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PCKREDITOR_DE_PRODUCTLEVEL', 'False', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
  }
  
  function remove() {
    xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }
  
  function keys() {
  
  $filename = explode('?', basename($_SERVER['REQUEST_URI'], 0));//[0];
  	
		if ($filename[0] == "modules.php"){
			if ($_GET['get_pclasses'] == TRUE)  {
				require_once ("../". DIR_WS_CLASSES . 'kreditor.php');
				global $KRED_ISO3166_DE, $KRED_ISO639_DE, $KRED_EUR;
				$eid = MODULE_PAYMENT_PCKREDITOR_DE_EID;
				$secret = MODULE_PAYMENT_PCKREDITOR_DE_SECRET;
				fetch_pclasses($eid, $KRED_EUR, $secret, $KRED_ISO3166_DE, $KRED_ISO639_DE, $result);
						
				$pclassIDs = "";
				$pclassMonths = "";
				$pclassRates = "";
				$pclassFees = "";
				$pclassStartfees = "";
		
				foreach ($result as $pclass) {
					if ($pclass[1] == "1/24 avbetalningskonto" || strtolower($pclass[1]) == "ratenkauf") {
						xtc_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . $pclass[0] . "' where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_DE_PCLASS_DEFAULT'");
		
					} else {
						$pclassIDS .= "$pclass[0];";
						$pclassFees.= $pclass[4]/100 . ";";
						$pclassMonths .= "$pclass[2];";
						$pclassRates .= ($pclass[5]/100) . ";";
						$pclassStartfees .= ($pclass[3]/100) . ";";
					}
				}
				
				$pclassIDS = substr($pclassIDS,0,-1);
				$pclassMonths = substr($pclassMonths,0,-1);
				$pclassFees = substr($pclassFees,0,-1);
				$pclassRates = substr($pclassRates,0,-1);
				$pclassStartfees = substr($pclassStartfees,0,-1);

		
		
				xtc_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . $pclassIDS . "' where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_DE_PCLASS'");
				xtc_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . $pclassMonths . "' where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_DE_MONTH'");
				xtc_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . $pclassRates . "' where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_DE_RATE'");
				xtc_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . $pclassFees . "' where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_DE_MONTH_FEE'");
				xtc_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . $pclassStartfees . "' where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_DE_START_FEE'");
		
		
			} else if ($_GET['view_pclasses'] == TRUE)  {
				$query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_PCLASS'");
				$arr = xtc_db_fetch_array($query);
				xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_MONTH'");
				xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_RATE'");
				xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_PCKREDITOR_START_FEE'");
				print_r($arr);
			}
		}
    return array('MODULE_PAYMENT_PCKREDITOR_DE_STATUS',
		 'MODULE_PAYMENT_PCKREDITOR_DE_ORDER_STATUS_ID',
		 'MODULE_PAYMENT_PCKREDITOR_DE_EID',
		 'MODULE_PAYMENT_PCKREDITOR_DE_SECRET',
		 'MODULE_PAYMENT_PCKREDITOR_DE_ARTNO',
		 'MODULE_PAYMENT_PCKREDITOR_DE_AUTO_ACTIVATE',
		 'MODULE_PAYMENT_PCKREDITOR_DE_AUTO_ACTIVATE_SEND_DELAY',
		 'MODULE_PAYMENT_PCKREDITOR_DE_ORDER_LIMIT',
		 'MODULE_PAYMENT_PCKREDITOR_DE_MINLIMIT',
		 'MODULE_PAYMENT_PCKREDITOR_DE_ORDER_TOTAL_IGNORE',
		 'MODULE_PAYMENT_PCKREDITOR_DE_ZONE',
		 'MODULE_PAYMENT_PCKREDITOR_DE_TAX_CLASS',
		 'MODULE_PAYMENT_PCKREDITOR_DE_ALLOWED',
		 'MODULE_PAYMENT_PCKREDITOR_DE_IMAGEPOSITION',
		 'MODULE_PAYMENT_PCKREDITOR_DE_SORT_ORDER',
		 'MODULE_PAYMENT_PCKREDITOR_DE_PRODUCTLEVEL',
		 'MODULE_PAYMENT_PCKREDITOR_DE_PCLASS',
		 'MODULE_PAYMENT_PCKREDITOR_DE_MONTH',
		 'MODULE_PAYMENT_PCKREDITOR_DE_MONTH_FEE', 
		 'MODULE_PAYMENT_PCKREDITOR_DE_RATE',
		 'MODULE_PAYMENT_PCKREDITOR_DE_START_FEE',
		 'MODULE_PAYMENT_PCKREDITOR_DE_PCLASS_DEFAULT');	
  }
}
