<?php
/*
 Copyright (c) 2010 Bernd Trissler and Patrick Kuendinger for Klarna & Marcus Ripkens, Invent-IT
 Released under the GNU General Public License
*/

class kreditor_de
{
    var $code, $title, $description, $enabled;
    function __construct()
    {
        global $order;
        $this->code = 'kreditor_de';
        $this->enabled = (defined('MODULE_PAYMENT_KREDITOR_DE_STATUS') and MODULE_PAYMENT_KREDITOR_DE_STATUS == 'True') ? true : false;
        $this->currency = $_SESSION['currency'];
        $this->sort_order = (defined('MODULE_PAYMENT_KREDITOR_DE_SORT_ORDER')) ? MODULE_PAYMENT_KREDITOR_DE_SORT_ORDER : 0;
        $this->title = MODULE_PAYMENT_KREDITOR_DE_TEXT_TITLE;
        $this->description = MODULE_PAYMENT_KREDITOR_DE_TEXT_DESCRIPTION;
        
        if($this->enabled === true){
            $currencies_query =
                xtc_db_query("select value, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places from " .
                    TABLE_CURRENCIES . " where code = '".
                    $_SESSION['currency']."'");
            $currencies = xtc_db_fetch_array($currencies_query);

            if (MODULE_ORDER_TOTAL_KREDITOR_DE_PAYMENT_CHG_STATUS == 'true'){
                if(is_numeric(MODULE_ORDER_TOTAL_KREDITOR_DE_PAYMENT_CHG_FIXED) && MODULE_KREDITOR_DE_PAYMENT_CHG_FIXED >= 0){
                    $kreditor_payment_chg = round(MODULE_ORDER_TOTAL_KREDITOR_DE_PAYMENT_CHG_FIXED*(xtc_get_tax_rate(MODULE_ORDER_TOTAL_KREDITOR_DE_PAYMENT_CHG_TAX_CLASS)/100+1), 2);
                }else{
                    $kreditor_payment_chg = 0;
                }
                $this->title = MODULE_PAYMENT_KREDITOR_DE_TEXT_TITLE . " " . "(+" . str_replace(".", ",", ($kreditor_payment_chg)) . " " . $currencies['symbol_right'] . " " . "Bearbeitungsgeb&uuml;hr)";
            }

            $this->form_action_url = xtc_href_link(FILENAME_CHECKOUT_PROCESS,'', 'SSL', false);
            $this->customers_id = $_SESSION['customer_id'];
        }
        
       if (is_object($order))
        {
            $this->update_status();
        }
    }
 
    function update_status()
    {
        global $order;


        if ((int)MODULE_PAYMENT_KREDITOR_DE_ORDER_STATUS_ID > 0)
        {
            $this->order_status = MODULE_PAYMENT_KREDITOR_DE_ORDER_STATUS_ID;
        }
        else
        {
    	    $this->order_status = $order->info['order_status'];
        }
		
	//Pruefen ob Waehrung ist EURO
        if ($this->currency != "EU" && $this->currency != "eu" && $this->currency != "EUR" && $this->currency != "eur")
        {
	    $this->enabled = false;
	}
	
	//Pruefen ob wir im Limit sind
        if (($order->info['total'] > MODULE_PAYMENT_KREDITOR_DE_ORDER_LIMIT) || ($order->info['total'] < MODULE_PAYMENT_KREDITOR_DE_ORDER_MINLIMIT))
        {
            $this->enabled = false;
        }
        
        //Zahlung ist nur moeglich wenn Rechnungs- und Lieferanschrift identisch
        if ($order->billing != $order->delivery)
        {
            $this->enabled = false;
        }

      if ($order->customer['country']['id'] != '81' )
        {
           $this->enabled = false;
	    }
        
    }

    function javascript_validation()
    {
	return false;
    }

    function selection()
    {

        global $order;
        
        if(!isset($_SESSION["error_values"]["gender"]))
    	    {
		if($order->customer['gender'] == "m")
		{
		    $_SESSION["error_values"]["gender"] = 1;
		}
		else
		{
		    $_SESSION["error_values"]["gender"] = 0;
		}
	    }
	    if(strlen($_SESSION["error_values"]["pno"]) > 0)
	    {
		$dt = $_SESSION["error_values"]["pno"];
		$dob = substr($dt,4,4) . "-" . substr($dt,2,2) . "-" . substr($dt,0,2);
		$customers_dob = getdate(strtotime($dob));
	    }
	    else
	    {
                $cust = \YES4Trade\Model\customers::get_by_customers_id($this->customers_id,[
                    'customers_dob'
                ]);
    		$customers_dob = getdate(strtotime($cust->customers_dob));
	    
                if ($cust->customers_dob == "0000-00-00 00:00:00"){
                    $customers_dob['year'] = 1900;
                }
            }

	    if(strlen($_SESSION["error_values"]["address"]["cellno"]) > 0)
	    {
		$display_cellno = $_SESSION["error_values"]["address"]["cellno"];
	    }
	    else
	    {
		$display_cellno = $order->customer['telephone'];
	    }
	
	
        // FIX THE LINK TO THE CONDITION
        if(is_numeric(MODULE_ORDER_TOTAL_KREDITOR_DE_PAYMENT_CHG_FIXED) && MODULE_ORDER_TOTAL_KREDITOR_DE_PAYMENT_CHG_FIXED >= 0)
        {
            $kreditor_payment_chg = round(MODULE_ORDER_TOTAL_KREDITOR_DE_PAYMENT_CHG_FIXED*(xtc_get_tax_rate(MODULE_ORDER_TOTAL_KREDITOR_DE_PAYMENT_CHG_TAX_CLASS)/100+1), 2);
        }
        else
        {
            $kreditor_payment_chg = 0;
        }

        $paymeny_charge_link = "<a href=\"javascript:void();\" onclick=\"window.open('https://www.kreditor.se/villkor_fi.yaws?eid=" . MODULE_PAYMENT_KREDITOR_DE_EID."&charge=" . 
                $kreditor_payment_chg."'," . "'villkor','width=300,height=370,scrollbars=no');\">" . KREDITOR_LANG_INFO_DE_PAYMENT."</a>";
           
	$days = array();
	$months = array();
	$years = array();
	for ($i=1, $n=31; $i<=$n; $i++)
	{
	    $days[] = array('id'=>str_pad($i,2,0,STR_PAD_LEFT),'text'=>str_pad($i,2,0,STR_PAD_LEFT));
	}
	for ($i=1, $n=12; $i<=$n; $i++)
	{
	    $months[] = array('id'=>str_pad($i,2,0,STR_PAD_LEFT),'text'=>str_pad($i,2,0,STR_PAD_LEFT));
	}
	for ($i=1900, $n=(int)date('Y'); $i<=$n; $i++)
	{
	    $years[] = array('id'=>str_pad($i,2,0,STR_PAD_LEFT),'text'=>str_pad($i,2,0,STR_PAD_LEFT));
	}


    	$fields=array(
        	    array('title' => KREDITOR_LANG_INFO_DE_IMGINVOICE, 'field' => ((MODULE_PAYMENT_KREDITOR_DE_IMAGEPOSITION == 'Block') ? xtc_image(DIR_WS_IMAGES . 'klarna_invoice_de_logo.png') : "")),
		    array('title' => KREDITOR_LANG_INFO_DE_CONDITIONS,
			    'field' => "<script type=\"text/javascript\" src=\"https://integration.klarna.com/js/klarnainvoice.js\"></script>
				<script>
					addKlarnaInvoiceEvent(function() { InitKlarnaInvoiceElements('klarna_invoice'," . MODULE_PAYMENT_KREDITOR_DE_EID . ", 'de', " . $kreditor_payment_chg . " ); });
				</script>
				<a href=\"".KREDITOR_LANG_INFO_DE_CONDITIONS."\" id=\"klarna_invoice\" onclick=\"ShowKlarnaInvoicePopup();return false;\"></a>"),
		    array('title' => KREDITOR_LANG_INFO_DE_GENDER,
			    'field' => "" . xtc_draw_radio_field('kreditor_de_gender',
				    '0', $_SESSION["error_values"]["gender"] == 0) . " Frau<br>" . xtc_draw_radio_field('kreditor_de_gender',
				    '1', $_SESSION["error_values"]["gender"] == 1) . " Mann"
			),
		    array('title' => KREDITOR_LANG_INFO_DE_PERSONALNUMBER,
			    'field' => 
				"Tag" . xtc_draw_pull_down_menu('dob_day',$days, (str_pad($customers_dob['mday'],2,0,STR_PAD_LEFT) )) .
				"Monat" . xtc_draw_pull_down_menu('dob_month',$months,(str_pad($customers_dob['mon'],2,0,STR_PAD_LEFT) )) .
				"Jahr" . xtc_draw_pull_down_menu('dob_year',$years,(str_pad($customers_dob['year'],2,0,STR_PAD_LEFT) ))
			),
		    array('title' => KREDITOR_LANG_INFO_DE_PHONENUMBER,
			    'field' => xtc_draw_input_field('kreditor_de_phone', ($display_cellno ))
			),
			array('field' => KREDITOR_LANG_INFO_DE_STREET_INFO)
            ); 
		    
  return array('id' => $this->code,
            'module' => $this->title,
            'fields' => $fields);
       
  }
  
  function strpos_arr($haystack, $needle, $where) {
        $defpos = 10000;
        if(!is_array($needle)) $needle = array($needle);
        foreach($needle as $what) {
            if(($pos = strpos($haystack, $what, $where))!==false) {
                if ($pos < $defpos) $defpos = $pos;
            }
        }
        return $defpos;
    }

    function split_address($address) {
        $numbers = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
        $characters = array('-', '/', ' ', '#', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
                'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G',
                'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');
        $specialchars = array('-', '/', ' ', '#', '.');

        $numpos = $this->strpos_arr($address,$numbers,2); //Where do the numbers start? Allow for leading numbers
        $streetname = substr($address, 0, $numpos); //Get the streetname by splitting off the from the start of the numbers
        $streetname = trim($streetname); //Strip off spaces at the end

        $numberpart = substr($address, $numpos); //Get the housenumber+extension
        $numberpart = trim($numberpart); //and strip off spaces

        $extpos = $this->strpos_arr($numberpart, $characters, 0); //Get the start position of the extension
        if ($extpos != '') { //See if there is one, if so
            $housenumber = substr($numberpart, 0, $extpos); //get the housenumber
            $houseextension = substr($numberpart, $extpos); // and the extension
            $houseextension = str_replace ($specialchars, '', $houseextension); // and strip special characters from it
        }
        else {
            $housenumber = $numberpart; //Otherwise, we already have the housenumber
        }

        return array( $streetname, $housenumber, $houseextension );
    }
  
  function pre_confirmation_check()
  {
    global $order;
    require_once (DIR_WS_CLASSES . 'kreditor_lang.php');
    $pno = $_POST['dob_day'] . $_POST['dob_month'] . $_POST['dob_year'];

    $this->kreditor_de_gender = $_POST['kreditor_de_gender'];
    $this->kreditor_de_pnum = $pno;
    
    if(isset($_POST['dob_year']) && $_POST['dob_year'] == '1900'){
xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=kreditor_de&error=' . KREDITOR_LANG_INFO_DE_DATE, 'SSL', true, false));
	return;
}
    
    $eid = MODULE_PAYMENT_KREDITOR_DE_EID;
    $secret = MODULE_PAYMENT_KREDITOR_DE_SECRET;

    $addr_array = $this->split_address($order->billing['street_address']);

    $this->kreditor_de_fname = $order->billing['firstname'];
    $this->kreditor_de_lname = $order->billing['lastname'];
    $this->kreditor_de_house = $addr_array[1].$addr_array[2];
    $this->kreditor_de_street = $addr_array[0];
    $this->kreditor_de_postno = $order->billing['postcode'];
    $this->kreditor_de_city = $order->billing['city'];
    $this->kreditor_de_phone2 = $order->customer['telephone'];
    $this->kreditor_de_phone = $_POST['kreditor_de_phone'];
    $this->kreditor_de_email = $order->customer['email_address'];
  }
  
  function confirmation()
  {
    return array('title' => MODULE_PAYMENT_KREDITOR_DE_TEXT_CONFIRM_DESCRIPTION);
  }

  function process_button()
  {
    global $_SERVER, $order, $order_total_modules, $customer_id, $currency;

    $process_button_string =
	xtc_draw_hidden_field('kreditor_de_gender',  $this->kreditor_de_gender) .
        xtc_draw_hidden_field('kreditor_de_pnum',  $this->kreditor_de_pnum) .
        xtc_draw_hidden_field('kreditor_de_fname',  $this->kreditor_de_fname) .
        xtc_draw_hidden_field('kreditor_de_lname',  $this->kreditor_de_lname) .
        xtc_draw_hidden_field('kreditor_de_street', $this->kreditor_de_street) .
	xtc_draw_hidden_field('kreditor_de_house', $this->kreditor_de_house) .
        xtc_draw_hidden_field('kreditor_de_postno', $this->kreditor_de_postno) .
        xtc_draw_hidden_field('kreditor_de_city',   $this->kreditor_de_city) .
	xtc_draw_hidden_field('kreditor_de_phone2',  $this->kreditor_de_phone2) .
        xtc_draw_hidden_field('kreditor_de_phone',  $this->kreditor_de_phone) .
        xtc_draw_hidden_field('kreditor_de_email',  $this->kreditor_de_email);
      
    $order_totals = $order_total_modules->modules;
	
	
    if (is_array($order_totals))
    {
      reset($order_totals);
      $j = 0;
      $table = split("[,]", MODULE_PAYMENT_KREDITOR_DE_ORDER_TOTAL_IGNORE);
      // php8 bugfix
      //while (list(, $value) = each($order_totals))
      foreach($order_totals as $egal => $value) {
	$class = substr($value, 0, strrpos($value, '.'));
	
	if (!$GLOBALS[$class]->enabled)
	{
	  continue;
	}
	$code = $GLOBALS[$class]->code;
	$ignore=false; 
	
	for ($i=0 ; $i<sizeof($table) && $ignore == false ; $i++)
	{
	  if ($table[$i] == $code)
	  {
	    $ignore = true;
	  }
	}
	
	$size = sizeof($GLOBALS[$class]->output);
	
	if ($ignore == false && $size > 0)
	{
	    $_SESSION['kreditor_de_ot']['code_size_'.$j] = $size;
	    for ($i=0; $i<$size; $i++)
	    {
		$_SESSION['kreditor_de_ot']['title_'.$j.'_'.$i] = $GLOBALS[$class]->output[$i]['title'];
		$_SESSION['kreditor_de_ot']['text_'.$j.'_'.$i] = $GLOBALS[$class]->output[$i]['text'];
		if (is_numeric($GLOBALS[$class]->deduction) && $GLOBALS[$class]->deduction > 0)
		{
		    $_SESSION['kreditor_de_ot']['value_'.$j.'_'.$i] = -$GLOBALS[$class]->deduction;
		}
		else
		{
		    $_SESSION['kreditor_de_ot']['value_'.$j.'_'.$i] = $GLOBALS[$class]->output[$i]['value'];
		}
		$_SESSION['kreditor_de_ot']['code_'.$j.'_'.$i] = $GLOBALS[$class]->code;
	    }
	    $j += 1;
	}
      }
	$_SESSION['kreditor_de_ot']['code_entries'] = $j;
    }
    
    //xtc_session_register('kreditor_de_ot');
    
    $process_button_string .= xtc_draw_hidden_field(xtc_session_name(), xtc_session_id());
    return $process_button_string;
  }

  function before_process()
  {
    global $order, $customer_id, $xtPrice, $sendto, $billto, $AUTO_ACTIVATE;
	
	
    require_once (DIR_WS_CLASSES . 'kreditor.php');
    $currency = $_SESSION['currency'];
    if ($currency != "EU" && $currency != "eu" && $currency != "EUR" && $currency != "eur")
    {
	xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=kreditor_de&error=' . KREDITOR_LANG_INFO_DE_ERRORCURRENCY, 'SSL', true, false));
	return;
    }

    $eid = MODULE_PAYMENT_KREDITOR_DE_EID;
    $estoreUser = $customer_id;
    $goodsList = array();
    $n = sizeof($order->products);

    // First all the ordinary items
    for ($i = 0 ; $i < $n ; $i++)
    {
	// Products price with tax
	if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 1)
	{
	    $price = $order->products[$i]['price'] * 100;
	}
	else
	{
	    $price = $order->products[$i]['price'] * (1 + $order->products[$i]['tax'] / 100) * 100;
	}
			
	  
	  
	  
        if (MODULE_PAYMENT_KREDITOR_DE_ARTNO == 'id' || MODULE_PAYMENT_KREDITOR_DE_ARTNO == '')
        {
	    $goodsList[] =
		mk_goods_flags($order->products[$i]['qty'],
		xtc_get_prid($order->products[$i]['id']),
		strip_tags($order->products[$i]['name']),
		$price,
		$order->products[$i]['tax'],
		0,
		32);
        }
        else
        {
	    $goodsList[] =
		mk_goods_flags($order->products[$i]['qty'],
		$order->products[$i][MODULE_PAYMENT_KREDITOR_DE_ARTNO],
		strip_tags($order->products[$i]['name']),
		$price,
		$order->products[$i]['tax'],
		0,
		32);
      }
    }

    // Then the extra charges like shipping and invoicefee and 
    // discount.
	
    $extra = $_SESSION['kreditor_de_ot']['code_entries'];
    $tod_rate = xtc_get_tax_rate(MODULE_PAYMENT_KREDITOR_DE_TAX_CLASS);
    for ($j=0 ; $j<$extra ; $j++)
    {
      $size = $_SESSION['kreditor_de_ot']["code_size_".$j];
      for ($i=0 ; $i<$size ; $i++)
      {
	$value = $_SESSION['kreditor_de_ot']["value_".$j."_".$i];
	$name = $_SESSION['kreditor_de_ot']["title_".$j."_".$i];
	$tax = $tod_rate*1;
	$name = rtrim($name, ":");
	if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 1)
	{
		$price_without_tax = $xtPrice->xtcFormat($value, false) * 100;
	}
	else
	{
		$price_without_tax = $xtPrice->xtcFormat($value, false) * 100 * (1 + $tax/ 100);
	}
	
	if ($value != "" && $value != 0)
	{
	  $goodsList[] = mk_goods_flags(1, "", $name, $price_without_tax, $tax, 0, 32);
	}
      }
    }
	
    // Add shipping	
    //$goodsList[] = mk_goods_flags(1, "", $order->info['shipping_method'], $order->info['shipping_cost']*100*($tod_rate/100+1), $tod_rate, 0, 40);
    $module = substr($order->info['shipping_class'], 0, strpos($order->info['shipping_class'], '_'));
    $shipping_tax = xtc_get_tax_rate($GLOBALS[$module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
    $goodsList[] = mk_goods_flags(1, "", $order->info['shipping_method'], $order->info['shipping_cost']*100*(($shipping_tax/100)+1), $shipping_tax, 0, 40);
	
    //Rounding off error fix ends
    $secret = MODULE_PAYMENT_KREDITOR_DE_SECRET;
    $estoreOrderNo = "";
    $shipmentfee = 0;
    $shipmenttype = 1;
    $handlingfee = 0;
    $ready_date = "";
	
    // Make sure that all POST data are
    // encoded as ISO
    $_POST = $this->decode_data($_POST);
	
    // Fixes potential security problem
    $pno   = $_POST['kreditor_de_pnum'.$addr_num];
    $fname = $_POST['kreditor_de_fname'.$addr_num];
    $lname = $_POST['kreditor_de_lname'.$addr_num];
    $addr = mk_addr_de("", $_POST['kreditor_de_street'],
		       $_POST['kreditor_de_postno'],
		       $_POST['kreditor_de_city'],
		       $_POST['kreditor_de_phone2'],
		       $_POST['kreditor_de_phone'],
		       $_POST['kreditor_de_email'], $_POST['kreditor_de_house']);
    $passwd = "";
    $clientIp = $_SERVER["REMOTE_ADDR"];
    $newPasswd = "";
	
    $gender = $_POST["kreditor_de_gender"];
	
    // Save the values so we do not have to enter them again in
    // the case of an error
    $_SESSION["error_values"] = array("pno" => $pno, "gender" => $gender, "address" => $addr, "fname" => $fname, "lname" => $lname);
	
	
    if (MODULE_PAYMENT_KREDITOR_DE_AUTO_ACTIVATE == 'True')
    {
      $flags = 1 ;
      if (MODULE_PAYMENT_KREDITOR_DE_AUTO_ACTIVATE_SEND_DELAY > 0)
      {
	$ready_date = date('Y-m-d', strtotime('now +'. MODULE_PAYMENT_KREDITOR_DE_AUTO_ACTIVATE_SEND_DELAY . ' days'));
      }
    } 
    /*else
    {
      $flags = 0;
    } */
   
    $status =
      add_transaction_de($eid, $estoreUser, $secret, $estoreOrderNo,
     $this->decode_data($goodsList), $shipmentfee, $shipmenttype,
     $handlingfee, $pno . $gender, $fname, $lname, $addr,
     $passwd, $clientIp, $newPasswd, $flags,
     "", $ready_date, "", -1, 0, $result);

    if ($status == 0)
    {
	// Reset the session in case of a successful purchase
	$_SESSION["error_values"] = null;

        // insert address in address book to get correct address in
        // confirmation mail (or fetch correct address from address book
        // if it exists)

        $q = "select countries_id from " . TABLE_COUNTRIES .  " where countries_iso_code_2 = 'DE'";

        $check_country_query = xtc_db_query($q);
        $check_country = xtc_db_fetch_array($check_country_query);

        $cid = $check_country['countries_id'];
        $where = [
            'entry_firstname'=>$order->delivery['firstname'],
            'entry_lastname'=>$order->delivery['lastname'],
            'entry_street_address'=>$order->delivery['street_address'],
            'entry_postcode'=>$order->delivery['postcode'],
            'entry_city'=>$order->delivery['city']
        ];
        $items = \YES4Trade\Model\address_book::get_by_customers_id((int)$customer_id, $where);
        if(sizeOf($items)){
            $item = current($items);
	    $sendto = $billto = $item->address_book_id;
        } else {
            $new = new \YES4Trade\Model\address_book([
                'customers_id' => (int)$customer_id,
		'entry_firstname' => $order->delivery['firstname'],
		'entry_lastname' => $order->delivery['lastname'],
		'entry_street_address' => $order->delivery['street_address'],
		'entry_postcode' => $order->delivery['postcode'],
		'entry_city' => $order->delivery['city'],
		'entry_country_id' => (int)$cid,
                'address_date_added'=>date('Y-m-d H:i:s')
            ]);
            $insID = $new->create();
	    $sendto = $billto = $insID;
        }
	  
	$_SESSION["payref"] = $result;
	  
        $payment['tan']=$result;
      
        //xtc_session_unregister('kreditor_de_ot');
      
    }
    else
    {
	xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=kreditor_de&error=' . urlencode($result), 'SSL', true, false));      
    }
  }
  
    function decode_data($input)
    {
		if(is_array($input))
		{
			foreach($input as $key => $data)
			{
				$decoded_array[$key] = $this->decode_data($data);
			}
		} 
		elseif(is_string($input))
		{
			if(mb_detect_encoding($input . "a", 'UTF-8, ISO-8859-1') == 'UTF-8')
			{
				return utf8_decode($input);
			}
			else
			{
				return $input;
			}
		} 
		else
		{
		    return $input;
		}
				
		return $decoded_array;
    }
  
  function after_process()
  {
    global $insert_id, $order;

    $this->order_status = MODULE_PAYMENT_KREDITOR_DE_ORDER_STATUS_ID;
    $invno = $_SESSION["payref"];
    $find_st_optional_field_query =  xtc_db_query("show columns from " . TABLE_ORDERS);

    $has_kreditor_de_ref = false;

    while($fields = xtc_db_fetch_array($find_st_optional_field_query))
    {
        if ( $fields['Field'] == "kreditor_de_ref" ) 
        {
	    $has_kreditor_de_ref = true;
	}
    }
    
    if ($has_kreditor_de_ref)
    {
        $update_sql_array = [
            'kreditor_de_ref'=>$invno
        ];
        yes_db_perform(TABLE_ORDERS, $update_sql_array,'update',[
            'orders_id'=>(int)$insert_id
        ]);
    }

    xtc_db_query("update " . TABLE_ORDERS . " set orders_status='" . $this->order_status . "' " . " where orders_id = '" . $insert_id . "'");

    // Insert transaction # into history file
    $sql_data_array = array(
        'orders_id' => (int)$insert_id, 
        'orders_status_id' => (int)$this->order_status, 
        'date_added' => 'now()', 
        'customer_notified' => 0,
        'comments' => ('Von Klarna akzeptiert ' .
                       date("Y-m-d G:i:s") .
                       ' Rechnungsnummer: ' .
                       $invno)
    );
    yes_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
    $secret = MODULE_PAYMENT_KREDITOR_DE_SECRET;
    $eid = MODULE_PAYMENT_KREDITOR_DE_EID;
    $invno = $_SESSION["payref"];
    update_orderno($eid, utf8_decode($invno), $secret, utf8_decode($insert_id), $result);
    return false;
  }


  function get_error()
  {
    if (isset($_GET['message']) && strlen($_GET['message']) > 0)
    {
      $error = stripslashes(urldecode($_GET['message']));
    }
    else
    {
      $error = $_GET['error'];
    }
    return array('title' => KREDITOR_LANG_INFO_DE_ERRORINVOICE, 'error' => $error);
  }

  function check()
  {
    if (!isset($this->_check))
    {
      $check_query = xtc_db_query("select configuration_value from " .
				  TABLE_CONFIGURATION .
				  " where configuration_key = " .
				  "'MODULE_PAYMENT_KREDITOR_DE_STATUS'");
      $this->_check = xtc_db_num_rows($check_query);
    }
    return $this->_check;
  }

  function install()
  {
    xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_STATUS', 'True', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_ZONE', '0', '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_EID', '0', '6', '0', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_SECRET', '', '6', '0', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_AUTO_ACTIVATE', 'False', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_AUTO_ACTIVATE_SEND_DELAY', '0', '6', '2', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_ARTNO', 'model', '6', '2', 'xtc_cfg_select_option(array(\'id\', \'model\'),', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_IMAGEPOSITION', 'Block', '6', '2', 'xtc_cfg_select_option(array(\'Title\', \'Block\'),', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_ORDER_TOTAL_IGNORE', 'ot_tax,ot_total,ot_subtotal,ot_subtotal_no_tax,ot_shipping', '6', '2', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_ORDER_LIMIT', '10500', '6', '2', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_ORDER_MINLIMIT', '0', '6', '2', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_SORT_ORDER', '0', '6', '0', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_ORDER_STATUS_ID', '0', '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_TAX_CLASS', '0', '6', '6', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_KREDITOR_DE_ALLOWED', '', '6', '0', now())");
  }
  
  function remove()
  {
    xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }
  
  function keys()
  {
    return array('MODULE_PAYMENT_KREDITOR_DE_STATUS',
		 'MODULE_PAYMENT_KREDITOR_DE_ORDER_STATUS_ID',
		 'MODULE_PAYMENT_KREDITOR_DE_EID',
		 'MODULE_PAYMENT_KREDITOR_DE_SECRET',
		 'MODULE_PAYMENT_KREDITOR_DE_ARTNO',
		 'MODULE_PAYMENT_KREDITOR_DE_AUTO_ACTIVATE',
		 'MODULE_PAYMENT_KREDITOR_DE_AUTO_ACTIVATE_SEND_DELAY',
		 'MODULE_PAYMENT_KREDITOR_DE_ORDER_LIMIT',
		 'MODULE_PAYMENT_KREDITOR_DE_ORDER_MINLIMIT',
		 'MODULE_PAYMENT_KREDITOR_DE_ORDER_TOTAL_IGNORE',
		 'MODULE_PAYMENT_KREDITOR_DE_ZONE',
		 'MODULE_PAYMENT_KREDITOR_DE_TAX_CLASS',
		 'MODULE_PAYMENT_KREDITOR_DE_ALLOWED',
		 'MODULE_PAYMENT_KREDITOR_DE_IMAGEPOSITION',
		 'MODULE_PAYMENT_KREDITOR_DE_SORT_ORDER');
  }
}
