<?php
/**
* TESTMODUS: 
 * KLARNA_TEST_MODE=True 
 * KLARNA_TEST_MODE_CUSTOMER_ID=39
 * in der config.ebayapi hinterlegen





DRAN DENKEN: includes/simpleajax/ajax.js MANUELL EINSPIELEN







 #################################################
 ####### includes/header.php        ##############
 #################################################

SICHERSTELLEN DAS payment_modules->javascript_validation() implementiert ist.

if (strstr($PHP_SELF, FILENAME_CHECKOUT_SHIPPING) and defined('USE_EASYCHECKOUT') and USE_EASYCHECKOUT == 'True') {
 echo $payment_modules->javascript_validation();
}
 

 #################################################
 ####### checkout_confirmation.html ##############
 #################################################


 ####### irgendwo oben              ##############

 {if $KLARNA_CLIENT_TOKEN}

<script>
var KLARNA_CLIENT_TOKEN = '{$KLARNA_CLIENT_TOKEN}';
var KLARNA_ADDRESS_DATA = JSON.parse('{$KLARNA_ADDRESS_DATA}');
var KLARNA_EASYCHECKOUT = false;
</script>
<script src="includes/klarna_yes_pay_later.js"></script>
<script src="https://x.klarnacdn.net/kp/lib/v1/api.js" async></script>

 {/if}

 ####### AN DER STELLE WO BEZAHLART GEZEIGT WIRD  ###############
{if $PAYMENT_METHOD!=''}
 [...]
<div id="klarna_container"></div>
 [...]
{/if}






 ####### SUBMIT BUTTON ERSETZEN     ###############
        {if $KLARNA_CLIENT_TOKEN}
            {* KLARNA SUBMIT BUTTON *}
        <input class="y_button_w y_right" type="button" value="Zahlungspflichtig bestellen" onclick="this.style.display = 'none';klarna_auth();" alt="Zahlungspflichtig bestellen" title=" Zahlungspflichtig bestellen " />
        {else}
            {* ORIGINAL SUBMIT BUTTON *}
        <input type="submit" .... />
        {/if}


 #################################################
 ####### checkout_confirmation.html ##############
 #################################################








 #################################################
 ####### easy_checkout.html         ##############
 #################################################

 ####### irgendwo oben              ##############

 {if $KLARNA_CLIENT_TOKEN}

<script>
var KLARNA_CLIENT_TOKEN = '{$KLARNA_CLIENT_TOKEN}';
var KLARNA_ADDRESS_DATA = JSON.parse('{$KLARNA_ADDRESS_DATA}');
var KLARNA_EASYCHECKOUT = true;
var KLARNA_CATEGORIES = JSON.parse('{$KLARNA_CATEGORIES}');
</script>
<script src="includes/klarna_yes_pay_later.js"></script>
<script src="https://x.klarnacdn.net/kp/lib/v1/api.js" async></script>

 {/if}
 Alternativ hab ich in der includes/form_check.js.php noch eine Funktion,
 die bei Submit auf der checkout Seite die klarna Funktionalitaet startet
 
 ####### SUBMIT BUTTON              ###############
  
 Wenn der Submit Button als {$BUTTON_CONTINUE} eingebunden ist, muss nichts
 gemacht werden. Wird ein eigener Button eingebunden, muss drauf geachtet
 werden, dass dieser die id "checkout_submit_button" hat

 #################################################
 ####### easy_checkout.html         ##############
 #################################################


 *  
 */
class klarna_yes_pay_later{
    var $_check,$sort_order, $info, $enabled, $debug, $code, $title, $description,
        $base_url, $auth, $form_action_url,$sandbox;
    public function __construct() {
        global $order;
        $this->sandbox = (main::isDev(true) or main::isDev()) ? true : false;
        $this->base_url = ($this->sandbox === true) ? 'https://api.playground.klarna.com':'https://api.klarna.com';
        $this->debug = false;
        $this->code = 'klarna_yes_pay_later';
        $this->title = MODULE_PAYMENT_KLARNA_YES_PAY_LATER_TEXT_TITLE;
        $this->description = MODULE_PAYMENT_KLARNA_YES_PAY_LATER_TEXT_DESCRIPTION;
        if(defined('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SORT_ORDER') and !empty(constant('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SORT_ORDER'))){
            $this->sort_order = intval(constant('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SORT_ORDER'));
        }else{
            $this->sort_order = 2;
        }
        
        $this->enabled = (defined('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_STATUS') and MODULE_PAYMENT_KLARNA_YES_PAY_LATER_STATUS == 'true') ? true : false;
        if($this->enabled === true){
            $this->info = MODULE_PAYMENT_KLARNA_YES_PAY_LATER_TEXT_INFO;
            $this->auth = [
                'user'=>MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID,
                'pass'=>MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET,
            ];
        }
        if(is_object($order)){
            $this->update_status();
        }
    }
/**************************************************************/
    /**
     * Prueft ob das Modul in der Konfiguration aktiviert ist
     * @global order $order
     */
	function update_status() {
        global $order;
        if(!defined('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID') or MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID ==''){
            $this->enabled = false;
        }
        if(!defined('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET') or MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET ==''){
            $this->enabled = false;
        }
        if(($this->enabled == true) && intval(constant('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_ZONE')) > 0 ) {
            $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
                intval(constant('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_ZONE')),
                intval($order->billing['country']['id']),
                intval($order->billing['zone_id'])
            );
            if($check_flag == false) {
                $this->enabled = false;
            }
		}
	}
/**************************************************************/
	function javascript_validation() {
	}
/**************************************************************/
        
        /**
         * BEI EASYCHECKOUT MIT SUMMEN BEI NORMALEM CHECKOUT NUR ADRESSE
         * @return Array
         */
	function selection() {
            if(basename($_SERVER['SCRIPT_FILENAME']) == 'shopping_cart.php'){
                return [];
            }
            if(!defined('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID') or 
                    !defined('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET')
            ){
                return [];
            }
            // WENN KEINE KUNDEN ID DANN AUCH KEIN KLARNA KAUF
            if(!isset($_SESSION['customer_id'])){
                return [];
            }
            try{
                //if($this->get_session() == null){
                    if($this->create_session()){// setzt die _session[klarna_yes_pay_later]
                        return array(
                            'id' => $this->code, 
                            'module' => 'Klarna<div id="klarna_container"></div>',
                            'description' => $this->info
                        );
                    }
                    // ERSTMAL RAUS - IMMER ERZEUGEN
                /*}else{
                    return array(
                        'id'=>$this->code,
                        'module' => 'Klarna<div id="klarna_container"></div>',
                        'description' => $this->info
                    );
                }*/ 
            }catch(Exception $e){
                yes_mail_debug($e->getMessage(),false,'Klarna Session error');
            }
            return [];
	}
/**************************************************************/
	function pre_confirmation_check() {
        // HIER DEN AUTHORIZATION TOKEN DER IM EASY CHECKOUT
        // GENERIERT WURDE, NACHDEM DER USER SICH EINGELOGGT HAT
        // BEI KLARNA
        $_SESSION['klarna_yes_pay_later']['authorization_token'] = $_POST['klarna_authorization_token'];
	    $this->form_action_url = xtc_href_link(FILENAME_CHECKOUT_PROCESS);
        return;
	}
/**************************************************************/
	function confirmation() {
		// Stand: 29.04.2009
		return false;
	}
/**************************************************************/
	function process_button() {
		// Stand: 29.04.2009
		return false;
	}
/**************************************************************/
	function before_process() {
            // checkout process.php
            // wir haben den authorize_token erhalten und koennen
            // die bestellung nun bei klarna erzeugen
            // das versuchen wir hier
            $klarna_session = $this->get_session();
            if(!isset($klarna_session['authorization_token'])){
                if(defined('USE_EASYCHECKOUT') and USE_EASYCHECKOUT == 'True'){
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING.'?error_message=Klarna+Rechnungskauf+Fehlende+Authorisation'));
                }else{
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_CONFIRMATION));
                }
            }

            $session_response = $this->call('/payments/v1/sessions/'.$klarna_session['session_id']);
            $session_resp = json_decode($session_response,true);

            $yes_data = $this->getKlarnaOrderConstruct(true);
            $yes_data = [
                'order_lines'=>$session_resp['order_lines'],
                'order_amount'=>$session_resp['order_amount'],
                'order_tax_amount'=>$session_resp['order_tax_amount'],
                'purchase_country' => $session_resp['purchase_country'],
                'purchase_currency' => $session_resp['purchase_currency'],
                'shipping_address' => $session_resp['shipping_address'],
                'billing_address'=>$session_resp['billing_address']
            ];
            try {
                $response = $this->call('/payments/v1/authorizations/'.$klarna_session['authorization_token'].'/order',$yes_data);
                $resp = json_decode($response,true);
                if(isset($resp['fraud_status']) and $resp['fraud_status'] == 'ACCEPTED'){
                    // das ist die order_id die klarna bestaetigt hat
                    // kauf erfolgreich.
                    $_SESSION['klarna_yes_pay_later']['klarna_order_id'] = $resp['order_id'];
                    $_SESSION['klarna_yes_pay_later']['authorized_payment_method'] = $resp['authorized_payment_method']['type'];
                }else{
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING.'?error_message=Klarna%20Zahlung%20fehlgeschlagen'));
                }
            } catch (Exception $e) {
                xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING.'?error_message=Klarna%20Zahlung%20wegen%20Abbruch%20fehlgeschlagen'));
            }
	}
/**************************************************************/
	function payment_action() {
		return;
	}
/**************************************************************/
	function after_process() {
            global $order, $insert_id;
            $klarna_session = $this->get_session();
            $insert_sql_array = array(
                'orders_id'=>(int)$insert_id,
                'klarna_intern_orders_id'=>$klarna_session['klarna_order_id'],
                'merchant_id'=>constant('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID'),
                'payment_method'=>$klarna_session['authorized_payment_method'],
            );
            yes_db_perform('klarna_orders',$insert_sql_array);
            $this->clear_session();
            // ORDER AUF BEZAHLT SETZEN
            $update_sql_array = array(
                'orders_status'=>ORDERS_STATUS_BEZAHLT
            );
            yes_db_perform(TABLE_ORDERS,$update_sql_array,'update',[
                'orders_id'=>(int)$insert_id
            ]);
            $order->add_history(ORDERS_STATUS_BEZAHLT, false, 'Klarna Payment success');
            return;
	}
/**************************************************************/
	function check() {
		// Stand: 29.04.2009
		if(!isset($this->_check)) {
			$check_query = xtc_db_query("select configuration_value from ".TABLE_CONFIGURATION." where configuration_key = 'MODULE_PAYMENT_KLARNA_YES_PAY_LATER_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}
/**************************************************************/
	function admin_order($oID) {
		// Stand: 29.04.2009
		return false;
	}
/**************************************************************/
	function install() {
            global $messageStack;
            try{
                xtc_db_query(
                    "/* DROP TABLE IF EXISTS `klarna_orders`;*/
                    CREATE TABLE `klarna_orders` (  `klarna_orders_id` int(11) NOT NULL,  `orders_id` int(11) NOT NULL,  `klarna_intern_orders_id` varchar(64) NOT NULL,  `merchant_id` varchar(64) NOT NULL,`fulfillment_sent` INT(1) NOT NULL,payment_method VARCHAR(32) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Auftragsdaten die mit Klarna Payment erzeugt wurden';
                    ALTER TABLE `klarna_orders`  ADD PRIMARY KEY (`klarna_orders_id`),  ADD KEY `orders_id` (`orders_id`);
                    ALTER TABLE `klarna_orders`  MODIFY `klarna_orders_id` int(11) NOT NULL AUTO_INCREMENT;"
                );
            }catch(Exception $e){
                $messageStack->add_session('Klarna Installation - Basistabellen existierten bereits.'.$e->getMessage(),'error');
            }
            xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) "
                . "values ('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_STATUS', 'true', '6', '0', "
                . "'xtc_cfg_select_option(array(\'true\', \'false\'),',NULL, now())");
            xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) "
                . "values ('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_ALLOWED', 'DE', '6', '1', "
                . "NULL, NULL, now())");
            xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) "
                . "values ('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_ZONE', '', '6', '2', "
                . "NULL, NULL, now())");
            xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) "
                . "values ('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SORT_ORDER', '', '6', '3', "
                . "NULL, NULL, now())");
            xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) "
                . "values ('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET', '', '6', '5', "
                . "NULL, NULL, now())");
            xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) "
                . "values ('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID', '', '6', '4', "
                . "NULL, NULL, now())");
	}
/**************************************************************/
	function remove() {
		xtc_db_query("delete from ".TABLE_CONFIGURATION." where configuration_key LIKE 'MODULE_PAYMENT_KLARNA_YES%'");
	}
	function keys() {
		// Stand: 29.04.2009
            return array('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_STATUS', 
                'MODULE_PAYMENT_KLARNA_YES_PAY_LATER_ALLOWED', 'MODULE_PAYMENT_KLARNA_YES_PAY_LATER_ZONE',
                'MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SORT_ORDER',
                'MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID',
                'MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET'
            );
	}
	public function call( string $url, array $post_fields = [], string $customRequest = '', $use_post = false ){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $this->base_url.$url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $this->auth['user'].':'.$this->auth['pass']);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			"Content-Type: application/json",
		]);
        
		if(sizeOf($post_fields)){
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));
		}
		if(!empty($customRequest)){
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $customRequest);			
		}
		if($use_post === true){
			curl_setopt($ch, CURLOPT_POST, true);  // POST-Methode sicherstellen			
		}
		// cURL-Ausführung und Antwort
		$resp = curl_exec($ch);

		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);  // Statuscode abfragen
		curl_close($ch);
		if(!in_array($httpCode,[200,204,201])){
			throw new \Exception($this->base_url.$url.': Invalid Statuscode '.$httpCode.' '.print_r($resp,true));
		}
		return $resp;
	}

    public function clear_session(){
        $_SESSION['klarna_yes_pay_later'] = null;
        unset($_SESSION['klarna_yes_pay_later']);
    }

    public function save_session(array $data){
        $_SESSION['klarna_yes_pay_later'] = $data;
    }

    public function get_session():array|null{
        return $_SESSION['klarna_yes_pay_later']??null;
    }

    public function create_session(){
        try{
            $data = $this->get_create_session_data();
            $response = $this->call('/payments/v1/sessions',$data,'',true);
            $resp = json_decode($response,true);
            $this->save_session($resp);    
            //yes_mail_debug("WIR ERZEUGEN EINE NEUE KLARNA SESSION BEIM AUFRUF DER KAUFABWICKLUNG:\n".print_r($data,true)."\n\nUND WIR ERHALTEN:\n".print_r($resp,true),true,'KLARNA SESSION ERZEUGT');
        }catch(Exception $e){
            yes_mail_debug('Klarna session failed '.$e->getMessage(),false,'Klarna create Session Fehler');
            throw new Exception($e->getMessage());
        }
        return true;
    }

    public function update_session_total(array $order_totals){
        $total = 0;
        foreach($order_totals as $ot){
            if($ot['code']=='ot_total'){
                $total += xtc_round(floatval($ot['value']),2)*100;
            }
        }
        $klarna_session = $this->get_session();
        $data = [
            'order_lines'=>[[
                'name'=>'Ihre Bestellung bei '.constant('STORE_NAME'),
                'quantity'=>1,
                'total_amount'=>$total,
                'unit_price'=>$total,
            ]],
            "order_amount"=> $total,
        ];
        $response = $this->call('/payments/v1/sessions/'.$klarna_session['session_id'],$data,'',true);
        //yes_mail_debug("WIR AKTUALISIEREN DIE SUMMEN DER KLARNA SESSION:\n".print_r($data,true)."\n\nUND WIR ERHALTEN:\n".print_r(json_decode($response,true),true),true,'KLARNA SESSION AKTUALISIERT');
    }

    public function get_create_session_data():array{
        $order = new \order('',$xtPrice);
        $order_total_modules = new \order_total($order->Price); // GV Code ICW ADDED FOR CREDIT CLASS SYSTEM
        $order_totals = $order_total_modules->process();
        $total = 0;
        foreach($order_totals as $ot){
            if($ot['code']=='ot_total'){
                $total += xtc_round(floatval($ot['value']),2)*100;
            }
        }
        $data = [
            "acquiring_channel"=> "ECOMMERCE",
            "billing_address"=>[
              "city"=> $order->billing['city'],
              "country"=> $order->billing['country']['iso_code_2'],
              "email"=> ($this->sandbox === true)?'customer@email.'.strtolower($order->billing['country']['iso_code_2']) : $order->customer['email_address'],
              "family_name"=> $order->billing['lastname'],
              "given_name"=> $order->billing['firstname'],
              "organization_name"=> $order->billing['company']??null,
              "phone"=> null,
              "postal_code"=> $order->billing['postcode'],
              "street_address"=> $order->billing['street_address'],
              "street_address2"=> $order->billing['suburb']??null,
            ],
            'order_lines'=>[[
                'name'=>'Ihre Bestellung bei '.constant('STORE_NAME'),
                'quantity'=>1,
                'total_amount'=>"$total",
                'unit_price'=>"$total",
            ]],
            "locale"=> "de-DE",
            "merchant_urls"=>[
              "confirmation"=> $this->get_return_url_base()."checkout_process.php",
              "notification"=> $this->get_return_url_base()."callback/klarna.php",
              "push"=> $this->get_return_url_base()."callback/klarna.php",
              "authorization"=> $this->get_return_url_base()."checkout_process.php",
             ],
            "order_amount"=> "$total",
            "order_tax_amount"=> 0,
            "purchase_country"=> $order->billing['country']['iso_code_2'],
            "purchase_currency"=> "EUR",
            "shipping_address"=>[
              "city"=> $order->delivery['city'],
              "country"=> $order->delivery['country']['iso_code_2'],
              "email"=> ($this->sandbox === true)?'customer@email.'.strtolower($order->billing['country']['iso_code_2']) : $order->customer['email_address'],
              "family_name"=> $order->delivery['lastname'],
              "given_name"=> $order->delivery['firstname'],
              "phone"=> null,
              "postal_code"=> $order->delivery['postcode'],
              "street_address"=> $order->delivery['street_address'],
              "street_address2"=> $order->delivery['suburb']??null,
              "organization_name"=> $order->delivery['company']??null,
            ],
            "intent"=> "buy"
          ];
          return $data;
  
    }

    public function get_return_url_base(){
        return ($this->sandbox === true)? 'https://yes-a177922.de/':HTTPS_SERVER;
    }

    public function getKlarnaOrderAdressPart($part){
        global $order;
        switch($part){
            case 'billing':
                $address_source = $order->billing;
                break;
            case 'shipping':
                $address_source = $order->delivery;
                break;
        }
        $gender = '';
        if(isset($address_source['gender']) and $address_source['gender']!=''){
            $gender = ($address_source['gender']=='f')?"Frau":"Herr";
        }
        return [
            "given_name" => $address_source['firstname'],
            "family_name" => $address_source['lastname'],
            "email" => $order->customer['email_address'],
            "title" => $gender,
            "street_address" => $address_source['street_address'],
            "street_address2" => $address_source['suburb'],
            "postal_code" => $address_source['postcode'],
            "city" => $address_source['city'],
            "region" => $address_source['state'],
            "phone" => $order->customer['telephone'],
            "country" => $address_source['country']['iso_code_2']
        ];
        
    }
    public function getKlarnaGender(){
        global $order;
        return ($order->customer['gender']=='f')?'female':'male';

    }

    public function getKlarnaOrderConstruct($addresses=false){
        global $order, $order_totals;
        $total_tax = 0;
        $order_lines = [];//$this->getKlarnaOrderLines($order->products);
        $order_amount = 0;
        $order_tax_amount = 0;
        foreach($order_lines as $orl){
            $order_amount += $orl['total_amount'];
            $order_tax_amount += $orl['total_tax_amount'];
        }
        if(!$addresses){
            return [
                "purchase_country" => strtolower($order->billing['country']['iso_code_2']),
                "purchase_currency" => strtolower($order->info['currency']),
                "locale" => "de-de",
                "order_amount" => (int)$order_amount,
                "order_tax_amount" => (int)$order_tax_amount,
                "order_lines" => $order_lines,
            ];
        }
        return [
            "purchase_country" => strtolower($order->billing['country']['iso_code_2']),
            "purchase_currency" => strtolower($order->info['currency']),
            "locale" => "de-de",
            "order_amount" => (int)$order_amount,
            "order_tax_amount" => (int)$order_tax_amount,
            "order_lines" => $order_lines,
            "billing_address"=>$this->getKlarnaOrderAdressPart('billing'),
            "shipping_address"=>$this->getKlarnaOrderAdressPart('shipping'),
        ];
    }

}
