<?php
class amazon_payment {
    var $code, $title, $description, $enabled;


    function __construct() {
      global $order;

      $this->code = 'amazon_payment';
      $this->title = MODULE_PAYMENT_AMAZON_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_AMAZON_TEXT_DESCRIPTION;
      $this->enabled = ((defined('MODULE_PAYMENT_AMAZON_STATUS') and MODULE_PAYMENT_AMAZON_STATUS == 'True') ? true : false);
      $this->sort_order = (defined('MODULE_PAYMENT_AMAZON_SORT_ORDER')) ? MODULE_PAYMENT_AMAZON_SORT_ORDER : 0;
      if($this->enabled === true){
        $this->min_order = MODULE_PAYMENT_AMAZON_MIN_ORDER;
        if ((int)MODULE_PAYMENT_AMAZON_ORDER_STATUS_ID > 0) {
          $this->order_status = MODULE_PAYMENT_AMAZON_ORDER_STATUS_ID;
        }
        if (is_object($order)) $this->update_status();
      }
    }


    function update_status() {
        global $order;
        $customer_id = (int)$_SESSION['customer_id'];
        $order_check_query = yes_query(
            "select orders_id from " . TABLE_ORDERS . " where customers_id =:customers_id",
            ['customers_id'=>$customer_id],
        );

        if (sizeOf($order_check_query) >= MODULE_PAYMENT_AMAZON_MIN_ORDER) {
            $check_flag = false;
        }else{
            if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_AMAZON_ZONE > 0) ) {
                $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
                    intval(MODULE_PAYMENT_AMAZON_ZONE),
                    intval($order->delivery['country']['id']),
                    intval($order->delivery['zone_id'])
                );
            }
            if ($check_flag == false) {
                $this->enabled = false;
            }
        }

        if ($this->enabled == true) {
            if ($order->content_type == 'virtual') {
                $this->enabled = false;
            }
        }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return false;
    }

    function process_button() {
      return false;
    }

    function before_process() {
      return false;
    }

    function after_process() {
      return false;
    }

    function get_error() {
      return false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_AMAZON_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_AMAZON_STATUS', 'False',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_AMAZON_ALLOWED', '', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_AMAZON_ZONE', '0',  '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_AMAZON_SORT_ORDER', '0',  '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_AMAZON_MIN_ORDER', '0',  '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_AMAZON_ORDER_STATUS_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
   }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_AMAZON_STATUS','MODULE_PAYMENT_AMAZON_ALLOWED', 'MODULE_PAYMENT_AMAZON_ZONE', 'MODULE_PAYMENT_AMAZON_ORDER_STATUS_ID', 'MODULE_PAYMENT_AMAZON_MIN_ORDER', 'MODULE_PAYMENT_AMAZON_SORT_ORDER');
    }
}


