<?php
/* -----------------------------------------------------------------------------------------
   $Id: ot_subtotal.php,v 1.2 2008/11/18 10:53:56 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(ot_subtotal.php,v 1.7 2003/02/13); www.oscommerce.com 
   (c) 2003	 nextcommerce (ot_subtotal.php,v 1.10 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

  class ot_subtotal {
    var $title, $output, $code, $description, $enabled, $sort_order, $Price;

    function __construct($price) {
      $this->code = 'ot_subtotal';
      $this->title = MODULE_ORDER_TOTAL_SUBTOTAL_TITLE;
      $this->description = MODULE_ORDER_TOTAL_SUBTOTAL_DESCRIPTION;
      $this->enabled = ((defined('MODULE_ORDER_TOTAL_SUBTOTAL_STATUS') and MODULE_ORDER_TOTAL_SUBTOTAL_STATUS == 'true') ? true : false);
      $this->sort_order = (defined('MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER')) ? MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER : 0;
      $this->Price=$price;

      $this->output = array();
    }

    function process() {
      global $order, $currencies;
      if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 0) {
	$this->output[] = array('title' => MODULE_ORDER_TOTAL_SUBTOTAL_TITLE_NO_TAX . ':',
                                'text' => $this->Price->xtcFormat($order->info['subtotal'],true),
                                'value' => $order->info['subtotal']);
      }
      if ($_SESSION['customers_status']['customers_status_show_price_tax'] != 0) {
        $item = \YES4Trade\Model\address_book::get_by_customers_id_and_address_book_id((int)$_SESSION['customer_id'], (int)$_SESSION['sendto']);
        if($item != null){
            $country_id = $item->entry_country_id;
        }else{
            $country_id = STORE_COUNTRY;
        }
        $zone_id = 0;
        $tax_class_id = 1; // egal, geht nur drum ob tax enthalten oder nicht
        $shipping_tax = xtc_get_tax_rate($tax_class_id, $order->delivery['country']['id'], $order->delivery['zone_id']);
        if($shipping_tax > 0){
            $title = $this->title;
	}else{
            $title = $this->title.' (Netto)';
	}
	$this->output[] = array(
            'title' => $title . ':',
            'text' => $this->Price->xtcFormat($order->info['subtotal'],true),
            'value' => $order->info['subtotal']
        );
      }


    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }

      return $this->_check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER');
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', '6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '1', '6', '2', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
