<?php
/*
$Id: ot_payment_fee.php,v 1.30 2018/11/28 07:49:27 cvs Exp $
$Id: ot_payment_fee.php,v 1.30 2018/11/28 07:49:27 cvs Exp $

XT-Commerce - community made shopping
http://www.xt-commerce.com

Copyright (c) 2008 mario aspeleiter <mario.aspeleiter@gmx.de>
-----------------------------------------------------------------------------------------
based on:
Copyright (c) 2002 osCommerce - Marco Falcini - MARCUS - <www.oscommercedev.com>
Copyright (c) 2005-2006 Manfred Dennerlein <manni@zapto.de> - 1st Vision GmbH

Adapted for xtcommerce 2005/11/25 by Manfred Dennerlein (md@1st-vision.de)
Adapted for YES and xtcommerce 2008/01/07 by mario aspeleiter (mario.aspeleiter@agri-consulting.de)

Released under the GNU General Public License
-----------------------------------------------------------------------------------------
*/

define('MODULE_ORDER_TOTAL_PAYMENT_STATUS_TITLE', 'Anzeigen Bezahlartengeb&uuml;hr');
define('MODULE_ORDER_TOTAL_PAYMENT_STATUS_DESC', 'Soll dieses Modul angezeigt werden?');
define('MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER_TITLE', 'Sortierreihenfolge');
define('MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER_DESC','Sortierreihenfolge dieses Moduls.');

// NEW HANDLING FOR ALL PAYMENTS
define('MODULE_ORDER_TOTAL_PAYMENT_DEFINE_TITLE','Konfiguration der Bezahlarten');
define('MODULE_ORDER_TOTAL_PAYMENT_DEFINE_DESC','Konfigurieren Sie die Geb&uuml;hren der einzelnen Bezahlarten. '.
	'Sie k&ouml;nnen mehrere Bezahlarten definieren durch Komma getrennt. '.
	'F&uuml;r jede Bezahlart k&ouml;nnen Sie eine Geb&uuml;hr in Prozent sowie einen festen Betrag festlegen.<br /><br />'.
	'<b>Beispiel:</b><br /><i>paypal:3.4:0.35,sofortueberweisungredirect:4.8:0.45</i><br /><br />'.
	'Mit dieser gezeigten Beispielkonfiguration definieren Sie f&uuml;r die Bezahlarten Paypal und Sofortueberweisung (Redirect) Bezahlarten-Geb&uuml;hren. '.
	'Bei Paypal wird eine prozentuale Geb&uuml;hr von 3,4% des Auftragswerts und ein fester Betrag von 0,35EUR in Rechnung gestellt. '.
	'Bei der Konfiguration f&uuml;r Sofortueberweisung (Redirect) wird eine prozentuale Geb&uuml;hr von 4,8% und ein fester Betrag von 0,45EUR Geb&uuml;hr berechnet.');


define('MODULE_ORDER_TOTAL_PAYMENT_SHOW_RATE_TITLE','Zeige Bezahlartengeb&uuml;hr');
define('MODULE_ORDER_TOTAL_PAYMENT_SHOW_RATE_DESC','Zeige Bezahlartengeb&uuml;hren auf der Bestellbest&auml;tigungsseite?');

// REVERSE KOMMT KOMPLETT RAUS
define('MODULE_ORDER_TOTAL_PAYMENT_CALC_TYPE','Normal');

class ot_payment_fee {
	var $title, $output, $code, $description, $enabled, $sort_order;
	var $debug = false;

	function __construct() {
		global $xtPrice;
		$this->code = 'ot_payment_fee';
                if(defined('MODULE_ORDER_TOTAL_PAYMENT_TITLE')){
                    $this->title = MODULE_ORDER_TOTAL_PAYMENT_TITLE;
                }
                if(defined('MODULE_ORDER_TOTAL_PAYMENT_DESCRIPTION')){
                    $this->description = MODULE_ORDER_TOTAL_PAYMENT_DESCRIPTION;
                }
		$this->enabled = ((defined('MODULE_ORDER_TOTAL_PAYMENT_STATUS') and MODULE_ORDER_TOTAL_PAYMENT_STATUS == 'true') ? true : false);
                if(defined('MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER')){
                    $this->sort_order = MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER;
                }
		$this->output = array();
	}

	// function to check and calc payment_fees
	function calc_fees($payment_values,$cart_payment_value = ''){
		global $order, $currencies, $xtPrice;
		$this->debug(sprintf('calc_fees(%s,%s)',implode('|',$payment_values),$cart_payment_value));
		//printf('<li><b>calc_fees(</b>%s,%s<b>)</b></li>',implode(':',$payment_values),$cart_payment_value);
		//check if payment method is paypal. If yes, add fee.
		if($cart_payment_value == ''){
		    $selected_payment = (isset($_SESSION['payment']))?$_SESSION['payment']:null;
        }else{
		    $selected_payment = $cart_payment_value;
        }
		// PAYPAL IPN MUSS NICHT EXTRA DEFINIERT WERDEN
		if(!empty($selected_payment) and strtolower($selected_payment) == 'paypal_ipn'){
			$selected_payment = 'paypal';
		}
		$fee_proz = (isset($payment_values[1]))?$payment_values[1]:0;
		if(isset($payment_values[2])){
			$fee_flat = $payment_values[2];
		}else{
			$fee_flat = 0;
		}
		if (!empty($selected_payment) and strtolower($selected_payment) == strtolower($payment_values[0])) { // gewaehlte Bezahlart hat Gebuehr
                        // checkout_shipping
                        if(isset($order->info['pp_total'])){
                                $order_total = $order->info['pp_total'];
                        }else{
                                $order_total = $order->info['total'];
                        }
                        // BUGFIX MARIO:
                        $order_total = $order_total - $order->info['shipping_cost'];
                        if(!$_SESSION['customers_status']['customers_status_show_price_tax']) {
                                $order_total += $order->info['tax'];
                        }
			$this->debug(sprintf('<b>selected payment %s total: %s</b> (cart_payment_value: "%s")',$selected_payment,$order_total,$cart_payment_value));
			if(MODULE_ORDER_TOTAL_PAYMENT_CALC_TYPE == 'Reverse') {
				$payment_fee =  $xtPrice->xtcFormat( ($order_total + $fee_flat)/ (1 - $fee_proz/100) - $order_total, false);
			} else {
				$payment_fee =  $xtPrice->xtcFormat((($fee_proz/100) * $order_total) + $fee_flat, false);
			}
			return $payment_fee;
		}
		return false;
	}

	// $cart_payment_method WIRD NUR GESETZT IM WARENKORB FUER DIE PREVIEW
	function process($cart_payment_method = '') {
		global $order, $currencies, $xtPrice;
		if (defined('MODULE_ORDER_TOTAL_PAYMENT_STATUS') and MODULE_ORDER_TOTAL_PAYMENT_STATUS == 'true') {
			// NEW HANDLING FOR ALL PAYMENTS
			$defines = explode(',',MODULE_ORDER_TOTAL_PAYMENT_DEFINE);
				  
			if(is_array($defines) and sizeOf($defines)>0){
				foreach($defines as $k=>$payment_fee_define){
					$payment_fee = explode(':',$payment_fee_define);
					$fee = $this->calc_fees($payment_fee,$cart_payment_method);
					if($fee){ // GEBUEHR ERMITTELT
						if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 1) {
						    if($cart_payment_method != ''){
							// brauchen wir nicht im cart, aber ich berechne es mal
                                                        // 2021/07 NICHT SESSION_CART SONDERN order object
							//$cart_tax = $this->process_tax_rates($order,$fee,true);
						    }else{
							$this->process_tax_rates($order,$fee);
						    }
						}
						$fee_proz = $payment_fee[1];
						$fee_flat = (isset($payment_fee[2]))?$payment_fee[2]:0;
						$order->info['total'] += $fee;
						$order->info['subtotal'] += $fee;
						if(MODULE_ORDER_TOTAL_PAYMENT_SHOW_RATE == 'true') {
							$this->output[] = array('title' => $this->title . ' (' . (($fee_proz) ? $fee_proz . ' %'  : '') . ( ($fee_proz && $fee_flat) ? ' + ' : '' ) . (($fee_flat) ? $xtPrice->xtcFormat($fee_flat, true) : '') . '):',
								'text' =>  $xtPrice->xtcFormat($fee, true),
								'value' => $fee,
								'tax_rate_percent'=>$fee_proz
							);
						} else {
							$this->output[] = array('title' => $this->title . ':',
								'text' =>  $xtPrice->xtcFormat($fee, true),
								'value' => $fee,
								'tax_rate_percent'=>$fee_proz
							);
						}
						if($cart_payment_method != '')
						    return $fee;
					}
				}
			}
		}
	}
	function process_tax_rates($order,$fee,$cart = false){
            if($cart){
                if(isset($_SESSION['sendto'])){
                    $item = \YES4Trade\Model\address_book::get_by_address_book_id((int)$_SESSION['sendto']);
                    $delivery_country = $item->toArray();
                }else{
                    if(isset($_SESSION['customer_default_address_id'])){
                        $item = \YES4Trade\Model\address_book::get_by_address_book_id((int)$_SESSION['customer_default_address_id']);
                        $delivery_country = $item->toArray();
                        $tax_country_id = (isset($_SESSION['default_shipping_countries_id'])) ? $_SESSION['default_shipping_countries_id'] : $delivery_country['entry_country_id'];
                        $tax_zone_id = (isset($_SESSION['default_shipping_countries_id'])) ? 0 : $delivery_country['entry_zone_id'];
                    }else{
                        // USER NOCH NICHT ANGEMELDET
                        $tax_country_id = STORE_COUNTRY;
                        $tax_zone_id = 0;
                    }
                }
            }else{
                $tax_country_id = $order->delivery['country']['id'];
                $tax_zone_id = $order->delivery['zone_id'];
            }
            // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            /*if(!yes_eu_oss_use_country_handling($tax_country_id)){
                $tax_country_id = STORE_COUNTRY;
                $tax_zone_id = 0;
            }*/
            // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            
	    $cart_taxes = array(); // WARENKORB HANDLING
		//printf('<li><b>process_tax_rates(</b>%s,%s,%s<b>)</b></li>','order',$fee,$cart);
		$tax_array = array();
		$items = (!$cart) ? $order->products : $order->get_products();
		foreach($items as $product){
		    $_tax = ($cart) ? xtc_get_tax_rate($product['tax_class_id'], $tax_country_id, $tax_zone_id) : $product['tax'];
		    $_tax = number_format($_tax,2,'.','');
		    if(!isset($tax_array[ 'TAX'.$_tax ])){
			    $tax_array[ 'TAX'.$_tax ] = array(
				'tax_rate' => $_tax,
				'tax_class_id' => $product['tax_class_id'],
				'tax_total' => 0,
				'percentage' => 0
			    );
		    }
		    $tax_array[ 'TAX'.$_tax ]['tax_total'] += $product['final_price'];
		}
		$_subtotal = ($cart) ? $order->total : $order->info['subtotal'];
		foreach($tax_array as $tax_rate => $tax_data){
			$tax_array[$tax_rate]['percentage'] = $tax_array[$tax_rate]['tax_total'] / ($_subtotal/100);
			$discount_value_brutto = $fee / 100 * $tax_array[$tax_rate]['percentage'];
			$discount_value_tax = $discount_value_brutto-($discount_value_brutto / ((100+$tax_array[$tax_rate]['tax_rate'])/100));
			$order->info['tax'] += $discount_value_tax;
			if($cart){
			    if(isset($_SESSION['default_shipping_countries_id']) and $_SESSION['default_shipping_countries_id']>0){
				$discount_tax_description = xtc_get_tax_description($tax_array[$tax_rate]['tax_class_id'], $_SESSION['default_shipping_countries_id']);
			    }else{
				if(isset($_SESSION['customer']['country_id']) and $_SESSION['customer']['country_id'] > 0){
				    $discount_tax_description = xtc_get_tax_description($tax_array[$tax_rate]['tax_class_id'],$_SESSION['customer']['country_id']);
				}else{
				    $tax_country_id = (isset($_SESSION['customer']['country_id']))?$_SESSION['customer']['country_id']:STORE_COUNTRY;
				    $discount_tax_description = xtc_get_tax_description($tax_array[$tax_rate]['tax_class_id'],$tax_country_id);
				}
			    }
			}else{
			    $discount_tax_description = xtc_get_tax_description($tax_array[$tax_rate]['tax_class_id'], $tax_country_id, $tax_zone_id);
			}
			if(!$cart){
			    $order->info['tax_groups'][TAX_ADD_TAX . $discount_tax_description] += $discount_value_tax;
			}else{
			    $cart_taxes[ $tax_data['tax_class_id'] ] = $discount_value_tax;
			}
			//$order->info['total'] -= $discount_value_tax;
		}
		if($cart){
		    return $cart_taxes;
		}
	}
	function check() {
		if (!isset($this->_check)) {
			$check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_PAYMENT_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}

		return $this->_check;
	}

	function keys() {
		return array('MODULE_ORDER_TOTAL_PAYMENT_STATUS', 'MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER', 'MODULE_ORDER_TOTAL_PAYMENT_DEFINE', 'MODULE_ORDER_TOTAL_PAYMENT_SHOW_RATE','MODULE_ORDER_TOTAL_PAYMENT_TAX_CLASS');
	}

	function install() {
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_PAYMENT_STATUS', 'true', '6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_PAYMENT_SHOW_RATE', 'true', '6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_ORDER_TOTAL_PAYMENT_TAX_CLASS', 'true', '6', '1','xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(',now())");
			
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER', '35',  '6', '2', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_PAYMENT_DEFINE', 'paypal:3.4:0.35,sofortueberweisungredirect:4.8:0.45', '6', '3', now())");
	}


	function remove() {
		xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
	}
	
	function debug($msg){
	    if($this->debug)
		echo '<li>'.$msg;
	}
}

