<?php
/* -----------------------------------------------------------------------------------------
   $Id: checkout_new_address.php,v 1.6 2016/05/12 10:49:36 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(checkout_new_address.php,v 1.3 2003/05/19); www.oscommerce.com 
   (c) 2003	 nextcommerce (checkout_new_address.php,v 1.8 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

$module_smarty=new yesSmarty;
$module_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
// include needed functions
require_once(DIR_FS_INC . 'xtc_draw_radio_field.inc.php');
require_once(DIR_FS_INC . 'xtc_get_country_list.inc.php');
require_once(DIR_WS_CLASSES.'yes_input_field.php');

if (!isset($process)) $process = false;

if(!isset($default_array)){
    $default_array = array(
	'gender'=>'m',
	'firstname'=>'',
	'lastname'=>'',
	'company'=>'',
	'street_address'=>'',
	'suburb'=>'',
	'postcode'=>'',
	'city'=>'',
	'state'=>'',
	'country'=>STORE_COUNTRY,
	'zone_id'=>0
    );
}

if (ACCOUNT_GENDER == 'true') {
    $male = ($default_array['gender'] == 'm') ? true : false;
    $female = ($default_array['gender'] == 'f') ? true : false;
    $module_smarty->assign(array(
	'gender'=>'1',
	'INPUT_MALE'=>xtc_draw_radio_field('gender', 'm', $male),
	'INPUT_FEMALE'=>xtc_draw_radio_field('gender', 'f', $female)  . (xtc_not_null(ENTRY_GENDER_TEXT) ? '<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>': ''),
	'INPUT_GENDER_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'gender',
	    'label'=>ENTRY_GENDER,
	    'type'=>'radio',
	    'required'=>true,
	    'required_text'=>ENTRY_GENDER_TEXT,
	    'values'=>array(
		array(
		    'label'=>MALE,
		    'value'=>'m',
		    'checked'=>$male
		),
		array(
		    'label'=>FEMALE,
		    'value'=>'f',
		    'checked'=>$female
		)
	    )
	)),
    ));	
}
if (ACCOUNT_COMPANY == 'true') {
    $module_smarty->assign(array(
	'company'=>'1',
	'INPUT_COMPANY'=>xtc_draw_input_field('company',$default_array['company']) . '&nbsp;' . (xtc_not_null(ENTRY_COMPANY_TEXT) ? '<span class="inputRequirement">' . ENTRY_COMPANY_TEXT . '</span>': ''),
	'INPUT_COMPANY_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'company',
	    'label'=>ENTRY_COMPANY,
	    'type'=>'text',
	    'required'=>((defined('ENTRY_COMPANY_MIN_LENGTH') and ENTRY_COMPANY_MIN_LENGTH > 0) ? true : false),
	    'minlength'=>ENTRY_COMPANY_MIN_LENGTH,
	    'maxlength'=>64,
	    'placeholder'=>(defined('ENTRY_COMPANY_PLACEHOLDER') and ENTRY_COMPANY_PLACEHOLDER != '') ? ENTRY_COMPANY_PLACEHOLDER : '',
	    'required_text'=>ENTRY_COMPANY_TEXT,
	    'value'=>$default_array['company']
	))
    ));
}
if (ACCOUNT_SUBURB == 'true') {
    $module_smarty->assign(array(
	'suburb'=>'1',
	'INPUT_SUBURB'=>xtc_draw_input_field('suburb',$default_array['suburb']) . '&nbsp;' . (xtc_not_null(ENTRY_SUBURB_TEXT) ? '<span class="inputRequirement">' . ENTRY_SUBURB_TEXT . '</span>': ''),
	'INPUT_SUBURB_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'suburb',
	    'label'=>ENTRY_SUBURB,
	    'type'=>'text',
	    'required'=>false,
	    'maxlength'=>128,
	    'placeholder'=>(defined('ENTRY_SUBURB_PLACEHOLDER') and ENTRY_SUBURB_PLACEHOLDER != '') ? ENTRY_SUBURB_PLACEHOLDER : '',
	    'required_text'=>ENTRY_SUBURB_TEXT,
	    'value'=>$default_array['suburb']
	))
    ));
}
if (ACCOUNT_STATE == 'true') {
    if ($process == true) {
      if ($entry_state_has_zones == true) {
	$zones_array = array();
	$zones_query = yes_query(
            "select zone_name from " . TABLE_ZONES . " where zone_country_id =:country_id order by zone_name",
            ['country_id'=> (int)$country]
        );
	foreach($zones_query as $zones_values) {
	    $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
	}
	$entry_state = xtc_draw_pull_down_menu('state', $zones_array,$default_array['state']);
	$state_array_data = array(
	    'name'=>'state',
	    'label'=>ENTRY_STATE,
	    'type'=>'select',
	    'required'=>((defined('ENTRY_STATE_MIN_LENGTH') and ENTRY_STATE_MIN_LENGTH > 0) ? true : false),
	    'required_text'=>ENTRY_STATE_TEXT,
	    'default_value'=>$default_array['state'],
	    'options'=>$zones_array
	);
      } else {
	    $entry_state =  xtc_draw_input_field('state',$default_array['state']);
	    $state_array_data = array(
		'name'=>'state',
		'label'=>ENTRY_STATE,
		'type'=>'text',
		'required'=>((defined('ENTRY_STATE_MIN_LENGTH') and ENTRY_STATE_MIN_LENGTH > 0) ? true : false),
		'minlength'=>ENTRY_STATE_MIN_LENGTH,
		'maxlength'=>64,
		'placeholder'=>(defined('ENTRY_STATE_PLACEHOLDER') and ENTRY_STATE_PLACEHOLDER != '') ? ENTRY_STATE_PLACEHOLDER : '',
		'required_text'=>ENTRY_STATE_TEXT,
		'value'=>$default_array['state']
	    );
      }
    } else {
	$entry_state =  xtc_draw_input_field('state',$default_array['state']);
	$state_array_data = array(
	    'name'=>'state',
	    'label'=>ENTRY_STATE,
	    'type'=>'text',
	    'required'=>((defined('ENTRY_STATE_MIN_LENGTH') and ENTRY_STATE_MIN_LENGTH > 0) ? true : false),
	    'minlength'=>ENTRY_STATE_MIN_LENGTH,
	    'maxlength'=>64,
	    'placeholder'=>(defined('ENTRY_STATE_PLACEHOLDER') and ENTRY_STATE_PLACEHOLDER != '') ? ENTRY_STATE_PLACEHOLDER : '',
	    'required_text'=>ENTRY_STATE_TEXT,
	    'value'=>$default_array['state']
	);
    }

    if (xtc_not_null(ENTRY_STATE_TEXT)) $entry_state.=  '&nbsp;<span class="inputRequirement">' . ENTRY_STATE_TEXT;

    $module_smarty->assign(array(
	'state'=>'1',
	'INPUT_STATE'=>$entry_state,
	'INPUT_STATE_ARRAY'=>yes_input_field::get_html($state_array_data)
    ));
}

$countries_array = array();
if(basename($_SERVER['SCRIPT_NAME']) == FILENAME_CHECKOUT_SHIPPING_ADDRESS){
    // VERSANDADRESSE DARF NUR ERLAUBTE LAENDER ENTHALTEN
    $ac = main::get_allowed_delivery_countries();
    foreach($ac as $c){
        $countries_array[] = array(
            'value'=>$c['id'],
            'title'=>$c['text']
        );
    }
    $select_country = xtc_draw_pull_down_menu('country',$ac,$default_array['country'],'',false);
}else{
    $countries = xtc_get_countries();
    for ($i=0, $n=sizeof($countries); $i<$n; $i++) {
            $countries_array[] = array('value' => $countries[$i]['countries_id'], 'title' => $countries[$i]['countries_name'],'active'=>(($selected==$countries[$i]['countries_id'])?1:0));
    }
    $select_country = xtc_get_country_list('country',$default_array['country']);
}
$module_smarty->assign(array(
    'INPUT_FIRSTNAME'=>xtc_draw_input_field('firstname',$default_array['firstname']) . '&nbsp;' . (xtc_not_null(ENTRY_FIRST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_FIRST_NAME_TEXT . '</span>': ''),
    'INPUT_FIRSTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'firstname',
	'label'=>ENTRY_FIRST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_FIRST_NAME_MIN_LENGTH') and ENTRY_FIRST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_FIRST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>(defined('ENTRY_FIRST_NAME_PLACEHOLDER') and ENTRY_FIRST_NAME_PLACEHOLDER != '') ? ENTRY_FIRST_NAME_PLACEHOLDER : '',
	'required_text'=>ENTRY_FIRST_NAME_TEXT,
	'value'=>$default_array['firstname']
    )),
    'INPUT_LASTNAME'=>xtc_draw_input_field('lastname',$default_array['lastname']) . '&nbsp;' . (xtc_not_null(ENTRY_LAST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_LAST_NAME_TEXT . '</span>': ''),
    'INPUT_LASTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'lastname',
	'label'=>ENTRY_LAST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_LAST_NAME_MIN_LENGTH') and ENTRY_LAST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_LAST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>(defined('ENTRY_LAST_NAME_PLACEHOLDER') and ENTRY_LAST_NAME_PLACEHOLDER != '') ? ENTRY_LAST_NAME_PLACEHOLDER : '',
	'required_text'=>ENTRY_LAST_NAME_TEXT,
	'value'=>$default_array['lastname']
    )),
    'INPUT_STREET'=>xtc_draw_input_field('street_address',$default_array['street_address']) . '&nbsp;' . (xtc_not_null(ENTRY_STREET_ADDRESS_TEXT) ? '<span class="inputRequirement">' . ENTRY_STREET_ADDRESS_TEXT . '</span>': ''),
    'INPUT_STREET_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'street_address',
	'label'=>ENTRY_STREET_ADDRESS,
	'type'=>'email',
	'required'=>true,
	'maxlength'=>128,
	'minlength'=>ENTRY_STREET_ADDRESS_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_STREET_ADDRESS_PLACEHOLDER') and ENTRY_STREET_ADDRESS_PLACEHOLDER != '') ? ENTRY_STREET_ADDRESS_PLACEHOLDER : '',
	'required_text'=>ENTRY_STREET_ADDRESS_TEXT,
	'value'=>$default_array['street_address']
    )),
    'INPUT_CODE'=>xtc_draw_input_field('postcode',$default_array['postcode']) . '&nbsp;' . (xtc_not_null(ENTRY_POST_CODE_TEXT) ? '<span class="inputRequirement">' . ENTRY_POST_CODE_TEXT . '</span>': ''),
    'INPUT_CODE_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'postcode',
	'label'=>ENTRY_POST_CODE,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>16,
	'minlength'=>ENTRY_POSTCODE_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_POSTCODE_PLACEHOLDER') and ENTRY_POSTCODE_PLACEHOLDER != '') ? ENTRY_POSTCODE_PLACEHOLDER : '',
	'required_text'=>ENTRY_POST_CODE_TEXT,
	'value'=>$default_array['postcode']
    )),
    'INPUT_CITY'=>xtc_draw_input_field('city',$default_array['city']) . '&nbsp;' . (xtc_not_null(ENTRY_CITY_TEXT) ? '<span class="inputRequirement">' . ENTRY_CITY_TEXT . '</span>': ''),
    'INPUT_CITY_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'city',
	'label'=>ENTRY_CITY,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>128,
	'minlength'=>ENTRY_CITY_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_CITY_PLACEHOLDER') and ENTRY_CITY_PLACEHOLDER != '') ? ENTRY_CITY_PLACEHOLDER : '',
	'required_text'=>ENTRY_CITY_TEXT,
	'value'=>$default_array['city']
    )),
    'SELECT_COUNTRY'=>$select_country . '&nbsp;' . (xtc_not_null(ENTRY_COUNTRY_TEXT) ? '<span class="inputRequirement">' . ENTRY_COUNTRY_TEXT . '</span>': ''),
    'INPUT_COUNTRY_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'country',
	'label'=>ENTRY_COUNTRY,
	'type'=>'select',
	'required'=>true,
	'default_value'=>$default_array['country'],
	'options'=>  $countries_array,
	'required_text'=>ENTRY_COUNTRY_TEXT
    )),
));
if(isset($_REQUEST['no_header']) and $_REQUEST['no_header'] == 1){
    $module_smarty->assign(array(
	'NO_HEADER'=>1,
	'INPUT_ADDRESS'=>$INPUT_ADDRESS,
	'TYPE'=>(isset($_REQUEST['type']) and $_REQUEST['type'] == 'shipping') ? 'shipping' : 'payment'
    ));
}
$module_smarty->assign('language', $_SESSION['language']);
$module_smarty->caching = 0;
$module= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/checkout_new_address.html');
$smarty->assign('MODULE_new_address',$module);
