<?php
/* -----------------------------------------------------------------------------------------
   $Id: address_book_details.php,v 1.4 2016/05/12 08:12:16 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(address_book_details.php,v 1.9 2003/05/22); www.oscommerce.com 
   (c) 2003	 nextcommerce (address_book_details.php,v 1.9 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------/-----*/

// include needed functions
require_once(DIR_WS_CLASSES.'yes_input_field.php');
include_once('inc/xtc_get_zone_name.inc.php');
include_once('inc/xtc_get_country_list.inc.php');
include_once('inc/xtc_get_countries.inc.php');
include_once('inc/xtc_draw_checkbox_field.inc.php'); 

$module_smarty=new yesSmarty;
$module_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
if (!isset($process)) $process = false;
$form_fields_array = array();

if ((isset($_GET['edit']) && ($_SESSION['customer_default_address_id'] != $_GET['edit'])) || (isset($_GET['edit']) == false) ) {
    $module_smarty->assign(array(
	'new'=>'1',
	'CHECKBOX_PRIMARY'=>xtc_draw_checkbox_field('primary', 'on', false, 'id="primary"'),
	'INPUT_PRIMARY_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'primary',
	    'label'=>TEXT_PRIMARY_ADDRESS,
	    'type'=>'checkbox',
	    'required'=>false,
	    'value'=>'on',
	    'checked'=>false
	))
    ));
}
if (ACCOUNT_GENDER == 'true') {
	$male = ($entry['entry_gender'] == 'm') ? true : false;
	$female = ($entry['entry_gender'] == 'f') ? true : false;
	$module_smarty->assign(array(
	    'gender'=>'1',
	    'INPUT_MALE'=>xtc_draw_radio_field('gender', 'm',$male),
	    'INPUT_FEMALE'=>xtc_draw_radio_field('gender', 'f',$female).(xtc_not_null(ENTRY_GENDER_TEXT) ? '<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>': ''),
	    'INPUT_GENDER_ARRAY'=>yes_input_field::get_html(array(
		'name'=>'gender',
		'label'=>ENTRY_GENDER,
		'type'=>'radio',
		'required'=>true,
		'required_text'=>ENTRY_GENDER_TEXT,
		'values'=>array(
		    array(
			'label'=>MALE,
			'gender'=>'m',
			'value'=>'m',
			'checked'=>$male
		    ),
		    array(
			'label'=>FEMALE,
			'gender'=>'f',
			'value'=>'f',
			'checked'=>$female
		    )
		)
	    ))
	));
	$form_fields_array[] = array(
		'tag'=>'input',
		'type'=>'radio',
		'name'=>'gender',
		'value'=>'m',
		'active'=>$male
	);
	$form_fields_array[] = array(
		'tag'=>'input',
		'type'=>'radio',
		'name'=>'gender',
		'value'=>'f',
		'active'=>$female
	);
}
if (ACCOUNT_COMPANY == 'true') {
    $module_smarty->assign(array(
	    'company'=>'1',
	    'INPUT_COMPANY'=>xtc_draw_input_field('company', $entry['entry_company']) . '&nbsp;' . (xtc_not_null(ENTRY_COMPANY_TEXT) ? '<span class="inputRequirement">' . ENTRY_COMPANY_TEXT . '</span>': ''),
	    'INPUT_COMPANY_ARRAY'=>yes_input_field::get_html(array(
		'name'=>'company',
		'label'=>ENTRY_COMPANY,
		'type'=>'text',
		'required'=>((defined('ENTRY_COMPANY_MIN_LENGTH') and ENTRY_COMPANY_MIN_LENGTH > 0) ? true : false),
		'minlength'=>ENTRY_COMPANY_MIN_LENGTH,
		'maxlength'=>64,
		'placeholder'=>(defined('ENTRY_COMPANY_PLACEHOLDER') and ENTRY_COMPANY_PLACEHOLDER != '') ? ENTRY_COMPANY_PLACEHOLDER : '',
		'required_text'=>ENTRY_COMPANY_TEXT,
		'value'=>$entry['entry_company']
	    ))
    ));
}

if (ACCOUNT_STATE == 'true') {
    if ($process == true) {
	if ($entry_state_has_zones == true) {
	    $zones_array = array();
	    $zones_query = yes_query(
                "select zone_name from " . TABLE_ZONES . " where zone_country_id =:country_id order by zone_name",
                ['country_id'=>(int)$country]
            );
	    foreach($zones_query as $zones_values) {
                $zones_array[] = array(
                    'id' => $zones_values['zone_name'], 
                    'text' => $zones_values['zone_name']
                );
	    }
	    $state_input= xtc_draw_pull_down_menu('state', $zones_array);
	    $state_array_data = array(
		'name'=>'state',
		'label'=>ENTRY_STATE,
		'type'=>'select',
		'required'=>((defined('ENTRY_STATE_MIN_LENGTH') and ENTRY_STATE_MIN_LENGTH > 0) ? true : false),
		'required_text'=>ENTRY_STATE_TEXT,
		'default_value'=>xtc_get_zone_name($entry['entry_country_id'], $entry['entry_zone_id'], $entry['entry_state']),
		'options'=>$zones_array
	    );
	} else {
	    $state_input= xtc_draw_input_field('state');
	    $state_array_data = array(
		'name'=>'state',
		'label'=>ENTRY_STATE,
		'type'=>'text',
		'required'=>((defined('ENTRY_STATE_MIN_LENGTH') and ENTRY_STATE_MIN_LENGTH > 0) ? true : false),
		'minlength'=>ENTRY_STATE_MIN_LENGTH,
		'maxlength'=>64,
		'placeholder'=>(defined(ENTRY_STATE_PLACEHOLDER) and ENTRY_STATE_PLACEHOLDER != '') ? ENTRY_STATE_PLACEHOLDER : '',
		'required_text'=>ENTRY_STATE_TEXT,
		'value'=>xtc_get_zone_name($entry['entry_country_id'], $entry['entry_zone_id'], $entry['entry_state'])
	    );
	}
    } else {
	$state_input= xtc_draw_input_field('state', xtc_get_zone_name($entry['entry_country_id'], $entry['entry_zone_id'], $entry['entry_state']));
	$state_array_data = array(
	    'name'=>'state',
	    'label'=>ENTRY_STATE,
	    'type'=>'text',
	    'required'=>((defined('ENTRY_STATE_MIN_LENGTH') and ENTRY_STATE_MIN_LENGTH > 0) ? true : false),
	    'minlength'=>ENTRY_STATE_MIN_LENGTH,
	    'maxlength'=>64,
	    'placeholder'=>(defined(ENTRY_STATE_PLACEHOLDER) and ENTRY_STATE_PLACEHOLDER != '') ? ENTRY_STATE_PLACEHOLDER : '',
	    'required_text'=>ENTRY_STATE_TEXT,
	    'value'=>xtc_get_zone_name($entry['entry_country_id'], $entry['entry_zone_id'], $entry['entry_state'])
	);
    }
    if (xtc_not_null(ENTRY_STATE_TEXT)) $state_input.= '&nbsp;<span class="inputRequirement">' . ENTRY_STATE_TEXT;
    
    $module_smarty->assign(array(
	'state'=>'1',
	'INPUT_STATE'=>$state_input,
	'INPUT_STATE_ARRAY'=>yes_input_field::get_html($state_array_data)
    ));
}

if (ACCOUNT_SUBURB == 'true') {
    $module_smarty->assign(array(
	'suburb'=>'1',
	'INPUT_SUBURB'=>xtc_draw_input_field('suburb', $entry['entry_suburb']) . '&nbsp;' . (xtc_not_null(ENTRY_SUBURB_TEXT) ? '<span class="inputRequirement">' . ENTRY_SUBURB_TEXT . '</span>': ''),
	'INPUT_SUBURB_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'suburb',
	    'label'=>ENTRY_SUBURB,
	    'type'=>'text',
	    'required'=>false,
	    'maxlength'=>128,
	    'placeholder'=>(defined('ENTRY_SUBURB_PLACEHOLDER') and ENTRY_SUBURB_PLACEHOLDER != '') ? ENTRY_SUBURB_PLACEHOLDER : '',
	    'required_text'=>ENTRY_SUBURB_TEXT,
	    'value'=>$entry['entry_suburb']
	))
    ));
}
  
$module_smarty->assign(array(
    'INPUT_FIRSTNAME'=>xtc_draw_input_field('firstname',$entry['entry_firstname']) . '&nbsp;' . (xtc_not_null(ENTRY_FIRST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_FIRST_NAME_TEXT . '</span>': ''),
    'INPUT_FIRSTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'firstname',
	'label'=>ENTRY_FIRST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_FIRST_NAME_MIN_LENGTH') and ENTRY_FIRST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_FIRST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>(defined('ENTRY_FIRST_NAME_PLACEHOLDER') and ENTRY_FIRST_NAME_PLACEHOLDER != '') ? ENTRY_FIRST_NAME_PLACEHOLDER : '',
	'required_text'=>ENTRY_FIRST_NAME_TEXT,
	'value'=>$entry['entry_firstname']
    )),
    'INPUT_LASTNAME'=>xtc_draw_input_field('lastname',$entry['entry_lastname']) . '&nbsp;' . (xtc_not_null(ENTRY_LAST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_LAST_NAME_TEXT . '</span>': ''),
    'INPUT_LASTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'lastname',
	'label'=>ENTRY_LAST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_LAST_NAME_MIN_LENGTH') and ENTRY_LAST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_LAST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>(defined('ENTRY_LAST_NAME_PLACEHOLDER') and ENTRY_LAST_NAME_PLACEHOLDER != '') ? ENTRY_LAST_NAME_PLACEHOLDER : '',
	'required_text'=>ENTRY_LAST_NAME_TEXT,
	'value'=>$entry['entry_lastname']
    )),
    'INPUT_STREET'=>xtc_draw_input_field('street_address', $entry['entry_street_address']) . '&nbsp;' . (xtc_not_null(ENTRY_STREET_ADDRESS_TEXT) ? '<span class="inputRequirement">' . ENTRY_STREET_ADDRESS_TEXT . '</span>': ''),
    'INPUT_STREET_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'street_address',
	'label'=>ENTRY_STREET_ADDRESS,
	'type'=>'email',
	'required'=>true,
	'maxlength'=>128,
	'minlength'=>ENTRY_STREET_ADDRESS_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_STREET_ADDRESS_PLACEHOLDER') and ENTRY_STREET_ADDRESS_PLACEHOLDER != '') ? ENTRY_STREET_ADDRESS_PLACEHOLDER : '',
	'required_text'=>ENTRY_STREET_ADDRESS_TEXT,
	'value'=>$entry['entry_street_address']
    )),
    'INPUT_CODE'=>xtc_draw_input_field('postcode', $entry['entry_postcode']) . '&nbsp;' . (xtc_not_null(ENTRY_POST_CODE_TEXT) ? '<span class="inputRequirement">' . ENTRY_POST_CODE_TEXT . '</span>': ''),
    'INPUT_CODE_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'postcode',
	'label'=>ENTRY_POST_CODE,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>16,
	'minlength'=>ENTRY_POSTCODE_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_POSTCODE_PLACEHOLDER') and ENTRY_POSTCODE_PLACEHOLDER != '') ? ENTRY_POSTCODE_PLACEHOLDER : '',
	'required_text'=>ENTRY_POST_CODE_TEXT,
	'value'=>$entry['entry_postcode']
    )),
    'INPUT_CITY'=>xtc_draw_input_field('city', $entry['entry_city']) . '&nbsp;' . (xtc_not_null(ENTRY_CITY_TEXT) ? '<span class="inputRequirement">' . ENTRY_CITY_TEXT . '</span>': ''),
    'INPUT_CITY_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'city',
	'label'=>ENTRY_CITY,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>128,
	'minlength'=>ENTRY_CITY_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_CITY_PLACEHOLDER') and ENTRY_CITY_PLACEHOLDER != '') ? ENTRY_CITY_PLACEHOLDER : '',
	'required_text'=>ENTRY_CITY_TEXT,
	'value'=>$entry['entry_city']
    )),
));    


if ($_POST['country']){
	$selected = $_POST['country'];
}else{
	$selected = $entry['entry_country_id'];
}
$countries_array = array();
$countries = xtc_get_countries();
for ($i=0, $n=sizeof($countries); $i<$n; $i++) {
	$countries_array[] = array('value' => $countries[$i]['countries_id'], 'title' => $countries[$i]['countries_name'],'active'=>(($selected==$countries[$i]['countries_id'])?1:0));
}

$module_smarty->assign(array(
    'SELECT_COUNTRY'=>xtc_get_country_list('country', $selected) . '&nbsp;' . (xtc_not_null(ENTRY_COUNTRY_TEXT) ? '<span class="inputRequirement">' . ENTRY_COUNTRY_TEXT . '</span>': ''),
    'INPUT_COUNTRY_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'country',
	'label'=>ENTRY_COUNTRY,
	'type'=>'select',
	'required'=>true,
	'default_value'=>$selected,
	'options'=>  $countries_array,
	'required_text'=>ENTRY_COUNTRY_TEXT
    )),
));    
$form_fields_array[] = array(
	'tag'=>'select',
	'name'=>'country',
	'values'=>$countries_array
);
$module_smarty->assign('formfields',$form_fields_array);
$module_smarty->assign('language', $_SESSION['language']);
$module_smarty->caching = 0;
$main_content=$module_smarty->fetch(CURRENT_TEMPLATE . '/module/address_book_details.html');
$smarty->assign('MODULE_address_book_details',$main_content);
