<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of yes_input_field_text
 *
 * @author mario
 */
class yes_input_field_select extends yes_input_field{
    var $size;
    var $options;
    var $default_value;
    public function __construct($params){
	foreach($params as $param=>$value){
	    
	    if(!property_exists(get_class($this), $param)){
		echo '<li>'.get_class($this).': param '.$param.' doesnt exists';
	    }
	    $this->$param = $value;
	}
    }
    
    public function parse($xtc=false){
	$req = ($this->required) ? 'required="required"' : '';
	$size = ($this->size > 0) ? 'size="'.$this->size.'"' : '';
	$cls = ($this->css_class != '') ? 'class="'.$this->css_class.'"' : '';
	$id = 'id="'.$this->id.'"';
	$label = (!empty($this->label)) ? sprintf('<label for="%s">%s</label>',$this->id, $this->label . ( ($this->required) ? ' * ' : '' )  ) : '';
	if(!$xtc){
	    $html = sprintf('<select %s name="%s" %s %s %s>',
			$id,$this->name,$req,$size,$cls);
	    foreach($this->options as $opt){
		$selected = ($opt['id'] === $this->default_value) ? ' selected="selected"' : '';
		$html .= sprintf('<option value="%s"%s>%s</option>',$opt['id'],$selected,$opt['name']);
	    }
	    $html .= '</select>';
	    return array(
		'input'=>$html,
		'label'=>$label,
		'plain'=>parent::asArray($this)
	    );
	}
	$parameters = $id;
	if($this->size > 0){
	    $parameters .= 'size="'.$this->size.'" ';
	}
	if($this->css_class != ''){
	    $parameters .= 'class="'.$this->css_class.'" ';
	}
	return array(
	    'input'=>xtc_draw_pull_down_menu($this->name, $this->options, $this->default_value,$parameters, $this->required),
	    'label'=>$label
	);
    }
}

