<?php
/* -----------------------------------------------------------------------------------------
   $Id: product.php,v 1.85 2020/05/11 07:09:46 ssh-511548-cvs Exp $ 

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2005 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(Coding Standards); www.oscommerce.com 

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

require_once(DIR_WS_CLASSES.'products_email_notification.php');
require_once(DIR_FS_INC . 'xtc_get_vpe_name.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_i_tax.inc.php');
require_once(DIR_WS_CLASSES.'product_properties.php');
class product {
	var $pID;
	var $useStandardImage;
	var $standardImage;
	var $isProduct;
        var $data;
	/**
	 * 
	 * Constructor
	 * 
	 */
	function __construct($pID = 0,$admin=false) {
		$this->pID = intval($pID);
		$this->useStandardImage = true;
		$this->standardImage = 'noimage.gif';
		if ($pID == 0) {
			$this->isProduct = false;
			return;
		}
		// query for Product
		$group_check = "";
		if (GROUP_CHECK == 'true') {
//			$group_check = " and p.group_permission_" . $_SESSION['customers_status']['customers_status_id'] . "=1 ";
		}

		$fsk_lock = "";
		if ($_SESSION['customers_status']['customers_fsk18_display'] == '0') {
			$fsk_lock = ' and p.products_fsk18!=1';
		}
                $parameters = [
                    'products_id'=> $this->pID,
                    'language_id'=>(int) $_SESSION['languages_id']
                ];
		$product_query_raw = sprintf("select p.*,pd.* FROM %s p LEFT JOIN %s pd USING(products_id) where ",
                    TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION
                );
		if(!$admin){
                    $product_query_raw .= "p.products_status = '1' and ";
		}
		$product_query_raw .= sprintf(" p.products_id =:products_id %s %s and pd.language_id =:language_id",
                    $group_check, $fsk_lock
                );
		$product_query = yes_query($product_query_raw,$parameters);
		if (!is_countable($product_query) or !sizeOf($product_query)) {
                    $this->isProduct = false;
		} else {    
                    $this->isProduct = true;
                    $this->data = current($product_query);
		}
	}



    function getGraduated() {
        global $xtPrice;
        $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
            (int) $_SESSION['customers_status']['customers_status_id'], 
            $this->pID
        );
        $discount = $xtPrice->xtcCheckDiscount($this->pID); //EINGEFUEGT!
	$staffel = array ();
        foreach($group_prices_items as $GPI){
            $staffel[] = array (
                'stk' => $GPI->quantity,
                'price' => $GPI->personal_offer
            );
        }
        $staffel_data = [];
        for ($i = 0, $n = sizeof($staffel); $i < $n; $i++) {
            if ($staffel[$i]['stk'] == 1) {
                $quantity = $staffel[$i]['stk'];
                if ($staffel[$i+1]['stk'] > 0){
                    $quantity = $staffel[$i]['stk'] . '-' . ($staffel[$i +1]['stk'] - 1);
                }
            } else {
                $quantity = ' > ' . $staffel[$i]['stk'];
                if($staffel[$i +1]['stk'] > 0 ){
                    $quantity = $staffel[$i]['stk'] . '-' . ($staffel[$i +1]['stk'] - 1);
                }
            }
            $vpe_price = $staffel[$i]['price'] - $staffel[$i]['price'] / 100 * $discount;
            $country_id = yes_get_store_country_id();
            $zone_id = yes_get_store_zone_id();
            if($xtPrice->getCountry_id() > 0){
                $country_id = $xtPrice->getCountry_id();
                $zone_id = $xtPrice->getZone_id();
            }
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                $this->pID, $country_id
            );
            $vpe = yes_get_products_vpe_string($xtPrice, $this->pID, $vpe_price);
            $staffel_data[$i] = array (
                'QUANTITY' => $quantity,
                'VPE' => $vpe,
                'PRICE' => $xtPrice->xtcFormat($staffel[$i]['price'] - $staffel[$i]['price'] / 100 * $discount,
                true,
                $products_tax_class_id
            ));
        }
	return $staffel_data;
    }
	/**
	 * 
	 * valid flag
	 * 
	 */

	function isProduct() {
		return $this->isProduct;
	}

	// beta
	function getBuyNowButton($id, $name) {
		global $PHP_SELF;
		if(!function_exists('xtc_image_button'))
			require(DIR_FS_INC.'xtc_image_button.inc.php');
		return '<a href="' . xtc_href_link(basename($PHP_SELF), 'action=buy_now&BUYproducts_id=' . (int)xtc_db_input($id) . '&' . xtc_get_all_get_params(array (
			'action','BUYproducts_id'
		)), 'NONSSL') . '">' . xtc_image_button('button_buy_now.gif', TEXT_BUY . $name . TEXT_NOW) . '</a>';

	}
        
        public function get_default_distributor_id(){
            $query = xtc_db_query(sprintf(
				"SELECT distributor_id FROM products_distributors WHERE products_id=%d ORDER BY is_default DESC LIMIT 1",
				intval($this->data['products_id'])
            ));
            if(!xtc_db_num_rows($query)){
                return 0;
            }
            $record = xtc_db_fetch_array($query);
            return $record['distributor_id'];
        }

	function getStockTafficRule($stock = -1, $average_stock = -1) {
		global $main;
		if ($stock == -1 || $average_stock == -1) {
			$stock = $this->data['products_quantity'];
			$average_stock = $this->data['products_average_stock'];
		}
		if ($stock > 0) {
			$percentage = $stock / $average_stock * 100;
			if ($percentage > 100)
				$percentage = 100;
		} else {
			$percentage = 0;
		}
		foreach ($main->STOCKS_TRAFFIC as $key => $arr) {

			if ($percentage > $main->STOCKS_TRAFFIC[$key]['percentage']) {
				if ($percentage < $main->STOCKS_TRAFFIC[$key +1]['percentage']) {
					return array (
						'name' => $main->STOCKS_TRAFFIC[$key +1]['name'],
						'image' => 'admin/images/icons/' . $main->STOCKS_TRAFFIC[$key +1]['image']
					);
				}
			}
			elseif ($percentage == $main->STOCKS_TRAFFIC[$key]['percentage']) {
				return array (
					'name' => $main->STOCKS_TRAFFIC[$key]['name'],
					'image' => 'admin/images/icons/' . $main->STOCKS_TRAFFIC[$key]['image']
				);
			}
		}
	}
	
	function get_shop_link($products_id){
	    return xtc_href_link(FILENAME_PRODUCT_INFO,'products_id='.$products_id,$connection = 'NONSSL', $add_session_id = true, $search_engine_safe = true, $urlencode=false,$product_listing_mode = true);
	}

	function getVPEtext($product, $price) {
		global $xtPrice;
		if (!is_array($product))
			$product = $this->data;
                return yes_get_products_vpe_string($xtPrice, $this->pID, $price);

	}
	
	function getProducts_price($xtPrice,$products_id,$tax_class_id,$products_price,$format=true,$specialprice = true){
	    if(!$specialprice){
		return $xtPrice->xtcFormat($products_price,$format,$tax_class_id,$curr=false);
	    }
	    return $xtPrice->xtcGetPrice($products_id, $format, 1, $tax_class_id, $products_price);
	}
        
        /**
         * Gibt zu einem bestimmten Lieferanten beim Default EK die Lieferzeit
         * zurueck. Der Return Wert ist -1 bei keinem Eintrag, ansonsten die
         * Anzahl der Wochen. 4 = 4 Wochen
         * 
         * NEU: Rueckgabewert = shipping_status_name der hinterlegten 
         * shipping_status_id
         * 
         * @param int $distributor_id
         * @return int
         */
        public function get_default_ek_price_shippingtime_from_distributor_id($distributor_id){
            $shipping_sql_field = 'shipping_status_id';
            $query = yes_query(sprintf(
                    "SELECT %s FROM distributor_product_prices WHERE distributor_id=:distributor_id AND products_id=:products_id ORDER BY is_default DESC,date_saved DESC LIMIT 1",
                    $shipping_sql_field
            ),[
                'distributor_id'=>$distributor_id,
                'products_id'=>$this->data['products_id']
            ]);
            if(!sizeOf($query)){
                return -1;
            }
            $record = current($query);
            if($record[$shipping_sql_field] < 1){
                return -1;
            }
            if(!function_exists('xtc_get_shipping_status_name')){
                require_once(DIR_FS_INC.'xtc_get_shipping_status_name.inc.php');
                //throw new Exception('Missing function xtc_get_shipping_status_name()');
            }
            return xtc_get_shipping_status_name($record[$shipping_sql_field]);
        }
	
	function get_shipping_status_values($products_shippingtime,$products_date_available,$qty_total,$languages_id){
	    global $main;
	    if($products_shippingtime > 0){
		$shipping_status_name = $main->getShippingStatusName($products_shippingtime);
	    }else{
		$shipping_status_name = '';
	    }

	    if (defined('ACTIVATE_SHIPPING_STATUS') && ACTIVATE_SHIPPING_STATUS=='true') {
		    if($products_date_available>0 and strtotime($products_date_available)>time()){
                        $days = ( strtotime($products_date_available) - time() ) / (60*60*24);
			$shipping_name = number_format($days,0,'',''). ' '.TEXT_DAYS;
		    }else{
                        $shipping_name = $shipping_status_name;
                        $shipping_status_image = $main->getShippingStatusImage($products_shippingtime);
                        if($qty_total < 1){
                            $dID = $this->get_default_distributor_id();
                            if($dID > 0){
                                $dsh = $this->get_default_ek_price_shippingtime_from_distributor_id($dID);
                                if(is_array($dsh) && sizeOf($dsh)){
                                    $shipping_name = $dsh['name'];
                                    $shipping_status_image = $dsh['image'];
                                }
                            }
                        }
		    }
	    }else{
                $shipping_name = '';
                $shipping_status_image = '';
	    }
	    return array(
		'name'=>$shipping_name,
		'image'=>$shipping_status_image
	    );
	}	
        
        function buildDataArrayDesc(& $array, $image = 'thumbnail'){
	    if(!isset($array['products_id'])){
			return array();
	    }
		// bof products_email_notification
		$products_email_notification = array();
		if(isset($_SESSION['customer_id']) and $_SESSION['customer_id'] > 0){
		    $pem = new products_email_notification();
		    $products_email_notification = $pem->getNotificationData( $_SESSION['customer_id'], $array['products_id']);
		}else{
		    if(isset($_SESSION['products_email_notification'][$array['products_id']] )){
			$products_email_notification = $_SESSION['products_email_notification'][$array['products_id']];
		    }
		}
		// eof products_email_notification
		$is_new = false;
		if($array['products_date_added'] > 0 and defined('MAX_DISPLAY_NEW_PRODUCTS_DAYS') and MAX_DISPLAY_NEW_PRODUCTS_DAYS != '0'){
		    /*
		    $datetime1 = date_create($array['products_date_added']);
		    $datetime2 = date_create();
		    $interval = date_diff($datetime1, $datetime2);
		    $diff = $interval->format('%R%a');
		    if(substr($diff,0,1) == '+' and substr($diff,1) < MAX_DISPLAY_NEW_PRODUCTS_DAYS){
			$is_new = true;
		    }*/
		    $start = new DateTime($array['products_date_added']);
		    $end = new DateTime();
		    $days = round(($end->format('U') - $start->format('U')) / (60*60*24));
		    if($days < MAX_DISPLAY_NEW_PRODUCTS_DAYS){
			$is_new = true;
		    }


                }
                $condition = '';
                if(isset($array['products_conditions_id']) and $array['products_conditions_id'] > 0){
                    $condition = \YES4Trade\Model\products_conditions::get_condition_title(
                        $array['products_conditions_id']
                    );
                }
		return array (
			'PRODUCTS_NAME' => $array['products_name'],
			'SLAVE_TITLE' => $array['slave_title'],
			'SLAVES' => $this->getSlaves(),
			'PRODUCTS_MASTER_STATUS' => $array['products_master_status'],
			'PRODUCTS_MODEL' => $array['products_model'],
			'PRODUCTS_EAN' => $array['products_ean'],
			'COUNT' => $array['ID'],
			'PRODUCTS_ID' => $array['products_id'],
			'PRODUCTS_IMAGE' => $this->productImage($array['products_image'], $image),
			'PRODUCTS_IMAGE_INFO' => $this->productImage($array['products_image'], 'info_images'),
			'PRODUCTS_LINK' => $this->get_shop_link($array['products_id']),
			'PRODUCTS_DESCRIPTION' => $array['products_description'],
			'PRODUCTS_EXTRA_TEXT' => $array['products_extra_text'],
			'PRODUCTS_EXPIRES' => $array['expires_date'],
			'PRODUCTS_CATEGORY_URL' => $array['cat_url'],
			'PRODUCTS_SHORT_DESCRIPTION' => $array['products_short_description'],
			'PRODUCTS_FSK18' => $array['products_fsk18'],
			'MANUFACTURERS_ID' => $array['manufacturers_id'],
			'PRODUCTS_DATE_AVAILABLE' => ($array['products_date_available'] >= date('Y-m-d'))?$array['products_date_available']:'',
			'PRODUCTS_VPE_STATUS'=>$array['products_vpe_status'],
			'PRODUCTS_VPE_VALUE'=>$array['products_vpe_value'],
			'PRODUCTS_VPE'=>$this->getVPEtext($array, $price_float),
                        'PRODUCTS_VPE_BASE_MEASURE'=>$array['products_vpe_base_measure'],
			'PRODUCTS_MASTER'=>$array['products_master'],
			'PRODUCTS_EMAIL_NOTIFICATION'=>$products_email_notification,
			'IS_NEW'=>$is_new,
                        'MPN'=>$array['mpn'],
                        'DEFAULT_SHIPPER'=> \YES4Trade\Model\shipper_profiles::get_products_id_value($array['products_id']),
                        'WEIGHT'=> xtc_get_ext_products_weight($array['products_id']),
                        'CONDITION'=> $condition
		);
        }
	function buildDataArray(& $array, $image = 'thumbnail', $include_xy = true) {
	    if(!class_exists('products_quantity')){
		require_once(DIR_FS_CATALOG.'admin/includes/classes/class.storagequantity.php');
	    }
	    if(!function_exists('xtc_get_product_collies')){
		require_once(DIR_FS_INC.'xtc_collis.inc.php');
	    }
	    if(!isset($array['products_id'])){
		return array();
	    }
	    $product = new products_quantity($array['products_id']);
            global $xtPrice, $main;

            //$tax_rate = $xtPrice->TAX[$array['products_tax_class_id']];
            $tax_rate = false;
            // EU-OSS 2021/07
            if($xtPrice->getCountry_id()>0){
                $country_id = $xtPrice->getCountry_id();
                $zone_id = $xtPrice->getZone_id();
            }else{
                $country_id = yes_get_store_country_id();
                $zone_id = yes_get_store_zone_id();
            }
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                $array['products_id'], 
                $country_id
            );
            
            $array['products_tax_class_id'] = $products_tax_class_id;
            
            if($_SESSION['customers_status']['customers_status_show_price_tax'] == 1){
                $tax_rate = xtc_get_tax_rate($products_tax_class_id,$country_id, $zone_id);
            }
            $buy_now = '';
            $products_price = $this->getProducts_price($xtPrice,$array['products_id'], $products_tax_class_id, $array['products_price']);
            $special_percent = 0;
            $is_special = false;
            if($xtPrice->xtcCheckSpecial($array['products_id'],true) > 0){
                $products_incl_special_price_raw = $this->getProducts_price($xtPrice,$array['products_id'], $array['products_tax_class_id'],$array['products_price'],false,true);
                $products_excl_special_price_raw = $this->getProducts_price($xtPrice,$array['products_id'], $array['products_tax_class_id'],$array['products_price'],false,false);
				if(is_float($products_incl_special_price_raw)){
                	$special_percent = number_format(($products_excl_special_price_raw-$products_incl_special_price_raw)/$products_excl_special_price_raw*100,2,'.','');
                	$is_special = true;
				}
            }
                
//printf('pID %s, Netto %s, Brutto %s<br />',$array['products_id'],$array['products_price'],$products_price);
		$products_price_clean=$this->getProducts_price($xtPrice,$array['products_id'], $array['products_tax_class_id'], $array['products_price'],false);
		$price_float = (float)str_replace(',','.',$products_price_clean);
		if ($_SESSION['customers_status']['customers_status_show_price'] != '0') {
			if ($_SESSION['customers_status']['customers_fsk18'] == '1') {
				if ($array['products_fsk18'] == '0')
					$buy_now = $this->getBuyNowButton($array['products_id'], $array['products_name']);
					$wishlist = $this->getWishlistButton($array['products_id'], $array['products_name']); // wishlist

			} else {
				$buy_now = $this->getBuyNowButton($array['products_id'], $array['products_name']);
				$wishlist = $this->getWishlistButton($array['products_id'], $array['products_name']); // wishlist
			}
		}
		$stocks_traffic_image = '';
		$stocks_traffic_name = '';
		if (defined('ACTIVATE_STOCKS_TRAFFIC') && ACTIVATE_STOCKS_TRAFFIC == 'true') {
			$stocks_traffic = $this->getStockTafficRule($array['products_quantity'], $array['products_average_stock']);
			$stocks_traffic_image = $stocks_traffic['image'];
			$stocks_traffic_name = $stocks_traffic['name'];
		}
		$shipping_status_values = $this->get_shipping_status_values($array['products_shippingtime'],$array['products_date_available'],$product->get_available1_qty(),$_SESSION['languages_id']);
		$shipping_status_name = $shipping_status_values['name'];
		$shipping_status_image = $shipping_status_values['image'];
		
		if(!isset($array['slave_name'])){
                    $array['slave_name'] = '';
                }
		if(!isset($array['ID'])){
                    $array['ID'] = 0;
                }
		if(!isset( $array['expires_date'])){
                    $array['expires_date'] = '';
                }
		if(!isset($array['cat_url'])){
                    $array['cat_url'] = '';
                }
		
		// bof product properties
                
		$properties = array();
		$products_properties = yes_get_products_properties_id_array($array['products_id']);
		if(sizeOf($products_properties)){
                    if($include_xy){
                        $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($array['products_id']);
                        $diff_values_for_properties = [];
                        /** RAUS 2024/10
                        $ppxyv = $xy->product_properties_xy_prices_values[0];
                        if(is_countable($ppxyv->product_properties_xy_prices_values_for_properties) and sizeOf($ppxyv->product_properties_xy_prices_values_for_properties)){
                            foreach($ppxyv->product_properties_xy_prices_values_for_properties as $xyfp){
                                $diff_values_for_properties[] = $xyfp->products_properties_id;
                            }
                        }*/
                    }
                    foreach($products_properties as $ppID){
                        $is_xy_price = false;
                        if($xy !== false){
                            if($xy->products_properties_id_X == $ppID || $xy->products_properties_id_Y == $ppID){
                                $is_xy_price = true;
                            }
                        }
                        
                        $pp = new product_properties($ppID);
                        $desc = $pp->getDescription($_SESSION['languages_id']);
                        $values = array();
                        $values_array = $pp->getValues($_SESSION['languages_id']);
                        if(sizeOf($values_array)){
                            foreach($values_array as $val){
                                $price_brutto = xtc_oe_get_price_i_tax($val['price'], $tax_rate);
                                $val_arr = array(
                                    'id'=>$val['description']->getProducts_properties_values_id(),
                                    'price_netto'=>$val['price'],
                                    'price_brutto'=> $price_brutto,
                                    'price_formatted'=> $xtPrice->xtcFormat($price_brutto, true),
                                    'title'=>$val['description']->getTitle(),
                                    'image'=>$val['image'],
                                    'input_span'=>$val['input_span'],
                                    'files_image'=>$val['files_image']
                                );
                                $values[] = $val_arr;
                            }
                        }
                        if(!sizeOf($values)){
                            continue;
                        }
                        $prop = array(
                            'title'=>$desc->getTitle(),
                            'sort_order'=>$pp->getSort_order(),
                            'text'=>$desc->getText(),
                            'tag'=>$pp->getTag(),
                            'id'=>$desc->getProducts_properties_id(),
                            'values'=>$values,
                        );
                        if($is_xy_price){
                            $prop['is_xy_price'] = true;
                            if($xy->products_properties_id_X == $ppID){
                                $prop['xy_priceX'] = true;
                            }
                            if($xy->products_properties_id_Y == $ppID){
                                $prop['xy_priceY'] = true;
                            }
                        }else{
                            if(in_array($ppID, $diff_values_for_properties)){
                                $prop['xy_price_allocation'] = true;
                            }
                        }
                        $properties[] = $prop;
                    }
		}
		// eof product properties
		
		// bof products_email_notification
		$products_email_notification = array();
		if(isset($_SESSION['customer_id']) and $_SESSION['customer_id'] > 0){
		    $pem = new products_email_notification();
		    $products_email_notification = $pem->getNotificationData( $_SESSION['customer_id'], $array['products_id']);
		}else{
		    if(isset($_SESSION['products_email_notification'][$array['products_id']] )){
			$products_email_notification = $_SESSION['products_email_notification'][$array['products_id']];
		    }
		}
		// eof products_email_notification
		$is_new = false;
		if($array['products_date_added'] > 0 and defined('MAX_DISPLAY_NEW_PRODUCTS_DAYS') and MAX_DISPLAY_NEW_PRODUCTS_DAYS != '0'){
		    /*
		    $datetime1 = date_create($array['products_date_added']);
		    $datetime2 = date_create();
		    $interval = date_diff($datetime1, $datetime2);
		    $diff = $interval->format('%R%a');
		    if(substr($diff,0,1) == '+' and substr($diff,1) < MAX_DISPLAY_NEW_PRODUCTS_DAYS){
			$is_new = true;
		    }*/
		    $start = new DateTime($array['products_date_added']);
		    $end = new DateTime();
		    $days = round(($end->format('U') - $start->format('U')) / (60*60*24));
		    if($days < MAX_DISPLAY_NEW_PRODUCTS_DAYS){
			$is_new = true;
		    }


                }
                $condition = '';
                if(isset($array['products_conditions_id']) and $array['products_conditions_id'] > 0){
                    $condition = \YES4Trade\Model\products_conditions::get_condition_title(
                        $array['products_conditions_id']
                    );
                }
		return array (
                    'PRODUCTS_TAX_CLASS_ID'=>$products_tax_class_id,
			'PRODUCTS_NAME' => $array['products_name'],
			'SLAVE_TITLE' => $array['slave_title'],
			'SLAVES' => $this->getSlaves(),
			'PRODUCTS_MASTER_STATUS' => $array['products_master_status'],
			'PRODUCTS_MODEL' => $array['products_model'],
			'PRODUCTS_EAN' => $array['products_ean'],
			'COUNT' => $array['ID'],
			'PRODUCTS_ID' => $array['products_id'],
			'PRODUCTS_IMAGE' => $this->productImage($array['products_image'], $image),
			'PRODUCTS_IMAGE_INFO' => $this->productImage($array['products_image'], 'info_images'),
			'PRODUCTS_LINK' => $this->get_shop_link($array['products_id']),
			'PRODUCTS_PRICE' => $products_price,
			'PRODUCTS_PRICE_CLEAN' => (is_float($products_price_clean)) ? number_format($products_price_clean,2,',','.').$_SESSION['currency'] : 0,
			'PRODUCTS_PRICE_RAW' => $products_price_clean,
			'CURRENCY'=>$_SESSION['currency'],
			'PRODUCTS_TAX_INFO' => $main->getTaxInfo($tax_rate),
			'PRODUCTS_TAX_RATE' => $tax_rate,
			'PRODUCTS_TAX_VALUE' => $tax_rate,
			'PRODUCTS_QUANTITY' => $array['products_quantity'],
			'PRODUCTS_STOCKS_TRAFFIC_IMAGE' => $stocks_traffic_image,
			'PRODUCTS_STOCKS_TRAFFIC_NAME' => $stocks_traffic_name,
			'PRODUCTS_SHIPPING_LINK' => $main->getShippingLink($array['products_id']),
			'PRODUCTS_BUTTON_BUY_NOW' => $buy_now,
			'BUTTON_BUY_NOW'=> $buy_now,
			'PRODUCTS_SHIPPING_NAME' => $shipping_status_name,
			'SHIPPING_NAME' => $shipping_status_name,
			'SHIPPING_STATUS_NAME'=>($array['products_shippingtime'] > 0) ? $main->getShippingStatusName($array['products_shippingtime']) : '',
			'PRODUCTS_SHIPPING_IMAGE' => $shipping_status_image,
			'SHIPPING_IMAGE' => $shipping_status_image,
			'PRODUCTS_DESCRIPTION' => $array['products_description'],
			'PRODUCTS_EXTRA_TEXT' => $array['products_extra_text'],
			'PRODUCTS_EXPIRES' => $array['expires_date'],
			'PRODUCTS_CATEGORY_URL' => $array['cat_url'],
			'PRODUCTS_SHORT_DESCRIPTION' => $array['products_short_description'],
			'PRODUCTS_FSK18' => $array['products_fsk18'],
			'MANUFACTURERS_ID' => $array['manufacturers_id'],
			'PRODUCTS_DATE_AVAILABLE' => ($array['products_date_available'] >= date('Y-m-d'))?$array['products_date_available']:'',
			'PRODUCTS_VPE_STATUS'=>$array['products_vpe_status'],
			'PRODUCTS_VPE_VALUE'=>$array['products_vpe_value'],
			'PRODUCTS_VPE'=>$this->getVPEtext($array, $price_float),
                        'PRODUCTS_VPE_BASE_MEASURE'=>$array['products_vpe_base_measure'],
			'PROPERTIES'=>$properties,
			'PRODUCTS_MASTER'=>$array['products_master'],
			'WISHLIST_BUTTON' => $wishlist,      // wishlist
			'QUANTITY_AVAILABLE1'=>$product->get_available1_qty(),
			'QUANTITY_AVAILABLE2'=>$product->get_available2_qty(),
			'QUANTITY_TOTAL'=>$product->get_products_total_qty(),
			'GRADUATED'=>$this->getGraduated(),
			'PRODUCTS_EMAIL_NOTIFICATION'=>$products_email_notification,
			'IS_NEW'=>$is_new,
                        'MPN'=>$array['mpn'],
                    'PRICE_SPECIAL_PERCENT'=>$special_percent,
                    'IS_SPECIAL'=>$is_special,
                    'DEFAULT_SHIPPER'=> \YES4Trade\Model\shipper_profiles::get_products_id_value($array['products_id']),
                    'WEIGHT'=> xtc_get_ext_products_weight($array['products_id']),
                    'CONDITION'=> $condition
		);
	}

	function productImage($name, $type) {

		switch ($type) {
			case 'info' :
				$path = DIR_WS_INFO_IMAGES;
				break;
			case 'thumbnail' :
				$path = DIR_WS_THUMBNAIL_IMAGES;
				break;
			case 'popup' :
				$path = DIR_WS_POPUP_IMAGES;
				break;
			default :
				$path = DIR_WS_INFO_IMAGES;
				break;
		}

		if ($name == '') {
			if ($this->useStandardImage == 'true' && $this->standardImage != '')
				return $path . $this->standardImage;
		} else {
			// check if image exists
			if (!file_exists($path . $name)) {
				if ($this->useStandardImage == 'true' && $this->standardImage != '')
					$name = $this->standardImage;
			}
			return $path . $name;
		}
	}

	function getMoImages(){
		$mo_images = array();
		$more_images_query = xtc_db_query("SELECT image_name,image_nr FROM products_images WHERE products_id='".intval($this->pID)."' and noshop=0");
		if(!xtc_db_num_rows($more_images_query))
			return $mo_images;
		while($more_images = xtc_db_fetch_array($more_images_query)){
			$mo_images[] = array(
				'image'=>DIR_WS_INFO_IMAGES . $more_images['image_name'],
				'popup'=>DIR_WS_POPUP_IMAGES . $more_images['image_name'],
				'image_nr'=>$more_images['image_nr']
			);
		}
		return $mo_images;
	}

	function getManufacturersData(){
		if(!isset($this->data['manufacturers_id']) or intval($this->data['manufacturers_id']) === 0 ){
			return [];
		}
		$query_raw = sprintf(
			"SELECT m.manufacturers_name,manufacturers_meta_title,manufacturers_meta_description,manufacturers_meta_keywords,manufacturers_url,url_clicked,manufacturers_image FROM manufacturers m LEFT JOIN manufacturers_info mi USING(manufacturers_id) WHERE m.manufacturers_id='%d' and mi.languages_id='%d'",
			intval($this->data['manufacturers_id']),
			intval($_SESSION['languages_id'])
		);
		$query = xtc_db_query($query_raw);
		if(xtc_db_num_rows($query)){
			$manufacturer = xtc_db_fetch_array($query);
			return $manufacturer;
		}/* 28.07.11:mario
		 * else{
			print_r($query);
		}*/
	}

	function getSlaves(){
		global $xtPrice;
                if($xtPrice->getCountry_id()>0){
                    $country_id = $xtPrice->getCountry_id();
                    $zone_id = $xtPrice->getZone_id();
                }else{
                    $country_id = yes_get_store_country_id();
                    $zone_id = yes_get_store_zone_id();
                }
		$slaves = array();
		if($this->data['products_master_status'] < 1){
                    return $slaves;
                }
		$master_sql_raw = sprintf(
                    "select p.*,pd.products_name from %s p LEFT JOIN products_description pd USING(products_id) where products_master='%d' and pd.language_id='%d'",
                    TABLE_PRODUCTS,intval($this->data['products_id']),(int)$_SESSION['languages_id']
		);
		$master_query = xtc_db_query($master_sql_raw);
		while ($listing = xtc_db_fetch_array($master_query)) {
			if ($_SESSION['customers_status']['customers_fsk18_display']=='0' && $listing['products_fsk18']=='1') {
			} else {
                            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                                $this->data['products_id'], 
                                $country_id
                            );
                            $listing['price'] = $xtPrice->xtcGetPrice($listing['products_id'],
                                $format=true,
                                1,
                                $products_tax_class_id,
                                $listing['products_price']
                            );

                            // check if customer is allowed to add to cart
                            $listing['ADD_FORM'] = xtc_draw_form('addslave_'.$listing['products_id'],xtc_href_link(FILENAME_PRODUCT_INFO,xtc_get_all_get_params(array('action','products_id')) . 'action=add_product&products_id=' . $listing['products_id']));

                            if ($_SESSION['customers_status']['customers_status_show_price']!='0') {
					// fsk18
					if ($_SESSION['customers_status']['customers_fsk18']=='1') {
						if ($listing['products_fsk18']=='0') {
							$listing['ADD_QTY'] = xtc_draw_input_field('products_qty', '1','size="3"'). ' ' . xtc_draw_hidden_field('products_id', $listing['products_id']);
							$listing['ADD_CART_BUTTON'] = xtc_image_submit('button_in_cart.gif', IMAGE_BUTTON_IN_CART);
						}
					} else {
						$listing['ADD_QTY'] = xtc_draw_input_field('products_qty', '1','size="3"') . ' ' . xtc_draw_hidden_field('products_id', $listing['products_id']);
						$listing['ADD_CART_BUTTON'] = xtc_image_submit('button_in_cart.gif', IMAGE_BUTTON_IN_CART);
					}
                            }
                            $listing['PRODUCTS_LINK'] = xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $listing['products_id']);
                            if(!empty($listing['slave_title'])){
                                    $listing['products_name'] = $listing['slave_title'];
                            }
                            $slaves[] = $listing;
			}
		}
		return $slaves;
	}

	private static function get_first_products_to_categories_allocation(int $products_id):int{
		$query = yes_query(sprintf(
			"SELECT c.categories_id FROM %s c LEFT JOIN %s p2c USING(categories_id) WHERE c.categories_status=1 AND p2c.products_id=:id ORDER BY sort_order LIMIT 1",
				TABLE_CATEGORIES,TABLE_PRODUCTS_TO_CATEGORIES,
			),['id'=>$products_id],
			true
		);
		if($query === false){
			return 0;
		}
		return intval( $query['categories_id'] );
	}

	/**
	 * Ermitteln der products_to_categories.categories_id
	 * Holt sich die categories_id aus products_to_categories unter
	 * Beruecksichtigung der categories.sort_order
	 * 
	 * Nuetzlich wenn keine products.default_category hinterlegt ist
	 * 
	 * @param bool $cache
	 * @return int
	 */
	function getCategoriesId($cache=true){
		global $InstanceCache;
		if($cache){
			$cache_key = 'getCategoriesId.categories.products.'.$this->pID;
			$cache_group = 'categories';
			$key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

			$CachedString = $InstanceCache->getItem($key); // cache group
			if (!$CachedString->isHit()) {
				$categories_id = self::get_first_products_to_categories_allocation(intval($this->pID));
				$CachedString->set($categories_id)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
				$InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
			}else{
				$categories_id = $CachedString->get();
			}

		}else{
			$categories_id = self::get_first_products_to_categories_allocation(intval($this->pID));
		}
		return $categories_id;
	}

	function get_earliest_estimated_date_receipt(){
		$query = xtc_db_query(sprintf(
			"SELECT MIN(do.estimated_date_receipt) as datum FROM distributor_orders do LEFT JOIN distributor_orders_products dop USING(distributor_orders_id) WHERE do.orders_status IN(1,2) AND dop.products_id='%d' AND do.estimated_date_receipt>0 LIMIT 1",
			intval($this->pID)
		));
		if(!xtc_db_num_rows($query))
			return 0;
		$record = xtc_db_fetch_array($query);
		return $record['datum'];
	}
	
	
    function getWishlistButton($products_id, $name) {
		global $PHP_SELF;
        $wish = new Wishlist();
		if(!isset($_SESSION['customer_id']) or empty($_SESSION['customer_id']))
	    	return '';
		$wishl_id = $wish->CheckProducts($products_id, $_SESSION['customer_id']);
		if( $wishl_id>0 )   {
			$parameter=xtc_get_all_get_params(array('products_id'));
			$wid = 'action=add_product&wishbutton_listfromwish=1&products_id='.$products_id;
			if($parameter !='')
			$wid.= '&'.$parameter;
			$goto = basename($PHP_SELF);
			$button_wishlist = '<a href="'.xtc_href_link($goto, $wid).'">'.xtc_image_button('wishlist_button_del_bg.gif', IMAGE_BUTTON_FROM_WISHLIST).'</a>';		
		} else {
			//$attributes=xtc_products_default_attributes($products_id);
			$attributes = array();
			$wid = xtc_get_uprid($products_id, $attributes );      // wishlist
			$wid = 'action=add_product&wishbutton_list2wish=1&products_id='.$wid;
			$button_wishlist = '<a href="'.xtc_href_link(FILENAME_WISHLIST, $wid).'">'.xtc_image_button('wishlist_button_bg.gif', IMAGE_BUTTON_IN_WISHLIST).'</a>';		
		}    
		return $button_wishlist;
    }
    
    public function get_products_content(){
        $array = array();
        $language_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
        $items = \YES4Trade\Model\products_content::get_by_products_id($this->pID);
        foreach($items as $it){
            $record = $it->toArray();
            if(!empty($record['content_file'])){
                $record['content_file_basename'] = basename($record['content_file']);
            }else{
                $record['content_file_basename'] = '';
			}
			$pcd = \YES4Trade\Model\products_content_description::get_by_content_id_and_language_id( intval($record['content_id']), intval($language_id) );
			$record['content_name'] = $pcd->content_name;
            $array[] = $record;
        }
        return $array;
    }
    
   // muss auch in der yes/admin/includes/classes Version definiert werden
   function get_running_auctions_list(){
		$auctions = array();
		$ea_list = \YES4Trade\Model\ebay_auctions::get_runnings_by_products_id(intval($this->pID),[
			'id','type','ebay_id','quantity','title'
		]);
		foreach($ea_list as $ea){
			$record = $ea->toArray();
			$record['variation'] = 0;
			$auctions[] = $record;
		}
		$query = xtc_db_query(sprintf(
			"SELECT id,type,ebay_id,eav.quantity,title,1 as variation FROM ebay_auctions ea LEFT JOIN ebay_auctions_variations eav ON eav.ebay_auctions_id=ea.id WHERE ea.products_id='0' AND eav.products_id='%d' AND status=0",
			intval($this->pID)
		));                
		while($record = xtc_db_fetch_array($query)){
			$auctions[] = $record;
		}
		return $auctions;
    }
    
    public static function is_stuecklistenartikel(int $products_id){
        $query = yes_query(
            "SELECT products_collies_id FROM products_collies WHERE products_id=:products_id",
            ['products_id'=>$products_id],
        );
        return (sizeOf($query)>0) ? true : false;
    }
    
    public static function add_history_static($products_id, string $comments){
        $editor_id = intval($_SESSION['customer_id'] ?? 0);
		$insert_sql_array = array(
            'editor_id'=>$editor_id,
            'products_id'=>intval($products_id),
            'date_saved'=>'now()',
            'comments'=>$comments
		);
		yes_db_perform('products_history',$insert_sql_array);
    }
    
    public static function exists( int $products_id ){
        if($products_id < 1){
            return false;
        }
        $query = yes_query(sprintf(
            "SELECT products_id FROM %s WHERE products_id=:products_id",
                TABLE_PRODUCTS,
            ),['products_id'=>(int)$products_id]
        );
        return (sizeOf($query)>0)?true:false;
    }
}
