<?php
/* -----------------------------------------------------------------------------------------
   $Id: ebay_order.php,v 1.8 2017/07/05 12:34:22 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(order.php,v 1.32 2003/02/26); www.oscommerce.com
   (c) 2003	 nextcommerce (order.php,v 1.28 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   credit card encryption functions for the catalog module
   BMC 2003 for the CC CVV Module


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

  // include needed functions
  if(!function_exists('xtc_date_long')){
	require_once(DIR_FS_INC . 'xtc_date_long.inc.php');
  }
  if(!function_exists('xtc_address_format')){
	  require_once(DIR_FS_INC . 'xtc_address_format.inc.php');
  }
  if(!function_exists('xtc_get_country_name')){
	  require_once(DIR_FS_INC . 'xtc_get_country_name.inc.php');
  }
  if(!function_exists('xtc_get_countries')){
	  require_once(DIR_FS_INC . 'xtc_get_countries.inc.php');
  }
  if(!function_exists('xtc_get_zone_code')){
	  require_once(DIR_FS_INC . 'xtc_get_zone_code.inc.php');
  }
  if(!function_exists('xtc_get_tax_description')){
	  require_once(DIR_FS_INC . 'xtc_get_tax_description.inc.php');
  }


  class order {
    var $info, $totals, $products, $customer, $delivery, $content_type, $weight, $total;
    var $is_ebay = true; // GEBRAUCHT IM YES VERSANDMODUL


    function __construct($order_id = '') {
	      $this->info = array();
	      $this->totals = array();
	      $this->products = array();
	      $this->customer = array();
	      $this->delivery = array();
	      $this->transaction();
	      if($order_id != ''){
		$order_id = xtc_db_prepare_input($order_id);

      		$order = yes_query("select
                                   customers_id,
                                   customers_cid,
                                   customers_name,
                                   customers_company,
                                   customers_street_address,
                                   customers_suburb,
                                   customers_city,
                                   customers_postcode,
                                   customers_state,
                                   customers_country,
                                   customers_telephone,
                                   customers_email_address,
                                   customers_address_format_id,
                                   delivery_name,
                                   delivery_company,
                                   delivery_street_address,
                                   delivery_suburb,
                                   delivery_city,
                                   delivery_postcode,
                                   delivery_state,
                                   delivery_country,
                                   delivery_address_format_id,
                                   billing_name,
                                   billing_company,
                                   billing_street_address,
                                   billing_suburb,
                                   billing_city,
                                   billing_postcode,
                                   billing_state,
                                   billing_country,
                                   billing_address_format_id,
                                   payment_method,
                                   cc_type,
                                   cc_owner,
                                   cc_number,
                                   cc_expires,
                                   cc_cvv,
                                   cc_start,
                                   cc_issue,
                                   currency,
                                   comments,
                                   currency_value,
                                   date_purchased,
				   date_shipping,
				   shipping_class,
                                   orders_status,
				   ebay_shippingcountry,
                                   last_modified
                                   from " . TABLE_ORDERS . " where
                                   orders_id =:orders_id",
                        ['orders_id'=>$order_id],
                        true
                    );

                    $totals_query = yes_query("select title, text,value,class from " . TABLE_ORDERS_TOTAL . " where orders_id =:orders_id order by sort_order",
                        ['orders_id'=>$order_id]
                    );
		    foreach($totals_query as $totals) {
		        $this->totals[] = array('title' => $totals['title'],
		                                'text' =>$totals['text'],
						'class'=>$totals['class'],
		                                'value'=>$totals['value']);
		    }
		
                    $order_total = yes_query("select text from " . TABLE_ORDERS_TOTAL . " where orders_id =:orders_id and class = 'ot_total'",
                        ['orders_id'=> $order_id],
                        true
                    );
		
                    $shipping_method = yes_query("select title from " . TABLE_ORDERS_TOTAL . " where orders_id =:orders_id and class = 'ot_shipping'",
                        ['orders_id'=> $order_id],
                        true
                    );
		
		    $order_status['orders_status_name'] = main::get_orders_status_name($order['orders_status'], $_SESSION['languages_id']);
		
			$this->info = array('currency' => $order['currency'],
                          'currency_value' => $order['currency_value'],
                          'payment_method' => $order['payment_method'],
                          'cc_type' => $order['cc_type'],
                          'cc_owner' => $order['cc_owner'],
                          'cc_number' => $order['cc_number'],
                          'cc_expires' => $order['cc_expires'],
// BMC CC Mod Start
                          'cc_start' => $order['cc_start'],
                          'cc_issue' => $order['cc_issue'],
                          'cc_cvv' => $order['cc_cvv'],
// BMC CC Mod End
                          'date_purchased' => $order['date_purchased'],
                          'date_shipping' => $order['date_shipping'],
                          'orders_status' => $order_status['orders_status_name'],
                          'last_modified' => $order['last_modified'],
                          'total' => strip_tags($order_total['text']),
                          'shipping_method' => ((substr($shipping_method['title'], -1) == ':') ? substr(strip_tags($shipping_method['title']), 0, -1) : strip_tags($shipping_method['title'])),
			  'shipping_class' => $order['shipping_class'],
			  'ebay_shippingcountry'=>$order['ebay_shippingcountry'],
                          'comments' => $order['comments'],
			    'id'=>$order_id
                          );

			$this->customer = array('id' => $order['customers_id'],
		                              'name' => $order['customers_name'],
		                              'csID' => $order['customers_cid'],
		                              'company' => $order['customers_company'],
		                              'street_address' => $order['customers_street_address'],
		                              'suburb' => $order['customers_suburb'],
		                              'city' => $order['customers_city'],
		                              'postcode' => $order['customers_postcode'],
		                              'state' => $order['customers_state'],
		                              'country' => $order['customers_country'],
		                              'format_id' => $order['customers_address_format_id'],
		                              'telephone' => $order['customers_telephone'],
		                              'email_address' => $order['customers_email_address']);
			
			
			$delivery_country_id = main::get_country_values_from_name(xtc_db_prepare_input($order['delivery_country']));
			$this->delivery = array('id' => $order['customers_id'],
		                              'name' => $order['delivery_name'],
		                              'csID' => $order['customers_cid'],
		                              'company' => $order['delivery_company'],
		                              'street_address' => $order['delivery_street_address'],
		                              'suburb' => $order['delivery_suburb'],
		                              'city' => $order['delivery_city'],
		                              'postcode' => $order['delivery_postcode'],
		                              'state' => $order['delivery_state'],
		                              'country' => $order['delivery_country'],
			    'country_id'=>$delivery_country_id['countries_id'],
		                              'format_id' => $order['delivery_address_format_id'],
		                              'telephone' => $order['delivery_telephone'],
		                              'email_address' => $order['customers_email_address']);
	      } // end if orders_id
    }

    function transaction() {
      global $transaction,$auction_data;
      $this->info = array('order_status' => ORDERS_STATUS_UPSELLING,
                          'currency' => $transaction['currency'],
                          'payment_method' => $transaction['order']['payment_method'],
                          'shipping_method' => EBAY_WORKAROUND_SHIPPINGMETHOD,
                          'shipping_cost' => $transaction['order']['shipping'],
                          'shipping_class'=>EBAY_WORKAROUND_SHIPPINGCLASS,
                          'payment_class' => $transaction['order']['payment_method']
                          );

      // WE NEED THE COUNTRY ID
      $delivery_country_id_query = xtc_db_query("SELECT countries_id,countries_iso_code_3 FROM countries WHERE countries_iso_code_2='".xtc_db_prepare_input( $transaction['ship']['country'] )."'");
      $delivery_country_id = xtc_db_fetch_array($delivery_country_id_query);

      $this->delivery = array('country' => array('id' => $delivery_country_id['countries_id'], 'title' => $transaction['ship']['countryname'], 'iso_code_2' => $transaction['ship']['country'],'iso_code_3'=>$delivery_country_id['countries_iso_code_3'] ));


      $this->products[0] = array('qty' => $transaction['order']['qty'],
                                        'name' => $transaction['order']['products_name'],
                                        'model' => $auction_data['products_model'],
                                        'tax' => $transaction['order']['vat'],
                                        'price' =>  $transaction['order']['itemtotal'],
                            		'final_price' => ($transaction['order']['itemtotal']*$transaction['order']['qty']),
                                        'id' => $auction_data['products_id']);
    }
    function calculate( ) {
      $this->total = 0;
      $this->weight = 0;
      if (!is_array($this->products)) return 0;

      reset($this->products);
      // php8 bugfix
      //while (list($id, ) = each($this->products)) {
      foreach($this->products as $id => $egal) {

        // products price
        $product_query = yes_query("select products_weight from " . TABLE_PRODUCTS . " where products_id=:products_id",
            ['products_id'=>$this->products[$id]['id'] ]
        );
        if (sizeOf($product_query)) {
            $product = current($product_query);
            $this->weight += ($this->products[$id]['qty'] * $product['products_weight']);
        }

      }
    }

    function count_contents() {  // get total number of items in cart 
      $total_items = 0;
      if (is_array($this->products)) {
        reset($this->products);
        // php8 bugfix
        //while (list($id, ) = each($this->products)) {
        foreach($this->products as $id => $egal) {
          $total_items += $this->get_quantity($id);
        }
      }

      return $total_items;
    }

    function show_weight() {
      $this->calculate();

      return $this->weight;
    }

    function get_quantity($id) {
      if (isset($this->products[$id])) {
        return $this->products[$id]['qty'];
      } else {
        return 0;
      }
  }
    
  public function get_real_shipping_costs(){
      if(stristr($this->info['shipping_class'],'pickup') or stristr($this->info['payment_method'],'pickup')){
          return 0;
      }
      $graduation_query = xtc_db_query(sprintf(
              "SELECT shipping_graduation_id FROM shipping_graduation WHERE value <= %s ORDER BY value DESC limit 1",
              sizeOf($this->products)
      ));
      $graduation = xtc_db_fetch_array($graduation_query);
      $gID = $graduation['shipping_graduation_id'];
      $group_query = xtc_db_query(sprintf(
              "SELECT shipping_graduation_groups_id FROM shipping_graduation_countries WHERE country_id='%s'",
              $this->delivery['country_id']
      ));
      if(xtc_db_num_rows($group_query)){
          $group = xtc_db_fetch_array($group_query);
          $groupID = $group['shipping_graduation_groups_id'];
      }else{
          $groupID = 999999;
      }
      $weight_query = xtc_db_query(sprintf(
              "SELECT shipping_graduation_weights_id FROM shipping_graduation_weights ORDER BY abs(weight - %s) limit 1",
              $this->show_weight()
      ));
      $weight = xtc_db_fetch_array($weight_query);
      $wID = $weight['shipping_graduation_weights_id'];
      $cost_query = xtc_db_query(sprintf(
              "SELECT grad_value_cost FROM shipping_graduation_values WHERE shipping_graduation_id='%s' AND shipping_graduation_weights_id='%s' AND shipping_graduation_groups_id='%s'",
              $gID,$wID,$groupID
      ));
      if(xtc_db_num_rows($cost_query)){
          $cost = xtc_db_fetch_array($cost_query);
          return $cost['grad_value_cost'];
      }
      return 0;
  }
  
  public function save_real_shipping_cost(){
      yes_query(
            "DELETE FROM orders_costs WHERE orders_id=:orders_id AND title='shipping'",
            ['orders_id'=>$this->info['id']]
      );
      $insert_sql_array = array(
          'orders_id'=>$this->info['id'],
          'title'=>'shipping',
          'costs'=>$this->get_real_shipping_costs()
      );
      yes_db_perform('orders_costs',$insert_sql_array);
  }
}
