<?php
/**
 * EU OSS Handling verwenden
 * 
 * Prueft anhand der country_id ob der dazugehoerige ISO2 Code in der Konfig
 * Variable EUOSS_COUNTRIES_ISO2LIST enthalten ist. Gibt true zurueck wenn fuer
 * dieses Land das EU OSS Handling angewendet werden muss.
 * Ist das Land gleich STORE_COUNTRY wird auch automatisch false zurueckgegeben
 * 
 * @param int $country_id
 * @return bool
 */
function yes_eu_oss_use_country_handling( int $country_id ){
    if($country_id === STORE_COUNTRY){
        return false;
    }
    $record = main::get_country_values($country_id);
    if(!isset($record['countries_iso_code_2'])){
        return false;
    }
    $compare_array = [];
    $iso_list = explode(',',EUOSS_COUNTRIES_ISO2LIST);
    foreach($iso_list as $iso){
        $compare_array[] = strtoupper(trim($iso));
    }
    return in_array($record['countries_iso_code_2'],$compare_array);
}

/**
 * Steuerklasse Zuweisung Artikel
 * 
 * hat der Artikel eine Zuweisung in der Tabelle products_tax_rates_allocation
 * oder groups_tax_rates_allocation?
 * 
 * @param int $products_id
 * @return 'product'|'group'|''
 */
function yes_eu_oss_get_tax_class_allocation($products_id){
    $parameters = ['products_id'=>(int)$products_id];
    $query = yes_query(
        "SELECT products_id FROM products_tax_rates_allocation WHERE products_id=:products_id",
        $parameters
    );
    if(sizeOf($query)){
        return ['source'=>'product'];
    }
    // keine artikelbasierte steuersatz zuordnung
    // in produktgruppen nachschauen
    $query = yes_query(
        "SELECT ga.groups_id FROM groups_allocations ga WHERE products_id=:products_id",
        $parameters
    );
    foreach($query as $record){
        $query2 = xtc_db_query(sprintf(
            "SELECT gtra.groups_id, g.groups_title FROM groups_tax_rates_allocation gtra LEFT JOIN `groups` g USING(groups_id) WHERE gtra.groups_id='%d'",
            $record['groups_id']
        ));
        if(xtc_db_num_rows($query2)){
            $recordg = xtc_db_fetch_array($query2);
            return ['source'=>'group','source_info'=>$recordg['groups_title']];
        }
    }
    // Keine Steuerklasse zugewiesen
    return '';
}
/**
 * EU OSS Steuerklasse fuer Artikel
 *  
 * Basierend auf der pID wird ermittelt, welche Steuerklasse (tax_class_id) 
 * verwendet werden muss. Die Zuordnungen sind in den Tabellen 
 * products_tax_rates_allocation, zones_to_geo_zones und tax_rates enthalten
 * 
 * @param int $products_id
 * @param int $country_id
 * @param int $zone_id
 * @return int
 */
function yes_eu_oss_get_products_tax_class_id( $products_id, $country_id, $zone_id = 0){
    $sql_country_id = $country_id;
    
    // WIR HABEN DERZEIT KEIN BUNDESLAND BASIERTES MWST SYSTEM, VON DAHER
    // IMMER ZONE ID Null
    //$sql_zone_id = $zone_id;
    $sql_zone_id = 0;
    
    if(!yes_eu_oss_use_country_handling($country_id)){
    //REIN    $sql_country_id = STORE_COUNTRY;
    //REIN    $sql_zone_id = 0;
    }
    $parameters = [
        'country_id'=>(int)$sql_country_id,
        'zone_id'=>(int)$sql_zone_id,
        'products_id'=>(int)$products_id
    ];
    $query = yes_query(
        "SELECT tr.tax_class_id FROM zones_to_geo_zones zgz LEFT JOIN tax_rates tr ON zgz.geo_zone_id=tr.tax_zone_id LEFT JOIN products_tax_rates_allocation ptra USING(tax_rates_id) WHERE zgz.zone_country_id=:country_id AND zgz.zone_id=:zone_id AND ptra.products_id=:products_id",
        $parameters
    );
    if(sizeOf($query)){
        $record = current($query);
        return $record['tax_class_id'];
    }
    // keine artikelbasierte steuersatz zuordnung
    // in produktgruppen nachschauen
    $parameters = [
        'products_id'=>(int)$products_id
    ];
    $query = yes_query(
        "SELECT ga.groups_id FROM groups_allocations ga WHERE products_id=:products_id",
        $parameters
    );
    if(sizeOf($query)){
        $record = current($query);
        $parameters = [
            'country_id'=>$sql_country_id,
            'zone_id'=>$sql_zone_id,
            'groups_id'=>$record['groups_id']
        ];
        $query = yes_query(
            "SELECT tr.tax_class_id FROM zones_to_geo_zones zgz LEFT JOIN tax_rates tr ON zgz.geo_zone_id=tr.tax_zone_id LEFT JOIN groups_tax_rates_allocation gtra USING(tax_rates_id) WHERE zgz.zone_country_id=:country_id AND zgz.zone_id=:zone_id AND gtra.groups_id=:groups_id",
            $parameters
        );
        if(sizeOf($query)){
            $record = current($query);
            return $record['tax_class_id'];
        }
    }
    // Keine Steuerklasse zugewiesen. Hilft nix. Muessen wir 1 zurueckgeben
    return 1;
}