<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_oe_get_price_i_tax.inc.php

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   XTC-Bestellbearbeitung:
   http://www.xtc-webservice.de / Matthias Hinsche
   info@xtc-webservice.de

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (xtc_get_products_price.inc.php,v 1.13 2003/08/20); www.nextcommerce.org
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

/**
 * Ermittelt den Brutto Wert von $value
 * Wird $check mit true uebergeben, wird $tax_class_id verwendet. Ansonsten
 * gilt der Wert $tax_class_id als tax rate, also zb 19
 * 
 * @param float $value Betrag
 * @param mixed $tax_class_id
 * @param bool $check
 * @return float
 */
function xtc_oe_get_price_i_tax($value, $tax_class_id, $check = false) {
    if ($check === true or $check == '1'){
        $tax = yes_query(
            "select tax_rate from " . TABLE_TAX_RATES . " where tax_class_id =:tax",
            ['tax'=> (int)$tax_class_id],
            true
        );
        $bvalue = ($value*($tax['tax_rate']+100)/100);
    }else{
        // tax_class_id enthaelt MwSt Satz, zb 19
        $bvalue = ($value*($tax_class_id+100)/100);
    }

   return $bvalue;
}
