<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_address_format.inc.php,v 1.4 2013/03/05 08:40:28 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_address_format.inc.php,v 1.5 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
   require_once(DIR_FS_INC . 'xtc_get_zone_code.inc.php');
   require_once(DIR_FS_INC . 'xtc_get_country_name.inc.php');
   require_once(DIR_FS_INC . 'xtc_get_country_data_from_name.inc.php');
   
function xtc_address_format($address_format_id, $address, $html, $boln, $eoln) {
    $address_format = yes_query(sprintf(
        "select address_format as format from %s where address_format_id =:format_id",
            TABLE_ADDRESS_FORMAT
        ),['format_id'=>$address_format_id],
        true
    );
    $company = addslashes($address['company']);
    $firstname = addslashes($address['firstname']);
    $lastname = addslashes($address['lastname']);
    $street = addslashes($address['street_address']);
    $suburb = '';
    if(!empty($address['suburb'])){
        $suburb = addslashes($address['suburb']);
    }
    $city = addslashes($address['city']);
    $state = addslashes($address['state']??'');
    $zone_id = (isset($address['zone_id'])) ? $address['zone_id'] : 0;
    $postcode = addslashes($address['postcode']);
    $zip = $postcode;
    if(isset($address['country_id'])){
        $country_id = $address['country_id'];
        $country = xtc_get_country_name($country_id);
    }else{
        $country = (is_countable($address['country'])) ? $address['country']['title'] : $address['country'];
        if(!is_countable($address['country'])){
          $country_data = xtc_get_country_data_from_name($country);
        }
        $country_id = (is_countable($address['country'])) ? $address['country']['id'] : $country_data['countries_id'];
    }
	
	
    $state = xtc_get_zone_code($country_id, $zone_id, $state);

    if ($html) {
// HTML Mode
      $HR = '<hr>';
      $hr = '<hr>';
      if ( ($boln == '') && ($eoln == "\n") ) { // Values not specified, use rational defaults
        $CR = '<br>';
        $cr = '<br>';
        $eoln = $cr;
      } else { // Use values supplied
        $CR = $eoln . $boln;
        $cr = $CR;
      }
    } else {
// Text Mode
      $CR = $eoln;
      $cr = $CR;
      $HR = '----------------------------------------';
      $hr = '----------------------------------------';
    }

    $statecomma = '';
    $streets = $street;
    if (!empty($suburb)) $streets = $street . $cr . $suburb;
    if (empty($firstname)) $firstname = addslashes($address['name']);
    if (empty($country)) $country = addslashes($address['country']);
    if (!empty($state)) $statecomma = $state . ', ';

    $fmt = $address_format['format'];
    eval("\$address = \"$fmt\";");

    if ( (ACCOUNT_COMPANY == 'true') && (xtc_not_null($company)) ) {
      $address = $company . $cr . $address;
    }

    $address = stripslashes($address);

    return $address;
}
