<?php
require_once('includes/application_top.php');
define('EBAY_TOKEN_EXPIRE_WARNING_DAYS',14);
@set_time_limit(0);
require('includes/classes/class.ebay.php');
// initiate template engine for mail
$smarty = new yesSmarty;
$EBAYAPI = new ebayApi();
$basics = new basics();
$error_reporting = yes_getErrorReporting();
error_reporting(E_ERROR);
$key = 'ebay_auth_duration_check';
$InstanceCache->deleteItem($key); // ebay_auth_duration_check
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once('includes/classes/class.ebaymail.php');

if(isset($_GET['action'])){
    switch($_GET['action']){
		case 'create_user':
			$error = '';
			if(isset($_POST['seller']) and !empty($_POST['seller'])){
				if(!xtc_validate_email($_POST['email'])){
					$error = 'Invalid Email Address';
				}
				if(empty($error)){
					$insert_sql_array = [
						'environment'=>(defined('EBAY_TESTMODE') and constant('EBAY_TESTMODE') == '1') ? 'sandbox' : 'production',
						'user'=>$_POST['seller'],
						'email_address'=>$_POST['email'],
					];
					yes_db_perform('ebay_auth',$insert_sql_array);
					$messageStack->add_session('eBay Seller '.$_POST['seller'].' added','success');
					xtc_redirect(xtc_href_link(basename(__FILE__)));
				}
			}
			echo xtc_draw_form('create_user_form',basename(__FILE__),'action=create_user');
			if(!empty($error)){
				printf('<div class="ui-state-error">&nbsp;%s</div>',
					$error
				);
			}
			printf('<label for="seller">eBay User ID</label><br />%s<br />',
				xtc_draw_input_field('seller',$_GET['seller']??'','id="seller"')
			);
			printf('<label for="email">Email</label><br />%s<br /><input type="submit" value="Add" class="ui-button ui-corner-all ui-state-default" />',
				xtc_draw_input_field('email',$_GET['seller']??'','id="email"',false,'email')
			);
			echo '</form>';
			exit;
			break;
        case 'platform_notifications':
            $roles = [
    			'Application',
    			'Event',
				'User',
    			'UserData'
            ];
            
            $events_array = [
				'AskSellerQuestion', // frage an verkaeufer
				'BestOffer','BestOfferDeclined','BestOfferPlaced', // bestoffer aktionen
				'EndOfAuction', // eine Auktion gilt als beendet
				'ItemClosed', // Angebot gilt als beendet (durch kauf oder durch ablauf des angebots)
				'FeedbackReceived',
				'ItemExtended', // Angebot wurde verlaengert
				'ItemSuspended', // wenn ebay cancelt
				'ItemSold','ItemUnsold'

            ];
            
            $user = $_GET['user']??EBAY_USER;
            $role = (isset($_GET['role']) and in_array($_GET['role'], $roles))?$_GET['role']:'Application';
            if(empty($user)){
                die(json_encode([
                    'MSG'=>$_GET['action'].': No User available'
                ]));
            }
            
            if(isset($_POST['event']) and sizeOf($_POST['event'])){
					$uprefs = [];
					foreach($_POST['event'] as $ek=>$ev){
						$uprefs[] = [
							'NotificationEnable'=>[
								'EventEnable'=>$ev,
								'EventType'=>$ek
							]
						];
					}
					$server = 'https://yes-a177922.de';
					$additional_parameters = [
						'UserDeliveryPreferenceArray'=>$uprefs,
						'ApplicationDeliveryPreferences'=>[
  							'ApplicationURL'=>$server.'/soap.php',
  							'ApplicationEnable'=>'Enable',
  							'AlertEnable'=>'Enable'
						]
					];
					$ebaycalls = new \YES4Trade\Model\ebaycalls();
					$response = $ebaycalls->tradingQuery($user, 
						'SetNotificationPreferences',
						intval(constant('EBAY_SITE_ID')),
						$additional_parameters
					);
					die('OK');
            }
            
			$ebaycalls = new \YES4Trade\Model\ebaycalls();
			$additional_xml_params = [
				'PreferenceLevel' => $role
			];
			$res = $ebaycalls->tradingQuery($user,
				'GetNotificationPreferences',
				intval(constant('EBAY_SITE_ID')),
				$additional_xml_params
			);
				
            $events = ''; // wird nur bei role user gefuellt
            $title = sprintf('<h3>Einstellungen f&uuml;r Platform Notifications %s</h3>',
				$role
            );
            switch($role){
                case 'UserData':
                    $title = sprintf('<h3>Einstellungen f&uuml;r Platform Notifications %s</h3>',
                            $role,
                    );
                    $items = $res->UserData;
                    break;
                case 'Application':
                    $title = sprintf('<h3>Einstellungen f&uuml;r Platform Notifications %s (<span style="color: %s">Status: %s</span>)</h3>',
                            $role,
                            ($res->ApplicationDeliveryPreferences->ApplicationEnable=='Enable')?'green':'red',
                            $res->ApplicationDeliveryPreferences->ApplicationEnable
                    );
                    $items = $res->ApplicationDeliveryPreferences;
                    break;
                case 'User':
                    $items = [];
                    $diff_events_from_ebay = [];
                    if(isset($res->UserDeliveryPreferenceArray) and sizeOf($res->UserDeliveryPreferenceArray->NotificationEnable)){
                        $items = $res->UserDeliveryPreferenceArray->NotificationEnable;
                        foreach($items as $ne){
                            $diff_events_from_ebay[] = $ne->EventType;
                        }
                    }
                    $contents = [];
                    $contents[] = [
                        ['text'=>'Event','params'=>'','align'=>'left','form'=>'','th'=>true],
                        ['text'=>'Enable','params'=>'','align'=>'left','form'=>'','th'=>true],
                    ];
                    $params = 'class="yesListTable_minimal" id="platform_notifications_update_table"';
                    $table = new tableBlock();
                    $table->table_parameters = $params;
                    
                    foreach($events_array as $evnt){
                        $default_enabled = 'Disable';
                        $content = [];
                        $content[] = ['text'=>$evnt,'params'=>'','align'=>'left','form'=>''];
                        foreach($items as $item_enabled){
                            if(!in_array($item_enabled->EventType,$diff_events_from_ebay)){
                                throw new Exception( 'Platform Notifications: Unknown event "'.$evnt.'". Please contact YES Support');
                            }
                            if($item_enabled->EventType == $evnt and $item_enabled->EventEnable == 'Enable'){
                                $default_enabled = 'Enable';
                            }
                        }
                        $content[] = ['text'=>xtc_draw_pull_down_menu('event['.$evnt.']',[
                            ['id'=>'Enable', 'text'=>'Enable'],
                            ['id'=>'Disable', 'text'=>'Disable']
                        ], $default_enabled),'params'=>'','align'=>'left','form'=>''];
                        $contents[] = $content;
                    }
                    $events = $table->tableBlock_draw($contents);
                    break;
            }
            
            $smarty->assign([
                'role'=>$role,
                'roles'=>$roles,
                'title'=>$title,
                'items'=>$items,
                'full_html'=>(isset($_GET['full_html']) and $_GET['full_html'] == 0) ? 0 : 1,
                'events'=>$events,
				'user'=>$user,
            ]);
            $smarty->display('token.platform_notifications.html');
            exit;
            break;
        
	case 'new_user2':
		if(!isset($_REQUEST['user'])){
		    $query = xtc_db_query(sprintf(
		            "SELECT COUNT(Id) as anz FROM ebay_auth WHERE environment='%s'",
		            ((EBAY_TESTMODE == 0)?'production':'sandbox')
		    ));
		    $record = xtc_db_fetch_array($query);
		    if($record['anz'] >= EBAYUSER_COUNTER){
		            $messageStack->add_session('Um einen neuen Token anzulegen, m&uuml;ssen Sie erst den alten Token l&ouml;schen.','error');
		            xtc_redirect(xtc_href_link('token.php'));
		    }
		}
		ebayApi::create_oauth2_usertoken($_REQUEST['user']);
		break;
    case 'shipping_policies':
		$id = intval($_GET['tID']);
		$ebay_user = yes_query("SELECT user,id FROM ebay_auth WHERE id=:id",
		 	['id'=>$id],true
		);
		$site_id = $EBAYAPI->get_site_id_from_name(EBAY_SITE);
		$url = xtc_href_link('ebayapi_sdk_calls.php?action=fulfillment_policies&seller='.$ebay_user['user'].'&marketplaceId='.$site_id);
		if(main::isDev()){
			$url = str_replace('https://','http://',$url);
		}
		xtc_redirect($url);
		break;
	case 'update_seller_profiles':
		$environment = (EBAY_TESTMODE == '1')?'sandbox':'production';
		$site = $EBAYAPI->get_site_id_from_name(EBAY_SITE_ID);
		$user = $_REQUEST['user']??EBAY_USER;
		$ebaycaller = new \YES4Trade\Model\ebaycalls();
		$res = $ebaycaller->tradingQuery($user,'GetUserPreferences',$site);
	    if(isset($res->Ack) and $res->Ack == 'Success'){
			xtc_db_query("DELETE FROM ebay_seller_profiles WHERE ebay_user='".xtc_db_input($ebay_user)."'");
			$num = (is_countable($res->SellerProfilePreferences->SupportedSellerProfiles))?sizeOf($res->SellerProfilePreferences->SupportedSellerProfiles):0;
			foreach($res->SellerProfilePreferences->SupportedSellerProfiles as $sspt){
				foreach($sspt->SupportedSellerProfile as $ssp){
					$insert_sql_array = array(
						'ebay_user'=>$user,
						'ProfileType'=>$ssp->getProfileType(),
						'ProfileID'=>$ssp->getProfileID(),
						'ProfileName'=>$ssp->getProfileName(),
						'ShortSummary'=>$ssp->getShortSummary()
					);
					xtc_db_perform('ebay_seller_profiles',$insert_sql_array);
				}
			}
			$messageStack->add_session(MSG_SUCCESS_UPDATE_SELLER_PROFILES.' ('.$num.')','success');
	    }else{
			$messageStack->add_session(MSG_ERROR_UPDATE_SELLER_PROFILES,'error');
	    }
	    xtc_redirect(xtc_href_link(basename(__FILE__)));
	    exit;
	    break;
	case 'get_token_status':
		$msg = '';
		$id = $_GET['id']??null;
		if($id == null){
			$query = [
				'user'=>EBAY_USER,
			];
			$record = $query;
		}else{
			$query = yes_query(
				"SELECT user,ebaytkn,environment FROM ebay_auth WHERE id=:id",[
					'id'=>$id
				],true
			);
			if($query === false){
				die(json_encode([
					'MSG'=>'Invalid User ID'
				]));
			}
		}
		$ini_conf = ebayApi::get_ebay_config_ini();
		$cfg = $ini_conf['ebay-config'];
		$ebaycalls = new \YES4Trade\Model\ebaycalls();
		try{
			$xml = $ebaycalls->tradingQuery($query['user'],'GetTokenStatus',intval(constant('EBAY_SITE')));
		}catch( Exception $e){
			$msg .= '<div style="color: red;">'.$query['user'].': '.$e->getMessage().'</div>';
			$error = true;
		}
		if(!$error){
			$date_exp = new DateTime($xml->TokenStatus->ExpirationTime);
			$date_now = new DateTime();

			if(isset($_GET['display_details']) and $_GET['display_details'] == 1){
				if(!empty($msg)) $msg .= "<br /><br />";
				if($xml->TokenStatus->Status == 'Active'){
					$msg .= sprintf("Token f&uuml;r %s (%s) ist noch g&uuml;ltig bis %s",
						$query['user'],
						$query['environment'],
						$date_exp->format('d.m.Y H:i:s')
					);
				}else{
					yes_debug($xml);
					$msg .= sprintf("Token f&uuml;r %s (%s) hat Status %s",
						$query['user'],
						$query['environment'],
						$xml->TokenStatus->Status
					);
				}
			}
		}
		die(json_encode(array(
			'MSG' => $msg
		)));
		break;
	case 'checkreq':
			$id = intval($_GET['tID']);
			$ebay_user = yes_query(
				"SELECT user,environment,ebaytkn FROM ebay_auth WHERE id=:id",[
					'id'=>$id
				],true
			);
			if($ebay_user === false){
				$messageStack->add_session('Invalid ebay_user ID','error');
				xtc_redirect(xtc_href_link(basename(__FILE__)));
			}
			$environment = $ebay_user['environment'];
			$site = $EBAYAPI->get_site_id_from_name(EBAY_SITE_ID);
			$user = $ebay_user['user'];
			$ebaycalls = new \YES4Trade\Model\ebaycalls();
			$res = $ebaycalls->tradingQuery($user,'GetUser',$site);
			if(isset($res->Ack) and $res->Ack == 'Success'){
				$messageStack->add_session('Yes, Success. Seller '.$user.' is ready to request EbayAPI','success');
			}else{
				if(is_countable($res->Errors)){
					for($i=0;$i<sizeOf($res->Errors);$i++){
						$error = $errors[$i];
						$messageStack->add_session(htmlspecialchars(yes_encode_string($error->LongMessage)),'error');
					}
				}else{
					$messageStack->add_session(htmlspecialchars(yes_encode_string($res->Errors->LongMessage)),'error');
				}
			}
			xtc_redirect(xtc_href_link('token.php',xtc_get_all_get_params(array('action'))));
			break;
		case 'delete':
			$id = xtc_db_input($_GET['tID']);
			$user = yes_query("SELECT user FROM ebay_auth WHERE id=:id",
				['id'=>$id],
				true
			);

			$query = xtc_db_query(sprintf(
				"SELECT id FROM ebay_products WHERE ebay_user='%s'",
				$user['user']
			));
			$num = xtc_db_num_rows($query);
			if($num > 0){
		    	$messageStack->add_session(
					sprintf(TEXT_DELETE_ERROR_CART_ITEMS_EXISTS,
						$num
					),'error'
				);
				xtc_redirect(xtc_href_link('token.php',xtc_get_all_get_params(array('action','tID'))));
			}

			// IN DER DEV SOAP USER VERWALTUNG UPDATEN
			$self = (xtc_not_null($_SERVER['SCRIPT_URI'])) ? $_SERVER['SCRIPT_URI'] : $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
			if(main::isDev(true)){
				$protocol = 'http://';
			}else{
				$protocol = 'https://';
			}
			if(strpos($self,$protocol) === false){
				$self = $protocol.$self;
			}
			$server = current(explode('admin/token.php',$self));

			$url = 'https://yes-a177922.de/soap_user_manager.php';
			$json_array = [
				'action'=>'del',
				'user'=>$user['user'],
				'server'=>$server
			];

			$dotenv = \Dotenv\Dotenv::createImmutable(main::get_secure_path()); // Pfad zur .env-Datei
			$dotenv->load();

			$signature = hash_hmac('sha256', json_encode($json_array), $_ENV['YES2YES_SECRET']);
			try{
				$client = new \GuzzleHttp\Client();
			}catch(Exception $e){
				$messageStack->add_session('Cant remove User from soap_users Allocation. '.$e->getMessage(),'error');
				xtc_redirect(xtc_href_link('token.php'));
			}
			try{
				$response = $client->request('POST',$url,[
					'headers'=>[
						'X-YES-AUTH'=>$signature,
					],
					'json'=>$json_array
				]);
				$code = $response->getStatusCode(); // 200
				$reason = $response->getReasonPhrase();
				if($code !== 200){
					$messageStack->add_session('Cant remove User from soap_users Allocation. '.$e->getMessage(),'error');
					xtc_redirect(xtc_href_link('token.php'));
				}
			}catch(Exception $e){
				$messageStack->add_session('Cant remove User from soap_users Allocation. '.$e->getMessage(),'error');
				xtc_redirect(xtc_href_link('token.php'));
			}

			xtc_db_query("DELETE FROM ebay_auth WHERE id='".$id."'");
			\ebayAPI::delete_oauth2_files($user['user']);
			$messageStack->add_session(sprintf(TEXT_EBAY_USER_DELETED,$user['user']),'success');
			xtc_redirect(xtc_href_link('token.php',xtc_get_all_get_params(array('action','tID'))));
			break;
		case 'save':
			$update_sql_array = array(
				'store_name'=>$_POST['store_name'],
				'email_address'=>$_POST['email_address'],
				'bank'=>$_POST['bank'],
				'vat_id'=>$_POST['vat_id'],
				'store_name_wrap'=>$_POST['store_name_wrap'],
				'bank_wrap'=>$_POST['bank_wrap'],
			    'use_prefix_for_auctiontitle'=>$_POST['use_prefix_for_auctiontitle'],
			    'ebay_store_name'=>$_REQUEST['ebay_store_name'],
                            'ebay_payment_active'=>(int)$_REQUEST['ebay_payment_active']
			);
			xtc_db_perform('ebay_auth',$update_sql_array,'update',"id='".$_GET['tID']."'");
			$messageStack->add_session('Zugangsdaten wurden aktualisiert','success');
			xtc_redirect(xtc_href_link('token.php',xtc_get_all_get_params(array('action'))));
			break;
	}
}
$token_query_raw = sprintf("SELECT *,date_format(tknexp,'%s') as datum FROM ebay_auth",'%d.%m.%Y');
$token_query = xtc_db_query($token_query_raw);
$token_num = xtc_db_num_rows($token_query);
$items = array();
$selected = false;
while($token = xtc_db_fetch_array($token_query)){
	$token['id'] = $token['Id'];
	$token['username'] = (xtc_not_null($token['user']))?$token['user']:EBAY_SHOPUSERNAME;
	$token['selected'] = false;
	if ( ((!isset($_GET['tID'])) && (!isset($_GET['tID'])) || (@$_GET['tID'] == $token['id'])) && (!$selected) && (!isset($_GET['action']) or substr($_GET['action'], 0, 3) != 'new') ) {
		$token['selected'] = true;
		$selected = true;
		$tInfo = new objectInfo($token);
	}
	$items[] = $token;
}
$box_html = '';
$heading = array();
$contents = array();
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
  case 'oauth2_redirect':
  	break;
  case 'delete_confirm':
		$id = intval($_GET['id']??0);
		if($id == 0){
			die('Invalid request');
		}
		$user = yes_query("SELECT user FROM ebay_auth WHERE id=:id",
			['id'=>$id],
			true
  		);

	    $query = xtc_db_query(sprintf(
		    "SELECT id FROM ebay_products WHERE ebay_user='%s'",
		    $user['user']
	    ));
	    if(xtc_db_num_rows($query)){
			printf('<div><i>Seller %s - %s</i></div>',
				$user['user'],
				sprintf(constant('TEXT_DELETE_ERROR_CART_ITEMS_EXISTS'),
					xtc_db_num_rows($query)
				)
			);
	    }else{
			printf('<div>Seller %s - %s</div><div>%s</div>',
				$user['user'],
				constant('TEXT_CONFIRM_DELETE_EBAY_AUTH'),
				yes_draw_href_button(IMAGE_DELETE, xtc_href_link('token.php',xtc_get_all_get_params(array('action','tID')).'action=delete&tID='.$id))
			);
	    }
		exit;
	    break;
  case 'edit':
	    $heading[] = array('text' => '<b>Zugangsdaten ' . $tInfo->username . ' bearbeiten</b>');
	    $contents = array('form' => xtc_draw_form('edit', 'token.php?'.xtc_get_all_get_params(array('action','tID')).'action=save&tID='.$tInfo->id));
	    $contents[] = array('text' => 'Diese Daten werden ben&ouml;tigt um f&uuml;r Ihre Ebay-Seller die passenden Angaben in den Emails sowie der Auktionsabwicklung anzuzeigen.');
	    $contents[] = array('text' => '<b>eBay Store Name (falls vorhanden):</b>');
	    $contents[] = array('text' => xtc_draw_input_field('ebay_store_name',$tInfo->ebay_store_name,'maxlength="128" size="30"'));
	    $contents[] = array('text' => '<b>eBay Payment aktiv:</b><br /><i>Wenn Sie das eBay Payment freigeschaltet haben, werden zu allen Transaktionen die Auftr&auml;ge im Status Bezahlt angelegt.</i>');
	    $contents[] = array('text' => xtc_draw_checkbox_field('ebay_payment_active','1',($tInfo->ebay_payment_active==1)?true:false).' aktiv');
            
	    $contents[] = array('text' => '<b>Name der Firma:</b>');
	    $contents[] = array('text' => xtc_draw_input_field('store_name',$tInfo->store_name,'maxlength="255" size="30"'));
	    $contents[] = array('text' => '<b>Email Adresse:</b>');
	    $contents[] = array('text' => xtc_draw_input_field('email_address',$tInfo->email_address,'maxlength="255" size="30"'));
	    $contents[] = array('text' => '<b>Bankverbindung/Rechnungsfuss:</b>');
	    $contents[] = array('text' => xtc_draw_input_field('bank',$tInfo->bank,'maxlength="255" size="30"'));
	    $contents[] = array('text' => '<b>USt.-ID:</b>');
	    $contents[] = array('text' => xtc_draw_input_field('vat_id',$tInfo->vat_id,'maxlength="255" size="30"'));
	    $contents[] = array('text' => '<b>Firmenanschrift/Briefkopf:</b>');
	    $contents[] = array('text' => xtc_draw_textarea_field('store_name_wrap','virtual',25,6,$tInfo->store_name_wrap));
	    $contents[] = array('text' => '<b>Bank-Daten (Emails)</b>');
	    $contents[] = array('text' => xtc_draw_textarea_field('bank_wrap','virtual',25,6,$tInfo->bank_wrap));
	    
	    $contents[] = array(
		'text' =>TEXT_USE_PREFIX_IN_AUCTION_TITLE.':<br />'.xtc_draw_input_field('use_prefix_for_auctiontitle',$tInfo->use_prefix_for_auctiontitle)
	    );
	    
	    
	    $contents[] = array('text' => '<input class="ui-button ui-corner-all ui-state-default type="button" value="'.IMAGE_CANCEL.'" onClick="window.location.href=\''.xtc_href_link('token.php',xtc_get_all_get_params(array('action'))).'\';">&nbsp;&nbsp;<input type="submit" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default">');
	    break;
  default:
		try{ 
			$access_token = ebayApi::get_oauth2_usertoken($tInfo->username);
		}catch(Exception $e){
			switch($e->getMessage()){
				case 'REFRESH':
					$access_token = ebayApi::refresh_oauth2_usertoken($tInfo->username);
					break;
				case 'CREATE':
					ebayApi::create_oauth2_usertoken($tInfo->username);
					break;
			}
			xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params()));
		}
		if(is_object($tInfo)) {
            $environment_get_param = '';
            if(main::isDev(true)){
                //$environment_get_param = '&environment=sandbox';
            }
		    $heading[] = array('text' => '<b>Zugangsdaten ' . $tInfo->username . '</b>');
		    $contents[] = array('align' => 'center', 'text' => '<input type="button" value="'.IMAGE_EDIT.'" title="'.IMAGE_EDIT.'" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('token.php', xtc_get_all_get_params(array('tID','action')).'tID=' . $tInfo->id . '&action=edit') . '\';" style="width:180px;">');
		    $contents[] = array('align' => 'center', 'text' => '<input type="button" value="'.IMAGE_UPDATE.'" title="'.IMAGE_UPDATE.'" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('token.php', xtc_get_all_get_params(array('tID','action','environment')).'user=' . $tInfo->username . '&action=new_user2'.$environment_get_param) . '\';" style="width:180px;">');
		    $contents[] = array('align' => 'center', 'text' => '<input type="button" value="API Test" title="API Test" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('token.php', xtc_get_all_get_params(array('tID','action','environment')).'tID=' . $tInfo->id . '&action=checkreq') . '\';" style="width:180px;">');
			if(!is_file(main::get_secure_path().'ebay_shipping_policies.json')){
				$title = 'Generieren';
			}else{
				$title = 'Aktualisieren';
			}
			$contents[] = array('align' => 'center', 'text' => '<input type="button" value="Shipping Policies '.$title.'" title="Shipping Policies '.$title.'" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('token.php', xtc_get_all_get_params(array('tID','action')).'tID=' . $tInfo->id . '&action=shipping_policies') . '\';" style="width:180px;">');
		    $contents[] = array('align'=>'center','text'=> yes_draw_href_button(TEXT_UPDATE_SELLER_PROFILES,xtc_href_link(basename(__FILE__),'action=update_seller_profiles&user='.$tInfo->username),'width:180px;'));
            $contents[] = array('align' => 'center', 'text' => '<a class="lbOn bigWidth" id="' . xtc_href_link('ebayapi_sdk_calls.php', 'seller='.$tInfo->username.'&action=seller_profile') . '""><input type="button" value="Seller Infos '.$tInfo->username.'" title="Seller Infos '.$tInfo->username.'" class="ui-button ui-corner-all ui-state-default" style="width:180px;" /></a>');
		    $contents[] = array('align'=>'center','text'=> '<input type="button" value="Token Status" title="Token Status" class="ui-button ui-corner-all ui-state-default get_token_status" data-userid="'.$tInfo->id.'" style="width:180px;">');
		    //$contents[] = array('align' => 'center', 'text' => '<input type="button" value="'.IMAGE_DELETE.'" title="'.IMAGE_DELETE.'" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\'' . xtc_href_link('token.php', xtc_get_all_get_params(array('tID','action')).'tID=' . $tInfo->id . '&action=delete_confirm') . '\';" style="width:180px;">');
		    $contents[] = array('align' => 'center', 'text' => '<input type="button" value="Platform Notifications" title="Platform Notifications" class="lbOn ui-button ui-corner-all ui-state-default" id="' . xtc_href_link('token.php', 'user='.$tInfo->username.'&action=platform_notifications') . '" style="width:180px;">');
		    if($tInfo->ebay_store_name != ''){
				$contents[] = array('text' => '<b>eBay Store Name:</b>');
				$contents[] = array('text' => $tInfo->ebay_store_name);
		    }
		    $contents[] = array('text' => '<b>Name der Firma:</b>');
		    $contents[] = array('text' => $tInfo->store_name);
		    $contents[] = array('text' => '<b>Email Adresse:</b>');
		    $contents[] = array('text' => $tInfo->email_address);
		    $contents[] = array('text' => '<b>Bankverbindung/Rechnungsfuss:</b>');
		    $contents[] = array('text' => $tInfo->bank);
		    $contents[] = array('text' => '<b>USt.-ID:</b>');
		    $contents[] = array('text' => $tInfo->vat_id);
		    $contents[] = array('text' => '<b>Firmenanschrift/Briefkopf:</b>');
		    $contents[] = array('text' => $tInfo->store_name_wrap);
		    $contents[] = array('text' => '<b>Bank-Daten (Emails)</b>');
		    $contents[] = array('text' => $tInfo->bank_wrap);
		    $query = xtc_db_query("SELECT * FROM ebay_seller_profiles WHERE ebay_user='".$tInfo->username."'");
		    if(xtc_db_num_rows($query)){
			$prof = "<table border=\"0\" class=\"yesListTable_minimal\">
			    <thead>
				<tr>
				    <th>Typ</th>
				    <th>ID</th>
				    <th>Name</th>
				</tr>
			    </thead>
			    <tbody>
			";

			while($record = xtc_db_fetch_array($query)){
			    if($record['ShortSummary'] != ''){
				$prof .= sprintf(
					"<tr><td>%s</td><td>%s</td><td>%s</td></tr><tr class=\"odd\"><td colspan=\"3\"><div class=\"ui-state-default ui-corner-all\" style=\"width:10px;text-align:center;float: left;\">&#8505;</div> <i>%s</i></td></tr>",
					$record['ProfileType'],
					$record['ProfileID'],
					xtc_db_prepare_input($record['ProfileName']),
					xtc_db_prepare_input($record['ShortSummary'])
				);
			    }else{
				$prof .= sprintf(
					"<tr><td>%s</td><td>%s</td><td>%s</td></tr>",
					$record['ProfileType'],
					$record['ProfileID'],
					xtc_db_prepare_input($record['ProfileName'])
				);
			    }
			}
			$prof .= "</tbody>
			    </table>";
			$contents[] = array('text' => '<p><b>'.TEXT_SELLER_PROFILES.'</b></p>'.$prof);
		    }
		    
		    
		    
	    }
	    break;
}

if ((xtc_not_null($heading)) && (xtc_not_null($contents))) {
  $box_html .= '            <td width="25%" valign="top" class="ui-widget-content">' . "\n";

  $box = new box;
  $box_html .= $box->infoBox($heading, $contents);

  $box_html .= '            </td>' . "\n";
}


$add_button = array('text'=>TEXT_ADD_EBAY_USER,
    'link'=>xtc_href_link('token.php',xtc_get_all_get_params(array('action')).'action=create_user'),
    'lbOn'=>true,
    'auth'=>true
);
if($token_num > EBAYUSER_COUNTER){
    $add_button['error'] = TEXT_EBAY_USER_LIMIT_EXCEEDED;
}
$buttons = array(
    $add_button
);
if(main::isDev()){
	$buttons[] = array('text'=>'Sandbox User registrieren',
	    'link'=>xtc_href_link('token.php',xtc_get_all_get_params(array('action')).'action=new_user2&environment=sandbox'),
	    'lbOn'=>false,
	    'auth'=>true
	);
}
if(isset($_GET['action']) and $_GET['action'] == 'oauth2_redirect'){
    if(isset($_SESSION['yes_ebay_sdk_oauth_redirect_target'])){
        $smarty->assign('yes_ebay_sdk_oauth_redirect_target',$_SESSION['yes_ebay_sdk_oauth_redirect_target']);
        $_SESSION['yes_ebay_sdk_oauth_redirect_target'] = null;
        unset($_SESSION['yes_ebay_sdk_oauth_redirect_target']);
    }
    $smarty->assign(array(
	'OAUTH_REDIRECT_URL'=>$_GET['auth2_url'],
        'SELLER'=>$_GET['seller'],
    ));
}
$smarty->assign(array(
    'TABLE_HEADING_EBAY_USERID'=>TEXT_EBAY_USERID,
    'TABLE_HEADING_EMAIL'=>TEXT_EMAIL,
    'TABLE_HEADING_TO_DATE'=>TABLE_HEADING_TO_DATE,
    'HEADING_TITLE'=>HEADING_TITLE,
    'HEADING_ADDITIONAL_TITLE'=>TEXT_EBAY_API_STATUS.': '.((EBAY_TESTMODE == '1') ? 'Test' : 'Live'),
    'TEXT_TOKEN_INTRO'=>TEXT_TOKEN_INTRO,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'items'=>$items,
    'TEXT_NO_TOKENS'=>TEXT_NO_TOKENS,
    'BOX'=>$box_html,
    'EDIT_BASELINK'=>xtc_href_link('token.php',xtc_get_all_get_params(array('action','tID')).'tID='),
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
	'TEXT_DELETE_EBAY_USER'=>TEXT_DELETE_EBAY_USER,
));
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('token.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
