
{if $ERROR}
<div class="ui-widget" style="margin-bottom: 10px;">
    <div class="ui-state-error ui-corner-all" style="padding: 0 .7em;"> 
	<p><span class="ui-icon ui-icon-alert" style="float: left; margin-right: .3em;"></span> 
	<strong>Fehler:</strong><br />{$ERROR}</p>
    </div>
</div>
{/if}


{if $action == 'check'}
    <table border="0">
	<tr>
	    <td>Check &raquo;shipping_status&laquo;</td>
	    <td align="right"><img class="check_result_shipping_status" src="images/icon_status_red_light.gif" border="0" /></td>
	</tr>
	<tr class="shipping_status_error" style="display: none;">
	    <td colspan="2" class="error"></td>
	</tr>
	<tr>
	    <td>Check &raquo;lang&laquo;</td>
	    <td align="right"><img class="check_result_lang" src="images/icon_status_red_light.gif" border="0" /></td>
	</tr>
	<tr class="lang_error" style="display: none;">
	    <td colspan="2" class="error"></td>
	</tr>
	<tr>
	    <td>Check &raquo;manufacturer&laquo;</td>
	    <td align="right"><img class="check_result_manufacturer" src="images/icon_status_red_light.gif" border="0" /></td>
	</tr>
    	<tr class="manufacturer_error" style="display: none;">
	    <td colspan="2" class="error"></td>
	</tr>
</table>
    
<script type="text/javascript">
    {literal}
	function do_check_results(json,detail){
	    if(json.SUCCESS == 1){
		$('img.check_result_'+detail).attr('src','images/icon_status_green.gif');
	    }else{
		$('img.check_result_'+detail).attr('src','images/icon_status_red.gif');
		for(i=0;i<json.ERRORS.length;i++){
		    $('table tr.'+detail+'_error td').append(json.ERRORS[i]+'<br />');
		}
		$('table tr.'+detail+'_error td').css('font-size','smaller');
		$('table tr.'+detail+'_error').show();
	    }
	}
	$(function(){
  
	    $.ajax({
		url: 'yes_xmlrpc.php?action=check&detail=shipping_status',
		dataType: 'json',
		success: function(json){
		    do_check_results(json,'shipping_status');
		}
	    });
	    $.ajax({
		url: 'yes_xmlrpc.php?action=check&detail=lang',
		dataType: 'json',
		success: function(json){
		    do_check_results(json,'lang');
		}
	    });
	    $.ajax({
		url: 'yes_xmlrpc.php?action=check&detail=manufacturer',
		dataType: 'json',
		success: function(json){
		    do_check_results(json,'manufacturer');
		}
	    });
	});
    {/literal}
</script>
    
{elseif $action == 'import'}
    
    <ul class="import_items">
	{foreach from=$DATA item=pID}
	<li id="{$pID}" class="not_imported">{$pID}</li>
	{/foreach}
    </ul>
    
{elseif $action == 'get_categories'}
    
    <h3>Import Shopkategorien vom Remoteserver</h3>
    {$TREE}
    
{elseif $action=='remote_server_select'}
    <form action="yes_xmlrpc.php">
    {$INPUT_TOKEN}<input type="submit" value="Remote Server verwenden" />
    </form>
    
{elseif $action == 'import_category'}

    <h3>Artikel Import aus Remote Kategorie &raquo;{$CATEGORY}&laquo;</h3>
    <div class="ui-widget-content paging" align="center">
	{if $BACK_LINK}
	    <a href="{$BACK_LINK}">&lt;&lt; Zur&uuml;ck</a>
	{/if}
	Zeige {$NUM_START} bis {$NUM_CURRENT} von insgesamt {$NUM_TOTAL} Artikel
	{if $NEXT_LINK}
	    <a href="{$NEXT_LINK}">&gt;&gt; Vor</a>
	{/if}
	<br />
	Zeige Seite <input readonly="readonly" class="page_select" type="text" name="page" value="{$PAGE}" /> von {$MAX_PAGES}
    </div>
    <form action="yes_xmlrpc.php?action=import_products" method="post">
	<input type="submit" value="Import" />
    <table border="0" class="ui-widget">
	<thead class="ui-widget-header">
	    <tr>
		<th class="ui-state-highlight"><input type="checkbox" name="checkall" id="checkall" /></th>
		<th>Artikelbild</th>
		<th>pID</th>
		<th>Artikel</th>
	    </tr>
	</thead>
	<tbody>
    {foreach from=$DATA item=product}
	    <tr>
		<td width="15">
		    {if $product.exists}
			<img title="Bereits importiert als pID {$product.exists}" src="images/icons/tick.gif" />
		    {else}
		    <input type="checkbox" name="id[]" value="{$product.products_id}" />
		    {/if}
		</td>
		<td width="100">{if $product.products_image != ''}<img style="max-height:60px;max-width:100px;" src="{$SERVER_IMAGE_PATH}{$product.products_image}" border="0" />{else}&nbsp;{/if}</td>
		<td>{$product.products_id}</td>
		<td>
		    {$product.products_name}
		    {if $product.products_model != ''}
			<br /><i>Art-Nr: {$product.products_model}</i>
		    {/if}
		    {if $product.products_ean != ''}
			<br /><i>EAN: {$product.products_ean}</i>
		    {/if}
		    {assign var="numcol" value="0"}
		    {foreach from=$product.collies item=collie}
			<input type="hidden" name="collies[{$product.products_id}][]" value="{$collie.products_id}:{$collie.quantity}:{$collie.sort_order}" />
			{assign var="numcol" value=$numcol+1}
		    {/foreach}
		    {if $numcol > 0}
			<br /><img src="images/arrow_right.gif" border="0" />&nbsp;<i>Enth&auml;lt {$numcol} Collis die ggf. automatisch mit importiert werden</i>
		    {/if}
		</td>
	    </tr>
    {/foreach}
	</tbody>
    </table>
	<input type="submit" value="Import" />
    </form>
    </div>

{elseif $action == 'search'}

    <h3>Suchergebnis &raquo;{$SEARCH}&laquo;</h3>
    <div class="ui-widget-content paging" align="center">
	{if $BACK_LINK}
	    <a href="{$BACK_LINK}">&lt;&lt; Zur&uuml;ck</a>
	{/if}
	Zeige {$NUM_START} bis {$NUM_CURRENT} von insgesamt {$NUM_TOTAL} Artikel
	{if $NEXT_LINK}
	    <a href="{$NEXT_LINK}">&gt;&gt; Vor</a>
	{/if}
	<br />
	Zeige Seite <input readonly="readonly" class="page_select" type="text" name="page" value="{$PAGE}" /> von {$MAX_PAGES}
    </div>
    <form action="yes_xmlrpc.php?action=import_products" method="post">
	<input type="submit" value="Import" />
    <table border="0" class="ui-widget">
	<thead class="ui-widget-header">
	    <tr>
		<th class="ui-state-highlight"><input type="checkbox" name="checkall" id="checkall" /></th>
		<th>Artikelbild</th>
		<th>pID</th>
		<th>Artikel</th>
	    </tr>
	</thead>
	<tbody>
    {foreach from=$DATA item=product}
	    <tr>
		<td width="15">
		    {if $product.exists}
			<img title="Bereits importiert als pID {$product.exists}" src="images/icons/tick.gif" />
		    {else}
		    <input type="checkbox" name="id[]" value="{$product.products_id}" />
		    {/if}
		</td>
		<td width="100">{if $product.products_image != ''}<img style="max-height:60px;max-width:100px;" src="{$SERVER_IMAGE_PATH}{$product.products_image}" border="0" />{else}&nbsp;{/if}</td>
		<td>{$product.products_id}</td>
		<td>
		    {$product.products_name}
		    {if $product.products_model != ''}
			<br /><i>Art-Nr: {$product.products_model}</i>
		    {/if}
		    {if $product.products_ean != ''}
			<br /><i>EAN: {$product.products_ean}</i>
		    {/if}
		    {assign var="numcol" value="0"}
		    {foreach from=$product.collies item=collie}
			<input type="hidden" name="collies[{$product.products_id}][]" value="{$collie.products_id}:{$collie.quantity}:{$collie.sort_order}" />
			{assign var="numcol" value=$numcol+1}
		    {/foreach}
		    {if $numcol > 0}
			<br /><img src="images/arrow_right.gif" border="0" />&nbsp;<i>Enth&auml;lt {$numcol} Collis die ggf. automatisch mit importiert werden</i>
		    {/if}
		</td>
	    </tr>
    {/foreach}
	</tbody>
    </table>
	<input type="submit" value="Import" />
    </form>
    </div>

{elseif $action == 'remote_server'}
    
    <h3>Remote Server Verwaltung</h3>
		<p>Es sind {$NUM} Remote Server Schnittstellen gespeichert</p>
		{if $NUM > 0}
		<table border="0">
		    <thead class="ui-widget-header">
			<tr>
			    <th>Alias</th>
			    <th>Server</th>
			    <th colspan="2">Angelegt</th>
			</tr>
		    </thead>
		    <tbody class="ui-widget-content">
			{foreach from=$token item=t}
			<tr>
			    <td>
				{if $SESSION_TOKEN == $t.yes_xmlrpc_remote_token_id}
				<img src="images/icon_status_green.gif" title="Token wird verwendet" border="0" />
				{/if}
				{$t.token_alias}
			    </td>
			    <td>{$t.server}</td>
			    <td>{$t.date_added|date_format:"%d.%m.%Y"}</td>
			    <td>
				<a href="javascript:;" class="tkn_delete" id="{$t.yes_xmlrpc_remote_token_id}"><img src="images/icons/cross.gif" /></a>
				&nbsp;
				<a href="javascript:;" class="tkn_edit" id="{$t.yes_xmlrpc_remote_token_id}"><img src="images/arrow_right.gif" /></a>
			    </td>
			</tr>
			{/foreach}
		    </tbody>
		</table>
		{/if}
		<a href="javascript:;" class="ui-state-default ui-corner-all add_remote_token">Neuen Remote Server anlegen</a>
{elseif $action == 'import_config'}
    <h3>Import Konfiguration</h3>
    <form name="import_config" action="yes_xmlrpc.php?action=save_import_config" method="post" onsubmit="return import_config_check()">
    <h4>Importkategorie</h4>
    <p>Legen Sie fest, in welcher Shopkategorie die erzeugten Artikel f&uuml;r Importe aus dem aktuellem Remote Server gespeichert werden.</p>
    {$INPUT_SHOPCATEGORIES}
    
    <h4>Sprachen</h4>
    <p>Folgende Sprachen sind auf dem Remote Server installiert. Legen Sie fest, wie die Ihr YES System die Remote Sprachpakete verarbeiten soll.</p>
    {foreach from=$DATA item=rl}
	<p>
	    Remote Sprach-ID {$rl.id}: {$rl.text}<br />
	    <input class="import" title="Sprache importieren" type="checkbox" name="import[language][{$rl.id}]" {if $rl.checked} checked="checked"{/if} />
	    Lokale Sprache: {$rl.input}
	</p>
    {/foreach}
    <h4>Versanddauer</h4>
    <p>Folgende Versanddauer Angaben f&uuml;r Artikel sind auf dem Remote Server installiert. Legen Sie fest, wie die Ihr YES System die Remote Versandangaben verarbeiten soll.</p>
    <table border="0">
	<thead>
	    <tr>
		<th width="100">Remote ID</th>
		<th width="600">Name</th>
		<th>Lokale Zuweisung</th>
	    </tr>
	</thead>
	<tbody>
	    {foreach from=$SHIP_DATA item=ship}
	    <tr>
		<td>{$ship.id}</td>
		<td>{$ship.text}</td>
		<td>{$ship.input}</td>
	    </tr>
	    {foreachelse}
	<tr>
	    <td colspan="3"><i>Keine Eintr&auml;ge</i></td>
	</tr>
	    {/foreach}
	    
	</tbody>
    </table>
    <h4>VPE</h4>
    <p>Folgende VPE sind auf dem Remote Server installiert. Legen Sie fest, wie die Ihr YES System die Remote VPE verarbeiten soll.</p>
    <table border="0">
	<thead>
	    <tr>
		<th width="100">Remote ID</th>
		<th width="600">Name</th>
		<th>Lokale Zuweisung</th>
	    </tr>
	</thead>
	<tbody>
	    {foreach from=$VPE_DATA item=vpe}
	    <tr>
		<td>{$vpe.id}</td>
		<td>{$vpe.text}</td>
		<td>{$vpe.input}</td>
	    </tr>
	    {foreachelse}
	<tr>
	    <td colspan="3"><i>Keine Eintr&auml;ge</i></td>
	</tr>
	    {/foreach}
	</tbody>
    </table>
    <h4>Einheiten</h4>
    <p>Folgende Mengeneinheiten sind auf dem Remote Server installiert. Legen Sie fest, wie die Ihr YES System die Remote Mengeneinheiten verarbeiten soll.</p>
    <table border="0">
	<thead>
	    <tr>
		<th width="100">Remote ID</th>
		<th width="600">Name</th>
		<th>Lokale Zuweisung</th>
	    </tr>
	</thead>
	<tbody>
	    {foreach from=$UNITS_DATA item=unit}
	    <tr>
		<td>{$unit.id}</td>
		<td>{$unit.text}</td>
		<td>{$unit.input}</td>
	    </tr>
	    {foreachelse}
	<tr>
	    <td colspan="3"><i>Keine Eintr&auml;ge</i></td>
	</tr>
	    {/foreach}
	</tbody>
    </table>
    <br />
    <input type="submit" value="Import Konfiguration Speichern" />
    </form>
    
{elseif $action == ''}


    {if $REQUEST != ''}
<a href="javascript:;" class="show_debug">Debug</a><br />


<div class="debug_info ui-widget" style="display: none;">
<b>Sende folgenden Request:</b>
<br />
<textarea>{$REQUEST}</textarea>
<br />
<b>Serverantwort</b>
<br />
<textarea>{$RESPONSE}</textarea>
</div>
    {/if}

<div id="ui-widget">
    <div class="ui-state-highlight ui-corner-all" style="margin-top: 20px; padding: 0 .7em;"> 
	<p>
	    <strong>Call {$call}</strong> <a href="javascript:;" class="toggle_relations">Relationen anzeigen</a><br />
    {if $call == 'yes.getProduct'}
	{if $PRODUCTS_ID_LINK}
	<a href="{$PRODUCTS_ID_LINK}" target="_blank">pID {$PRODUCTS_ID} wurde erzeugt</a>
	{/if}
    {elseif $call == 'yes.getConfig'}
    
    
	{foreach from=$DATA item=rows key=table}
	RemoteServer Tabelle {$table}<br />
	<table border="0">
	    <tr>
		{assign var=cols value=0}
		    {foreach from=$rows.0 key=col item=irr}
			{if $col != 'relation_data'}
			    {assign var=cols value=$cols+1}
			<th>{$col}</th>
			{/if}
		    {/foreach}
	    </tr>
		{foreach from=$rows item=row}
	    <tr>
		    {foreach from=$row item=val key=col}
			{if $col != 'relation_data'}
			<td>{$val}</td>
			{/if}
		    {/foreach}
	    </tr>
	    {assign var="_relation_table" value=""}
	    {foreach from=$row.relation_data item=reld key=reltable}
		{assign var="_relation_table" value=$reltable}
	    {/foreach}
		    {if $_relation_table != ''}
			{assign var=rcols value=0}
			{foreach from=$row.relation_data.$_relation_table.0 key=rcol item=rirr}
				{assign var=rcols value=$rcols+1}
			{/foreach}
			
	    <tr class="relations" style="display:none;">
		<td colspan="{$cols}">
		    
		    {foreach from=$row.relation_data item=rel key=relation_table_name}

		    <i>Relations Tabelle {$relation_table_name}</i><br />
		    
		    
		    
		    
		    <table border="0" class="relation_table">
			<tr>
			    <td colspan="{$rcols}">
			    </td>
			</tr>
			<tr>
			{foreach from=$rel.0 key=rcol item=rirr}
			    <th>{$rcol}</th>
			{/foreach}
			</tr>
			{foreach from=$rel item=rrow}
			<tr>
				{foreach from=$rrow item=rval}
			    <td>{$rval}</td>
				{/foreach}
			</tr>
			{/foreach}
			</table>
		    {/foreach}
		    
		    
		    
		    
		    
		    
		</td>
	    </tr>
		    {/if}
		{/foreach}
	</table>
	{/foreach}
    {/if}
	</p>
    </div>
</div>
    
{/if} {* END IF ACTION == '' *}
    
<script type="text/javascript">
    {if $MAX_PAGES}
    var MAX_PAGES = {$MAX_PAGES};
    {/if}
    {if $PAGE_LINK}
    var PAGE_LINK = '{$PAGE_LINK}';
    {/if}
    {literal}
	function import_product(){
	    {/literal}{if $action == 'import'}{literal}
	    if($('ul.import_items li.not_imported').length == 0){
		$('#dialog').dialog({
		    modal: true,title: 'Import Status',close:function(){
			window.location.href='yes_xmlrpc.php';
		    }
		}).html('Alle Artikel Importauftr&auml;ge sind abgeschlossen.');
		return false;
	    }
	    {/literal}{/if}{literal}
	    var rpID = $('ul.import_items li.not_imported').attr('id');
	    if(parseInt(rpID) > 0){
		$('ul.import_items li#'+rpID).removeClass('not_imported').addClass('processing').html(rpID+' wird gerade importiert.');
		$.ajax({
		    url: 'yes_xmlrpc.php?action=import_product&id='+rpID,
		    dataType: 'json',
		    success: function(json){
			if(json.SUCCESS == 0){
			    $('ul.import_items li#'+rpID).removeClass('processing').addClass('import_error');
			    if(json.ERROR != ''){
				$('ul.import_items li#'+rpID).html(json.ERROR);
			    }
			}else{
			    $('ul.import_items li#'+rpID).removeClass('processing').addClass('imported').html(json.MSG);
			}
			import_product();
		    },
		    error: function(jqXHR, textStatus, errorThrown){
			alert("Client Error:\r\n"+jqXHR.responseText);
		    }
		});
	    }
	}
	$(function(){
	   $('a.show_debug').click(function(){
	      $('.debug_info').dialog({
		  title: 'DEBUG',
		  width: 800,
		  height: 500
	      });
	   });
	   $('a.toggle_relations').click(function(){
	      $('tr.relations').toggle();
	   });
	    $('ul.directory > li').each(function(){
		childs = $(this).children();
		if(childs.length == 0){
		    $(this).css('cursor','pointer');
		    $(this).click(function(){
			yes = confirm('Kategorie '+$(this).html()+' importieren?');
			if(yes){
			    window.location.href = 'yes_xmlrpc.php?action=import_category&id='+$(this).attr('id');
			}
		    });
		    $(this).css('list-style-image','url(images/icons/current_folder.gif)');
		}
	    });
	    $('input[name="checkall"]').change(function(){
		$('input[name="id[]"]').each(function(){
		   chk = (!$(this).prop('checked')) ? true : false;
		   $(this).prop('checked',chk);
		});
	    });
	    import_product();
	});
	$('input[name="page"]').click(function(){
	    page = prompt('Gehe zu Seite (0-'+MAX_PAGES+')',$(this).val());
	    if(page){
		if( page >= 0 && page <= MAX_PAGES ){
		    window.location.href = PAGE_LINK+'&page='+page;
		}
		
	    }
	});
    function import_config_check(){
	var _import_chk={};
	var _lang_ok = true;
	$('form[name="import_config"] select.language').each(function(){
	    _imp = $(this).closest('p').find('input.import').prop('checked');
	    if(_imp == true){
		if(!_import_chk[$(this).val()]){
		    _import_chk[ $(this).val() ] = true;
		}else{
		    _lang_ok = false;
		}
	    }
	});
	if($('form[name="import_config"] input.import').size() && $('form[name="import_config"] input.import').val().length){
	    if($('form[name="import_config"] input.import:checked').size() < 1){
		alert("Fehler:\r\nSie haben kein Sprachpaket konfiguriert.");
		return false;
	    }
	}else{
	    alert("Fehler:\r\nEs wurde kein lokales Sprachpaket gefunden.");
	    return false;
	}
	if(!_lang_ok){
	    alert("Fehler: \r\n"+'Verwenden Sie unterschiedliche Sprachpakete.');
	    return false;
	}
	return true;
    }
    {/literal}
</script>


