<?php
/* --------------------------------------------------------------
   $Id: tax_rates.php,v 1.4 2017/01/09 08:37:48 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(tax_rates.php,v 1.28 2003/03/12); www.oscommerce.com 
   (c) 2003	 nextcommerce (tax_rates.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');

foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
    if(strpos($cd->getKey(),'tax_description_')>-1 
            or strpos($cd->getKey(),'tax_rates_')>-1
            or strpos($cd->getKey(),'wishlist_taxclasses')>-1){
        $InstanceCache->deleteItem($cd->getKey()); // tax_description_*, tax_rates_*, wishlist_taxclasses
    }
}


require_once(DIR_WS_CLASSES.'product.php');
$smarty = new yesSmarty;
$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
$smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$action = (isset($_GET['action'])) ? $_GET['action'] : '';

$classes = [
    'Standardsatz',
    'Ermäßigt',
    'Ermäßigt 2',
    'Stark ermäßigt',
    'Stark ermäßigt 2',
    'Zwischensatz',
];
$updates = [
        'AT'=>[
            ['tax_class'=> 0,'value'=> 20],
            ['tax_class'=> 1,'value'=> 10],
            ['tax_class'=> 2,'value'=> 13],
            ['tax_class'=> 5,'value'=> 13], // zwischensatz
        ],
        'BE'=>[
            ['tax_class'=> 0,'value'=> 21],
            ['tax_class'=> 1,'value'=> 6],
            ['tax_class'=> 2,'value'=> 12],
            ['tax_class'=> 5,'value'=> 12], // zwischensatz
        ],
        'BG'=>[
            ['tax_class'=> 0,'value'=> 20],
            ['tax_class'=> 1,'value'=> 9],
        ],
        'CY'=>[
            ['tax_class'=> 0,'value'=> 19],
            ['tax_class'=> 1,'value'=> 5],
            ['tax_class'=> 2,'value'=> 9],
        ],
        'CZ'=>[
            ['tax_class'=> 0,'value'=> 21],
            ['tax_class'=> 1,'value'=> 10],
            ['tax_class'=> 2,'value'=> 15],
        ],
        'DE'=>[
            ['tax_class'=> 0,'value'=> 19],
            ['tax_class'=> 1,'value'=> 7],
        ],
        'DK'=>[
            ['tax_class'=> 0,'value'=> 25],
        ],
        'EE'=>[
            ['tax_class'=> 0,'value'=> 20],
            ['tax_class'=> 1,'value'=> 9],
        ],
        'GR'=>[
            ['tax_class'=> 0,'value'=> 24],
            ['tax_class'=> 1,'value'=> 6],
            ['tax_class'=> 2,'value'=> 13],
        ],
        'ES'=>[
            ['tax_class'=> 0,'value'=> 21],
            ['tax_class'=> 1,'value'=> 10],
            ['tax_class'=> 3,'value'=> 4], // stark erm.
        ],
        'FI'=>[
            ['tax_class'=> 0,'value'=> 24],
            ['tax_class'=> 1,'value'=> 10],
            ['tax_class'=> 2,'value'=> 14],
        ],
        'FR'=>[
            ['tax_class'=> 0,'value'=> 20],
            ['tax_class'=> 1,'value'=> 5.5],
            ['tax_class'=> 2,'value'=> 10],
            ['tax_class'=> 3,'value'=> 2.1], // stark erm.
        ],
        'HR'=>[
            ['tax_class'=> 0,'value'=> 25],
            ['tax_class'=> 1,'value'=> 5],
            ['tax_class'=> 2,'value'=> 13],
        ],
        'HU'=>[
            ['tax_class'=> 0,'value'=> 27],
            ['tax_class'=> 1,'value'=> 5],
            ['tax_class'=> 2,'value'=> 18],
        ],
        'IE'=>[
            ['tax_class'=> 0,'value'=> 23],
            ['tax_class'=> 1,'value'=> 9],
            ['tax_class'=> 2,'value'=> 13.5],
            ['tax_class'=> 3,'value'=> 4.8], // stark erm.
            ['tax_class'=> 5,'value'=>13.5], // zwischen
        ],
        'IT'=>[
            ['tax_class'=> 0,'value'=> 22],
            ['tax_class'=> 1,'value'=> 5],
            ['tax_class'=> 2,'value'=> 10],
            ['tax_class'=> 3,'value'=> 4], // stark erm.
        ],
        'LT'=>[
            ['tax_class'=> 0,'value'=> 21],
            ['tax_class'=> 1,'value'=> 5],
            ['tax_class'=> 2,'value'=> 9],
        ],
        'LU'=>[
            ['tax_class'=> 0,'value'=> 17],
            ['tax_class'=> 1,'value'=> 8],
            ['tax_class'=> 3,'value'=> 3], // stark erm.
            ['tax_class'=> 5,'value'=> 14], // zwischen
        ],
        'LV'=>[
            ['tax_class'=> 0,'value'=> 21],
            ['tax_class'=> 1,'value'=> 12],
            ['tax_class'=> 2,'value'=> 5],
        ],
        'MT'=>[
            ['tax_class'=> 0,'value'=> 18],
            ['tax_class'=> 1,'value'=> 5],
            ['tax_class'=> 2,'value'=> 7],
        ],
        'NL'=>[
            ['tax_class'=> 0,'value'=> 21],
            ['tax_class'=> 1,'value'=> 9],
        ],
        'PL'=>[
            ['tax_class'=> 0,'value'=> 23],
            ['tax_class'=> 1,'value'=> 5],
            ['tax_class'=> 2,'value'=> 8],
        ],
        'PT'=>[
            ['tax_class'=> 0,'value'=> 23],
            ['tax_class'=> 1,'value'=> 6],
            ['tax_class'=> 2,'value'=> 13],
            ['tax_class'=> 5,'value'=> 13], // zwischen
        ],
        'RO'=>[
            ['tax_class'=> 0,'value'=> 19],
            ['tax_class'=> 1,'value'=> 5],
            ['tax_class'=> 2,'value'=> 9],
        ],
        'SE'=>[
            ['tax_class'=> 0,'value'=> 25],
            ['tax_class'=> 1,'value'=> 6],
            ['tax_class'=> 2,'value'=> 12],
        ],
        'SI'=>[
            ['tax_class'=> 0,'value'=> 22],
            ['tax_class'=> 1,'value'=> 9.5],
        ],
        'SK'=>[
            ['tax_class'=> 0,'value'=> 20],
            ['tax_class'=> 1,'value'=> 10],
        ],
];




switch ($action) {
    case 'products_set_default':
        $tcID = (int)xtc_db_input($_GET['configuration_value']);
        if($tcID < 1){
            $messageStack->add_session('Es wurde keine Steuerklasse gew&auml;hlt f&uuml;r die Standard-Steuerklassen Hinterlegung.','error');
            xtc_redirect(xtc_href_link(basename(__FILE__)));
        }
        $query = xtc_db_query(sprintf(
                "SELECT products_id FROM %s LEFT JOIN products_tax_rates_allocation ptra USING(products_id) WHERE ptra.products_id IS NULL",
                TABLE_PRODUCTS
        ));
        $pID_array = [];
        while($record = xtc_db_fetch_array($query)){
            $pID_array[] = $record['products_id'];
        }
        $tr_array = [];
        foreach(explode(',',EUOSS_COUNTRIES_ISO2LIST) as $iso2){
            $cID = yes_get_country_id_from_iso2($iso2);
            $z2gz_array = \YES4Trade\Model\zones_to_geo_zones::get_by_zone_country_id(intval($cID),[
                'geo_zone_id'
            ]);
            $z2gz = current($z2gz_array);
            $gzID = $z2gz->geo_zone_id;
            $query = xtc_db_query(sprintf(
                "SELECT tax_rates_id, tax_description FROM %s WHERE tax_zone_id='%d'",
                TABLE_TAX_RATES,$gzID
            ));
            $record = xtc_db_fetch_array($query);
            $tr_array[ $cID ] = $record['tax_rates_id'];
        }
        foreach($pID_array as $pID ){
            foreach($tr_array as $cID => $tr){
                $insert_sql_array = [
                    'products_id'=>$pID,
                    'tax_rates_id'=>$tr,
                    'date_added'=>'now()'
                ];
                xtc_db_perform('products_tax_rates_allocation',$insert_sql_array);
                
                $insert_sql_array = [
                    'products_id'=>$pID,
                    'editor_id'=>$_SESSION['customer_id'],
                    'date_saved'=>'now()',
                    'comments'=>'YES EU Steuersatz Default Import',
                ];
                xtc_db_perform('products_history', $insert_sql_array);
            }
        }
        $messageStack->add_session('Artikel wurden mit einem EU OSS Standard Steuersatz gespeichert.','success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        exit;
        break;
    case 'products_set_default_confirmation':
        $query = xtc_db_query(sprintf(
                "SELECT COUNT(products_id) AS num FROM %s LEFT JOIN products_tax_rates_allocation ptra USING(products_id) WHERE ptra.products_id IS NULL",
                TABLE_PRODUCTS
        ));
        $record = xtc_db_fetch_array($query);
        if($record['num'] < 1){
            die('Alle Artikel haben bereits eine EU OSS konforme Steuersatz Zuweisung');
        }
        printf('<p>Es sind %d Artikel vorhanden, zu denen kein EU OSS Standardsteuersatz hinterlegt wurde. Sie k&ouml;nnen diese Artikel automatisch mit dem Standardsteuersatz versehen.</p>',
                $record['num']
        );
        echo xtc_draw_form('products_set_default_confirmation_form',basename(__FILE__),'','GET');
        echo xtc_draw_hidden_field('action','products_set_default');
        echo 'Standardsteuersatz: '.xtc_cfg_pull_down_tax_classes(1);
        echo '<br />';
        echo '<input type="submit" onclick="$(this).hide();alert(\'Bitte warten. Prozess kann mehrere Minuten dauern.\')" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" />';
        echo '</form>';
        exit;
        break;
    case 'import_upload':
        $target_dir = \main::get_importdata_path();
        $target_file = $target_dir . 'ptca_import_file.csv';
        if (!move_uploaded_file($_FILES["import_file"]["tmp_name"], $target_file)) {
            $messageStack->add_session("Fehler beim Upload der Importdatei",'error');
            xtc_redirect(xtc_href_link(basename(__FILE__),'action=import'));
        }
        // aus admin/includes/modules/export/products_tax_class_allocation.php
        $tax_rates_query = xtc_db_query(sprintf(
                "SELECT tr.*, tc.tax_class_title FROM %s tr LEFT JOIN %s tc USING(tax_class_id) ORDER BY tr.tax_rates_id",
                TABLE_TAX_RATES, TABLE_TAX_CLASS
        ));
        $rates = [];
        while($tax_rate = xtc_db_fetch_array($tax_rates_query)){
            $rates[ $tax_rate['tax_zone_id'] ][$tax_rate['tax_rates_id']] = $tax_rate['tax_rates_id']
                    .': '
                    .$tax_rate['tax_class_title']
                    .' ('.number_format($tax_rate['tax_rate'],2,',','')
                    .'%)';
        }
        $import_data = [];
        if (($handle = fopen($target_file, "r")) !== FALSE) {
            $row_counter = 0;
            while (($row = fgetcsv($handle, 1000, "\t")) !== FALSE) {
                if($row_counter == 0){
                    $row_counter++;
                    continue;
                }
                $row_counter++;
                $pID = $row[0];
                $import_data[ $pID ] = array_slice($row,2);
            }
            fclose($handle);
        }
        $insert_counter = 0;
        foreach($import_data as $pID => $product_data){
            $nr = 0;
            xtc_db_query(sprintf(
                "DELETE FROM products_tax_rates_allocation WHERE products_id='%d'",
                $pID
            ));
            $product_updated = false;
            foreach($rates as $rates_zone_id => $rates_values){
                $item = $product_data[ $nr ];
                foreach($rates_values as $rates_id=>$rate){
                    if($rates_id == $item){
                        $insert_sql_array = [
                            'products_id'=>$pID,
                            'tax_rates_id'=>$item,
                            'date_added'=>'now()'
                        ];
                        xtc_db_perform('products_tax_rates_allocation',$insert_sql_array);
                        $product_updated = true;
                    }
                }
                $nr++;
            }
            if($product_updated){
                $insert_counter++;
            }
        }
        $messageStack->add_session(sprintf(
            MSG_SUCCESS_PRODUCTS_TAX_CLASS_ALLOCATION_IMPORT, 
            $insert_counter, sizeOf($import_data)
        ),'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        exit;
        break;
    case 'products_tax_classes':
        if(isset($_GET['pID'])){
            $pID = (int)xtc_db_input($_GET['pID']);
            $query = xtc_db_query(sprintf(
                    "SELECT tax_rates_id FROM products_tax_rates_allocation WHERE products_id='%d'",
                    $pID
            ));
            $smarty->assign([
                'products_name'=>xtc_get_products_name($pID),
                'PRODUCTS_ID'=>$pID,
            ]);
        }elseif(isset($_GET['gID'])){
            $gID = (int)xtc_db_input($_GET['gID']);
            $query = xtc_db_query(sprintf(
                    "SELECT tax_rates_id FROM groups_tax_rates_allocation WHERE groups_id='%d'",
                    $gID
            ));
            $gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
            foreach($gh->groups as $g){
                if($g['groups_id'] == $gID){
                    $smarty->assign([
                        'groups_name'=>$g['groups_title'],
                        'GROUPS_ID'=>$gID,
                    ]);
                }
            }
        }else{
            die('Missing params');
        }
        if(isset($_POST['tax_rate'])){
            if(isset($_GET['pID'])){
                $sql_field = 'products_id';
                $sql_table = 'products_tax_rates_allocation';
                $sql_value = $pID;
            }elseif( isset($_GET['gID']) ){
                $sql_field = 'groups_id';
                $sql_table = 'groups_tax_rates_allocation';
                $sql_value = $gID;
            }else{
                die(json_encode([
                    'MSG'=>'Missing Parameters'
                ]));
            }
            xtc_db_query(sprintf(
                    "DELETE FROM %s WHERE %s='%d'",
                    $sql_table, $sql_field, $sql_value
            ));
            foreach($_POST['tax_rate'] as $geo_zone_id=>$tax_rates_id){
                $insert_sql_array = array(
                    $sql_field=>$sql_value,
                    'tax_rates_id'=>$tax_rates_id,
                    'date_added'=>'now()'
                );
                xtc_db_perform($sql_table,$insert_sql_array);
            }
            if($sql_field == 'products_id'){
                $comments = sprintf(PRODUCTS_TAX_RATES_ALLOCATION_UPDATE);
                $product = new product($sql_value);
                $product->add_history($comments);
            }
            die(json_encode(array(
                'MSG'=>'',
            )));
        }
        $saved_tax_rates = [];
        while($record = xtc_db_fetch_array($query)){
            $saved_tax_rates[] = $record['tax_rates_id'];
        }
        $query = xtc_db_query(sprintf(
                "SELECT tax_class_id,gz.geo_zone_name,tax_zone_id,tax_rates_id,tax_description FROM %s tr LEFT JOIN %s gz ON tr.tax_zone_id=gz.geo_zone_id ORDER BY tax_description",
                TABLE_TAX_RATES,TABLE_GEO_ZONES
        ));
        $tax_rates = [];
        while($record = xtc_db_fetch_array($query)){
            if(!isset($tax_rates[ $record['tax_zone_id'] ])){
                $tax_rates[ $record['tax_zone_id'] ] = [
                    'geo_zone'=>$record['geo_zone_name'],
                    'tax_rates'=>[],
                ];
            }
            $tax_rates[ $record['tax_zone_id'] ]['tax_rates'][] = [
                'id'=>$record['tax_rates_id'],
                'text'=>$record['tax_description'],
                'tax_class_id'=>$record['tax_class_id'],
                'selected'=>in_array($record['tax_rates_id'], $saved_tax_rates)
            ];
        }
        
        $parameters = 'name="copy_tax_class"';
        $smarty->assign([
            'tax_rates'=>$tax_rates,
            'tax_classes'=>xtc_tax_classes_pull_down($parameters),
            'JS_ALERT_AUTOMATIC_TAX_ZONE_WARNINGS'=>JS_ALERT_AUTOMATIC_TAX_ZONE_WARNINGS,
            'HEADING_TITLE_PRODUCTS_TAX_RATE_ALLOCATION'=>HEADING_TITLE_PRODUCTS_TAX_RATE_ALLOCATION,
            'HEADING_TITLE_GROUPS_TAX_RATE_ALLOCATION'=>HEADING_TITLE_GROUPS_TAX_RATE_ALLOCATION,
            'AUTOMATIC_TAX_ZONE_ALLOCATOR'=>AUTOMATIC_TAX_ZONE_ALLOCATOR,
            'TEXT_SELECT'=>TEXT_SELECT,
            'MSG_SAVED_TAX_ALLOCATION_REFRESH'=>MSG_SAVED_TAX_ALLOCATION_REFRESH,
            'TAX_ALLOCATION_INTRO'=>TAX_ALLOCATION_INTRO,
        ]);
        $smarty->display('products_tax_classes.html');
        exit;
        break;
    case 'tax_update_2':
        $prefix = $_GET['prefix'];
        $tax_class_ids = $_POST['tax_class_ids'];
        $items = \YES4Trade\Model\geo_zones::get_by_geo_zone_name_like($prefix);
        foreach($items as $geo_zone){
            \YES4Trade\Model\geo_zones::delete($geo_zone->geo_zones_id);
        }
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE tax_description LIKE '%s%%'",
                TABLE_TAX_RATES, $prefix
        ));
        foreach($updates as $iso2=>$taxes){
            $countryId = yes_get_country_id_from_iso2($iso2);
            $country = xtc_get_country_name($countryId);
            $new = new \YES4Trade\Model\geo_zones([
                'geo_zone_name'=>sprintf('%s Steuerzone %s',
                        $prefix, $country
                ),
                'geo_zone_description'=>'YES autom. Import',
                'date_added'=>date('Y-m-d H:i:s'),
            ]);
            $gzID = intval($new->create());
            $z2gz_items = \YES4Trade\Model\zones_to_geo_zones::get_by_zone_country_id(intval($countryId),[
                'association_id'
            ]);
            foreach($z2gz_items as $z2gz){
                \YES4Trade\Model\zones_to_geo_zones::delete($z2gz->association_id);
            }
            $new = new \YES4Trade\Model\zones_to_geo_zones([
                'zone_country_id'=>intval($countryId),
                'zone_id'=>0,
                'geo_zone_id'=>$gzID,
                'date_added'=>date('Y-m-d H:i:s')
            ]);
            $new->create();
            foreach($taxes as $tax){
                $insert_sql_array = [
                    'tax_zone_id'=>$gzID,
                    'tax_class_id'=> intval($tax_class_ids[ $tax['tax_class'] ]),
                    'tax_priority'=>1,
                    'tax_rate'=>$tax['value'],
                    'tax_description'=>sprintf('%s (%s) %s%%',
                            $prefix, $iso2,
//                            $classes[$tax['tax_class']],
                            number_format($tax['value'], 2,',','')
                    ),
                    'date_added'=>date('Y-m-d H:i:s')
                ];
                xtc_db_perform(TABLE_TAX_RATES,$insert_sql_array);
            }
        }
        
        die(json_encode(array(
            'MSG'=>''
        )));
        break;
    case 'tax_update':
        $yes_classes = [];
        $existing_classes_query = xtc_db_query(sprintf(
                "SELECT tax_class_id,tax_class_title FROM %s",
                TABLE_TAX_CLASS
        ));
        while($existing_classes = xtc_db_fetch_array($existing_classes_query)){
            $yes_classes[] = [
                'id'=>$existing_classes['tax_class_id'],
                'text'=>$existing_classes['tax_class_title'],
            ];
        }
        if(sizeOf($yes_classes)<sizeOf($classes)){
            die('Folgende Steuerklassen m&uuml;ssen hinterlegt sein um die Import Funktion nutzen zu k&ouml;nnen:<br /><i>'.
                    implode(', ',$classes).'</i>'
            );
        }
        $c_a = [];
        foreach($updates as $k=>$u){
            $c_a[] = sprintf("'%s'",$k);
        }
        $query = xtc_db_query(sprintf(
                "SELECT DISTINCT(countries_id) as anz FROM countries WHERE countries_iso_code_2 IN(%s)",
                implode(',',$c_a)
        ));
        $anz = xtc_db_num_rows($query);
        if($anz < sizeOf($updates)){
            die(sprintf('<p>Im YES System sind nicht alle (%d/%d) im Update aufgeführten EU Länder vorhanden. Importiert werden Steuers&auml;tze zu folgenden Ländern (ISO2):</p> %s',
                    $anz,sizeOf($c_a),
                    str_replace("'",'',implode(', ',$c_a))
            ));
        }
        
        $smarty->assign([
            'tax_classes'=>$classes,
            'input_yes_classes'=>xtc_draw_pull_down_menu('tax_class_id[0]',$yes_classes),
            'updates'=>json_encode($updates),
        ]);
        $smarty->display('tax_rates_import.html');
        exit;
        break;
    case 'deleteconfirm':
        $id = xtc_db_input($_GET['id']);
        xtc_db_query(sprintf(
                "DELETE FROM tax_rates WHERE tax_rates_id='%d'",
                $id
        ));
        $messageStack->add_session(MSG_SUCCESS_TAX_RATE_DELETED,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'new':
    case 'edit':
        if(isset($_GET['id'])){
            $id = (int)xtc_db_input($_GET['id']);
            $rates_query_raw = sprintf("select r.tax_rates_id, z.geo_zone_id, z.geo_zone_name, tc.tax_class_title, tc.tax_class_id, r.tax_priority, r.tax_rate, r.tax_description, r.date_added, r.last_modified from " . TABLE_TAX_CLASS . " tc, " . TABLE_TAX_RATES . " r left join " . TABLE_GEO_ZONES . " z on r.tax_zone_id = z.geo_zone_id where r.tax_class_id = tc.tax_class_id AND r.tax_rates_id='%d'",
                $id
            );
            $rates_query = xtc_db_query($rates_query_raw);
            $trInfo = (object) xtc_db_fetch_array($rates_query);
            $form = xtc_draw_form('rates', FILENAME_TAX_RATES, 'tID=' . $id  . '&action=save','POST','onSubmit="return check_gz_edit_form(this,'.$id.')"');
        }else{
            $trInfo = (object) array(
                'tax_rates_id'=>0,
                'geo_zone_id'=>0,
                'tax_class_id'=>0,
                'tax_priority'=>1,
                'tax_rate'=>0,
                'tax_description'=>'MwSt'
            );
            $form = xtc_draw_form('rates', FILENAME_TAX_RATES, 'action=save','POST','onSubmit="return check_gz_edit_form(this,null)"');
        }
        echo <<<JS_CODE_END
        <script>
function checkIfNumeric(value){
    const float= /^\s*(\+|-)?((\d+(\.\d+)?)|(\.\d+))\s*$/;
    if (float.test(value)) {
        return true;
    }
    return false;
}
function markError( formInstance, inputName ){
        $(formInstance).find('input[name="'+inputName+'"]').css({
           'color': 'white',
           'background-color': 'red'
        });
        window.setTimeout(function(){
            $(formInstance).find('input[name="'+inputName+'"]').css({
               'color': 'black',
               'background-color': 'white'
            });
        },1500)
}
function check_gz_edit_form(formInstance, id){
    var taxRate = $(formInstance).find('input[name="tax_rate"]').val();
    if(taxRate.indexOf(',')>-1){
        taxRate = taxRate.replace(',','.');
    }
    var taxDescription = $(formInstance).find('input[name="tax_description"]').val();
    var taxPriority = $(formInstance).find('input[name="tax_priority"]').val();
    var error = false;
    if(!checkIfNumeric(taxRate)){
        markError(formInstance, 'tax_rate');
        error = true;
    }
    if(!checkIfNumeric(taxPriority)){
        markError(formInstance, 'tax_priority');
        error = true;
    }
    if(taxDescription.trim().length < 2){
        markError(formInstance, 'tax_description');
        error = true;
    }
    if(!error){
        let url;
        if(id !== null){
            url = '?action=save&id='+id;
        }else{
            url = '?action=save';
        }
        $.ajax({
            url: url,
            dataType: 'json',
            data: $(formInstance).serialize(),
            method: 'post',
            success: function(json){
                if(id === null){
                    window.location.href='tax_rates.php';
                    return true;
                }
                $('table#tax-rates-table tbody tr[data-tax_rate_id="'+id+'"] td.priority').text( taxPriority );
                $('table#tax-rates-table tbody tr[data-tax_rate_id="'+id+'"] td.rate').text( taxRate+'%' );
                $('table#tax-rates-table tbody tr[data-tax_rate_id="'+id+'"] td.name').text( taxDescription );
                $('table#tax-rates-table tbody tr[data-tax_rate_id="'+id+'"] td.description').text( json.tax_class_title );
                $('table#tax-rates-table tbody tr[data-tax_rate_id="'+id+'"] td.zone_name .geo_zone_name').text( json.tax_zone_title );
                $('#modal_window').dialog('destroy');
            },
            error: function(xhr){
                alert('Cant save tax rate changes');
            }
        });
    }
    return false;
}
        </script>
        
JS_CODE_END;
        printf('<div class="main">%s',
            $form
        );
        printf('<h4>%s</h4>',TEXT_INFO_EDIT_INTRO);
        printf('<div>%s<br />%s</div>',TEXT_INFO_CLASS_TITLE,
            xtc_tax_classes_pull_down('name="tax_class_id"', $trInfo->tax_class_id)
        );
        printf('<div>%s<br />%s</div>',TEXT_INFO_ZONE_NAME,
            xtc_geo_zones_pull_down('name="tax_zone_id" style="font-size:10px"', $trInfo->geo_zone_id)
        );
        printf('<div>%s<br />%s</div>',TEXT_INFO_TAX_RATE,
            xtc_draw_input_field('tax_rate', $trInfo->tax_rate)
        );
        printf('<div>%s<br />%s</div>',TEXT_INFO_RATE_DESCRIPTION,
            xtc_draw_input_field('tax_description', $trInfo->tax_description)
        );
        printf('<div>%s<br />%s</div>',TEXT_INFO_TAX_RATE_PRIORITY,
            xtc_draw_input_field('tax_priority', $trInfo->tax_priority)
        );
        printf('<input type="submit" value="%s" /></div>',IMAGE_SAVE);
        exit;
        break;
      case 'save':
        if(isset($_GET['id'])){
            $tax_rates_id = (int)xtc_db_prepare_input($_GET['id']);
        }else{
            $tax_rates_id = Null;
        }
        $sql_array = array(
            'tax_class_id'=>$_POST['tax_class_id'],
            'tax_zone_id'=>$_POST['tax_zone_id'],
            'tax_rate'=>$_POST['tax_rate'],
            'tax_description'=>$_POST['tax_description'],
            'tax_priority'=>$_POST['tax_priority'],
            'last_modified'=>'now()'
        );
        if($tax_rates_id != Null){
            xtc_db_perform(TABLE_TAX_RATES, $sql_array,'update',"tax_rates_id='".$tax_rates_id."'");
        }else{
            xtc_db_perform(TABLE_TAX_RATES, $sql_array);
        }
        die(json_encode(array(
            'tax_class_title'=> xtc_get_tax_class_title($_POST['tax_class_id']),
            'tax_zone_title'=> xtc_get_zone_class_title($_POST['tax_zone_id'])
        )));
        break;

}
yes_draw_pre_header();
yes_draw_header(TITLE);
// initiate template engine for mail
$buttons = [];
$buttons[] = array('text'=>TABLE_HEADING_TAX_CLASSES_TITLE,
    'link'=>xtc_href_link(FILENAME_TAX_CLASSES,'action=ajax_list'),
    'lbOn'=>true,
    'auth'=>true
);
$buttons[] = array('text'=>TABLE_HEADING_TAX_ZONES,
    'link'=>xtc_href_link(FILENAME_GEO_ZONES),
    'lbOn'=>false,
    'auth'=>true
);
$buttons[] = array('text'=>IMAGE_NEW_TAX_RATE,
    'link'=>xtc_href_link(FILENAME_TAX_RATES, 'action=new'),
    'lbOn'=>true,
    'auth'=>true
);
$buttons[] = array('text'=>'MwSt Satz Import',
    'link'=>xtc_href_link(FILENAME_TAX_RATES, 'action=tax_update'),
    'lbOn'=>true,
    'auth'=>true
);
$buttons[] = [
    'text'=>'Artikel Standardsteuersatz',
    'link'=>xtc_href_link(basename(__FILE__),'action=products_set_default_confirmation'),
    'lbOn'=>true,
    'auth'=>true,
];
$search_tax_rates = (isset($_GET['search_tax_rates'])) ? $_GET['search_tax_rates'] : '';
$rates_query_raw = sprintf("select r.tax_rates_id, z.geo_zone_id, z.geo_zone_name, tc.tax_class_title, tc.tax_class_id, r.tax_priority, r.tax_rate, r.tax_description, r.date_added, r.last_modified from %s tc, %s r left join %s z on r.tax_zone_id = z.geo_zone_id where r.tax_class_id = tc.tax_class_id",
        TABLE_TAX_CLASS,TABLE_TAX_RATES,TABLE_GEO_ZONES
);
if($search_tax_rates != ''){
    if(strlen($search_tax_rates) == 2){
        $where = "c.countries_iso_code_2 LIKE '".$search_tax_rates."'";
    }else{
        $where = "c.countries_name LIKE '%".$search_tax_rates."%'";
    }
    $rates_query_raw .= sprintf(" AND z.geo_zone_id IN( SELECT geo_zone_id FROM %s zgz LEFT JOIN %s c ON c.countries_id=zgz.zone_country_id WHERE %s) ",
            TABLE_ZONES_TO_GEO_ZONES,TABLE_COUNTRIES, $where
    );
}
$rates_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $rates_query_raw, $rates_query_numrows);
$rates_query = xtc_db_query($rates_query_raw);
$_rates = [];
while ($rates = xtc_db_fetch_array($rates_query)) {
    $_rates[] = $rates;
}
$tax_rates_array = [];
foreach($_rates as $rates){
    $countries = [];
    $geo_zone_countries_query = xtc_db_query(sprintf(
        "SELECT c.countries_iso_code_2, zgz.zone_id FROM zones_to_geo_zones zgz LEFT JOIN countries c ON c.countries_id=zgz.zone_country_id WHERE geo_zone_id='%d'",
        $rates['geo_zone_id']
    ));
    while($geo_zone_countries = xtc_db_fetch_array($geo_zone_countries_query)){
        $countries[] = $geo_zone_countries['countries_iso_code_2'];
    }
    $countries_str = sprintf('%d %s: %s',
        sizeOf($countries),TEXT_COUNTRIES,
        implode(',',$countries)
    );
    $tax_rates_array[] = array(
        'tax_rate_id'=>$rates['tax_rates_id'],
        'tax_priority'=>$rates['tax_priority'],
        'tax_class_title'=>$rates['tax_class_title'],
        'tax_class_id'=>$rates['tax_class_id'],
        'tax_class_name'=>$rates['tax_description'],
        'geo_zone_name'=>$rates['geo_zone_name'],
        'countries'=>$countries_str,
        'tax_rate'=>xtc_display_tax_value($rates['tax_rate']),
    );
}
$smarty->assign(array(
    'IMPORT'=>($action=='import'),
    'TABLE_HEADING_TAX_RATE_PRIORITY'=>TABLE_HEADING_TAX_RATE_PRIORITY,
    'TABLE_HEADING_TAX_CLASS_TITLE'=>TABLE_HEADING_TAX_CLASS_TITLE,
    'TABLE_HEADING_ZONE'=>TABLE_HEADING_ZONE,
    'TABLE_HEADING_TAX_RATE'=>TABLE_HEADING_TAX_RATE,
    'TABLE_HEADING_ACTION'=>TABLE_HEADING_ACTION,
    'TABLE_HEADING_TAX_RATE_NAME'=>TABLE_HEADING_TAX_RATE_NAME,
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'rates'=>$tax_rates_array,
    'PAGING'=>$rates_split->display_count($rates_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_TAX_RATES).
        '<br />'.
        $rates_split->display_links($rates_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page']),
    'TEXT_INFO_HEADING_EDIT_TAX_RATE'=>TEXT_INFO_HEADING_EDIT_TAX_RATE,
    'TAX_RATE_DELETE_CONFIRM'=>TAX_RATE_DELETE_CONFIRM,
    'TEXT_SEARCH_COUNTRY_ALLOCATION'=>TEXT_SEARCH_COUNTRY_ALLOCATION,
    'INPUT_SEARCH_COUNTRY_ALLOCATION'=>xtc_draw_input_field("search_tax_rates", $search_tax_rates,'id="search_tax_rates" placeholder="DE, Germany ..."'),
    'TEXT_IMPORT_TAX_ALLOCATION_FILE'=>TEXT_IMPORT_TAX_ALLOCATION_FILE,
));
$smarty->display('tax_rates.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
