<?php
function GetDirectorySize($path){
    $bytestotal = 0;
    $path = realpath($path);
    if($path!==false && $path!='' && file_exists($path)){
        foreach(new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path, FilesystemIterator::SKIP_DOTS)) as $object){
            $bytestotal += $object->getSize();
        }
    }
    return $bytestotal;
}

function GetHumanFilesize($bytes, $dec = 2): string {

    $size   = array('B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
    $factor = floor((strlen($bytes) - 1) / 3);
    if ($factor == 0) $dec = 0;


    return sprintf("%.{$dec}f %s", $bytes / (1024 ** $factor), $size[$factor]);
}

function deleteDirContent( $path ){
    if (empty($path)) { 
        return false;
    }
    $last = substr($path, strlen($path)-1);
    $path = ($last=='/')?$path.'*':$path.'/*';
    exec('rm -Rf '.$path);
}

$exclude_tables = [
    'configuration',
    'zones',
    'countries',
    'zones_to_geo_zones',
    'customers',
    'countries_allocations',
    'content_manager',
    'tax_rates',
    'payment_moneybookers_countries',
    'admin_access',
    'admin_access_scheme',
    'admin_access_scheme_values',
    'address_book',
    'languages',
    'customers_status',
    'geo_zones',
    'configuration_group',
    'orders_status',
    'shipping_status',
    'reclamations_status',
    'address_format',
    'ebay_sitecodes',
    'tax_class',
    'ebay_timingdelays',
    'reclamations_types',
    'reclamations_reasons',
    'rueckerstattungen_types',
    'ebay_shippingoptions',
    'rueckerstattungen_status',
    'branches_transfer_status',
    'retoure_status',
    'distributor_invoices_status',
    'ebay_durations',
    'currencies',
    'cm_file_flags',
    'ebay_default_shippings',
    'ebay_default_payments',
    'ebay_uuid',
    'ebay_shippingmethods',
    'ebay_currencies',
    'ebay_sites',
    'ebay_countries',
    'distributor_invoices_reasons',
    'yes_help'
];

$exclude_table_actions = [
    ['sql'=>'DELETE FROM customers WHERE customers_id != 1','text'=>'Alle Kunden ausser Adminuser (id=1) löschen'],
    ['sql'=>'DELETE FROM address_book WHERE customers_id != 1','text'=>'Alle Kunden-Adressbücher ausser Adminuser (id=1) löschen'],
    ['sql'=>'DELETE FROM admin_access WHERE customers_id != 1 AND customers_id!="groups"','text'=>'Alle Berechtigungen ausser Adminuser (id=1) und Gruppen (id=groups) löschen'],
];


$query = xtc_db_query(sprintf(
        "SELECT
  TABLE_NAME AS `Table`,
  ROUND((DATA_LENGTH + INDEX_LENGTH)) AS `Size`
FROM
  information_schema.TABLES
WHERE
  TABLE_SCHEMA = '%s'
ORDER BY
  (DATA_LENGTH + INDEX_LENGTH)
DESC;",
        DB_DATABASE
));
$tables = [];
$tables_total = 0;
while($record = xtc_db_fetch_array($query)){
        if($record['Size'] > 0 and !in_array($record['Table'],$exclude_tables)){
            $record['size_text'] = GetHumanFilesize($record['Size']);
            $tables_total += $record['Size'];
            $tables[] = $record;
        }
}
$directories =[
    ['path'=>main::get_secure_path(),'text'=>'secure_files - beinhaltet diverse Dokumente, Historien, Sellerbezogene Zugangstoken zb fuer eBay und Amazon'],
    ['path'=>DIR_FS_CATALOG.'cache/','text'=>'Shop Cache - beinhaltet zwischengespeicherte Datenbankabfragen und verschiedenste andere Dokumente die vom Cache zwischengespeichert werden.'],
    ['path'=>DIR_FS_CATALOG.'templates_c/','text'=>'Shop Templatecache - wird von Smarty verwendet als Cache'],
    ['path'=>DIR_FS_CATALOG.'ebaymich/','text'=>'ebaymich - der Kunde hat die Möglichkeit hier selber Dateien abzulegen die öffentlich abrufbar sein sollen.'],
    ['path'=>DIR_FS_CATALOG.'export/','text'=>'export - wird von Exportmodulen verwendet, dort werden dann zb autom. generierte Sitemaps, Artikelexporte usw. abgelegt.'],
    ['path'=>DIR_FS_CATALOG.'files/','text'=>'sonst. Dateien (files) - wie bei ebaymich ein Verzeichnis worauf die User evtl Zugriff haben.'],
    ['path'=>DIR_FS_CATALOG.'images/product_images/','text'=>'Bilder - hier liegen alle Artikelbilder in versch. Grössen.'],
    ['path'=>DIR_FS_CATALOG.'admin/cron/','text'=>'cron Datenfiles - aus Bestellungen/Kunden/Emails zum Abgleich von Zahlungseingängen'],
    ['path'=>\main::get_exportdata_path(),'text'=>'Admin exportdata - hier sind diverse Bestellungen, Label, Exporte'],
    ['path'=>\main::get_importdata_path(),'text'=>'Importdata - Wenn von externen Anbietern Daten geholt werden, wird in diesem Verzeichnis gespeichert.'],
];
$total_size = 0;
foreach($directories as $nr=>$dir){
    $directories[$nr]['size'] = GetDirectorySize( $dir['path'] );
    $directories[$nr]['size_text'] = GetHumanFilesize($directories[$nr]['size']);
    $total_size += $directories[$nr]['size'];
}

if(isset($_GET['cleanup']) and $_GET['cleanup'] == 1){
    switch($_GET['type']){
        case 'tables_special':
            foreach($exclude_table_actions as $eta){
                xtc_db_query($eta['sql']);
            }
            xtc_db_query("OPTIMIZE TABLE customers");
            xtc_db_query("OPTIMIZE TABLE address_book");
            xtc_db_query("OPTIMIZE TABLE admin_access");
            xtc_redirect(xtc_href_link('system.php?action=cleanup'));
            break;
        case 'files':
            foreach($directories as $d){
                deleteDirContent($d['path']);
            }
            if(!is_dir(DIR_FS_CATALOG.'images/product_images/info_images')){
                mkdir(DIR_FS_CATALOG.'images/product_images/info_images');
            }
            if(!is_dir(DIR_FS_CATALOG.'images/product_images/popup_images')){
                mkdir(DIR_FS_CATALOG.'images/product_images/popup_images');
            }
            if(!is_dir(DIR_FS_CATALOG.'images/product_images/original_images')){
                mkdir(DIR_FS_CATALOG.'images/product_images/original_images');
            }
            if(!is_dir(DIR_FS_CATALOG.'images/product_images/thumbnail_images')){
                mkdir(DIR_FS_CATALOG.'images/product_images/thumbnail_images');
            }
            xtc_redirect(xtc_href_link('system.php?action=cleanup'));
            break;
        case 'tables':
            foreach($tables as $table){
                if($table['Table'] == 'groups'){
                    $table['Table'] = "`groups`";
                }
                try{
                    xtc_db_query(sprintf('TRUNCATE TABLE %s',
                            $table['Table']
                    ));
                    xtc_db_query(sprintf('OPTIMIZE TABLE %s',
                            $table['Table']
                    ));
                }catch( Exception $e ){
                    yes_debug($e);
                }
            }
            xtc_redirect(xtc_href_link('system.php?action=cleanup'));
            break;
    }
    exit;
}


$smarty = new yesSmarty;
$smarty->assign([
    'DIRECTORIES'=>$directories,
    'DIRECTORIES_TOTAL_SIZE'=> GetHumanFilesize($total_size),
    'TABLES'=>$tables,
    'TABLES_TOTAL_SIZE' => GetHumanFilesize($tables_total),
    'TABLES_EXCLUDE' => $exclude_tables,
    'TABLES_EXCLUDE_ACTIONS'=>$exclude_table_actions,
    'JQUERY'=> yes_get_cdn_link('jquery', '2.2.4')
]);

$smarty->display('system.cleanup.html');
