<?php
/* --------------------------------------------------------------
   $Id: stats_stock_overview.php,v 1.20 2017/07/11 05:53:16 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(stats_products_viewed.php,v 1.27 2003/01/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (stats_stock_warning.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');

$LISTINGNUM = 30;
$WHERE_SEARCH = '';
if(isset($_REQUEST['search']) and !empty($_REQUEST['search'])){
	$search = xtc_db_input($_REQUEST['search']);
	switch($_REQUEST['mode']){
		case 'name':
			$WHERE_SEARCH = sprintf(" and pd.products_name LIKE '%%%s%%' ",$search);
			break;
		case 'model':
			$WHERE_SEARCH = sprintf(" and p.products_model LIKE '%%%s%%' ",$search);
			break;
		case 'ean':
			$WHERE_SEARCH = sprintf(" and p.products_ean LIKE '%%%s%%' ",$search);
			break;
		case 'pid':
			$WHERE_SEARCH = sprintf(" and p.products_id=%s ",(int)$search);
			break;
	}
}
$smarty_products_array = array();
$products_query_raw = "select p.products_meldebestand,p.products_model,pc.quantity as collieqty,p.products_id, p.products_quantity, pd.products_name from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd left join products_collies pc on pd.products_id=pc.products_id where pd.language_id = '" . $_SESSION['languages_id'] . "' and pd.products_id = p.products_id $WHERE_SEARCH order by products_quantity";
$stats_split = new splitPageResults($_GET['page'], $LISTINGNUM, $products_query_raw, $products_query_numrows);
$products_query = xtc_db_query($products_query_raw);
$products = array();
while ($products_values = xtc_db_fetch_array($products_query)) {
	$products_values['link'] = xtc_href_link(FILENAME_CATEGORIES, 'pID=' . $products_values['products_id'] . '&action=new_product');
	$SQ = new products_quantity($products_values['products_id']);
	$products_values['pqty'] = $SQ->get_products_total_qty();
	$products_values['av1'] = $SQ->get_available1_qty();
	$products_values['av2'] = $SQ->get_available2_qty();
	
	$qty = $products_values['pqty']; // DEN ALS GRUNDLAGE FUER MELDEBESTAND_STR
	
	$meldebestand_str = ($qty>=$products_values['products_meldebestand']) ? xtc_image('images/icon_status_green.gif','�ber Meldebestand') : xtc_image('images/icon_status_red.gif','Unter Meldebestand');
	$meldebestand_str .= ' ('.$products_values['products_meldebestand'].')';
	$products_values['meldebestand'] = $meldebestand_str;
	
	$abverk_status_array = array(1,2,ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET,ORDERS_STATUS_BEZAHLT,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_STORNIERT);
	$startDate = time()-(60*60*24*7*4); // 4 wochen
	$endDate = time(); // 4 wochen
	$abverk1 = xtc_db_query(sprintf("
				SELECT SUM(op.products_quantity) as qty
				FROM orders_products op,orders o
				WHERE op.orders_id=o.orders_id
					and op.products_id='%s'
					and o.orders_status IN (%s)
					and UNIX_TIMESTAMP(o.date_purchased) > %s
					and UNIX_TIMESTAMP(o.date_purchased) < %s",
			$products_values['products_id'],
			implode(',',$abverk_status_array),
			$startDate,
			$endDate)
		);
   	$abverk1_res = xtc_db_fetch_array($abverk1);
	$products_values['abverkauf1'] = (int)$abverk1_res['qty'];
	$startDate = time()-(60*60*24*7*12); // 3 monate
	$endDate = time(); // 4 wochen
	$abverk2 = xtc_db_query(sprintf("
				SELECT SUM(op.products_quantity) as qty
				FROM orders_products op,orders o
				WHERE op.orders_id=o.orders_id
					and op.products_id='%s'
					and o.orders_status IN (%s)
					and UNIX_TIMESTAMP(o.date_purchased) > %s
					and UNIX_TIMESTAMP(o.date_purchased) < %s",
		$products_values['products_id'],
		implode(',',$abverk_status_array),
		$startDate,
		$endDate)
	);
    $abverk2_res = xtc_db_fetch_array($abverk2);
    $products_values['abverkauf2'] = (int)$abverk2_res['qty'];
    $products_values['in_auction'] = (int)\products_quantity::get_products_in_auction(intval($products_values['products_id']));
    $smarty_products_array[] = $products_values;
}
$smarty = new yesSmarty;
// dont allow cache
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
$search_mode_array = array(
	0=>array('id'=>'name','text'=>LABEL_INPUT_MODE_NAME),
	1=>array('id'=>'model','text'=>LABEL_INPUT_MODE_MODEL),
	2=>array('id'=>'ean','text'=>LABEL_INPUT_MODE_EAN),
	3=>array('id'=>'pid','text'=>'pID')
);
$smarty->assign(array(
	'FORM_END'=>'</form>',
	'HEADING_TITLE'=>HEADING_TITLE,
	'TABLE_HEADING_PRODUCT'=>TABLE_HEADING_PRODUCT,
	'TABLE_HEADING_PHYS'=>TABLE_HEADING_PHYS,
	'TABLE_HEADING_V1'=>TABLE_HEADING_V1,
	'TABLE_HEADING_QUANTITY_ALERT'=>TABLE_HEADING_QUANTITY_ALERT,
	'TABLE_HEADING_STATS1'=>TABLE_HEADING_STATS1,
	'TABLE_HEADING_STATS2'=>TABLE_HEADING_STATS2,
	'TABLE_HEADING_IN_AUCTION'=>TABLE_HEADING_IN_AUCTION,
	'products'=>$smarty_products_array,
	'SPLIT_COUNT'=>$stats_split->display_count($products_query_numrows, $LISTINGNUM, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('page', 'pID'))),
	'SPLIT_LINKS'=>$stats_split->display_links($products_query_numrows, $LISTINGNUM, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page', 'pID'))),
	'SEARCH_LEGEND'=>SEARCH_LEGEND,
	'LABEL_INPUT_SEARCH'=>LABEL_INPUT_SEARCH,
	'LABEL_INPUT_MODE'=>LABEL_INPUT_MODE,
	'IMAGE_SEARCH'=>IMAGE_SEARCH,
	'INPUT_SEARCH'=>xtc_draw_input_field('search',@$_REQUEST['search'],'size="20" maxlength="32"'),
	'INPUT_MODE'=>xtc_draw_pull_down_menu('mode',$search_mode_array,@$_REQUEST['mode']),
    'TEXT_STATS_STATUS_FILTER'=>TEXT_STATS_STATUS_FILTER
));
$smarty->display('stats_stock_overview.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
