<?php
if(!is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/paketliste_pdf_v2.html')){
    die('Need Templatefile. Location: templates/'.CURRENT_TEMPLATE.'/admin/paketliste_pdf_v2.html');
}
require_once(DIR_FS_INC.'xtc_get_products_image.inc.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_WS_CLASSES.'DHL_Paket_DE_Versenden_REST_API.php');

$action = (isset($_GET['action']))?$_GET['action']:'';

switch($action){
    case 'validate':
        die(json_encode(yes_shipping::validate( $_GET['id'] )));
        break;
    case 'secupay_unset_capture_error':
        if(!isset($_POST['hash']) or !sizeOf($_POST['hash'])){
            xtc_redirect(xtc_href_link('shipping.php','action=secupay_capture_error'));
        }
        $count = 0;
        foreach($_POST['hash'] as $sp_hash){
            $query = xtc_db_query(sprintf(
                    "SELECT ordernr FROM secupay_transaction_order WHERE hash='%s'",
                    xtc_db_input($sp_hash)
            ));
            if(!xtc_db_num_rows($query)){
                $messageStack->add_session('unknown hash '.$sp_hash,'error');
                continue;
            }
            $record = xtc_db_fetch_array($query);
            $update_sql_array = array(
                'capture_status'=>1
            );
            xtc_db_perform('secupay_transaction_order',$update_sql_array,'update',
                    "hash='".xtc_db_input($sp_hash)."' and capture_status='2'"
            );
            $order = new order($record['ordernr']);
            $order->add_history($order->info['orders_status'], false, COMMENTS_SECUPAY_CAPTURE_MANUALLY);
            $count++;
        }
        $messageStack->add_session(sprintf(MSG_SUCCESS_SECUPAY_CAPTURE_MANUALLY,$count),'succcess');
        xtc_redirect(xtc_href_link('shipping.php'));
        exit;
        break;
    case 'wemalo_webhook_add_event':
        require_once(DIR_WS_CLASSES.'wemalo.php');
        if(!defined('MODULE_SHIPPING_WEMALO_STATUS') or MODULE_SHIPPING_WEMALO_KEY == ''){
            die('Nicht Konfiguriert. <a href="shipping.php">Zur&uuml;ck</a>');
        }
        $wemalo = new wemalo;
        $saved = explode(',',MODULE_SHIPPING_WEMALO_WEBHOOKS);
        if(isset($_GET['delete']) and $_GET['delete'] == 1){
            $res = $wemalo->deleteWebHook($_GET['event']);
            if( $res == 'ok'){
                $new_vals = [];
                foreach($saved as $s){
                    if( $s != $_GET['event']){
                        $new_vals[] = $s;
                    }
                }
                main::update_configuration_value('MODULE_SHIPPING_WEMALO_WEBHOOKS', implode(',',$new_vals));
            }
            die(json_encode(array(
                'OK'=>1,
            )));
        }
        $res = $wemalo->registerWebHook($_GET['event']);
        $exists = false;
        foreach($saved as $s){
            if( $s == $_GET['event']){
                $exists = true;
            }
        }
        if($res->mode == 'update' or $res->mode == 'create'){
            if(!$exists){
                $new_val = MODULE_SHIPPING_WEMALO_WEBHOOKS.','.$_GET['event'];
                main::update_configuration_value('MODULE_SHIPPING_WEMALO_WEBHOOKS', $new_val);
            }
            die(json_encode(array(
                'OK'=>1,
            )));
        }else{
            if($exists){
                $new_vals = [];
                foreach($saved as $s){
                    if( $s != $_GET['event']){
                        $new_vals[] = $s;
                    }
                }
                main::update_configuration_value('MODULE_SHIPPING_WEMALO_WEBHOOKS', implode(',',$new_vals));
            }
            die(json_encode(array(
                'OK'=>0,
            )));
        }
        break;
    case 'wemalo_check_status':
        require_once(DIR_WS_CLASSES.'wemalo.php');
        if(!defined('MODULE_SHIPPING_WEMALO_STATUS') or MODULE_SHIPPING_WEMALO_KEY == ''){
            die('Nicht Konfiguriert. <a href="shipping.php">Zur&uuml;ck</a>');
        }
        $items = wemalo::get_submitted_items();
        $wemalo = new wemalo;
        // ALLE VERSEMDETEN letzte 3 tage
        //yes_debug($wemalo->getSentPackages( date('d.m.Y H:i:s',time()-(60*60*24*3) )));
        //yes_debug($wemalo->getWebHooks());
        echo '<ul style="list-style-type: none;font-size: 0.8em;">';
        foreach($items as $it){
            $s = new yes_shipping($it['shipping_id']);
            $callId = ($s->reclamations_id < 1) ? $s->orders_id : 'R'.$s->reclamations_id;
            // ORDER STATUS AUSLESEN
            $res = $wemalo->getGoodsOrderStatus($callId);
            /*
            // BOF ARTIKEL ERSETZEN
            $obj = ($s->reclamations_id < 1) ? new order($s->orders_id) : new reclamation( $s->reclamations_id );
            $array = ['positions'=>[]];
            foreach($obj->products as $op){
                $array['positions'][] = [
                    "externalId"=> $op['id'],
                    "quantity"=> $op['qty'],
                //    "externalPositionIdentifier"=> $op['id'],
                ];
            }
            $res = $wemalo->addGoodsOrderPosition($callId,$array);
            // EOF ARTIKEL ERSETZEN
            
            // ORDER PAKETE AUSLESEN
            $res = $wemalo->getOrderPackages($callId);
            yes_debug($res);
             * 
             */
            $src_string = ($s->reclamations_id > 0) ? TEXT_RECLAMATION .' '.$s->reclamations_id : TEXT_ORDER .' '.$s->orders_id;
            switch( $res->statusId ){
                default:
                    printf('<li>Versanddatensatz (%s) befindet sich im Status %s (StatusId %d)</li>',$src_string,$res->statusName,$res->statusId);
                    break;
            }
        }
        echo '</ul>';
        exit;
        break;
    case 'wemalo_submit':
        require_once(DIR_WS_CLASSES.'wemalo.php');
        if(!defined('MODULE_SHIPPING_WEMALO_STATUS') or MODULE_SHIPPING_WEMALO_KEY == ''){
            die('Nicht Konfiguriert. <a href="shipping.php">Zur&uuml;ck</a>');
        }
        $items = yes_shipping::get_wemalo_items_not_submitted();
        if(!sizeOf($items)){
            $messageStack->add_session(MSG_ERROR_NO_WEMALO_SUBMIT_ITEMS, 'error');
            xtc_redirect(xtc_href_link('shipping.php'));
        }
        $wemalo = new wemalo;
        //yes_debug($wemalo->getAllProducts());
        foreach($items as $i){
            $s = new yes_shipping( $i['id'] );
            $src_obj = ($s->reclamations_id > 0) ? new reclamation( $s->reclamations_id ) : new order( $s->orders_id );
            if($src_obj->delivery['company'] != '') {
                $name1 = $src_obj->delivery['company'];
                $name2 = $src_obj->delivery['name'];
            }else{
                $name1 = $src_obj->delivery['name'];
                $name2 = '';
            }
            $shipping_fee = 0;
            $discount = 0;
            foreach($src_obj->totals as $ot){
                switch($ot['class']){
                    case 'ot_shipping':
                        $shipping_fee += $ot['value'];
                        break;
                    case 'ot_discount':
                        $discount += $ot['value'];
                        break;
                }
            }
            $meta_array = [
                "externalId" => ($i['orders_id']>0) ? $i['orders_id'] : 'R'.$i['reclamations_id'],
                "shippingFee" => $shipping_fee,
                "discount" => $discount,
                "receiver" =>
                [
                    [
                        "name1"=> $name1,
                        "name2"=> $name2,
                        "name3"=> "",
                        "street"=> $src_obj->delivery['street_address'],
                        "streetNumber"=> '',
                        "addressAddition"=> $src_obj->delivery['suburb'],
                        "countryCode2Letter"=> $src_obj->delivery['iso_code_2'],
                        "city"=> $src_obj->delivery['city'],
                        "zip"=> $src_obj->delivery['postcode'],
                        "stateProvinceCountry"=> "",
                        "phoneNumber"=> "",
                        "email"=> ($src_obj->delivery['email_address'])?$src_obj->delivery['email_address']:$src_obj->customer['email_address'],
                        "customerNumber"=> $src_obj->customer['ID']
                    ]
                ]
            ];
            if($s->additional_params == 'Spedition::1'){
                $meta_array['dispatcherProfileId'] = 'Spedition';
            }
            $positions = [];
            foreach($src_obj->products as $op){
                $p = new product($op['id']);
                $collies = $p->get_collies();
                if(sizeOf($collies)){
                    foreach($collies as $colli){
                        // collie_products_id,quantity,sort_order
                        $positions[] = [
                            "externalId"=> $colli['collie_products_id'],
                            "quantity"=> $op['qty']*$colli['quantity'],
                            "externalPositionIdentifier"=> $colli['collie_products_id'],
                        ];
                    }
                }else{
                    $positions[] = [
                        "externalId"=> $op['id'],
                        "quantity"=> $op['qty'],
                        "externalPositionIdentifier"=> $op['id'],
                    ];
                }
            }
            $data = ['meta' => $meta_array, 'positions' => $positions ];
            $add = $wemalo->goodsOrderAdd($data);
            if($add->status != 200){
                $error = sprintf('(%s/Status %d) %s: %s', $add->resource,$add->status, $add->reason, $add->message );
                xtc_redirect(xtc_href_link('shipping.php?action=wemalo_submit_list&id='.$i['id'].'&error='.urlencode($error)));
            }
            $insert_sql_array = array(
                'shipping_id'=>$i['id'],
                'submitted'=>1,
                'wemalo_reference_id'=>$add->id,
            );
            xtc_db_perform('wemalo',$insert_sql_array);
        }
        $messageStack->add_session(MSG_WEMALO_ORDERS_SUBMITTED,'success');
        xtc_redirect(xtc_href_link('shipping.php'));
        exit;
        break;
    case 'wemalo_submit_list':
        require_once('shipping.wemalo.php');
        exit;
        break;
    case 'secupay_capture_error':
        require_once('shipping.secupay_capture_error.php');
        exit;
        break;
    case 'daily_otc':
        include('shipping_daily_otc.php');
        exit;
	break;
    case 'ebay_completesales_process':
        /**
         * 
         * 
         * 
         * Im V2 Versandmodul bzw auch im alten Handling werden beim
         * Versandabschluss alle zum Auftrag gehoerenden eBay Transaktionen
         * mit shipped=1 markiert. Da kann es natuerlich vorkommen, besonders
         * bei kombinierten eBay Auftraegen, dass einzelne der kombinierten
         * Transaktionen noch gar nicht als versendet gemeldet werden soll.
         * Da in diesem Listing hier alle Transaktionen mit shipped=1 
         * gezeigt werden, sollte hier vllt mal vernuenftiges Handling
         * gebaut werden, damit der Seller zumindest hier sehen kann, dass
         * evtl noch nicht alles verschickt wurde.
         * Auf jeden Fall mal fragen, wie es derzeit gehandhabt wird von
         * den Sellern.
         * 
         * 
         * 
         * 
         * 
         * 
         * 
         * 
         * 
         */



        $msg = '';
        $stapel_id = array();
        $one_click = false;
        $one_click_messages = array();
        if(is_array($_GET['id'])){
            foreach($_GET['id'] as $getid){
                $stapel_id[] = (int)xtc_db_input($getid);
            }
            $one_click = true;
        }else{
            $stapel_id[] = (int)xtc_db_input($_GET['id']);
        }
        $EBAYAPI = new ebayAPI();
        foreach($stapel_id as $id){
            $counter = 0;
            $q = yes_db_query(sprintf(
                    "SELECT et.orders_id,et.ebayid,et.transactionid,et.userid,et.seller,et.site FROM ebay_transactions et WHERE et.shipped=1 AND id='%s'",
                    $id
            ));
            if(!yes_db_num_rows($q)){
                if(!$one_click){
                    die(json_encode(array(
                        'MSG'=>MSG_ERROR_COMPLESETESALES_NO_ITEM
                    )));
                }else{
                    $one_click_messages[] = MSG_ERROR_COMPLESETESALES_NO_ITEM;
                    continue;
                }
            }
            $cs_errors = array();
            // WOZU foreach? ist doch nur eine
            //foreach($q as $record){
            $record = current($q);
            if(empty($record['seller'])){
                xtc_db_query("UPDATE ebay_transactions SET shipped=2 WHERE id='".$id."'");
                if(!$one_click){
                    header('Content-Type: text/html; charset='.CHARSET);
                    die(json_encode(array(
                        'MSG'=>MSG_ERROR_COMPLESETESALES_NO_SELLER
                    )));
                }else{
                    $one_click_messages[] = MSG_ERROR_COMPLESETESALES_NO_SELLER;
                    continue;
                }
            }
            $site_id = $EBAYAPI->get_site_id_from_name($record['site']);

            $ebaycalls = new \YES4Trade\Model\ebaycalls();
            $body = [
                'ItemID' => $record['ebayid'],
                'Shipped'=>true
            ];
            if(!empty($record['transactionid'])){
                $body['TransactionID'] = $record['transactionid'];
            }
            if(isset($_GET['tracking_number'][$id]) and is_countable($_GET['tracking_number'][$id]) and sizeOf($_GET['tracking_number'][$id])){
                $ShipmentTrackingDetails = [];
                foreach($_GET['tracking_number'][$id] as $versender=>$tracking_number){
                    switch(strtolower($versender)){
                        case 'mydpd':
                            $tracking_versender = 'DPD';
                            break;
                        case 'easylog2':
                            $tracking_versender = 'DHL';
                            break;
                        default:
                            $tracking_versender = $versender;
                            break;
                    }
                    $ShipmentTrackingDetails[] = [
                        'ShipmentTrackingNumber'=>$tracking_number,
                        'ShippingCarrierUsed'=>$tracking_versender
                    ];
                }
                $body['Shipment'] = $ShipmentTrackingDetails;
            }
            $seller = $record['seller'];
            if(ebayApi::oauth2_refreshtoken_exists($seller)){
                    if(!ebayApi::oauth2_usertoken_exists($seller) or ebayApi::get_oauth2_usertoken_lifetime($seller) < 1){
                        try{
                            ebayApi::refresh_oauth2_usertoken($seller);
                        }catch(Exception $e){
                            $api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
                            die(json_encode(array(
                                'MSG'=>$api_error
                            )));
                        }
                    }
            }
            $res = $ebaycalls->tradingQuery($seller,
                'CompleteSale',
                $site_id,
                $body
            );
            if($EBAYAPI->isGood($res)){
                if($record['orders_id'] > 0){
                    $order = new order($record['orders_id']);
                    $order->add_history($order->info['orders_status'], false, 'ebay completesales sent');
                }
                xtc_db_query("UPDATE ebay_transactions SET shipped=2 WHERE id='".$id."'");
            }else{
                $errstr = implode('<br />',$EBAYAPI->getResponseErrors($res));
                $cs_errors[] = sprintf('#%s / oID %s: %s',
                        $record['ebayid'],
                        $record['orders_id'],
                        '<br />'.$errstr
                );
                $msg = sprintf(
                        MSG_ERROR_COMPLETESALES,
                        $record['ebayid'],
                        $record['userid'],
                        '<br />'.$errstr
                );
                if($record['orders_id'] > 0){
                    $order = new order($record['orders_id']);
                    $order->add_history($order->info['orders_status'], false, "ebay completesales failed\r\n".$errstr);
                }
                xtc_db_query("UPDATE ebay_transactions SET shipped=2 WHERE id='".$id."'");
            }
            if(sizeOf($cs_errors)){
                require_once(DIR_FS_INC.'yes_write_notice.inc.php');
                $recipients_array = main::get_notice_recipients('ebayapi_cart');
                yes_write_notice('eBay Completesales Fehler',implode('<br />',$cs_errors),0,$recipients_array);
            }
            if(!$one_click){
                header('Content-Type: text/html; charset='.CHARSET);
                die(json_encode(array(
                    'MSG'=>yes_encode_string($msg)
                )));
            }else{
                $one_click_messages[] = yes_encode_string($msg);
            }
        } // end foreach stapel id
        if($one_click){
            die(json_encode(array(
                'messages'=>$one_click_messages,
                'step_url'=>''
            )));
        }
        exit;
    case 'ebay_completesales_preview':
        $q = yes_db_query("SELECT et.id,et.orders_id,et.ebayid,et.transactionid,et.userid,et.seller,et.site FROM ebay_transactions et WHERE et.shipped=1");
        $data = array();
        foreach($q as $record){
            if(empty($record['seller'])){
                continue;
            }
            // BOF - TRACKINGNUMMER
            $orders_query = xtc_db_query(sprintf(
                    "SELECT orders_status, combined_orders_id,delivery_address_format_id FROM %s WHERE orders_id='%s'",
                    TABLE_ORDERS,$record['orders_id']
            ));
            $orders_data = xtc_db_prepare_input(xtc_db_fetch_array($orders_query));
            if($orders_data['combined_orders_id'] > 0 and ($orders_data['orders_status'] == ORDERS_STATUS_STORNIERT) ){
                $orders_id = $orders_data['combined_orders_id'];
            }else{
                $orders_id = $record['orders_id'];
            }
            $record['orders_id'] = $orders_id;
            $tracking_query = xtc_db_query(sprintf(
                    "SELECT id,tracking_id,versender,company,name1,name2,street1,street2,city,postcode,country_name FROM shippings WHERE orders_id='%s'",
                    $orders_id
            ));
            if(xtc_db_num_rows($tracking_query)){
                $tracking = xtc_db_fetch_array($tracking_query);
                $address = array(
                    'name'=>$tracking['name1'].' '.$tracking['name2'],
                    'company'=>$tracking['company'],
                    'street_address'=>$tracking['street1'],
                    'suburb'=>$tracking['street2'],
                    'city'=>$tracking['city'],
                    'country'=>$tracking['country_name'],
                    'postcode'=>$tracking['postcode']
                );

                $record['orders_address'] = xtc_address_format($orders_data['delivery_address_format_id'], $address, true, '', ', ');
                if($tracking['tracking_id'] != ''){ // ALTES HANDLING
                    $record['tracking_number'] = array($tracking['tracking_id']);
                    switch(strtolower($tracking['versender'])){
                        case 'mydpd':
                            $tracking_versender = 'DPD';
                            break;
                        case 'easylog2':
                            $tracking_versender = 'DHL';
                            break;
                        default:
                            $tracking_versender = $tracking['versender'];
                            break;
                    }
                    $record['tracking_versender'] = array($tracking_versender);
                }else{
                    $record['tracking_versender'] = array();
                    $record['tracking_number'] = array();
                    $YS = new yes_shipping($tracking['id']);
                    foreach($YS->getTracking_id_array() as $tracking_id){
                        $record['tracking_number'][] = $tracking_id;
                        switch(strtolower($YS->getVersender())){
                            case 'easylog2':
                                $tracking_versender = 'DHL';
                                break;
                            default:
                                $tracking_versender = $YS->getVersender();
                                break;
                        }
                        $record['tracking_versender'][] = $tracking_versender;
                    }
                    if(!sizeOf($record['tracking_versender'])){
                        $record['tracking_versender'][] = $tracking['versender'];
                    }

                }
            }
            $ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($record['ebayid'],['title']);
            if($ea !== null){
                $record['AUCTION_TITLE'] = $ea->title;
            }else{
                $record['AUCTION_TITLE'] = 'Keine YES Auktion';
            }
            $record['tracking_versender_urlencoded'] = array();
            if(isset($record['tracking_versender'])){
                reset($record['tracking_versender']);
            }else{
                $record['tracking_versender'] = [];
            }
            foreach($record['tracking_versender'] as $tv){
                $record['tracking_versender_urlencoded'][] = urlencode($tv);
            }
            $data[] = $record;
        }
        yes_draw_pre_header();
        $smarty->assign(array(
            'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
            'ITEMS'=>$data,
            'CDN_UI_CSS'=>yes_get_cdn_link('jquery-ui-css'),
            'CDN_JQUERY_JS'=>yes_get_cdn_link('jquery'),
            'IMAGE_BACK'=>IMAGE_BACK,
            'link'=>xtc_href_link('shipping.php','action=ebay_completesales_process'),
            'TEXT_COMPLETESALES_PREVIEW_INTRO'=>TEXT_COMPLETESALES_PREVIEW_INTRO,
            'TEXT_EBAYCOMPLETESALES_DONE'=>TEXT_EBAYCOMPLETESALES_DONE,
            'HEADING_TITLE'=>HEADING_TITLE_EBAY_COMPLETESALES
        ));
        $smarty->display('ebay_completesales.html');
        exit;
    case 'ebay_completesales':
        $EBAYAPI = new ebayAPI();
        $counter = 0;
        $q = yes_db_query("SELECT et.id,et.orders_id,et.ebayid,et.transactionid,et.userid,et.seller,et.site FROM ebay_transactions et WHERE et.shipped=1 LIMIT 50");
        $cs_errors = array();
        foreach($q as $record){
            if($record['seller'] != ''){
                $site_id = $EBAYAPI->get_site_id_from_name($record['site']);

                $orders_query = xtc_db_query(sprintf(
                        "SELECT orders_status, combined_orders_id FROM %s WHERE orders_id='%s'",
                        TABLE_ORDERS,$record['orders_id']
                ));
                $orders_data = xtc_db_fetch_array($orders_query);
                if($orders_data['combined_orders_id'] > 0 and ($orders_data['orders_status'] == ORDERS_STATUS_STORNIERT) ){
                    $orders_id = $orders_data['combined_orders_id'];
                }else{
                    $orders_id = $record['orders_id'];
                }
                $ebaycalls = new \YES4Trade\Model\ebaycalls();

                // ebay container fuer trackingdetails
                $tracking_query = xtc_db_query(sprintf(
                        "SELECT id,tracking_id,versender FROM shippings WHERE orders_id='%s'",
                        $orders_id
                ));
                $ShipmentTrackingDetails = [];
                if(xtc_db_num_rows($tracking_query)){
                    $tracking = xtc_db_fetch_array($tracking_query);
                    if($tracking['tracking_id'] != ''){ // ALTES HANDLING
                        switch(strtolower($tracking['versender'])){
                            case 'easylog2':
                                $tracking_versender = 'DHL';
                                break;
                            case 'mydpd':
                                $tracking_versender = 'DPD';
                                break;
                            default:
                                $tracking_versender = $tracking['versender'];
                                break;
                        }
                        $ShipmentTrackingDetails[] = [
                            'ShipmentTrackingNumber' => $tracking['tracking_id'],
                            'ShippingCarrierUsed' => $tracking_versender
                        ];
                    }else{
                        $YS = new yes_shipping($tracking['id']);
                        foreach($YS->getTracking_id_array() as $tracking_id){
                            switch(strtolower($YS->getVersender())){
                                case 'easylog2':
                                    $tracking_versender = 'DHL';
                                    break;
                                case 'mydpd':
                                    $tracking_versender = 'DPD';
                                    break;
                                default:
                                    $tracking_versender = $YS->getVersender();
                                    break;
                            }
                            $ShipmentTrackingDetails[] = [
                                'ShipmentTrackingNumber' => $tracking_id,
                                'ShippingCarrierUsed' => $tracking_versender
                            ];
                        }
                    }
                }
                // EOF - TRACKINGNUMMER
                $body = [
                    'ItemID' => $record['ebayid'],
                    'Shipped'=>true,
                    'Shipment'=>$ShipmentTrackingDetails
                ];
                if(!empty($record['transactionid'])){
                    $body['TransactionID'] = $record['transactionid'];
                }
                $res = $ebaycalls->tradingQuery($record['seller'],
                    'CompleteSale',
                    $site_id,
                    $body
                );
                if($EBAYAPI->isGood($res)){
                    if($record['orders_id'] > 0){
                        $order = new order($record['orders_id']);
                        $order->add_history($order->info['orders_status'], false, 'ebay completesales sent');
                    }
                    xtc_db_query("UPDATE ebay_transactions SET shipped=2 WHERE id='".$record['id']."'");
                    $counter++;
                }else{
                    $errstr = implode('<br />',$EBAYAPI->getResponseErrors($res));
                    $cs_errors[] = sprintf('#%s / oID %s: %s',
                            $record['ebayid'],
                            $record['orders_id'],
                            $errstr
                    );
                    $messageStack->add_session(sprintf(
                            MSG_ERROR_COMPLETESALES,
                            $record['ebayid'],
                            $record['userid'],
                            $errstr
                    ),'error');
                    if($record['orders_id'] > 0){
                        $order = new order($record['orders_id']);
                        $order->add_history($order->info['orders_status'], false, "ebay completesales failed\r\n".$errstr);
                    }
                }
            }else{
                // KEINE REFERENZ - NUR RAUSNEHMEN
                xtc_db_query("UPDATE ebay_transactions SET shipped=2 WHERE id='".$record['id']."'");
            }
        }
        if(sizeOf($cs_errors)){
            require_once(DIR_FS_INC.'yes_write_notice.inc.php');
            $recipients_array = main::get_notice_recipients('ebayapi_cart');
            yes_write_notice('eBay Completesales Fehler',implode('<br />',$cs_errors),0,$recipients_array);
        }
        $messageStack->add_session(sprintf(MSG_SUCCESS_COMPLETESALES,$counter),'success');
        xtc_redirect(xtc_href_link('shipping.php',xtc_get_all_get_params(array('action'))));
        break;
    case 'calc_weight':
        // KALKULIERT DAS GEWICHT IM VERSANDMODUL BASIEREND AUF DEN AUSGE-
        // WAEHLTEN rpID MIT DER JEWEILIGEN MENGE. WIRD GEBRAUCHT FUER
        // TEILLIEFERUNG
        $id_val = xtc_db_input($_GET['id']);
        $id_params = explode('_',$id_val);
        if(strpos($id_val, 'orders_')>-1){
            $ob = new order($id_params[1]);
            $index = 'opID';
        }else{
            $ob = new reclamation($id_params[1]);
            $index = 'rpID';
        }
        $return_weight = 0;
        $fsk18 = false;
        $sperrgut = false;
        foreach($_GET['opID'] as $iID => $qty){
            foreach($ob->products as $p){
                if($p[$index] != $iID){
                    continue;
                }
                $pw = xtc_get_ext_products_weight( $p['id'] ) * $qty;
                $return_weight += $pw;
                if($qty < 1){
                    continue;
                }
                if($ob->has_FSK18_products($iID)){
                    $fsk18 = true;
                }
                
                // SPERRGUT
                if(!defined('MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID') or MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID < 1){
                    continue;
                }
                $query = xtc_db_query(sprintf(
                        "SELECT packagings_id FROM products WHERE products_id='%d'",
                        $p['id']
                ));
                $record = xtc_db_fetch_array($query);
                if($record['packagings_id'] == MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID){
                    $sperrgut = true;
                }
            }
        }
        
        // AUSSERDEM WIRD HIER GEPRUEFT OB SICH BEI DHL SPERRGUT ODER FSK18
        // GEAENDERT HAT
        die(json_encode(array(
            'WEIGHT'=>$return_weight,
            'FSK18'=>$fsk18,
            'SPERRGUT'=>$sperrgut,
        )));
        break;
    case 'import_hermesweb_file':
            $file = xtc_try_upload('filename', \main::get_importdata_path());
            $file = $file->filename;
            $data = array();
            if(!is_file(\main::get_importdata_path().$file)){
                $messageStack->add_session('Upload Error','error');
                xtc_redirect(xtc_href_link('shipping.php'));
            }
            $content = file_get_contents(\main::get_importdata_path().$file);
            $content = explode(PHP_EOL,$content);
            $success = 0;
            $total = 0;
            $YS = new yes_shipping;
            foreach($content as $nr=>$line){
                if($nr == 0) continue;
                $data = explode(';',$line);
                if(sizeOf($data) < 3)
                    continue;
                $orders_id = 0;
                $reclamations_id = 0;
                $id = 0;
                $type = 'order';
                if(strpos($data[12], 'RE ') !== false){
                    $renr_parts = explode('RE ',$data[12]);
                    if(strpos($renr_parts[1], '/') !== false){
                        $renr_parts = explode(' / ',$renr_parts[1]);
                        $orders_id = (int)trim($renr_parts[0]);
                    }else{
                        $orders_id = (int)trim($renr_parts[1]);
                    }
                    $id = $orders_id;
                }elseif(strpos($data[12], 'REKL ') !== false){
                    $rekl_parts = explode('REKL ',$data[12]);
                    if(strpos($rekl_parts[1], '/') !== false){
                        $rekl_parts = explode(' / ',$rekl_parts[1]);
                        $reclamations_id = (int)trim($rekl_parts[0]);
                    }else{
                        $reclamations_id = (int)trim($rekl_parts[1]);
                    }
                    $id = $reclamations_id;
                    $type = 'reclamation';
                }
                $total++;
                if($orders_id == 0 and $reclamations_id == 0)
                    continue;
                $transaction_id = $data[16];
                if($YS->add_tracking_number($id, $transaction_id,$type)){
                    $success++;
                }
            }
            unlink(\main::get_importdata_path().$file);
            $messageStack->add_session(sprintf(MSG_SUCCESS_HERMESWEB_IMPORT,$success,$total),'success');
            xtc_redirect(xtc_href_link('shipping.php'));
            exit;
            break;
    case 'import_gls_file':
            $file = yes_try_upload('filename', \main::get_importdata_path());
            $file = $file->filename;
            $data = array();
            if(!is_file(\main::get_importdata_path().$file)){
                $messageStack->add_session('Upload Error','error');
                xtc_redirect(xtc_href_link('shipping.php'));
            }
            $content = file_get_contents(\main::get_importdata_path().$file);
            $content = explode(PHP_EOL,$content);
            $success = 0;
            $total = 0;
            $YS = new yes_shipping;
            $id_array_key = 0;
            $transaction_nr_array_key = 1;
            foreach($content as $line){
                if($line == 'customerId;ParcelNumber;'){
                    // header
                    continue;
                }
                if($line == 'ParcelNumber;Reference;;'){
                    $id_array_key = 1;
                    $transaction_nr_array_key = 0;
                    continue;
                }
                $data = explode(';',$line);
                if(sizeOf($data) < 3)
                    continue;
                $total++;
                $id = $data[ $id_array_key ];
                $type = (strpos($id,'R')>-1) ? 'reclamation' : 'order';
                $transaction_id = $data[$transaction_nr_array_key];
                if($YS->add_tracking_number($id, $transaction_id,$type)){
                    $success++;
                }
            }
            unlink(\main::get_importdata_path().$file);
            $messageStack->add_session(sprintf(MSG_SUCCESS_GLS_IMPORT,$success,$total),'success');
            xtc_redirect(xtc_href_link('shipping.php'));
            exit;
            break;
    case 'import_easylog_file':
            $file = xtc_try_upload('filename', \main::get_importdata_path());
            $file = $file->filename;
            $data = array();
            if(!is_file(\main::get_importdata_path().$file)){
                $messageStack->add_session('import error '.$file,'error');
                xtc_redirect(xtc_href_link('shipping.php'));
            }
            $content = file_get_contents(\main::get_importdata_path().$file);
            $content = explode(PHP_EOL,$content);
            foreach($content as $line){
                    $cols = explode(";",$line);
                    if(sizeOf($cols) > 3){
                        $data[$cols[22]] = $cols[1];
                    }
            }
            $success = 0;
            if(!sizeOf($data)){
                $messageStack->add_session('import error - no data in '.$file,'error');
                unlink(\main::get_importdata_path().$file);
                xtc_redirect(xtc_href_link('shipping.php'));
            }
            $YS = new yes_shipping;
            foreach($data as $id => $transaction_id){
                if($YS->add_tracking_number($id, $transaction_id)){
                        $success++;
                }
            }
            $messageStack->add_session(sprintf(MSG_SUCCESS_EASYLOG_IMPORT,$success,sizeOf($data)),'success');
            xtc_redirect(xtc_href_link('shipping.php'));
            exit;
            break;
    case 'import_ups_file':
            $file = xtc_try_upload('filename', \main::get_importdata_path());
            $file = $file->filename;
            $data = array();
            if(!is_file(\main::get_importdata_path().$file)){
                $messageStack->add_session('Upload Error','error');
                xtc_redirect(xtc_href_link('shipping.php'));
            }
            $content = file_get_contents(\main::get_importdata_path().$file);
            $content = explode(PHP_EOL,$content);
            $success = 0;
            $total = 0;
            $YS = new yes_shipping;
            foreach($content as $line_nr=>$line){
                if($line_nr == 0) continue;
                $data = explode(';',$line);
                if(sizeOf($data) < 3)
                    continue;
                $total++;
                $id = str_replace('"','',$data[7]);
                $transaction_id = str_replace('"','',$data[1]);
                if($YS->add_tracking_number($id, $transaction_id)){
                        $success++;
                }
            }
            unlink(\main::get_importdata_path().$file);
            $messageStack->add_session(sprintf(MSG_SUCCESS_UPS_IMPORT,$success,$total),'success');
            xtc_redirect(xtc_href_link('shipping.php'));
            exit;
            break;
    case 'import_dpd_file':
            $file = xtc_try_upload('filename', \main::get_importdata_path());
            $file = $file->filename;
            $data = array();
            if(!is_file(\main::get_importdata_path().$file)){
                $messageStack->add_session('Upload Error','error');
                xtc_redirect(xtc_href_link('shipping.php'));
            }
            $content = file_get_contents(\main::get_importdata_path().$file);
            $content = explode(PHP_EOL,$content);
            $success = 0;
            $total = 0;
            $YS = new yes_shipping;
            foreach($content as $line_nr=>$line){
                if($line_nr == 0) continue;
                $data = explode(';',$line);
                if(sizeOf($data) < 3)
                    continue;
                $total++;
                $id = str_replace('"','',$data[4]);
                if(empty($id)){
                    continue;
                }
                $transaction_id = str_replace('"','',$data[0]);
                if($YS->add_tracking_number($id, $transaction_id)){
                        $success++;
                }
            }
            unlink(\main::get_importdata_path().$file);
            $messageStack->add_session(sprintf(MSG_SUCCESS_DPD_IMPORT,$success,$total),'success');
            xtc_redirect(xtc_href_link('shipping.php'));
            exit;
            break;
    case 'json_get_send_shipping_emails_num':
	$query = xtc_db_query("SELECT COUNT(id) AS anz FROM shippings WHERE email_send_status=1");
	$record = xtc_db_fetch_array($query);
	die(json_encode(array('QTY'=>$record['anz'])));
        break;
    case 'send_shipping_emails':
        include('shipping.sendmail.php');
        exit;
	break;
    case 'klarna_fulfillment':
        $query = xtc_db_query(sprintf(
                "SELECT ko.*,s.* FROM klarna_orders ko LEFT JOIN %s o USING(orders_id) LEFT JOIN shippings s USING(orders_id) WHERE fulfillment_sent=0 and orders_status IN(%s) and s.reclamations_id=0 AND s.status=1",
                TABLE_ORDERS,implode(',',array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET))
        ));
        if(xtc_db_num_rows($query)){
            require_once(DIR_FS_CATALOG.'includes/modules/payment/klarna_yes_pay_later.php');
        }else{
            die('No Klarna orders to fulfill');
        }
        $items = [];
        while($record = xtc_db_fetch_array($query)){
            $items[] = $record;
        }
        $input_array = [];
        foreach($items as $k=>$record){
            $api_url=(main::isDev())?HTTP_CATALOG_SERVER.'klarna_api_caller.php':HTTPS_CATALOG_SERVER.'klarna_api_caller.php';
            $ch = curl_init($api_url);
            $data = [
                'klarna_merchant_id'=>MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID,
                'klarna_secret'=>MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET,
                'call'=>'order_fetch',
                'klarna_order_id'=>$record['klarna_intern_orders_id']
            ];
            $data_string = json_encode($data);                                                                                   
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                                                     
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);                                                                  
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                                                                      
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(                                                                          
                'Content-Type: application/json',                                                                                
                'Content-Length: ' . strlen($data_string))                                                                       
            );                                                                                                                   

            $result = curl_exec($ch);
            curl_close($ch);
            $klarna_order = json_decode($result,true);
            //yes_debug($klarna_order);
            $klarna_open_captures = $klarna_order['original_order_amount']-$klarna_order['captured_amount'];
            $klarna_order_items = [];
            foreach($klarna_order['order_lines'] as $ol){
                if($ol['type'] != 'physical'){
                    continue;
                }
                $klarna_order_items[] = $ol;
            }
            $YS = new yes_shipping($record['id']);
            $input_array[$k] = [
                'open_capture_value'=>number_format($klarna_open_captures/100,2,',',''),
                'open_capture_value_raw'=>number_format($klarna_open_captures/100,2,'.',''),
                'klarna_reference'=>$klarna_order['klarna_reference'],
                'klarna_order_status'=>$klarna_order['status'],
                'currency'=>$klarna_order['purchase_currency'],
                'orders_id'=>$record['orders_id'],
                'shippings_id'=>$YS->getId(),
                'products'=>$YS->getProducts(),
                'versender'=>$YS->getVersender(),
                'packages'=>$YS->getPackages(),
                'tracking_numbers'=>$YS->getTracking_id_array_full(),
                'klarna_order_items'=>$klarna_order_items,
                'captures'=>$klarna_order['captures'],
                'klarna_orders_id'=>$record['klarna_intern_orders_id'],
                'captured_amount'=>number_format($captured_amount,2,',',''),
                'KLARNA_FULFILLMENT_ORDER_IS_CAPTURED'=>sprintf(
                        KLARNA_FULFILLMENT_ORDER_IS_CAPTURED,
                        $klarna_order['klarna_reference']
                ),
            ];
        }
        $smarty->assign(array(
            'FORM'=>xtc_draw_form('klarna_fulfillment','shipping.php','action=klarna_fulfillment_process'),
            'INPUT_ITEMS'=>$input_array,
            'KLARNA_SHIPPING_METHODS'=> klarna_yes_pay_later::getKlarnaShippingMethods(),
            'KLARNA_FULFILLMENT_TITLE'=>KLARNA_FULFILLMENT_TITLE,
            'KLARNA_FULFILLMENT_SET_YES_CAPTURE'=>KLARNA_FULFILLMENT_SET_YES_CAPTURE,
            'KLARNA_FULFILLMENT_OPEN_CAPTURE_AMOUNT'=>KLARNA_FULFILLMENT_OPEN_CAPTURE_AMOUNT,
            'KLARNA_FULFILLMENT_CAPTURE_HISTORY',KLARNA_FULFILLMENT_CAPTURE_HISTORY,
        ));
        $smarty->display('klarna_fulfillment.tpl');
        exit;
        break;
    case 'klarna_set_captured':
        $koID = $_GET['klarna_order_id'];
        $update_sql_array = array(
            'fulfillment_sent'=>1
        );
        xtc_db_perform('klarna_orders',$update_sql_array,'update',"klarna_intern_orders_id='".$koID."'");
        die(json_encode(array(
            'MSG'=>''
        )));
        break;
    case 'klarna_fulfillment_process':
        $klarna_order_id = $_GET['klarna_order_id'];
        $captured = (int)str_replace('.','',$_GET['captured_value']);
        $msg = '';
        $data = [
            'klarna_merchant_id'=>MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID,
            'klarna_secret'=>MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET,
            'call'=>'capture',
            'klarna_order_id'=>$klarna_order_id,
            'captured_amount'=>$captured,
            'description'=>'Versandmeldung YES4Trade',
        ];
        $data_string = json_encode($data);                                                                                   
        try{
            $api_url=(main::isDev())?HTTP_CATALOG_SERVER.'klarna_api_caller.php':HTTPS_CATALOG_SERVER.'klarna_api_caller.php';
            $ch = curl_init($api_url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                                                     
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);                                                                  
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                                                                      
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(                                                                          
                'Content-Type: application/json',                                                                                
                'Content-Length: ' . strlen($data_string))                                                                       
            );                                                                                                                   

            $result = curl_exec($ch);
            curl_close($ch);
            $result = json_decode($result,true);
            if(isset($result['error'])){
                $msg = $result['error'];
            }

            $ch = curl_init($api_url);
            $data = [
                'klarna_merchant_id'=>MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID,
                'klarna_secret'=>MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET,
                'call'=>'order_fetch',
                'klarna_order_id'=>$klarna_order_id
            ];
            $data_string = json_encode($data);                                                                                   
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                                                     
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);                                                                  
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                                                                      
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(                                                                          
                'Content-Type: application/json',                                                                                
                'Content-Length: ' . strlen($data_string))                                                                       
            );                                                                                                                   

            $result = curl_exec($ch);
            curl_close($ch);
            $klarna_order = json_decode($result,true);
            $query = xtc_db_query(sprintf(
                    "SELECT orders_id FROM klarna_orders WHERE klarna_intern_orders_id='%s' AND merchant_id='%s'",
                    $klarna_order_id, MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID
            ));
            $record = xtc_db_fetch_array($query);
            $order = new order($record['orders_id']);
            if($klarna_order['status'] == 'CAPTURED'){
                $update_sql_array = array(
                    'fulfillmen7t_sent'=>1
                );
                xtc_db_perform('klarna_orders',$update_sql_array,'update',
                    "klarna_intern_orders_id='".$klarna_order_id."' AND merchant_id='".MODULE_PAYMENT_KLARNA_YES_PAY_LATER_MERCHANT_ID."'"
                );
                $order->add_history($order->info['orders_status'], false, 'Klarna Capture Status: '.$klarna_order['status']);
            }else{
                $order->add_history($order->info['orders_status'], false, 'Klarna Capture Status: '.$klarna_order['status']);
                $msg = 'Klarna Order #'.$klarna_order['klarna_reference'].' hat Status: '.$klarna_order['status'];
            }
        }catch(Exception $e){
            $msg = $e->getMessage();
        }
        die(json_encode(array(
            'MSG'=>$msg
        )));
    break;
    case 'scanner_mode':
        $smarty->assign('FORM',xtc_draw_form('scanner_mode','shipping.php',xtc_get_all_get_params(array('action')),'post','onsubmit="return do_scan(this);" id="scanner_mode"' ) );
        $smarty->assign(array(
            'V2'=>true,
            'HEADING_TITLE'=>SCANNER_MODE_HEADING_TITLE,
            'HEADING_TITLE_ORDERS'=>SCANNER_MODE_ORDERS_HEADING_TITLE,
            'HEADING_TITLE_SHIPPING_ITEMS'=>SCANNER_MODE_SHIPPING_ITEMS_HEADING_TITLE,
            'HEADING_TITLE_PRODUCTS_MODEL'=>SCANNER_MODE_PRODUCTS_MODEL_HEADING_TITLE,
            'SCANNER_MODE_INTRO'=>SCANNER_MODE_INTRO,
            'SCANNER_MODE_ORDERS_INTRO'=>SCANNER_MODE_ORDERS_INTRO,
            'SCANNER_MODE_SHIPPING_ITEMS_INTRO'=>SCANNER_MODE_SHIPPING_ITEMS_INTRO,
            'SCANNER_MODE_PRODUCTS_MODEL_INTRO'=>SCANNER_MODE_PRODUCTS_MODEL_INTRO,
            'SHIPPING_BARCODESCAN_DEFAULTMODE'=>SHIPPING_BARCODESCAN_DEFAULTMODE,
            'SCANNER_MODE_SHIPPING_ITEMS_OPTION'=>SCANNER_MODE_SHIPPING_ITEMS_OPTION
        ));
        $smarty->assign('INPUT_BARCODE', xtc_draw_input_field('barcode','','size="20" maxlength="32"') );
        $smarty->assign('FORM_END','</form>');
        $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
        $smarty->display(DIR_FS_ADMIN.'templates/ajax_shipping_scanner_mode.html');
        exit;
        break;
    // SETZT BEI VERSANDABSCHLUSS DATENSAETZEN DAS FLAG shipper_export_status 
    // AUF 1 MIT DEM KRITERIUM WHERE shipper_export_status=0 AND status=1
    case 'null_shipper_exports':
        xtc_db_query("UPDATE shippings SET shipper_export_status=1 WHERE shipper_export_status=0 AND status=1");
        xtc_redirect(xtc_href_link('shipping.php',xtc_get_all_get_params(array('action'))));
        break;
    // ES WIRD IN DER TABELLE shippings DAS FLAG shipper_export_status AUF 1
    // GESETZT WHERE shipper_export_status=0 AND status=1
    case 'write_shipper':
        $YSI = new YESShippingItems([
            'is_versandabschluss'=>true,
            'id_array'=>yes_shipping::get_shippings_id_list(Null,[
                'shipper_export_status'=>0,
                'status'=>1,
                'pdf_status'=>1,
                'csv_status'=>1,
                'shipper_export_status'=>0
            ])
        ]);
        $shipper_array = array();
        foreach($YSI->get_items() as $item){
            $shipper_array[ $item->shipping_configuration['versender'] ][] = $item;
        }
        foreach($shipper_array as $shipper=>$items){
            $ppdf = new yes_paketliste_pdf();
            if(isset($_REQUEST['debug']) and $_REQUEST['debug'] == 1){
                $ppdf->setDebug_html(true);
            }
            $ppdf->V2 = true;
            $filename = $ppdf->process_v2($shipper, $items);
        }
        xtc_db_query("UPDATE shippings SET shipper_export_status=1 WHERE shipper_export_status=0 AND status=1");
        $sizeof = (is_countable($shipper_array) and sizeOf($shipper_array))?sizeOf($shipper_array):0;
        $messageStack->add_session(sprintf(MSG_SUCCESS_CREATE_SHIPPER_EXPORT,$sizeof),'success');
        xtc_redirect(xtc_href_link('shipping_history.php','startD='.date('d').'&startM='.date('m').'&startY='.date('Y')));
        break;
    // DURCHLAEUFT DIE DATENSAETZE IM VERSANDABSCHLUSS, GRUPPERIERT NACH
    // VERSENDERN UND ERZEUGT CSV/XML DATEIEN BASIEREND AUF DEN EINZELNEN
    // shipping_action_{shipper}.php DATEIEN
    // AN DER TABELLE shippings WIRD NICHTS GEAENDERT
    case 'pre_shipper_export':
        $basics = new basics;
        $versender_items = array();
        $YSI = new YESShippingItems([
            'is_versandabschluss'=>true,
            'id_array'=>yes_shipping::get_shippings_id_list()
        ]);
        foreach($YSI->get_items() as $sh){
            $versender_items[$sh->shipping_configuration['versender'] ][] = $sh;
        }
        $files = array();
        foreach($versender_items as $versender => $packages){
                $save_as_name = '';
                require_once('shipping_action_'.$versender.'.php');
                if($save_as_name != ''){
                        $files[] = $save_as_name;
                }
        }
        if(sizeOf($files)){
            $zip_filename = 'VORAB_VERSENDER_EXPORT_'.date('Y_m_d_His').'.zip';
            $path = yes_get_sha1_from_string(date('Y-m-d'));
            foreach($files as $file){
                $basics->zip_file(\main::get_exportdata_path().$path,$file,$zip_filename,true);
            }
            $file_contents = $basics->read_file_content(\main::get_exportdata_path().$path.'/'.$zip_filename,$mode='rb');
            unlink(\main::get_exportdata_path().$path.'/'.$zip_filename);
            // send File to Browser
            header('Content-Type: application/octet-stream');
            header('Content-Transfer-Encoding: binary');
            header('Content-disposition: attachment; filename=' . $zip_filename);
            echo $file_contents;
            exit;
        }else{
            $messageStack->add_session('Keine Versender Exportdateien generiert','error');
            xtc_redirect(xtc_href_link('shipping.php'));
        }
        break;
    case 'pre_pdf':
        // LIEST ALLE RECHNUNGEN/REKLAMATIONEN DER VERSANDABSCHLUSS DATENSAETZE
        // EIN (csv_status=0) UND GENERIERT DIE HTML ANSICHTEN UND SPEICHERT
        // DIESE ALS PDF
        // 
        // WENN PDF_ORDER_EXPORT_AT_SHIPPING_ACTION AUF True GESETZT IST, DANN
        // WERDEN AUFTRAEGE BZW REKLAMATIONEN ALS PDF GESPEICHERT
        // 
        // WENN PDF_PACKINGSLIP_EXPORT_AT_SHIPPING_ACTION MIT True DEFINIERT 
        // WURDE, WERDEN AUCH DIE LIEFERSCHEINE MITERZEUGT
        // 
        // SPEICHERORT: exportdata/{crypt}VORVERSANDLISTE_GESAMT_{crypt}.pdf
        //
        // IN DER TABELLE shipping WERDEN HIERBEI KEINERLEI AENDERUNGEN
        // VORGENOMMEN.
        
        $crypt_dir = yes_get_sha1_from_string( date('Y-m-d') );
        $crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );

        $export_dir = \main::get_exportdata_path().$crypt_dir.'/';
        if(!is_dir($export_dir)){
                mkdir($export_dir);
        }
        
        
        if(PDF_PRODUCTS_EXPORT_AT_SHIPPING_ACTION == 'True'){
            $sql_status = 1;
            $sql_csv_status = 1;
            $sql_pdf_status = 0;
            if(is_countable($process_shipping_id_array) and sizeOf($process_shipping_id_array)){
                $id_array = $process_shipping_id_array;
            }else{
                $id_array = yes_shipping::get_shippings_id_list(Null,[
                    'status' => $sql_status,
                    'csv_status'=>$sql_csv_status,
                    'pdf_status'=>$sql_pdf_status
                ]);
            }
            $VERSANDABSCHLUSS = new YESShippingItems([
                'is_versandabschluss'=>true,
                'id_array'=>$id_array
            ]);
            $ppdf = new yes_paketliste_pdf();
            if(isset($_REQUEST['debug']) and $_REQUEST['debug'] == 1){
                $ppdf->setDebug_html(true);
            }
            $ppdf->V2 = true;
            $ppdf->setPre_write_mode(false);
            // entspricht paketliste_pdf()
            // der name ist egal, wird im aktuellen datum versandhistorie
            // gespeichert
            $paketliste_pdf_name = $ppdf->process_v2('', $VERSANDABSCHLUSS->get_items());
        }
        
        
        
        $pdf_smarty = new yesSmarty;


        $ship_pdf_name = $export_dir.'VORVERSANDLISTE_GESAMT_'.$crypt_file.'.pdf';

        // FUEGE ORDER AN GESAMTPDF AN
        if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
            $ship_pdf = new yes_pdf();
            if(DOMPDF_ORDER_LANDSCAPE == 'True'){
                $ship_pdf->set_landscape();
            }
            $yes_pdf_content = '';
        }else{
            $ship_pdf=new HTML2FPDF();
        }
        $barcodes_generated = array();
        $ship_pdf_pages = 0;
        $pages_html_array = array();
        $YSI = new YESShippingItems([
            'is_versandabschluss'=>true,
            'id_array'=>yes_shipping::get_shippings_id_list(null,[
                'csv_status'=>0
            ])
        ]);
        
        $packagelist = $YSI->get_items();
        if(!sizeOf($packagelist)){
            $messageStack->add_session(MSG_ERROR_PRE_PDF,'error');
            xtc_redirect(xtc_href_link('shipping.php',xtc_get_all_get_params(array('action'))));
        }
        foreach($packagelist as $k => $shipping_item) {
            if(get_class($shipping_item->source_obj->class_obj) == 'order'){
                $order = $shipping_item->source_obj->class_obj;
                $oID = $order->info['id'];
            }else{
                $reclamation = $shipping_item->source_obj->class_obj;
                $rID = $reclamation->info['id'];
            }
            $saved_orders_id = array();
            // email
            if($oID>0){
                $xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);

                // GENERIERE RECHNUNG-PDF
                $pdf_smarty->clear_all_assign();
                //$pdf_smarty->clear_cache();
                $pdf_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');
                if(PDF_ORDER_EXPORT_AT_SHIPPING_ACTION == 'True'){
                    // FUEGE RECHNUNG AN GESAMTPDF AN
                    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                        $yes_pdf_content .= $pdf_html;
                        $pages_html_array[] = $pdf_html;
                    }else{
                        $ship_pdf->AddPage();
                        $ship_pdf->WriteHTML($pdf_html);
                    }
                    $ship_pdf_pages++;
                }

                if(PDF_PACKINGSLIP_EXPORT_AT_SHIPPING_ACTION == 'True'){
                    // GENERIERE LIEFERSCHEIN-PDF
                    $pdf_smarty->clear_all_assign();
                    //$pdf_smarty->clear_cache();
                    // shippings_id mitgeben, da ja feststeht was geliefert
                    // werden soll
                    $pdf_packingslip_html=xtc_get_packingslip_html_for_pdf($order,
                        $pdf_smarty,
                        CURRENT_TEMPLATE . '/admin/mail/german/pdf_packingslip.html',
                        $lagerplaetze=true,
                        $comments=true,
                        $shipping_item->shipping_configuration['id']
                    );
                    // FUEGE LIEFERSCHEIN AN GESAMTPDF AN
                    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                        $yes_pdf_content .= $pdf_packingslip_html;
                        $pages_html_array[] = $pdf_packingslip_html;
                    }else{
                        $ship_pdf->AddPage();
                        $ship_pdf->WriteHTML($pdf_packingslip_html);
                    }

                    if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
                        $barcodes_generated[] = 'BARCODE_'.$order->info['id'];
                    }
                    $ship_pdf_pages++;
                }
            }else if($rID > 0) { // end if $oID
                $reclamation = new reclamation($rID);
                if(PDF_RECLAMATION_EXPORT_AT_SHIPPING_ACTION == 'True'){
                    // GENERIERE RECLA-PDF
                    $pdf_smarty->clear_all_assign();
                    //$pdf_smarty->clear_cache();
                    $pdf_rekla_html=xtc_get_reclamation_packingslip_html_for_pdf($reclamation,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_rekla.html',$lagerplaetze=true);

                    // FUEGE RECLA AN GESAMTPDF AN
                    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                        $yes_pdf_content .= $pdf_rekla_html;
                        $pages_html_array[] = $pdf_rekla_html;
                    }else{
                        $ship_pdf->AddPage();
                        $ship_pdf->WriteHTML($pdf_rekla_html);
                    }

                    if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
                        $barcodes_generated[] = 'BARCODE_R'.$rID;
                    }
                    $ship_pdf_pages++;
                }
            }
        }
        if($ship_pdf_pages > 0){
            if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                if(isset($_REQUEST['debug']) and $_REQUEST['debug'] == 1){
                    die($yes_pdf_content);
                }
                $landscape = false;
                if(DOMPDF_ORDER_LANDSCAPE == 'True'){
                    $landscape = true;
                }
                if(sizeOf($pages_html_array)){
                    $ypdf = new yes_pdf();
                    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
                        $ypdf->set_landscape();
                    }
                    $html = '<html><head><style type="text/css">'.
                        "@page pre_pdf {
                                  size: A4 portrait;
                                  margin: 0;
                                }

                                .pre_pdf_page {
                                   page: pre_pdf;
                                   page-break-after: always;
                                }".
                        '</style></head><body>';
                        foreach($pages_html_array as $nr=>$storage_page){
                            if (preg_match('/(?:<body[^>]*>)(.*)<\/body>/isU', $storage_page, $matches)) {
                                    $storage_page = $matches[1];
                            }
                            $html .= '<div class="pre_pdf_page">'.$storage_page.'</div>';
                        }
                    $html .= '</body></html>';
                    $ypdf->set_html($html);
                    $ypdf->save($ship_pdf_name);
                }
                //$ship_pdf->save_large_file($ship_pdf_name,$pages_html_array,$landscape);
                //$ship_pdf->set_html($yes_pdf_content);
                //$ship_pdf->save($ship_pdf_name);
            }else{
                $ship_pdf->Output($ship_pdf_name,$dest='F'); //Read the FPDF.org manual to know the other options
            }
        }
        if(sizeOf($barcodes_generated)){
            foreach($barcodes_generated as $bc){
                @unlink(\main::get_exportdata_path().$bc.'.jpg');
                @unlink(\main::get_exportdata_path().$bc.'.png');
            }
        }
        $messageStack->add_session(MSG_SUCCESS_PRE_PDF,'success');
        xtc_redirect(xtc_href_link('shipping.php',xtc_get_all_get_params(array('action'))));
        break;
    case 'lagerliste_raw':
    case 'lagerliste_pdf':
        $YSI = new YESShippingItems([
            'is_versandabschluss'=>true,
            'id_array'=>yes_shipping::get_shippings_id_list()
        ]);
        $html = $YSI->yes_get_shipping_lagerliste_html($action,$smarty);
        if($action == 'lagerliste_pdf'){
            if(isset($_REQUEST['check_html']) and $_REQUEST['check_html'] == 1){
                die($html);
            }
            if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                $pdf = new yes_pdf();
                $pdf->set_html($html);
                $pdf->output('PAKETLISTE_ALLE_VERSENDER.pdf');
            }else{
                $pdf=new HTML2FPDF();
                $pdf->AddPage();
                $pdf->WriteHTML($html);
                $pdf->Output('PAKETLISTE_ALLE_VERSENDER.pdf','I'); //Read the FPDF.org manual to know the other options
            }
            exit;
        }
        echo $html;
        exit;
    case 'pre_shipping_csv':
        $YSI = new YESShippingItems([
            'is_versandabschluss'=>true,
            'id_array'=>yes_shipping::get_shippings_id_list()
        ]);
        $datei = $YSI->versandabschluss_paketliste_csv(true);
        $messageStack->add_session(sprintf(MSG_SUCCESS_FILE_CREATED,'<a href="'.xtc_href_link('exportdata/'.$datei).'">'),'success');
        xtc_redirect(xtc_href_link('shipping.php',xtc_get_all_get_params(array('action','versandabschluss')).'versandabschluss=1'));
        break;
    case 'pre_shipping_pdf':
        $YSI = new YESShippingItems([
            'is_versandabschluss'=>true,
            'id_array'=>yes_shipping::get_shippings_id_list( $shipper )
        ]);
        $display_mode = 'storages';
        $products = $YSI->versandabschluss_get_different_products( $display_mode );
        // BOF - WIR ENTFERNEN no_storage UND FUEGEN ES AM ENDE AN
        $no_storage = array();
        $storages_array = array();
        foreach($products as $storage_id=>$storage){
            if($storage_id == 'no_storage'){
                $no_storage = $storage;
            }else{
                $storages_array[] = $storage;
            }
        }
        if(sizeOf($no_storage)){
            $storages_array[] = $no_storage;
        }
        // EOF - WIR ENTFERNEN no_storage UND FUEGEN ES AM ENDE AN
        
        $smarty->assign(array(
            'ITEMS'=>$storages_array,
            'display'=>$display_mode,
            'TITLE'=>TABLE_HEADING_PACKAGE_LIST,
        ));
        $html = $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/paketliste_pdf_v2.html');
        $ypdf = new yes_pdf();
        if(DOMPDF_ORDER_LANDSCAPE == 'True'){
            //$ypdf->set_landscape();
        }
        $ypdf->set_html($html);
        $ypdf->instance->render();
	$sha1_name = yes_get_sha1_from_string( date('d_m_Y-H_i_s') );
	$export_data_subdir = yes_get_sha1_from_string( date('Y-m-d') );
	$path = \main::get_exportdata_path().$export_data_subdir;
	if(!is_dir($path)){
		mkdir($path);
	}
        
        $file=$path.'/VORAB_PRODUKTLISTE_'.$sha1_name.'.pdf';
        // im versandabschluss
        //$file=$path.'/PRODUKTLISTE_'.$this->getFilter_sql_shipper().'_'.$sha1_name.'.pdf';
        $pdf_c = $ypdf->instance->output();
        file_put_contents($file, $pdf_c);
        chmod($tmp_name,0777);
        header('Content-type: application/pdf');
        header('Content-disposition: attachment; filename=' . basename($file));
        echo $pdf_c;
//        echo $buffer;
        exit;
        break;
    case 'delete_shipping':
	$id = (int)xtc_db_input($_REQUEST['id']);
        $json = isset($_GET['json']);
	$query = xtc_db_query(sprintf(
		"SELECT orders_id, reclamations_id FROM shippings WHERE id='%s' AND status=0",
		$id
	));
	if(!xtc_db_num_rows($query)){
            if($json){
                die(json_encode(array(
                    'MSG'=>'unauthorized call'
                )));
            }
            die('unauthorized call');
	}
	$record = xtc_db_fetch_array($query);
	if($record['reclamations_id']>0){
	    $reclamation = new reclamation($record['reclamations_id']);
	    $reclamation->add_history($reclamation->info['reclamations_status'], false, MSG_SHIPPING_ITEM_REMOVED);
            /* UNNUETZ
	    $update_sql_array = array(
		'shipping_comments'=>xtc_date_short(date('Y-m-d')).' '.MSG_SHIPPING_ITEM_REMOVED,
		'last_modified'=>'now()'
	    );
	    xtc_db_perform('reclamations',$update_sql_array,'update',"reclamations_id='".$record['reclamations_id']."'");
             * 
             */
	}else{
	    $order = new order($record['orders_id']);
	    $order->add_history($order->info['orders_status'], false, MSG_SHIPPING_ITEM_REMOVED);
            /* UNNUETZ
	    $update_sql_array = array(
		'shipping_comments'=> xtc_date_short(date('Y-m-d')).' '.MSG_SHIPPING_ITEM_REMOVED,
		'last_modified'=>'now()'
	    );
	    xtc_db_perform('orders',$update_sql_array,'update',"orders_id='".$record['orders_id']."'");
             * 
             */
	}
	xtc_db_query("DELETE FROM shippings WHERE id='".$id."'");
	xtc_db_query("DELETE FROM shippings_products WHERE shippings_id='".$id."'");
	xtc_db_query("DELETE FROM shippings_tracking_numbers WHERE shippings_id='".$id."'");
        if($json){
            die(json_encode(array(
                'MSG'=>''
            )));
        }
	$messageStack->add_session(MSG_SUCCESS_SHIPPING_ITEM_REMOVED,'success');
	xtc_redirect(xtc_href_link('shipping.php',xtc_get_all_get_params(array('action','id'))));
        break;
    case 'unset_rueckstand':
        // BOF - VERSANDMODUL - LISTING RUECKSTAND, MEHRERE MARKIEREN
        if(isset($_GET['id']) and is_countable($_GET['id'])){
            $affected = 0;
            foreach($_GET['id'] as $id){
                $id = (int)xtc_db_input($id);
                $order = new order($id);
                xtc_db_query("UPDATE orders SET rueckstand='0', last_modified=now() WHERE orders_id='".$id."'");
                $comments = HISTORY_ORDER_UNSET_RUECKSTAND;
                $order->add_history($order->info['orders_status'], false, $comments);
                $affected++;
            }
            $messageStack->add_session(sprintf(MSG_SUCCESS_ORDERS_UNSET_RUECKSTAND,implode(', ',$_GET['id'])),'success');
            if(isset($_GET['referrer'])){
                xtc_redirect(urldecode($_GET['referrer']));
            }
            xtc_redirect( xtc_href_link('shipping.php',xtc_get_all_get_params(array('action','referrer','id')).'action=rueckstand'));
        }
        // EOF - VERSANDMODUL - LISTING RUECKSTAND, MEHRERE MARKIEREN
            $oID = (int)xtc_db_input($_GET['oID']);
            $order = new order($oID);
            xtc_db_query("UPDATE orders SET rueckstand='0', last_modified=now() WHERE orders_id='".$oID."'");
            $messageStack->add_session(sprintf(MSG_SUCCESS_ORDER_UNSET_RUECKSTAND,$oID),'success');
            $comments = HISTORY_ORDER_UNSET_RUECKSTAND;
            $order->add_history($order->info['orders_status'], false, $comments);
            if(isset($_GET['referrer'])){
                xtc_redirect(urldecode($_GET['referrer']));
            }
            xtc_redirect( xtc_href_link('shipping.php',xtc_get_all_get_params(array('action','referrer')).'action=rueckstand'));
            break;
    case 'set_rueckstand':
            $oID = (int)xtc_db_input($_GET['oID']);
            $order = new order($oID);
            xtc_db_query("UPDATE orders SET rueckstand='1', last_modified=now() WHERE orders_id='".$oID."'");
            $messageStack->add_session(sprintf(MSG_SUCCESS_ORDER_SET_RUECKSTAND,$oID),'success');
            $comments = HISTORY_ORDER_SET_RUECKSTAND;
            $order->add_history($order->info['orders_status'], false, $comments);
            if(isset($_GET['referrer'])){
                xtc_redirect(urldecode($_GET['referrer']));
            }
            xtc_redirect( xtc_href_link('shipping.php',xtc_get_all_get_params(array('action'))));
            break;
    case 'json_add_part_delivery':
        $errors = false;
        if(!isset($_GET['shipper']) or $_GET['shipper'] == ''){
            $errors = true;
        }
        if(!isset($_GET['anzahl_pakete']) or $_GET['anzahl_pakete'] == ''){
            $errors = true;
        }
        if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
            
        }else{
            if(!isset($_GET['weight']) or $_GET['weight'] == ''){
                $errors = true;
            }
        }
        if(!isset($_GET['qty']) or !sizeOf($_GET['qty'])){
            $errors = true;
        }else{
            $total_qty = 0;
            foreach($_GET['qty'] as $id=>$qty){
                $total_qty += (int)$qty;
            }
            if($total_qty == 0){
                $error = true;
            }
        }
        if($error){
            die(json_encode(array(
                'MSG'=>'Fehlende Parameter'
            )));
        }
        $source_id_parts = explode('_',$_GET['source_id']);
        $add_params = (isset($_GET['versender_params']) and sizeOf($_GET['versender_params']))?$_GET['versender_params']:array();
        if($_GET['shipper'] == 'DHL'){
            // zb EU oder NAT-NOSERV
            $produkt = $_GET['versender_params'][$_GET['shipper']]['produkt'];
            $obj = DHL_Paket_DE_Versenden_REST_API::get_from_post($produkt);
            if(empty($obj->billingNumber)){
                $obj->billingNumber = DHL_Paket_DE_Versenden_REST_API::get_billingNumber($obj->product);
            }
            $obj->product = substr($obj->product,0,-4);
            $add_params = json_encode((array)$obj);
        }
        $data = [
            'id'=>$source_id_parts[1],
            'source'=>$source_id_parts[0],
            'versender'=>$_GET['shipper'],
            'packages'=>(isset($_GET['anzahl_pakete']))?$_GET['anzahl_pakete']:1,
            'products'=>(isset($_GET['qty']))?$_GET['qty']:0,
            'weight'=>(isset($_GET['weight']))?$_GET['weight']:0,
            'additional_params'=>$add_params
        ];
        yes_shipping::v2_add_part_delivery($data);
        die(json_encode(array(
            'MSG'=>''
        )));
        break;
    case 'json_add_delivery':
        $errors = false;
        if(!isset($_GET['shipper']) or $_GET['shipper'] == ''){
            $errors = true;
        }
        if(!isset($_GET['anzahl_pakete']) or $_GET['anzahl_pakete'] == ''){
            $errors = true;
        }
        if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
            
        }else{
            if(!isset($_GET['weight']) or $_GET['weight'] == ''){
                $errors = true;
            }
        }
        if($errors){
            die(json_encode(array(
                'MSG'=>'Fehlende Parameter'
            )));
        }
        $src_parts = explode('_',$_GET['source_id']);
        $add_params = (isset($_GET['versender_params']) and sizeOf($_GET['versender_params']))?$_GET['versender_params']:array();
        if($_GET['shipper'] == 'DHL'){
            // zb EU oder NAT-NOSERV
            $produkt = $_GET['versender_params'][$_GET['shipper']]['produkt'];
            $obj = DHL_Paket_DE_Versenden_REST_API::get_from_post($produkt);
            if(empty($obj->billingNumber)){
                $obj->billingNumber = DHL_Paket_DE_Versenden_REST_API::get_billingNumber($obj->product);
            }
            $obj->product = substr($obj->product,0,-4);
            $add_params = json_encode((array)$obj);
        }
        $data = [
            'id'=>$src_parts[1],
            'source'=>$src_parts[0],
            'versender'=>$_GET['shipper'],
            'packages'=>$_GET['anzahl_pakete'],
            'weight'=>(isset($_GET['weight']) and $_GET['weight'] > 0)?$_GET['weight']:0,
            'additional_params'=>$add_params
        ];
        $shippings_id = yes_shipping::v2_add_delivery($data);
        $msg = '';
        if($shippings_id === false){
            $msg = 'No products to ship';
        }
        die(json_encode(array(
            'MSG'=>$msg
        )));
        break;
    case 'configure_versender':
        $dversender = $_GET['shipper'];
        $srcId = current(array_reverse(explode('_',$_GET['source_id'])));
        if($_GET['source'] == 'reclamations'){
            $srcObj = new reclamation($srcId);
        }else{
            $srcObj = new order($srcId);
        }
        if(is_file('includes/modules/shipping.versender_'.$dversender.'.php')){
            include('includes/modules/shipping.versender_'.$dversender.'.php');
            $add_input = array();
            
            $default_shipping_profile = '';
            $selected_versender = '';

            if($srcObj->info['versender'] != ''){
                $default_shipping_profile = $srcObj->info['versender'];
            }
            if(sizeOf($srcObj->products) == 1 && $srcObj->delivery['country'] == 'Germany'){
                $pID = $srcObj->products[0]['id'];
                $profile = \YES4Trade\Model\shipper_profiles::get_products_id_value($pID);
                if(!empty($profile)){
                        $default_shipping_profile = $profile;
                }
            }
            if(!empty($default_shipping_profile)){
                $shipper_profile = \YES4Trade\Model\shipper_profiles::get_profile($default_shipping_profile);
                $default_shipping_params = $shipper_profile->versender_params;
                switch($dversender){
                    case 'DHL':
                        $dsp_array = (array)json_decode($default_shipping_params);
                        break;
                    default:
                        $dsp_array = explode(',',$default_shipping_params);
                        break;
                }
            }
            foreach($shipping_versender_extra_fields as $ai){
                $add_input_name_pref = sprintf('versender_params[%s]',
                        $dversender
                );
                $default_value = '';
                if(isset($ai['get_default_value_function'])){
                    switch($ai['name']){
                        case 'produkt':
                            if(isset($dsp_array)){
                                foreach($dsp_array as $_dsp){
                                    $_dsp_parts = explode(':',$_dsp);
                                    if($_dsp_parts[0] != $ai['name']){
                                        continue;
                                    }
                                    $default_value = $_dsp_parts[1];
                                }
                            }
                            if(empty($default_value)){
                                $cd = xtc_get_country_data_from_name($srcObj->delivery['country']);
                                $default_value = $ai['get_default_value_function']( $cd['countries_iso_code_2'] );
                            }
                            // EOF - Default Versender Angaben beim Artikel
                            break;
                    }
                }
                if(empty($default_value)){
                    if($srcObj->delivery['country'] == 'Germany' && sizeOf($srcObj->products) == 1){
                        if($dversender == 'DHL'){
                            $default_value = $dsp_array['product'];
                        }else{
                            foreach($dsp_array as $dsp){
                                $dsp_parts = explode(':',$dsp);
                                if($dsp_parts[0] != $ai['name']){
                                    continue;
                                }
                                $default_value = $dsp_parts[1];
                            }
                        }
                    }
                    $default_value = DHL_Paket_DE_Versenden_REST_API::get_country_based_shipper_profile($srcObj->delivery['country'], $srcObj->delivery['country_id']);
                }
                if(!empty($default_value)){
                    $profile = \YES4Trade\Model\shipper_profiles::get_profile($default_value);
		    if(isset($ai['content_load_url'])){
				$ai['content_load_url'] .= '&shipper_profile='.$default_value;
		    }
                    $default_value_params = (array)json_decode($profile->versender_params);
                    $default_value = $default_value_params['product'];
                }
                $params = '';
                if(isset($ai['content_load_url'])){
                    $params .= 'data-contentloadurl="'.$ai['content_load_url'].'" onchange="DHL_change_produkt(this)"';
                }
                $add_input[] = array(
                    'name'=>$ai['name'],
                    'input'=>xtc_draw_pull_down_menu($add_input_name_pref."[".$ai['name']."]",$ai['values'],$default_value,$params)
                );
            }
            if(sizeOf($add_input)){
                if(isset($_GET['display']) and $_GET['display'] == 'inline'){
                    printf('<b>Versandkonfiguration %s</b>',$dversender);
                    echo '<ul class="additional_params_entry" style="font-size: 1.3em;">';
                    foreach($add_input as $ai){   
                        if($ai['name']=='produkt'){
                            $ai['name'] = 'DHL Produkt';
                        }
                        printf("<li>%s: %s</li>",$ai['name'],$ai['input']);
                    }
                    echo '</ul><div class="ui-helper-clearfix"></div>';
                }else{
                    echo '<p style="padding: 3px;border: 1px solid #555; background-color: #FFAAFF;">';
                    foreach($add_input as $ai){   
                        printf("%s<br />%s<br />",$ai['name'],$ai['input']);
                    }
                    echo '</p>';
                }
            }
        }
        exit;
        break;

    case  'send_shipping_secupay_process':
        require_once(DIR_FS_CATALOG.DIRECTORY_SEPARATOR.'includes'.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'payment'.DIRECTORY_SEPARATOR.'secupay_inv_xtc.php');
        $one_click = (isset($_GET['one_click']) and $_GET['one_click'] == 1) ? true : false;
	$errors = array();
	foreach($_REQUEST['orders_id'] as $oID){
		$oID = (int)xtc_db_input($oID);
		$order = new order($oID);
		if(!$order){
			$errors[] = sprintf(TEXT_ERROR_SHIPPING_SECUPAY_INVALID_ORDER,$oID);
			continue;
		}
	        $sp = new secupay_inv_xtc($oID);
		if(!$sp->enabled){
			$errors[] = sprintf(TEXT_ERROR_SHIPPING_SECUPAY_INVALID_TRANSACTION,$oID);
			continue;
		}
		$sp_class = $order->info['payment_method'];
		if(!strstr($sp_class,'secupay')){
			$errors[] = sprintf(TEXT_ERROR_SHIPPING_SECUPAY_INVALID_PAYMENT,$oID,$sp_class);
			continue;
		}
		$is_first = true;
		if($order->has_part_delivery()){
			$query = xtc_db_query(sprintf(
				"SELECT id FROM shippings WHERE orders_id='%s' AND secupay_send_status=1",
				$oID
			));
			if(xtc_db_num_rows($query)){
				$is_first = false;
			}
		}
		$query = xtc_db_query(sprintf(
			"SELECT id,versender FROM shippings WHERE orders_id='%s' AND secupay_send_status=0 ORDER BY date_added LIMIT 1",
			$oID
		));
		$record = xtc_db_fetch_array($query);
		$shipper = $record['versender'];
		$shippings_id = $record['id'];
		$sp_trans = $sp->get_db_values();
		$trackingnumbers = (isset($_REQUEST['tracking_number'][$oID]) and $_REQUEST['tracking_number'][$oID] != '') ? explode(',',$_REQUEST['tracking_number'][$oID]) : array();
		$notification = array(
			'hash'=>$sp_trans['hash'],
			'transaction_id'=>$sp_trans['transaction_id'],
			'iframe_url_id'=>$sp_trans['iframe_url_id'],
			'is_first'=>$is_first,
			'payment'=>$sp_class,
			'tracking_numbers'=>$trackingnumbers
		);
		$call_method = 'adddata';
		switch($notification['payment']){
			case 'secupay_inv_xtc':
				if($notification['is_first']){
					$call_method = 'capture';
				}
				break;
		}
		if(sizeOf($notification['tracking_numbers'])){
			foreach($notification['tracking_numbers'] as $trn){
				switch($call_method){
					case 'capture':
						$resp_error = $sp->set_inv_first_capture($notification['hash'],$oID, $shipper, $trn);
						// nur die erste trackingnummer darf via capture gesendet werden
						$call_method = 'adddata';
						break;
					default:
						$resp_error = $sp->set_shipped($notification['hash'],$oID, $shipper, $trn);
						break;
				}
			}
		}else{
			switch($call_method){
				case 'capture':
					$resp_error = $sp->set_inv_first_capture($notification['hash'],$oID, $shipper);
					break;
				default:
					$resp_error = $sp->set_shipped($notification['hash'],$oID, $shipper);
					break;
			}
		}
                $update_sql_array = array(
                    'secupay_send_status'=>1
                );
                xtc_db_perform('shippings',$update_sql_array,'update',"id='".$shippings_id."'");
                if(!$one_click){
                    /*
                    printf('<li>send %s order #%s (hash %s) via %s</li>',
                            $notification['payment'],$oID,$notification['hash'],$call_method
                    );*/
                    if($resp_error != ''){
                            $messageStack->add_session($resp_error,'error');
                            $update_sql_array = array(
                                    'capture_status'=>2
                            );
                            xtc_db_perform('secupay_transaction_order',$update_sql_array,'update',"hash='".$notification['hash']."' and ordernr='".$oID."' and capture_status=0");
                            $order->add_history($order->info['orders_status'], false, 'Secupay Shipping Notification fehlgeschlagen. '.$resp_error);
                    }else{
                            $update_sql_array = array(
                                    'capture_status'=>1
                            );
                            xtc_db_perform('secupay_transaction_order',$update_sql_array,'update',"hash='".$notification['hash']."' and ordernr='".$oID."' and capture_status=0");
                            $order->add_history($order->info['orders_status'], false, 'Secupay Shipping Notification');
                    }
                }else{
                    if($resp_error != ''){
                            $update_sql_array = array(
                                    'capture_status'=>2
                            );
                            xtc_db_perform('secupay_transaction_order',$update_sql_array,'update',"hash='".$notification['hash']."' and ordernr='".$oID."' and capture_status=0");
                            $order->add_history($order->info['orders_status'], false, 'Secupay Shipping Notification fehlgeschlagen. '.$resp_error);
                            $errors[] = $resp_error;
                    }else{
                            $update_sql_array = array(
                                    'capture_status'=>1
                            );
                            xtc_db_perform('secupay_transaction_order',$update_sql_array,'update',"hash='".$notification['hash']."' and ordernr='".$oID."' and capture_status=0");
                            $order->add_history($order->info['orders_status'], false, 'Secupay Shipping Notification');
                    }
                }

	}
        if($one_click){
            die(json_encode(array(
                'messages'=>$errors,
                'error'=>(sizeOf($errors)) ? 1 : 0
            )));
        }else{
            //$messageStack->add_session('Secupay Tracking: OK','success');
            xtc_redirect(xtc_href_link('shipping.php'));
        }
        break;
    case 'send_shipping_secupay':
        require_once(DIR_FS_CATALOG.DIRECTORY_SEPARATOR.'includes'.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'payment'.DIRECTORY_SEPARATOR.'secupay_inv_xtc.php');
        $records = array();
	    $errors = array();
        $query = xtc_db_query(sprintf(
                "SELECT s.id as shippings_id, s.orders_id, sto.* FROM shippings s LEFT JOIN %s o USING ( orders_id ) LEFT JOIN secupay_transaction_order sto ON sto.ordernr=o.orders_id WHERE secupay_send_status=0 AND payment_class = 'secupay_inv_xtc' AND sto.hash IS NOT NULL",
                TABLE_ORDERS
        ));
        while($record = xtc_db_fetch_array($query)){
            $record['created_formatted'] = xtc_date_short($record['created']);
            $record['input'] = xtc_draw_checkbox_field('orders_id[]',$record['ordernr'],true);
            $records[] = $record;
        }
        foreach($records as $k=>$record){
            $shipping_query = xtc_db_query(sprintf(
                    "SELECT id FROM shippings WHERE orders_id='%s' ORDER BY date_finished DESC LIMIT 1",
                    $record['ordernr']
            ));
            $shipping = xtc_db_fetch_array($shipping_query);
            $yst = new yes_shipping($shipping['id']);
            $records[ $k ]['shipper'] = $yst->getVersender();
            $records[ $k ]['number'] = implode(',',$yst->getTracking_id_array());
            $order = new order($record['ordernr']);
	    $sp = new secupay_inv_xtc();
	    $res_status = $sp->get_status($record['hash']);
	    if(is_object($res_status) and $res_status->status === 'ok'){
			// OK
	    }else{
		$errors[] = sprintf('Auftrag %s: %s',$record['ordernr'],$res_status);
	    }
        }
        $smarty->assign(array(
            'FORM'=> xtc_draw_form('secupay_capt', 'shipping.php', 'action=send_shipping_secupay_process', 'POST'),
            'FORM_END'=>'</form>',
            'TEXT_SHIPPING_SPINV_SEND_CAPTURE_INTRO'=>TEXT_SHIPPING_SPINV_SEND_CAPTURE_INTRO,
            'ITEMS'=>$records,
            'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
	    'ERRORS'=>implode('<br />',$errors)
        ));
        $smarty->display('shipping.send_shipping_secupay.html');
        exit;
        break;
}

$abonded_block_shippings = array();
$query = xtc_db_query(sprintf(
	"SELECT orders_id FROM %s WHERE block_shipping = 1 AND block_shipping_end_date > 0 AND block_shipping_end_date < '%s'",
	TABLE_ORDERS,date('Y-m-d')
));
while($record = xtc_db_fetch_array($query)){
    $abonded_block_shippings[] = $record['orders_id'];
}
foreach($abonded_block_shippings as $abs){
    xtc_db_query(sprintf(
	    "UPDATE %s SET block_shipping=0, block_shipping_end_date='' WHERE orders_id='%s'",
	    TABLE_ORDERS,$abs
    ));
    $order = new order($abs);
    $order->add_history($order->info['orders_status'], false, TEXT_BLOCK_SHIPPING_ABONDED);
}
// AUCH FUER REKLAS - 2021/01/19
$abonded_block_shippings = array();
$query = xtc_db_query(sprintf(
	"SELECT reclamations_id FROM reclamations WHERE block_shipping = 1 AND block_shipping_end_date > 0 AND block_shipping_end_date < '%s'",
	date('Y-m-d')
));
while($record = xtc_db_fetch_array($query)){
    $abonded_block_shippings[] = $record['reclamations_id'];
}
foreach($abonded_block_shippings as $abs){
    xtc_db_query(sprintf(
	    "UPDATE reclamations SET block_shipping=0, block_shipping_end_date='' WHERE reclamations_id='%d'",
	    $abs
    ));
    $reclamation = new reclamation($abs);
    $reclamation->add_history($reclamation->info['reclamations_status'], false, TEXT_BLOCK_SHIPPING_ABONDED);
}

/**
 * BOF - DHL VERSANDMELDUNGEN
 */
if(defined('DHL_VERSENDEN_APPLICATION_ID') and DHL_VERSENDEN_APPLICATION_ID != ''){
    $max_date = date('Y-m-d',time()-(60*60*24*14));
    $dhl_trackings_missing = yes_shipping::get_dhl_items_with_missing_tracking_ids();
    if(sizeOf($dhl_trackings_missing)){
        $lnk = sprintf('&nbsp;<a href="%s">%s</a>',
                xtc_href_link('dhl_print_label.php','action=list'),
                BUTTON_DHL_GENERATE_TRACKINGNUMBERS
        );
        $messageStack->add(sprintf(MSG_DHL_GENERATE_TRACKINGNUMBERS,sizeOf($dhl_trackings_missing)).$lnk,'warning');
    }
}

if(defined('MODULE_SHIPPING_WEMALO_STATUS') and MODULE_SHIPPING_WEMALO_KEY != ''){
    $wemalo_items = yes_shipping::get_wemalo_items_not_submitted();
    if(sizeOf($wemalo_items)){
        $lnk = sprintf('&nbsp;<a href="%s">%s</a>',
                xtc_href_link('shipping.php','action=wemalo_submit_list'),
                BUTTON_WEMALO_NOT_SUBMITTED_LIST
        );
        $messageStack->add(sprintf(MSG_WEMALO_SUBMIT_LIST,sizeOf($wemalo_items)).$lnk,'warning');
    }
}



$shipper = (isset($_GET['shipper']) and $_GET['shipper'] != '') ? $_GET['shipper'] : '';
yes_draw_pre_header();
yes_draw_header(TITLE);
// BOF - brauchen wir in main::get_shipping_method_name_from_shipping_class
if(defined('EBAY_USER') and EBAY_USER != ''){
        $key = 'ebay_shippingmethods';
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $EBAYAPI = new ebayAPI();
            $ARRAY_ebay_shippingmethods = $EBAYAPI->get_ebay_details('ShippingServiceDetails');
            $CachedString->set($ARRAY_ebay_shippingmethods)->expiresAfter(0);//ebay_shippingmethods
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        } else {
            $ARRAY_ebay_shippingmethods = $CachedString->get();// Will print 'First product'
        }
}else{
    $ARRAY_ebay_shippingmethods = array();
}
// EOF main::get_shipping_method_name_from_shipping_class

$page = (isset($_GET['page'])) ? (int)xtc_db_input($_GET['page']) : 0;
$buttons = array();
$is_versandabschluss = (isset($_GET['versandabschluss']) and $_GET['versandabschluss'] == 1);
if(isset($_POST['scanner_mode']) and $_POST['scanner_mode'] == 'items'){
    $is_versandabschluss = true;
}
if($is_versandabschluss){
    $buttons[] = array(
        'text'=>BUTTON_SCANNER_MODE,
        'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=scanner_mode'),
        'lbOn'=>true,
        'auth'=>true,
    );
    $barcode_scan_string = (isset($_POST['barcode']) and $_POST['barcode'] != '') ? $_POST['barcode'] : '';
    $id_array = yes_shipping::v2_get_in_shipping_items($page,$shipper, $barcode_scan_string);
    $YSI = new YESShippingItems([
        'id_array'=>$id_array,
        'is_versandabschluss'=>$is_versandabschluss,
    ]);
    $shipper_values = array(array(
        'id'=>'',
        'text'=>TEXT_ALL_SHIPPER
    ));
    $diff_shipper = yes_shipping::v2_get_in_shipping_different_shipper();
    foreach($diff_shipper as $s){
        $shipper_values[] = array(
            'id'=>$s,
            'text'=>$s
        );
    }
    $total = yes_shipping::v2_count_in_shipping_items();
    $smarty->assign(array(
        'SHIPPER'=>$shipper,
        'NUM_ORDERS'=>$total,
        'INPUT_FILTER_SHIPPER'=> xtc_draw_pull_down_menu('shipper', $shipper_values, $shipper, 'id="filter_shipper"'),
        'TEXT_PROCESS_SHIPPING_PRE_TITLE'=>sprintf(TEXT_PROCESS_SHIPPING_PRE_TITLE,xtc_date_short(date('Y-m-d')))
    ));
    $buttons[] = array('text'=>TEXT_PRE_SHIPPING_PDF_PRODUCTS,
        'link' => xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=pre_shipping_pdf'),
        'lbOn'=>false,
        'auth'=>true,
    );
    
    // RAUS
    // RAUS $buttons[] = array('text'=>TEXT_PRINT,
    // RAUS    'link' => 'javascript:print_pre_shippings()',
    // RAUS    'lbOn'=>false,
    // RAUS    'auth'=>true,
    // RAUS );
    
    $buttons[] = array('text'=>TEXT_PRE_SHIPPING_CSV_PRODUCTS,
        'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=pre_shipping_csv'),
        'lbOn'=>false,
        'auth'=>true
    );
    $buttons[] = array('text'=>sprintf(TEXT_LINK_VIEW_SENDER_PACKINGSLIPS,$shipper),
        'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=lagerliste_raw'),
        'lbOn'=>false,
        'auth'=>true
    );
    $buttons[] = array('text'=>TEXT_LINK_GENERATE_PDF,
        'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=pre_pdf'),
        'lbOn'=>false,
        'auth'=>true
    );
    
    if(in_array('EASYLOG',$VERSENDER) or in_array('EASYLOG2',$VERSENDER)){
        $buttons[] = array('text'=>BUTTON_IMPORT_EASYLOG,
            'link'=>'javascript:;',
            'id' => 'import_easylog_file',
            'lbOn'=>false,
            'auth'=>true
        );
    }
    if(in_array('GLS',$VERSENDER)){
        $buttons[] = array('text'=>BUTTON_IMPORT_GLS,
            'link'=>'javascript:;',
            'id' => 'import_gls_file',
            'lbOn'=>false,
            'auth'=>true
        );
    }
    if(in_array('UPS',$VERSENDER)){
        array('text'=>BUTTON_IMPORT_UPS,
            'link'=>'javascript:;',
            'id' => 'import_ups_file',
            'lbOn'=>false,
            'auth'=>true
        );
    }
    if(in_array('DPD',$VERSENDER)){
        $buttons[] = array('text'=>BUTTON_IMPORT_DPD,
            'link'=>'javascript:;',
            'id' => 'import_dpd_file',
            'lbOn'=>false,
            'auth'=>true
        );
    }
    if(in_array('Hermesweb',$VERSENDER)){
        $buttons[] = array('text'=>BUTTON_IMPORT_HERMESWEB,
            'link'=>'javascript:;',
            'id' => 'import_hermesweb_file',
            'lbOn'=>false,
            'auth'=>true
        );
    }

    if(in_array('DHL',$VERSENDER) and defined('DHL_VERSENDEN_APPLICATION_ID') and DHL_VERSENDEN_APPLICATION_ID != ''){
        $buttons[] = array('text'=>'DHL Tagesabschluss',
            'link'=>'dhl_print_label.php?action=getManifest_select',
            'lbOn'=>true,
            'auth'=>true
        );
    }
    
    
    if( defined('SHIPPING_EXPORT_SHIPPER_PDF') and SHIPPING_EXPORT_SHIPPER_PDF == 'True'){
        $ppdf = new yes_paketliste_pdf;
        $shipper_items = $ppdf->get_open_shipper_exports_num();
        if($shipper_items > 0){
            $buttons[] = array('text'=>str_replace('?','',sprintf(TEXT_NULL_SHIPPER_EXPORT,$shipper_items)),
                'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=null_shipper_exports'),
                'lbOn'=>false,
                'auth'=>true,
                'add_css_class'=>'ui-state-error',
                'js_confirmation'=>true,
                'js_confirmation_text'=>sprintf(TEXT_NULL_SHIPPER_EXPORT,$shipper_items)
            );
            if($shipper_items > 1000){
                $buttons[] = array('text'=>TEXT_CREATE_SHIPPER_EXPORT,
                    'error'=>JS_ALERT_TOO_MUCH_SHIPPER_EXPORT_ITEMS,
                    'lbOn'=>false,
                    'auth'=>true,
                );
            }else{
                $buttons[] = array('text'=>TEXT_CREATE_SHIPPER_EXPORT,
                    'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=write_shipper'),
                    'lbOn'=>false,
                    'auth'=>true
                );
            }
        }
    }
    $buttons[] = array('text'=>TEXT_LINK_PRE_SHIPPER_EXPORT,
        'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=pre_shipper_export'),
        'lbOn'=>false,
        'auth'=>true
    );
    
    
    
    $buttons[] = array('text'=>TABLE_HEADING_SHIPPING_PROCESS,
        'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=ajax_write'),
        'lbOn'=>true,
        'auth'=>true,
        'add_css_class'=>'ui-state-highlight'
    );

    $smarty->assign(array(
        'INPUT_ITEMS_ACTION'=>xtc_draw_pull_down_menu('items_action',array(
            array('id'=>'','text'=>TEXT_SELECT),
            array('id'=>'remove_from_shipping','text'=>BUTTON_REMOVE_FROM_SHIPPING),
        ))
    ));
}else{
    $buttons[] = array(
        'text'=>BUTTON_SCANNER_MODE,
        'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=scanner_mode'),
        'lbOn'=>true,
        'auth'=>true,
    );
    $source = (isset($_GET['source'])) ? xtc_db_input($_GET['source']) :'orders';
    
    $total = yes_shipping::count_shippable_items($source,true);
    $id_array = yes_shipping::get_shippable_items($source,$page);
    
    $sources_array = array();
    $sources = array('orders','reclamations','block_orders','block_reclamations','rueckstand','otc');
    foreach($sources as $s){
        $add_css = (isset($_GET['source']) and $_GET['source'] == $s)?'ui-state-highlight':'';
        if(empty($add_css) and !isset($_GET['source']) and $s == 'orders'){
            $add_css = 'ui-state-highlight';
        }
        $buttons[] = array(
            'text'=>sprintf('%d %s',
                yes_shipping::count_shippable_items($s),
                get_source_title_string($s)
            ),
            'link'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('source','page')).'source='.$s),
            'lbOn'=>false,
            'auth'=>true,
            'add_css_class'=>$add_css
        );
    }
    $YSI = new YESShippingItems([
        'source'=>$source,
        'id_array'=>$id_array,
        'is_versandabschluss'=>$is_versandabschluss,
    ]);
    $items_action = [
        ['id'=>'','text'=>TEXT_SELECT],
    ];
    if(isset($_GET['source']) and $_GET['source'] == 'rueckstand'){
        $items_action[] = ['id'=>'unset_rueckstand','text'=>TEXT_LINK_UNSET_ORDER_ARREAR];
    }else if(isset($_GET['source']) and $_GET['source'] == 'block_orders'){
        $items_action[] = ['id'=>'unblock_orders','text'=>TEXT_VERSANDSPERRE_UNSET];
    }else{
        foreach($VERSENDER as $vs){
            $items_action[] = ['id'=>'select:'.urldecode($vs),'text'=>sprintf(TEXT_SET_VERSENDER_IN_DROPDOWN, $vs)];
        }
    }
    //$items_action[] = ['id'=>'save_as_shipping','text'=>BUTTON_SAVE_AS_SHIPPING];
    $smarty->assign(array(
        'BUTTON_SAVE_AS_SHIPPING'=>BUTTON_SAVE_AS_SHIPPING,
        'NUM_ORDERS'=>yes_shipping::count_shippable_items($source),
        'INPUT_ITEMS_ACTION'=>xtc_draw_pull_down_menu('items_action',$items_action),
    ));
}
$smarty->assign(array(
    'PAGER'=>$YSI->get_pager_html($total, $page),
    'HEADING_TITLE'=>$YSI->get_heading_title(yes_shipping::v2_get_in_shipping_items(-1)),
));
$items = $YSI->get_items();

if(!$YSI->getIs_versandabschluss() and strpos($source,'reclamation') === false){
    $filter_array = array(
        array('text'=>PRE_SHIPPING_FILTER_STORAGE,
            'id' => 'storage_filter_button',
            'selected'=>(isset($_GET['storage_filter']) and $_GET['storage_filter'] != '') ? 1 : 0
        ),
        array('text'=>PRE_SHIPPING_FILTER_ORDER_SOURCE,
            'id' => 'order_source_filter_button',
            'selected'=>(isset($_GET['order_source_filter']) and $_GET['order_source_filter'] != '') ? 1 : 0
        ),
        array('text'=>PRE_SHIPPING_FILTER_PAYMENT_METHOD,
            'id' => 'payment_method_filter_button',
            'selected'=>(isset($_GET['payment_method_filter']) and $_GET['payment_method_filter'] != '') ? 1 : 0
        ),
        array('text'=>PRE_SHIPPING_FILTER_SHIPPING_CLASS,
            'id' => 'shipping_class_filter_button',
            'selected'=>(isset($_GET['shipping_class_filter']) and $_GET['shipping_class_filter'] != '') ? 1 : 0
        ),
        array('text'=>PRE_SHIPPING_FILTER_CUSTOMERS_STATUS,
            'id' => 'customers_status_filter_button',
            'selected'=>(isset($_GET['customers_status']) and sizeOf($_GET['customers_status'])) ? 1 : 0
        ),
        array('text'=>PRE_SHIPPING_FILTER_VERSENDER,
            'id' => 'default_products_shipper_filter_button',
            'selected'=>(isset($_GET['default_products_shipper']) and $_GET['default_products_shipper'] != '') ? 1 : 0
        ),
        array('text'=>TEXT_FILTER_ORDERS_NOT_DE,
            'id' => 'orders_not_de',
            'selected'=>(isset($_GET['orders_not_de']) and $_GET['orders_not_de'] != '') ? 1 : 0
        ),
        array('text'=>TEXT_PART_DELIVERY,
            'id' => 'part_delivery_filter_button',
            'selected'=>(isset($_GET['has_part_delivery']) and $_GET['has_part_delivery'] != '') ? 1 : 0
        ),
    );
    if(defined('MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID') and MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID > 0 ){
        $filter_array[] = array('text'=>TEXT_SPERRGUT,
            'id' => 'sperrgut',
            'selected'=>(isset($_GET['sperrgut']) and $_GET['sperrgut'] != '') ? 1 : 0
        );
    }
}else{
    $filter_array = array(
/*        array('text'=>TABLE_HEADING_PACKAGE_LIST,
            'id' => 'package_list',
            'selected'=>0
        )*/
    );
}
$different_payments = shippings_v2_sql::get_different_payment_methods();
$different_shippings = shippings_v2_sql::get_different_shipping_classes();
$different_customer_statuses = shippings_v2_sql::get_different_customers_statuses();
$versender_values = array(array('id'=>'','text'=>TEXT_SELECT));
foreach($VERSENDER as $vers){
    $versender_values[] = array('id'=>$vers,'text'=>$vers);
}
$tracking_csv_containers = [
    [
        'title'=>TEXT_EASYLOG_FILE,
        'id'=>'easylog',
        'form_action'=>xtc_href_link('shipping.php','action=import_easylog_file'),
    ],[
        'title'=>TEXT_GLS_FILE,
        'id'=>'gls',
        'form_action'=>xtc_href_link('shipping.php','action=import_gls_file'),
    ],[
        'title'=>TEXT_UPS_FILE,
        'id'=>'ups',
        'form_action'=>xtc_href_link('shipping.php','action=import_ups_file'),
    ],[
        'title'=>TEXT_DPD_FILE,
        'id'=>'dpd',
        'form_action'=>xtc_href_link('shipping.php','action=import_dpd_file'),
    ],[
        'title'=>TEXT_HERMESWEB_FILE,
        'id'=>'hermesweb',
        'form_action'=>xtc_href_link('shipping.php','action=import_hermesweb_file'),
    ]
];
$insel_plz_array = [];
$pc = explode(',',constant('SHIPPING_POSTCODES_GERMANY_SPECIAL'));
foreach($pc as $plz){
    $insel_plz_array[$plz] = true;
}
$smarty->assign(array(
    'TRACKING_CSV_COUNTAINERS'=>$tracking_csv_containers,
    'IMAGE_UPLOAD'=>IMAGE_UPLOAD,
    'VERSENDER_ARRAY'=>array_reverse($VERSENDER),
    'ITEMS'=>$items,
    'INSEL_PLZ_ARRAY'=>$insel_plz_array,
    'BASEURL'=>xtc_href_link('shipping.php',xtc_get_all_get_params(array('action'))),
    'SOURCE'=>$YSI->getSource(),
    'FILTER_ARRAY'=>$filter_array,
    'WEIGHT_VALUES'=>$WEIGHT_VALUES,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'STORAGES'=> xtc_get_storages(),
    'PAYMENT_METHODS_FILTER'=>(isset($_GET['payment_method_filter']) and $_GET['payment_method_filter'] != '') ? $_GET['payment_method_filter']:'',
    'PAYMENT_METHODS'=>$different_payments,
    'TEXT_PAYMENT_METHOD'=>TEXT_PAYMENT_METHOD,
    'STORAGE_FILTER'=>(isset($_GET['storage_filter']) and $_GET['storage_filter'] != '') ? $_GET['storage_filter']:'',
    'ORDER_SOURCE_TITLE'=>PRE_SHIPPING_FILTER_ORDER_SOURCE,
    'ORDER_SOURCES'=>main::get_order_sources(),
    'ORDER_SOURCE_FILTER'=>(isset($_GET['order_source_filter']) and $_GET['order_source_filter'] != '') ? $_GET['order_source_filter']:'',
    'SHIPPING_CLASSES'=>$different_shippings,
    'SHIPPING_CLASS_FILTER'=>(isset($_GET['shipping_class_filter']) and $_GET['shipping_class_filter'] != '') ? $_GET['shipping_class_filter']:'',
    'CUSTOMER_STATUS_FILTER'=>(isset($_GET['customers_status']) and sizeOf($_GET['customers_status'])) ? $_GET['customers_status']:array(),
    'CUSTOMER_STATUSES'=>$different_customer_statuses,
    'VERSENDER_VALUES'=>$versender_values,
    'VERSENDER_FILTER'=>(isset($_GET['default_products_shipper']) and $_GET['default_products_shipper'] != '') ? $_GET['default_products_shipper']:'',
    'TEXT_COMMENT'=>TEXT_COMMENT,
    'TEXT_LINK_SET_ORDER_ARREAR'=>str_replace('"',"'",TEXT_LINK_SET_ORDER_ARREAR),
    'TEXT_LINK_UNSET_ORDER_ARREAR'=>str_replace('"',"'",TEXT_LINK_UNSET_ORDER_ARREAR),
    'TEXT_VERSANDSPERRE_UNSET'=>TEXT_VERSANDSPERRE_UNSET,
    'TEXT_VERSANDSPERRE_SET'=>TEXT_VERSANDSPERRE_SET,
    'IS_VERSANDABSCHLUSS'=>$YSI->getIs_versandabschluss(),
    'TEXT_REMOVE_SHIPPING_TITLE'=>TEXT_REMOVE_SHIPPING_TITLE,
    'TEXT_CONFIGURE_PART_DELIVERY'=>TEXT_CONFIGURE_PART_DELIVERY,
    'TEXT_SAVE_PART_DELIVERY'=>TEXT_SAVE_PART_DELIVERY,
    'JS_CONFIRM_SAVE_AS_SHIPPING'=>JS_CONFIRM_SAVE_AS_SHIPPING,
    'BUTTON_SAVE_AS_SHIPPING'=>BUTTON_SAVE_AS_SHIPPING,
    'JS_CONFIRM_DELETE_PACKAGES'=>JS_CONFIRM_DELETE_PACKAGES,
    'WEIGHT_FROM_ORDER'=>(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'),
    'PRINT'=>false,
    'CUSTOMER_DOUBLES_IN_SHIPPING_LIST_ITEM_TEXT'=>CUSTOMER_DOUBLES_IN_SHIPPING_LIST_ITEM_TEXT,
    'CUSTOMER_DOUBLES_IN_SHIPPING_LIST_HEADER'=>CUSTOMER_DOUBLES_IN_SHIPPING_LIST_HEADER,
    'JS_CONFIRM_REALLY_UNSET_ARREAR'=>JS_CONFIRM_REALLY_UNSET_ARREAR,
    'TEXT_VERSANDSPERRE_UNSET'=>TEXT_VERSANDSPERRE_UNSET,
));
$smarty->display('shipping_items.html');
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php');	
