<?php
/*
 * mario aspeleiter <dazze@gmx.de>
 * 15.03.2005
*/

// ALTER TABLE `admin_access` ADD `shipping_history` INT( 1 ) NOT NULL ;
// UPDATE `admin_access` SET `shipping_history` = '1' WHERE `customers_id` = '1' LIMIT 1 ;
require('includes/application_top.php');
require_once('includes/classes/class.csv.php');
require_once('includes/classes/yes_shipping.php');
require_once('includes/classes/class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');

if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'download'){
    $file = str_replace(array('..','\\'),'',$_REQUEST['file']);
    $check_basepath = \main::get_exportdata_path();
    if(substr($file,0,strlen($check_basepath)) != $check_basepath){
	die('Forbidden call.');
    }
    if(!is_file(DIR_FS_ADMIN.$file)){
	die('Unknown File.');
    }
    if(!in_array( substr( strtolower($file), strlen($file)-3,strlen($file) ), array('csv','pdf','txt','html') ) ) {
	die('File type not allowed');
    }
    $BASICS = new basics;
    $BASICS->download_file($file);
    exit;
}

function validateDate($value, $format = 'dd.mm.yyyy'){ 
    if(strlen($value) >= 6 && strlen($format) == 10){ 
        
        // find separator. Remove all other characters from $format 
        $separator_only = str_replace(array('m','d','y'),'', $format); 
        $separator = $separator_only[0]; // separator is first character 
        
        if($separator && strlen($separator_only) == 2){ 
            // make regex 
            $regexp = str_replace('mm', '(0?[1-9]|1[0-2])', $format); 
            $regexp = str_replace('dd', '(0?[1-9]|[1-2][0-9]|3[0-1])', $regexp); 
            $regexp = str_replace('yyyy', '(19|20)?[0-9][0-9]', $regexp); 
            $regexp = str_replace($separator, "\\" . $separator, $regexp); 
            if($regexp != $value && preg_match('/'.$regexp.'\z/', $value)){ 

                // check date 
                $arr=explode($separator,$value); 
                $day=$arr[0]; 
                $month=$arr[1]; 
                $year=$arr[2]; 
                if(@checkdate($month, $day, $year)) 
                    return true; 
            } 
        } 
    } 
    return false; 
}


$history_date = $_REQUEST['shipping_history_date'] ?? date('Y-m-d');
if(isset($_REQUEST['shipping_history_date']) and DateTime::createFromFormat('Y-m-d', $history_date) === false){
    $messageStack->add_session(sprintf(MSG_ERROR_DATE_FORMAT_INVALID,$history_date),'error');
    xtc_redirect(xtc_href_link(basename(__FILE__)));
}

/**
 * BOF - DHL VERSANDMELDUNGEN
 */
if(defined('DHL_VERSENDEN_APPLICATION_ID') and DHL_VERSENDEN_APPLICATION_ID != ''){
    $max_date = date('Y-m-d',time()-(60*60*24*14));
    $dhl_trackings_missing = yes_shipping::get_dhl_items_with_missing_tracking_ids();
    if(sizeOf($dhl_trackings_missing)){
        $lnk = sprintf('&nbsp;<a href="%s">%s</a>',
                xtc_href_link('dhl_print_label.php','action=list'),
                BUTTON_DHL_GENERATE_TRACKINGNUMBERS
        );
        $messageStack->add(sprintf(MSG_DHL_GENERATE_TRACKINGNUMBERS,sizeOf($dhl_trackings_missing)).$lnk,'warning');
    }
}
/**
 * EOF - DHL VERSANDMELDUNGEN
 */

yes_draw_pre_header();
yes_draw_header(TITLE);

$smarty = new yesSmarty;
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'HEADING_TITLE_INTRO'=>HEADING_TITLE_INTRO,
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'SHIPPING_HISTORY_DATE'=>$history_date,
    'TEXT_NO_HISTORY_AVAILABLE'=>TEXT_NO_HISTORY_AVAILABLE
));
// SHA1 VERSCHLUESSEL
$dirname = yes_get_sha1_from_string($history_date);
if(is_dir(\main::get_exportdata_path().$dirname)){
	$dir = \main::get_exportdata_path().$dirname;
	$files = array();
	if ($handle = opendir($dir)) {
		/* Das ist der korrekte Weg, ein Verzeichnis zu durchlaufen. */
		while (false !== ($file = readdir($handle))) {
			if(is_file($dir.'/'.$file)){
				$files[ $file ] = filemtime($dir.'/'.$file);
				$first_entry = $files[ $file ];
			}
		}
		closedir($handle);
	}
	arsort($files);
	$block = 0;
	$items = array();
    $ldir = 'exportdata/'.current(array_reverse(explode('exportdata/',$dir)));
	foreach($files as $file=>$v){
		$mtime = filemtime($dir.'/'.$file );
		$diff = 0;
		if(isset($last_entry))
			$diff = $mtime - $last_entry;
		//	echo 'D:'.$diff.'<br />';
		$last_entry = $mtime;
		if($diff < -30){
			$block++;
		}
		$date = date('d.m.y H:i:s', $mtime);
		//$date = $file['date'];
		$items[ $block ][] = array(
		    'href'=>$ldir.'/'.$file,
		    'file'=>$file,
		    'date'=>$date
		);
	}
	$smarty->assign('ITEMS',$items);
}
$smarty->display('shipping_history.html');
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php'); 

