<?php		
// TICKET 3283 -  Spalte 15 = weight muss real_weight werden
// 
// 
// WRITES EASYLOG CSV
if(sizeOf($packages) > 0 && $versender == 'EASYLOG'){
    if(ORDERS_STATUS_VERSENDET < 1)
        die('KONFIGURATIONSFEHLER - bitte kontaktieren Sie Y.E.S');

    $reference_number_length = 20;
    $anzahl_sammelsendg = 1;
    $counter_sort = 0;
    foreach( $packages as $k=>$loop_element ){
        // NEUES VERSANDMODUL (v2) - 2021/02
        // WENN UMGESTELLT KOENNEN ALLE !v2 BLOECKE ENTFERNT WERDEN
        $v2 = (gettype($loop_element) == 'object');
        $row = $v2 ? $loop_element->shipping_configuration : $loop_element;

        // COUNTRY DATA
        $country_query = xtc_db_query("SELECT countries_id,countries_iso_code_2,countries_iso_code_3 FROM countries WHERE countries_name='".$row['country_name']."'");
        $country_data = xtc_db_fetch_array($country_query);
        $isocode2 = $country_data['countries_iso_code_2'];
        $isocode3 = $country_data['countries_iso_code_2'];

        // ORDER DATA
        if($row['orders_id']>0){
            $order_query = xtc_db_query(sprintf(
                "SELECT payment_method,currency FROM orders WHERE orders_id='%s'",
                $row['orders_id']
            ));
            $order_data = xtc_db_fetch_array($order_query);
            $currency = $order_data['currency'];
            $payment_method = $order_data['payment_method'];
        }else{
            $reclamations_query = xtc_db_query(sprintf(
                "SELECT currency FROM reclamations WHERE reclamations_id='%s'",
                $row['reclamations_id']
            ));
            $reclamations_data = xtc_db_fetch_array($reclamations_query);
            $currency = $reclamations_data['currency'];
        }

        $service = '';
        // RUECKSCHEIN HANDLING
        if(SHIPPING_ACTION_EASYLOG_RUECKSCHEIN == 'true'){
            if($country_data['countries_id'] == STORE_COUNTRY){
                // NATIONAL
                $service = '110';
            }else{
                // INTERNATIONAL
                $service = '5309';
            }
        }
        // NACHNAHME HANDLING
        if($row['orders_id']>0){
            if(stristr($payment_method,'cod')){
                // BESTELLUNG PER NACHNAHME
                $orders_total_query = xtc_db_query(sprintf(
                        "SELECT value FROM orders_total WHERE orders_id='%s' AND class='ot_total'",
                        $row['orders_id']
                ));
                $orders_total = xtc_db_fetch_array($orders_total_query);
                $ot_value = number_format($orders_total['value'],2,',','');
                if($service != '') $service = $service.';';
                if($country_data['countries_id'] == STORE_COUNTRY){
                        // NATIONAL
                        $service .= '114='.$ot_value.' '.$currency;
                }else{
                        // INTERNATIONAL
                        $service .= '5311='.$ot_value.' '.$currency;
                }
            }
        }

        if($row['company'] != ''){
            $name1 = substr($row['company'],0,40);
            $name2 = substr($row['name1'],0,40);
            $name3 = substr($row['name2'],0,40);
        }else{
            $name1 = substr($row['name1'],0,40);
            $name2 = substr($row['name2'],0,40);
            $name3 = '';
        }

        if(SHIPPING_ACTION_EASYLOG_FIXED_WEIGHT>0){
            $weight = SHIPPING_ACTION_EASYLOG_FIXED_WEIGHT;
        }else{
            $weight = number_format($row['weight'],2,',','');
        }


        $ebay_id_string = '';
        if($row['ebay_id'] != ''){
                $ebay_id_string = ' EbayID: '.$row['ebay_id'];
        }
        $products_string = '';
        for($count=0;$count<$row['packages'];$count++){

            // UNIQUE KEY
            if($row['orders_id']>0){
                $unique_key = $row['orders_id'];
            }else{
                $unique_key = $row['reclamations_id'];
            }

            // CONTENT UND VERWENDUNGSZWECK
            if($row['orders_id']>0){
                $comment = 'Re-Nr: '.$row['orders_id'].$ebay_id_string;
                $order = new order($row['orders_id']);
                if($v2){
                    if(sizeOf($loop_element->products_to_ship) == 1){
                        $products_string = sprintf(' %s x [%s] %s',$loop_element->products_to_ship[0]->quantity,
                            $loop_element->products_to_ship[0]->products_id,
                            $loop_element->products_to_ship[0]->source_product['name']
                        );
                    }else{
                        $products_string = ' Diverse';
                    }
                }else{
                    if(sizeOf($order->products) == 1){
                        $products_string = sprintf(' %s x [%s] %s',$order->products[0]['qty'],
                            $order->products[0]['id'],
                            $order->products[0]['name']
                        );
                    }else{
                        $products_string = ' Diverse';
                    }
                }
            }else{
                $comment = 'Rekl-Nr: '.$row['reclamations_id'].$ebay_id_string;
                $reclamation = new reclamation($row['reclamations_id']);
                if($v2){
                    if(sizeOf($loop_element->products_to_ship) == 1){
                        $products_string = sprintf(' %s x [%s] %s',$loop_element->products_to_ship[0]->quantity,
                            $loop_element->products_to_ship[0]->products_id,
                            $loop_element->products_to_ship[0]->source_product['name']
                        );
                    }else{
                        $products_string = ' Diverse';
                    }
                }else{
                    if(sizeOf($reclamation->products) == 1){
                        $products_string = sprintf(' %s x [%s] %s',$reclamation->products[0]['qty'],
                            $reclamation->products[0]['id'],
                            $reclamation->products[0]['name']
                        );
                    }else{
                        $products_string = ' Diverse';
                    }
                }
            }
            if($row['packages']>1){
                $comment .= sprintf(' SamS %s/%s',($count+1),$row['packages']);
            }else{
                $comment .= $products_string;
            }
            
            if($row['orders_id']>0){
                if($v2){
                    $real_weight = $loop_element->get_calculated_shipping_weight(true);
                }else{
                    $real_weight = $order->show_weight($row['id']);
                }
            }else{
                if($v2){
                    $real_weight = $loop_element->get_calculated_shipping_weight(true);
                }else{
                    $real_weight = $reclamation->show_weight($row['id']);
                }
            }
            
            $sql_insert_array = array(
                "reference_number"=>$unique_key,
                "sender_reference_number"=>SHIPPING_ACTION_EASYLOG_ABS_REFNR,
                "verfahren"=>SHIPPING_ACTION_EASYLOG_VERFAHREN,
                "teilnahme"=>1,
                "service"=>$service,
                "waehrung"=>$currency,
                "name1"=>$name1,
                "name2"=>$name2,
                "name3"=>$name3,
                "street"=>substr($row['street1'],0,30),
                "suburb"=>substr($row['street2'],0,40),
                "postcode"=>substr($row['postcode'],0,10),
                "city"=>substr($row['city'],0,40),
                "country"=>$isocode3,
                "weight"=>$real_weight,
                "packages"=>$row['packages'],
                "package_type"=>4,
                "kommentar"=>$comment,
                "date_added"=>'now()',
                'sort_order'=>$counter_sort
            );
            if(DSGVO_ALLOW_SEND_CUSTOMER_EMAIL_ADDRESS_TO_SHIPPER == 'True'){
                $sql_insert_array["email"] = substr($row['email'],0,50);
            }
            xtc_db_perform('packages_calc_easylog',$sql_insert_array);
            $counter_sort++;
        } // END FOR PACKAGES_NR
    } // END FOREACH PACKAGES
    // write csv
    $save_as_name = 'easylog'.yes_get_sha1_from_string(date('Y_m_d-H_i_s')).'.csv';
    $path = \main::get_exportdata_path().yes_get_sha1_from_string(date('Y-m-d'));
    if(!is_dir($path)){
            mkdir($path);
    }

    $filename = $path.'/'.$save_as_name;
    $fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
    fclose($fh);
    $csv = new CSVfile($filename);
    $csv->open("w");
    $csv->delimiter = '|';

    $header = array('reference_number',
        'sender_reference_number',
        'verfahren',
        'teilnahme',
        'service',
        'waehrung',
        'name1',
        'name2',
        'name3',
        'strasse',
        'adresszusatz',
        'plz',
        'stadt',
        'land',
        'email',
        'gewicht',
        'paketanzahl',
        'pakettyp',
        'kommentar'
    );
    // 29.03.10 HEADER RAUS
    //$csv->addRow($header);

    $csvquery = xtc_db_query("select pc.* from packages_calc_easylog pc ORDER BY pc.sort_order ASC");
    while ($csvrow = xtc_db_fetch_array($csvquery)) {
        $csvrow = xtc_db_prepare_input($csvrow);
        $data = array();
        $data[] = $csvrow['reference_number'];
        $data[] = $csvrow['sender_reference_number'];
        $data[] = $csvrow['verfahren'];
        $data[] = $csvrow['teilnahme'];
        $data[] = $csvrow['service'];
        $data[] = $csvrow['waehrung'];
        $data[] = $csvrow['name1'];
        $data[] = $csvrow['name2'];
        $data[] = $csvrow['name3'];
        $data[] = $csvrow['street'];
        $data[] = $csvrow['suburb'];
        $data[] = $csvrow['postcode'];
        $data[] = $csvrow['city'];
        $data[] = $csvrow['country'];
        $data[] = $csvrow['email'];
        $data[] = $csvrow['weight'];
        $data[] = $csvrow['packages'];
        $data[] = $csvrow['package_type'];
        $data[] = $csvrow['kommentar'];
        $csv->addRow($data);
        xtc_db_query("DELETE FROM packages_calc_easylog WHERE packages_calc_easylog_id='".$csvrow['packages_calc_easylog_id']."'");
    }
    $csv->close();
}
