<?php
ini_set('memory_limit','1200M');
include('includes/application_top.php');
require('includes/config.ebayapi.inc.php');
require_once(DIR_FS_DOCUMENT_ROOT.'admin/includes/classes/class.ebay.php');
require_once(DIR_FS_DOCUMENT_ROOT.'admin/includes/classes/order.php');
define("TABLE_EBAY_TRANSACTIONS",'ebay_transactions');
define("TABLE_EBAY_PRODUCTS",'ebay_products');
define("TABLE_EBAY_AUCTIONS",'ebay_auctions');
define('TABLE_EBAY_CALLS','ebay_calls');
define('TABLE_EBAY_EMAILS','ebay_emails');
define("EBAYAPI",true);

$language_id = '2';
$oID = intval($_GET['orders_id']??0);
if($oID == 0){
	die('fehlende Parameter');
}
require_once(DIR_FS_INC . 'xtc_get_lang_path_from_ebay_site.inc.php');

function split_string($value){
	// WIR BASTELN VOR- UND NACHNAMEN
	$reg_fullname = array();
	$reg_fullname_array = array();
	
	$reg_fullname_ebay = $value;
	$reg_fullname_array = split(" ",$reg_fullname_ebay);
	$reg_fullname[0] = $reg_fullname_array[0];
	if( count($reg_fullname_array) > 1 ) {
		for($i=1;$i<count($reg_fullname_array);$i++) {
			$reg_fullname[1] .= ' '.$reg_fullname_array[$i];
		}
	}
	return $reg_fullname;
}

function _get_country_name_from_code($iso_code){
	$countryname_query = xtc_db_query("SELECT countries_name FROM countries WHERE countries_iso_code_2='".$iso_code."'");
	$countryname = xtc_db_fetch_array($countryname_query);
	return $countryname['countries_name'];
}

function _get_country_id_from_code($iso_code){
	$countryid_query = xtc_db_query("SELECT countries_id FROM countries WHERE countries_iso_code_2='".$iso_code."'");
	$countryid = xtc_db_fetch_array($countryid_query);
	return $countryid['countries_id'];
}

function _get_country_code($value,$ebayid){
	global $EBAYAPI;
	$iso2 = $EBAYAPI->get_iso2_from_ebay_countryname($value);
    if( $iso2 != '' ){
    	return $iso2;
    }else{
		$header = 'From: mario.aspeleiter@agri-consulting.de' . "\r\n" .
   		'Reply-To: mario.aspeleiter@agri-consulting.de' . "\r\n" .
   		'X-Mailer: PHP/' . phpversion();
		mail('mario.aspeleiter@agri-consulting.de','Fehlende Ebay-Land-Konvertierung','In Auktion Nr. '.$ebayid.' wurde das Land des Kaeufers als '.$value.' uebergeben, den bitte in popup_get_ebay_address.php adden');
    }
	return 'DE';
}

function _ebay_country_code($code){
	$country_id_query = xtc_db_query("SELECT countries_name,countries_id FROM countries WHERE countries_iso_code_2='".xtc_db_input(strtoupper( $code ))."'");
	$country_id_res = xtc_db_fetch_array($country_id_query);
	return (($country_id_res['countries_id'] > 0)?$country_id_res['countries_id']:'81');
}

function _ebay_zone_id($country_id){
	// bastel zone-id
	$zone_query = xtc_db_query("SELECT zone_id FROM ".TABLE_ZONES." WHERE zone_country_id='".$country_id."'");
	$zone = xtc_db_fetch_array($zone_query);
	return $zone["zone_id"];
}

$EBAYAPI = new ebayAPI;
$site_id = $EBAYAPI->get_site_id_from_name($transaction_details['site']);

$order = new \order($oID);
$ebaycalls = new \YES4Trade\Model\ebaycalls();
foreach($order->ebay_id_array as $ebay_id){
	$auction = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($ebay_id,['id','user']);
	if($auctions_id === null){
		die('No local entry for auction '.$ebay_id);
	}
	$res = $ebaycalls->tradingQuery($auction,'GetOrders',$site_id,[
		'ItemID'=>$ebay_id
	]);
	yes_debug($res);
}
$days = 20; // how many days
$span = 20; // how many days timespan

$from = new DateTime('-'.$days.' Days');//strftime('%Y-%m-%d',yes_strtotime(date('Y-m-d'))-(60*60*24*$days));
$to = new DateTime('-'.($days-$span).' Days');//strftime('%Y-%m-%d',yes_strtotime(date('Y-m-d H:i:s'))-(60*60*24*($days-$span)));
$transaction_details_query = xtc_db_query(sprintf("SELECT et.site,et.seller,user,ebayid,transactionid FROM ebay_transactions et LEFT JOIN ebay_auctions ea ON ea.ebay_id=et.ebayid WHERE et.orders_id='%s'",$oID));
$transaction_details = xtc_db_fetch_array($transaction_details_query);
if(!empty($transaction_details['user'])){
    $s = $EBAYAPI->getTradingService($transaction_details['user'], $site_id);
}else{
    $s = $EBAYAPI->getTradingService($transaction_details['seller'], $site_id);
}
$req = $EBAYAPI->get_sdk_type_class('GetItemTransactionsRequestType');
$req->ModTimeFrom = $from;
$req->ItemID = $transaction_details['ebayid'];
$req->TransactionID = $transaction_details['transactionid'];
$req->ModTimeTo = $to;
$req->DetailLevel = ['ReturnAll'];
$res = $s->GetItemTransactions($req);
if(!$EBAYAPI->isGood($res)){
	die(implode('<br />',$EBAYAPI->getResponseErrors($res)));
}
$v = current(current($res->TransactionArray->Transaction));
$buyer = $v->Buyer;
$buyerReg = $buyer->RegistrationAddress;
$buyerInfo = $buyer->BuyerInfo;
$buyerShip = $buyerInfo->ShippingAddress;

// APIBUG - MANCHMAL KEIN OBJECT REGISTRATIONADDRESS
$setShipFromXML = false;
if( !empty($buyerReg->Name) or !empty($buyerReg->CityName) ){

        // OKAY WIR HABEN EINE REGISTRATIONADDRESS
        $fullname = split_string( $buyerReg->Name );
        $transaction['reg']['fullname'] = xtc_db_input( $buyerReg->Name );
        $transaction['reg']['firstname'] = xtc_db_input($fullname[0]);
        $transaction['reg']['lastname'] = xtc_db_input($fullname[1]);
        $transaction['reg']['country'] = _get_country_code( $buyerReg->CountryName, $transaction_details['ebayid']);
        $transaction['reg']['countryname'] = _get_country_name_from_code( $transaction['reg']['country'] );
        $transaction['reg']['street'] = xtc_db_input($buyerReg->Street1);
        $transaction['reg']['suburb'] = xtc_db_input($buyerReg->Street2);
        $transaction['reg']['zip'] = xtc_db_input($buyerReg->PostalCode);
        $transaction['reg']['city'] = xtc_db_input($buyerReg->CityName);
        $transaction['reg']['phone'] = $EBAYAPI->get_phone_number_from_transactionrecord( xtc_db_input($buyerReg->Phone) );

        if( !xtc_not_null( $buyerShip->Name ) and !xtc_not_null($buyerShip->CityName) and !xtc_not_null($buyerShip->Street1) ){
                // WIR HABEN KEINE VERSANDADRESSE ABER SEHEN
                // DASS DIE PLZ UNTERSCHIEDLICH SIND
                // ALSO DAS FLAG ship_different SETZEN UND TROTZDEM
                // DIE UNVOLLSTAENDIGEN SHIPPINGDATEN UEBERNEHMEN
                $transaction['ebay_no_shippingaddress'] = '1';
                if( $buyerShip->PostalCode != $buyerReg->PostalCode ){
                        $transaction['ebay_different_address'] = 1;
                        $setShipFromXML = true;
                }else{
                        // WIR HABEN KEINE VOLLSTAENDIGE VERSANDADRESSE
                        // ABER DIE PLZ STIMMEN UEBEREIN - ALSO NEHMEN
                        // WIR ALS VERSANDADRESSE DIE REG-ADRESSE
                        $transaction['ship'] = $transaction['reg'];
                }
        }else{
                $setShipFromXML = true;
        }

}else{
        // WIR HABEN KEINE REG-ADDRESS ERHALTEN
        // ALSO NEHMEN WIR DIE (RESTE DER) SHIPPINGADDRESS
        $transaction['ebay_no_registrationaddress'] = '1';

        $fullname = split_string($buyerShip->Name);
        $transaction['reg']['fullname'] = xtc_db_input($buyerShip->Name);
        $transaction['reg']['firstname'] = xtc_db_input($fullname[0]);
        $transaction['reg']['lastname'] = xtc_db_input($fullname[1]);
        $transaction['reg']['street'] = xtc_db_input($buyerShip->Street1);
        $transaction['reg']['zip'] = xtc_db_input($buyerShip->PostalCode);
        $transaction['reg']['city'] = xtc_db_input($buyerShip->CityName);
        $transaction['reg']['country'] = _get_country_code( $buyerShip->CountryName, $transaction_details['ebayid']);
        $transaction['reg']['countryname'] = _get_country_name_from_code($transaction['reg']['country'] );
        $transaction['reg']['phone'] = $EBAYAPI->get_phone_number_from_transactionrecord( xtc_db_input($buyerShip->Phone) );
        $transaction['ship'] = $transaction['reg'];
        if($buyerShip->Street2 != '')
                $transaction['ship']['suburb'] = xtc_db_input($buyerShip->Street2);
}
$transaction['reg']['country_id'] = _ebay_country_code( $transaction['reg']['country'] );
$transaction['reg']['zone_id'] = _ebay_zone_id( $transaction['reg']['country_id'] );

// HIER HABEN WIR EINE VOLLSTAENDIGE SHIPPINGADDRESS UND EINE
// VOLLSTAENDIGE REGISTRATIONADDRESS
// DAS ARRAY ['reg'] IST BEREITS GESETZT UND NUN DAS ARRAY ['ship']
if($setShipFromXML){
        $fullname = split_string( $buyerShip->Name );

        $transaction['ship']['fullname'] = xtc_db_input($buyerShip->Name);
        $transaction['ship']['firstname'] = xtc_db_input($fullname[0]);
        $transaction['ship']['lastname'] = xtc_db_input($fullname[1]);
        $transaction['ship']['street'] = xtc_db_input($buyerShip->Street1 );
        if(xtc_not_null($buyerShip->Street2 ) )
                $transaction['ship']['suburb'] = xtc_db_input($buyerShip->Street2 );
        $transaction['ship']['zip'] = xtc_db_input($buyerShip->PostalCode );
        $transaction['ship']['city'] = xtc_db_input($buyerShip->CityName );
        $transaction['ship']['phone'] = $EBAYAPI->get_phone_number_from_transactionrecord( xtc_db_input($buyerShip->Phone) );

        $transaction['ship']['country'] = _get_country_code( $buyerShip->CountryName,$transaction_details['ebayid'] );
        $transaction['ship']['countryname'] = _get_country_name_from_code( $transaction['ship']['country'] );
}
        
if($_GET['action'] == 'save'){
	$order = new order($oID);
	// Wenn 2 versch. Telefonummern vorliegen, dann beide in einem speichern
	$order_phone = $transaction['reg']['phone'];
	if(!empty($transaction['ship']['phone']) and $transaction['ship']['phone'] != $order_phone){
		if(!empty($order_phone))
			$order_phone .= ' / '.$transaction['ship']['phone'];
		else
			$order_phone = $transaction['ship']['phone'];
	}

	$update_sql_array = array(
		'billing_name'=>$transaction['reg']['fullname'],
		'billing_street_address'=>$transaction['reg']['street'],
		'billing_postcode'=>$transaction['reg']['zip'],
		'billing_city'=>$transaction['reg']['city'],
		'billing_country'=>$transaction['reg']['countryname'],
		
		'customers_name'=>$transaction['reg']['fullname'],
		'customers_street_address'=>$transaction['reg']['street'],
		'customers_postcode'=>$transaction['reg']['zip'],
		'customers_city'=>$transaction['reg']['city'],
		'customers_country'=>$transaction['reg']['countryname'],
		'customers_telephone'=>$order_phone,
		
		'delivery_name'=>$transaction['ship']['fullname'],
		'delivery_street_address'=>$transaction['ship']['street'],
		'delivery_suburb'=>$transaction['ship']['suburb'],
		'delivery_postcode'=>$transaction['ship']['zip'],
		'delivery_city'=>$transaction['ship']['city'],
		'delivery_country'=>$transaction['ship']['countryname'],
		'ebay_no_shippingaddress'=>0,
		'ebay_no_registrationaddress'=>0
	);
	xtc_db_perform('orders',$update_sql_array,'update',"orders_id='".$oID."'");
	$order->add_history($order->info['orders_status'],0,'Fehlende Adressdaten per EbayAPI eingelesen.');

	if(isset($_REQUEST['update_stammdaten']) and $_REQUEST['update_stammdaten'] != ''){
		$query = xtc_db_query(sprintf(
			"SELECT customers_default_address_id FROM %s WHERE customers_id='%s'",
			TABLE_CUSTOMERS,$order->customer['ID']
		));
		$record = xtc_db_fetch_array($query);
		$name_parts = explode(' ',$transaction[$_REQUEST['update_stammdaten']]['fullname']);
		$upd = new \YES4Trade\Model\address_book([
                    'address_book_id'=>(int)$record['customers_default_address_id'],
                    'entry_firstname'=>$name_parts[0],
                    'entry_lastname'=>$name_parts[1],
                    'entry_street_address'=>$transaction[$_REQUEST['update_stammdaten']]['street'],
                    'entry_suburb'=>$transaction[$_REQUEST['update_stammdaten']]['suburb'],
                    'entry_postcode'=>$transaction[$_REQUEST['update_stammdaten']]['zip'],
                    'entry_city'=>$transaction[$_REQUEST['update_stammdaten']]['city'],
                    'entry_country_id'=>(int)_ebay_country_code( $transaction[$_REQUEST['update_stammdaten']]['country'] ),
                    'address_last_modified' => date('Y-m-d H:i:s'),
		]);
                $upd->update();
		
		// IN CUSTOMERS DEN NAMEN SETZEN
		if($transaction['reg']['fullname'] != ''){
		    xtc_db_query(sprintf(
			    "UPDATE %s SET customers_firstname='%s',customers_lastname='%s',customers_last_modified=now() WHERE customers_id='%s'",
			    TABLE_CUSTOMERS,$transaction['reg']['firstname'],$transaction['reg']['lastname'],$order->customer['ID']
		    ));
		    $new = new \YES4Trade\Model\customers_memo([
			'customers_id'=>(int)$order->customer['ID'],
			'memo_date'=>date('Y-m-d H:i:s'),
			'memo_title'=>'eBay Adressdaten eingelesen',
			'memo_text'=>'Name aus eBay Registrationsadresse (Auktion '.$transaction_details['ebayid'].') aktualisiert: '.$transaction['reg']['firstname'].' '.$transaction['reg']['lastname'],
			'poster_id'=>(int)$_SESSION['customer_id']
		    ]);
		    $new->create();
		}
	}
	die('Bestellung aktualisiert. Schliessen Sie das Popup');
}
if(!$_GET['action']){
?>
<!DOCTYPE html>
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo PAGE_HEADING; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css.php">
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<p class="main"><b><?php echo PAGE_HEADING; ?></b></p>

<p class="main"><?php echo TEXT_INTRO_EBAY_ADDRESSDATA; ?></p>
<form action="popup_get_ebay_address.php" method="get">
<input type="hidden" name="action" value="save">
<input type="hidden" name="orders_id" value="<?php echo $oID; ?>">

<table border="0" cellpadding="3" cellspacing="0" class="formArea">
<tr class="dataTableHeadingRow">
	<td colspan="2" class="main"><b><?php echo TEXT_REGISTRATION_ADDRESS; ?></b></td>
</tr>
<tr>
	<td class="main">Vorname:</td>
	<td class="main"><?php echo $transaction['reg']['firstname']; ?></td>
</tr>
<tr>
	<td class="main">Nachname:</td>
	<td class="main"><?php echo $transaction['reg']['lastname']; ?></td>
</tr>
<tr>
	<td class="main">Strasse:</td>
	<td class="main"><?php echo $transaction['reg']['street']; ?></td>
</tr>
<?php if($transaction['reg']['suburb'] != '') { ?>
<tr>
	<td class="main">Adresszusatz:</td>
	<td class="main"><?php echo $transaction['reg']['suburb']; ?></td>
</tr>
<?php } ?>
<tr>
	<td class="main">PLZ:</td>
	<td class="main"><?php echo $transaction['reg']['zip']; ?></td>
</tr>
<tr>
	<td class="main">Ort:</td>
	<td class="main"><?php echo $transaction['reg']['city']; ?></td>
</tr>
<tr>
	<td class="main">Land:</td>
	<td class="main"><?php echo $transaction['reg']['country']; ?></td>
</tr>
<tr class="dataTableHeadingRow">
	<td colspan="2" class="main"><b><?php echo TEXT_SHIPPING_ADDRESS; ?></b></td>
</tr>
<tr>
	<td class="main">Vorname:</td>
	<td class="main"><?php echo $transaction['ship']['firstname']; ?></td>
</tr>
<tr>
	<td class="main">Nachname:</td>
	<td class="main"><?php echo $transaction['ship']['lastname']; ?></td>
</tr>
<tr>
	<td class="main">Strasse:</td>
	<td class="main"><?php echo $transaction['ship']['street']; ?></td>
</tr>
<?php if($transaction['ship']['suburb'] != '') { ?>
<tr>
	<td class="main">Adresszusatz:</td>
	<td class="main"><?php echo $transaction['ship']['suburb']; ?></td>
</tr>
<?php } ?>
<tr>
	<td class="main">PLZ:</td>
	<td class="main"><?php echo $transaction['ship']['zip']; ?></td>
</tr>
<tr>
	<td class="main">Ort:</td>
	<td class="main"><?php echo $transaction['ship']['city']; ?></td>
</tr>
<tr>
	<td class="main">Land:</td>
	<td class="main"><?php echo $transaction['ship']['country']; ?></td>
</tr>
</table>
<br />
<b><?php echo TEXT_UPDATE_STAMMDATEN; ?></b><br />
<select name="update_stammdaten">
	<option value="reg"><?php echo TEXT_REGISTRATION_ADDRESS; ?>
	<option value="ship"><?php echo TEXT_SHIPPING_ADDRESS; ?>
	<option value=""><?php echo NO; ?>
</select>
<br />
<input class="ui-button ui-corner-all ui-state-default" type="submit" value="<?php echo BUTTON_UPDATE_ADDRESSDATA; ?>" />

</form>
<br /><br />
</body>
</html>

<?php
}

exit;
