<?php
function getPaypalStatusName($v):string{
	switch($v){
		case 'S': 
			$v = 'Erfolgreich abgeschlossen (Success)';
			break;

		case 'P': 
			$v = 'Im Prozess (Pending)';
			break;

		case 'C':
			$v = 'Abgebrochen (Canceled)';
			break;

		case 'E': 
			$v = 'Fehler (Error)';
			break;

		case 'R': 
			$v = 'Zurückgebucht (Refunded)';
			break;
	}
	return $v;
}
if(isset($error)) {
	echo $error;
}
$ypp = new \YES4Trade\Model\paypal_api();
$date_select = [
	['id'=>'-1 Day','text'=>'1 Tag'],
	['id'=>'-1 Week','text'=>'1 Woche'],
	['id'=>'-2 Weeks','text'=>'2 Wochen'],
	['id'=>'-1 Month','text'=>'1 Monat'],
];
$date_select_default = $_GET['date_from'] ?? '-1 Day';
printf( '<form action="%s" method="GET">%s%s</form>',
	xtc_href_link('paypal.php'),
	xtc_draw_pull_down_menu('date_from',$date_select,$date_select_default),
	yes_draw_href_button(TEXT_VIEW,'','','submit','ui-button ui-corner-all ui-state-default')
);
$page = intval($_GET['page']??1);
$act = $ypp->getAccess_token();
$ypp->set_access_token($act);
$response = $ypp->getReport(new DateTime($date_select_default), new DateTime());
$resp = json_decode($response);
$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
$head_done = false;	
$contents = [
	[
		['text'=>'Transaction','th'=>true],
		['text'=>'Payer','th'=>true],
		['text'=>'Shipping','th'=>true],
		['text'=>'Info','th'=>true],
		['text'=>'Amount','th'=>true]
	]
];
foreach($resp->transaction_details as $transaction){
	$info = $transaction->transaction_info;
	$payer_info = $transaction->payer_info;
	if($payer_info->address_status == 'Y'){
		$payer_info_html = $payer_info->payer_name->alternate_full_name;
		if($payer_info->country_code != null){
			$payer_info_html .= ' ('.$payer_info->country_code.')';
		}
		if($payer_info->email_address !== null){
			$payer_info_html .= '<br />'.$payer_info->email_address;
		}
	}else{
		$payer_info_html = sprintf(
		'%s%s<br />%s<br />%s %s',
		$payer_info->address->name,
		($payer_info->address->country_code != null)?' ('.$payer_info->address->country_code.')':'',
		$payer_info->address->line1.' '.$payer_info->address->line2,
		$payer_info->address->postal_code,
		$payer_info->address->city
	);
	}
	$sh_info = $transaction->shipping_info;
	if(isset($sh_info->name) and $sh_info->name !== Null){
		$sh_info_html = sprintf(
			'%s%s<br />%s<br />%s %s',
			$sh_info->name,
			($sh_info->address->country_code !== null)?' ('.$sh_info->address->country_code.')':'',
			$sh_info->address->line1.' '.$sh_info->address->line2,
			$sh_info->address->postal_code,
			$sh_info->address->city
		);
	}else{
		$sh_info_html = '';
	}
	$yes_alloc = '';
	if($info->invoice_id !== null){
		$oID = $ypp->get_yes_orders_id_from_invoice_id($info->invoice_id);
		if($oID > 0){
			$yes_alloc = sprintf('<a title="Yes Order #%s" href="%s"><button type="button" class="ui-button ui-corner-all ui-state-default">%s</button></a>',
				$oID,
				xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$oID),
				$oID
			);
		}
	}
	if(empty($yes_alloc)){
		$ipID = $ypp->get_ip_id($info->transaction_id);
		if($ipID > 0){
			$yes_alloc = sprintf('<a title="%s" href="%s"><button type="button" class="ui-button ui-corner-all ui-state-focus">%s</button></a>',
				TEXT_PAYMENT_ALLOCATION,
				xtc_href_link('paypal.php','action=redirect_to_ip&payment_id='.$ipID),
				TEXT_PAYMENT_ALLOCATION	
			);
		}else{
			$yes_alloc = sprintf('<a title="%s" href="javascript:save_ip(\'%s\');"><button type="button" class="ui-button ui-corner-all ui-state-highlight" data-txn="%s">%s</button></a>',
				TEXT_SAVE_TRANSACTION_AS_INCOMING_PAYMENT,
				$info->transaction_id,
				$info->transaction_id,
				'ZEP'
			);
		}
	}
	$trans_info_link = sprintf(
		'<a href="javascript:;" id="paypal.php?action=view_transaction&txn=%s" class="lbOn_nostyle" title="Paypal Transaction Info">%s</a>',
		$info->transaction_id,
		$info->transaction_id
	);
	$cols = [
		['text'=>$yes_alloc.$trans_info_link.'<br />'.getPaypalStatusName($info->transaction_status)],
		['text'=>$payer_info_html],
		['text'=>$sh_info_html],
		['text'=>sprintf(
			'initiation: %s<br />updated: %s',
			yes_date_short($info->transaction_initiation_date),
			yes_date_short($info->transaction_updated_date),
		)],
		['text'=>sprintf(
			'%s %s%s',
			$info->transaction_amount->value,
			$info->transaction_amount->currency_code,
			($info->fee_amount->value !== null)?
				'<br />Fee: '.$info->fee_amount->value.' '.$info->fee_amount->currency_code
			: ''
		)],
	];

/*

	if(!$head_done){
		$arr = [];
		foreach($info as $k=>$v){
			$arr[] = ['text'=>$k,'th'=>true];
		}
		$contents = [$arr];
		$head_done = true;
	}
	$cols = [];
	foreach($info as $k=>$v){
		switch($k){
			case 'transaction_id':
				$query = yes_query("SELECT xtc_order_id FROM paypal WHERE txn_id=:id",[
					'id'=>$v
				],true);
				if($query !== null and !empty($query['xtc_order_id'])){
					$v = sprintf('<a href="%s">%s</a>',xtc_href_link('orders.php','oID='.$query['xtc_order_id'].'&action=edit'),$v);
				}
				break;
		}
		if($k == 'transaction_status'){
			switch($v){
    			case 'S': 
					$v = 'Erfolgreich abgeschlossen (Success)';
					break;

    			case 'P': 
					$v = 'Im Prozess (Pending)';
					break;

    			case 'C':
					$v = 'Abgebrochen (Canceled)';
					break;

    			case 'E': 
					$v = 'Fehler (Error)';
					break;

    			case 'R': 
					$v = 'Zurückgebucht (Refunded)';
					break;
			}
		}
		if(gettype($v) == 'object'){

			$cols[] = ['text'=>$v->value.' '.$v->currency_code.'&nbsp;'];
		}else{
			$cols[] = ['text'=>$v.'&nbsp;'];
		}
	}
	*/
	$contents[] = $cols;
}
echo $table->tableBlock_draw($contents);
$last_link = '';
$next_link = '';
foreach($resp->links as $link){
	if($link->rel == 'last' and $page > 1){
		$last_link = sprintf('<a href="%s">Zurück</a>&nbsp;&nbsp;',
			xtc_href_link('paypal.php','page='.$page-1));
	}
	if($link->rel == 'first' and $page > 1){
		$last_link = sprintf('<a href="%s">Zurück</a>&nbsp;&nbsp;',
			xtc_href_link('paypal.php','page=1'));
	}
	if($link->rel == 'next' and $page < $resp->total_pages){
		$next_link = sprintf('&nbsp;&nbsp;<a href="%s">Weiter</a>',
			xtc_href_link('paypal.php','page='.$page+1));
	}
}
$date = new DateTime($resp->last_refreshed_datetime);
printf('<div class="ui-widget-content" style="margin-top: 18px;padding: 10px;">%sSeite %d von %d (insgesamt %d Datensätze)%s<br /><span style="color:#999;font-size:0.8em;">Liste zuletzt aktualisiert von Paypal am %s</span></div>',
	$last_link,$resp->page, $resp->total_pages,$resp->total_items, $next_link,
	$date->format('d.m.Y H:i:s')
);
