/* --------------------------------------------------------------
   $Id: general.js,v 1.41 2018/10/08 12:35:41 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.js,v 1.2 2001/05/20); www.oscommerce.com 
   (c) 2003	 nextcommerce (general.js,v 1.4 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/
 function getTableRowStatus(trid){
	var tr = document.getElementById(trid);
	if (tr==null) { return; }
	return tr.style.display == '';
 }
 function toggleTableRow(trid){
	var tr = document.getElementById(trid);
	if (tr==null) { return; }
	var bExpand = tr.style.display == '';
	tr.style.display = (bExpand ? 'none' : '');
 }

 function toggleBox(szDivID) {
  if (document.layers) { // NN4+
    if (document.layers[szDivID].visibility == 'visible') {
      document.layers[szDivID].visibility = "hide";
      document.layers[szDivID].display = "none";
//      document.layers[szDivID+"SD"].fontWeight = "normal";
    } else {
      document.layers[szDivID].visibility = "show";
      document.layers[szDivID].display = "inline";
//      document.layers[szDivID+"SD"].fontWeight = "bold";
    }
  } else if (document.getElementById) { // gecko(NN6) + IE 5+
    var obj = document.getElementById(szDivID);
//    var objSD = document.getElementById(szDivID+"SD");

    if (obj.style.visibility == 'visible') {
      obj.style.visibility = "hidden";
      obj.style.display = "none";
//      objSD.style.fontWeight = "normal";
    } else {
      obj.style.visibility = "visible";
      obj.style.display = "inline";
//      objSD.style.fontWeight = "bold";
    }
  } else if (document.all) { // IE 4
    if (document.all[szDivID].style.visibility == 'visible') {
      document.all[szDivID].style.visibility = "hidden";
      document.all[szDivID].style.display = "none";
//      document.all[szDivID+"SD"].style.fontWeight = "normal";
    } else {
      document.all[szDivID].style.visibility = "visible";
      document.all[szDivID].style.display = "inline";
//      document.all[szDivID+"SD"].style.fontWeight = "bold";
    }
  }
}

function SetFocus() {
  if (document.forms.length > 0) {
    var field = document.forms[0];
    for (i=0; i<field.length; i++) {
      if ( (field.elements[i].type != "image") && 
           (field.elements[i].type != "hidden") && 
           (field.elements[i].type != "reset") && 
           (field.elements[i].type != "submit") ) {

        document.forms[0].elements[i].focus();

        if ( (field.elements[i].type == "text") || 
             (field.elements[i].type == "password") )
          document.forms[0].elements[i].select();
        
        break;
      }
    }
  }
}

// **********************************************************************
// YES-LISTER FUNCTIONS
// **********************************************************************
var ajax_last_id;
var CSSclass = '';
var CSSclass_over = 'ui-state-focus';
var CSSclass_selected = 'ui-state-active';
function ajax_show_details(id){
  // "ajax_last_id" must be set from php in actual page
  // "id" is the actual item id from row
  // "params" is the string for get params from actual page
  // "page_link" is the string for the ajax detail php page
  if(ajax_last_id == id || !id ) // klick aufs aktive object
	return true;

  params = AJAX_GET_PARAMS+"="+id;
  $.ajax({
	  type: 'GET',
	  url:  AJAX_LINK,
	  data: params,
	  success: function(response) {
		  show_details(response);
	  }
  });
  if(ajax_last_id){
	$('#trid_'+ajax_last_id).removeClass();
	$('#trid_'+ajax_last_id).addClass(CSSclass);
  }

  ajax_last_id = id;
  $('#trid_'+id).removeClass();
  $('#trid_'+id).addClass(CSSclass_selected);
}
function show_details( response ) {
   $('#orderdetails').html(response);
}

function rowStyle(aktion,id){
	if( ajax_last_id == id || !id ){
		return true;
	}else{
		$('#trid_'+id).removeClass();
		if(aktion == 'over'){
			$('#trid_'+id).addClass(CSSclass_over);
		}else if(aktion == 'out'){
			$('#trid_'+id).addClass(CSSclass);
		}else{
			$('#trid_'+id).addClass(CSSclass_selected);
		}
	}
}

function ajax_onload(formname){
	// formname is the string for the formname of listing
        if(!document.forms[formname].elements.namedItem("start_id")){
            return true;
        }
	id = document.forms[formname].start_id.value;
	rowStyle('selected',id);
	ajax_show_details(id);
}

function ajax_box_action(id,action){
  params = AJAX_GET_PARAMS+"="+id+"&action="+action;
  showPreloader();
  $.ajax({
	  type: 'GET',
	  url:  AJAX_LINK,
	  data: params,
	  success: function(response) {
	      hidePreloader();
		  show_details(response);
	  }
  });
}


/** BUGFIX WENN NUR 1 ELEMENT **/
function checkbox_check(form_name,checkbox_name,checkbox_status){
	matched = 0;
	dom = document.forms[form_name];
	len = dom.elements[checkbox_name].length;
	for(i=0;i<len;i++){
		if(dom.elements[checkbox_name][i].disabled != true){
			dom.elements[checkbox_name][i].checked = checkbox_status;
			matched++;
		}
	}
	if(!matched && dom.elements[checkbox_name]){
		dom.elements[checkbox_name].checked = checkbox_status;
	}
}

function checkbox_get_checked(forminstance,elementname){
	matched = new Array();
	len = forminstance.elements[elementname].length;
	for(i=0;i<len;i++){
		if(forminstance.elements[elementname][i].disabled != true){
			if(forminstance.elements[elementname][i].checked)
				matched.push(forminstance.elements[elementname][i].value);
		}
	}
	if(forminstance.elements[elementname].value){
		if(forminstance.elements[elementname].disabled != true){
			if(forminstance.elements[elementname].checked)
				matched.push(forminstance.elements[elementname].value);
		}
	}
	return matched;
}


function getFormAction(formactionstring){
   var args = '';
   var query = formactionstring.split("?");     // Get query string
   if(!query[1])
	   return args;
   query = query[1];
   var pairs = query.split("&");                 // Split at ampersand
   search_array = query.split("&");
   for (var i=0; i < pairs.length; i++){
       var pos = pairs[i].indexOf('=');          // Look for "name=value"
       if (pos == -1) continue;                  // If not found, skip
       var argname = pairs[i].substring(0,pos);  // Extract the name
       var value = pairs[i].substring(pos+1);    // Extract the value
       args = args + argname+'='+unescape(value)+'&';          // Store as a decoded value
   }
   args = args.substring(0,(args.length-1));
   return args;                                  // Return the object
}

function get_rand_id() {
	min = 1000000;
	max = 9999999;
	return( min + parseInt( Math.random() * ( max-min+1 ) ) );
}

var moreFieldsHandlerCounter = 0;
function moreFieldsHandler(readroot,writeroot){
	moreFieldsHandlerCounter++;
	var newFields = document.getElementById(readroot).cloneNode(true);
	newFields.id = '';
	newFields.style.display = 'block';
	
	input_element = newFields.getElementsByTagName('input');
	for(i=0;i<input_element.length;i++){
		if(input_element[i].name == 'is_name'){
			input_element[i].name = 'is_name_' + moreFieldsHandlerCounter;
		}else if(input_element[i].name == 'is_value'){
			input_element[i].name = 'is_value_' + moreFieldsHandlerCounter;
		}
	}

	var insertHere = document.getElementById(writeroot);
	insertHere.parentNode.insertBefore(newFields,insertHere);
}

var moreFieldsHandlerArrayCounter = {};
function moreFieldsHandlerArray(readroot,writeroot,array_id){
    if('NR'+array_id in moreFieldsHandlerArrayCounter){
	moreFieldsHandlerArrayCounter['NR'+array_id] = moreFieldsHandlerArrayCounter['NR'+array_id]+1;
    }else{
	moreFieldsHandlerArrayCounter['NR'+array_id] = 0;
    }
	var newFields = document.getElementById(readroot).cloneNode(true);
	newFields.id = '';
	newFields.style.display = 'block';

	input_element = newFields.getElementsByTagName('input');
	for(i=0;i<input_element.length;i++){
		if(input_element[i].name == 'is_name['+array_id+']'){
			input_element[i].name = 'is_name_' + moreFieldsHandlerArrayCounter['NR'+array_id] + '['+array_id+']';
		}else if(input_element[i].name == 'is_value['+array_id+']'){
			input_element[i].name = 'is_value_' + moreFieldsHandlerArrayCounter['NR'+array_id] + '['+array_id+']';
		}
	}

	var insertHere = document.getElementById(writeroot);
	insertHere.parentNode.insertBefore(newFields,insertHere);
}

function removeFieldsHandler(element_node){
	element_node.parentNode.removeChild(element_node);
}


function sprintf() {
	if( sprintf.arguments.length < 2 ) {
		return;
	}
	var data = sprintf.arguments[ 0 ];
	for( var k=1; k<sprintf.arguments.length; ++k ) {
		switch( typeof( sprintf.arguments[ k ] ) ){
			case 'string':
				data = data.replace( /%s/, sprintf.arguments[ k ] );
				break;
			case 'number':
				data = data.replace( /%d/, sprintf.arguments[ k ] );
				break;
			case 'boolean':
				data = data.replace( /%b/, sprintf.arguments[ k ] ? 'true' : 'false' );
				break;
			default:
				/// function | object | undefined
				break;
		}
	}
	return( data );
}
if( !String.sprintf ) {
		String.sprintf = sprintf;
}

/** LOADING PROCESS HANDLER
  * erwartet das dass div "hidepage" im body enthalten ist
  * der Parameter mode entscheidet ob anzeigen oder ausblenden
*/
function loadingProcess(mode) {
	if (document.getElementById) {  // DOM3 = IE5, NS6
		document.getElementById('hidepage').style.visibility = mode;
	}else {
		if (document.layers) {  // Netscape 4
			document.hidepage.visibility = mode;
		} else {  // IE 4
			document.all.hidepage.style.visibility = mode;
		}
	}
}

/**
 * CHECKS THE QUICK SHIPPING FORMDATA
 * SETZT VORAUS, DASS ZU DEN ABZUFRAGENDEN INPUT FELDERN JEWEILS EIN HIDDEN
 * FIELD MIT NAMEN lang[input_field_name] UND DEM LANG VALUE FUER DAS INPUT
 * FELD VORHANDEN IST
 * SIEHE ajax_quick_shipping.html
 * 
 * @return bool
 */

function check_quick_shipping(){
	dom = document.forms['quick_shipping'];
	lang_array = dom.elements['lang'];
	domlen = dom.length;
	alert_str = '';
	if(dom.elements['package'].value < 1){
		alert_str = dom.elements['lang[package]'].value;
	}
        var dhl_params = '';
        if($('#additional_versender_params').length){
            dhl_params += $('#additional_versender_params').find('input,select').serialize();
            if($('#DHL_extraparams').length){
                dhl_params += '&'+$('#DHL_extraparams').find('input,select').serialize();
            }
            if(dhl_params != ''){
                dhl_params = '&'+dhl_params;
            }
            if($('input[name="weight"]').length == 1){
                let w = $('input[name="weight"]').val();
                w = parseFloat(w.replace(',','.'));
                var _weight = parseInt(w*1000);
                dhl_params += '&weight='+_weight;
            }
        }
	if(alert_str == ''){
            $.ajax({
                url: 'shipping.php?action=validate&id=orders_'+$(dom).find('input[name="orders_id"]').val()+dhl_params,
                dataType: 'json',
                success: function( json ){
                    if(json.ACK == 'Success'){
                        let yes = true;
                        if(json.MSG_TITLE != ''){
                            let str = json.MSG_TITLE;
                            str = str.replace('<br>',"\n");
                            str = str.replace('<br />',"\n");
                            str = str.replace(/(<([^>]+)>)/gi, "");
                            yes = confirm(str+"\n\nAuftrag trotzdem an DHL senden?");
                        }
                        if(yes){
                            if( dom.action.indexOf('one_click') >= 0){
                                // definiert in one_click_shipping.tpl
                                return one_click_quick_shipping_step_1();
                            }else{
                                dom.submit();
                                return true;
                            }
                        }
                    }else{
                        if(json.MSG != ''){
                            let msg = json.MSG;
                            if(json.MSG_TITLE != ''){
                                msg = json.MSG_TITLE+"\n\n"+msg;
                            }
                            alert(msg);
                        }
                    }
                },error: function( xhr ){
                    alert('Cant validate Quick Shipping item');
                }
            });
	}else{
            alert(alert_str);
        }
	return false;
}


function yes_get_all_get_params(url) {
   var params = [];
   var counter = 0;
   if(url.length > 0) {
	  var splitpos = url.indexOf('?');
	  var get_param_str = url.substr( (splitpos+1),url.length);
      var get_params = get_param_str.split("&");
      for(i = 0; i < get_params.length; i++) {
         var key_value = get_params[i].split("=");
         if(key_value.length == 2) {
            mykey = key_value[0];
            myvalue = key_value[1];
			params[counter] = [mykey,myvalue];
			counter++;
         }
      }
   }
   return params;
}

function yes_get_base_url(url){
	var base_url = '';
   if(url.length > 0) {
	  splitpos = url.indexOf('?');
	  base_url = url.substr( 0,splitpos);
   }
   return base_url;
}

function split_page_select(element,total){
	dom = element.form;
	page_input = prompt("Gehe zu Seite (Aktuell: "+element.value+" / Gesamt: "+total+")");
	page_input = parseInt(page_input);
	if( page_input > 0 && page_input <= total ){
		element.value = page_input;
		dom.elements['page'].value = page_input;
		dom.submit();
		return true;
	}
	alert(page_input+' kann nicht aufgerufen werden.');
}

function isEmail(email) {
  var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
  return regex.test(email);
}
