<?php
/* --------------------------------------------------------------
   $Id: html_output.php,v 1.90 2020/03/18 15:17:48 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(html_output.php,v 1.26 2002/08/06); www.oscommerce.com 
   (c) 2003	 nextcommerce (html_output.php,v 1.7 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

  ////
  // The HTML href link wrapper function
//  function xtc_href_link($page = '', $parameters = '', $connection = YES_HREF_CONNECTION_TYPE ) {
  function xtc_href_link($page = '', $parameters = '', $connection = 'NONSSL',$entities = false ) {
    if ($page == '') {
      die('</td></tr></table></td></tr></table><br><br><font color="#ff0000"><b>Error!</b></font><br><br><b>Unable to determine the page link!<br><br>Function used:<br><br>xtc_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</b>');
    }
	
    if ($connection == 'NONSSL') {
	if (ENABLE_SSL == 'true' and !strstr(HTTP_SERVER,'localhost')) {
		$link = HTTPS_CATALOG_SERVER . DIR_WS_ADMIN;
	}else{
		$link = HTTP_SERVER . DIR_WS_ADMIN;
	}
    } elseif ($connection == 'SSL') {
      if (ENABLE_SSL == 'true') {
        $link = HTTPS_CATALOG_SERVER . DIR_WS_ADMIN;
      } else {
        $link = HTTP_SERVER . DIR_WS_ADMIN;
      }
    } else {
      die('</td></tr></table></td></tr></table><br><br><font color="#ff0000"><b>Error!</b></font><br><br><b>Unable to determine connection method on a link!<br><br>Known methods: NONSSL SSL<br><br>Function used:<br><br>xtc_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</b>');
    }
    $sid = (defined('SID'))?SID:'';
    if ($parameters == '') {
      $link = $link . $page . '?' . $sid;
    } else {
      $link = $link . $page . '?' . $parameters . '&' . $sid;
    }

    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);

	if($entities)
		$link = htmlentities($link);

    return $link;
  }

  function xtc_catalog_href_link($page = '', $parameters = '', $connection = 'NONSSL',$entities = false) {
    if ($connection == 'NONSSL') {
      $link = HTTP_CATALOG_SERVER;
    } elseif ($connection == 'SSL') {
      if (ENABLE_SSL_CATALOG == 'true') {
        $link = HTTPS_CATALOG_SERVER . DIR_WS_CATALOG;
      } else {
        $link = HTTP_CATALOG_SERVER . DIR_WS_CATALOG;
      }
    } else {
      die('</td></tr></table></td></tr></table><br><br><font color="#ff0000"><b>Error!</b></font><br><br><b>Unable to determine connection method on a link!<br><br>Known methods: NONSSL SSL<br><br>Function used:<br><br>xtc_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</b>');
    }
    if ($parameters == '') {
      $link .= $page;
    } else {
      $link .= $page . '?' . $parameters;
    }

    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);
	if($entities)
		$link = htmlentities($link);


    return $link;
  }

  ////
  // The HTML image wrapper function
  function xtc_image($src, $alt = '', $width = '', $height = '', $params = '') {
    $image = '<img src="' . $src . '" alt="' . $alt . '"';
    if ($alt) {
      $image .= ' title=" ' . $alt . ' "';
    }
    if ($width) {
      $image .= ' width="' . $width . '"';
    }
    if ($height) {
      $image .= ' height="' . $height . '"';
    }
    if ($params) {
      $image .= ' ' . $params;
    }
    $image .= ' />';

    return $image;
  }

  ////
  // The HTML form submit button wrapper function
  // Outputs a button in the selected language
  function xtc_image_submit($image, $alt, $params = '') {
    return yes_draw_href_button($alt,'javascript:','','submit');
    //return '<input type="image" src="' .DIR_WS_LANGUAGES . $_SESSION['language'] . '/admin/images/buttons/' . $image . '" style="border:0px;" alt="' . $alt . '"' . (($params) ? ' ' . $params : '') . ' />';
  }

  ////
  // Draw a 1 pixel black line
  function xtc_black_line() {
    return xtc_image(DIR_WS_IMAGES . 'pixel_black.gif', '', '100%', '1');
  }

  ////
  // Output a separator either through whitespace, or with an image
  function xtc_draw_separator($image = 'pixel_black.gif', $width = '100%', $height = '1') {
    return xtc_image(DIR_WS_IMAGES . $image, '', $width, $height);
  }

  ////
  // Output a function button in the selected language
  function xtc_image_button($image, $alt = '', $params = '') {
    return yes_draw_href_button($alt,'javascript:','','button');
    //return xtc_image(DIR_WS_LANGUAGES. $_SESSION['language'] . '/admin/images/buttons/' . $image, $alt, '', '', $params);
  }

  ////
  // javascript to dynamically update the states/provinces list when the country is changed
  // TABLES: zones
  function xtc_js_zone_list($country, $form, $field) {
    $countries_query = xtc_db_query("select distinct zone_country_id from " . TABLE_ZONES . " order by zone_country_id");
    $num_country = 1;
    $output_string = '';
    while ($countries = xtc_db_fetch_array($countries_query)) {
      if ($num_country == 1) {
        $output_string .= '  if (' . $country . ' == "' . $countries['zone_country_id'] . '") {' . "\n";
      } else {
        $output_string .= '  } else if (' . $country . ' == "' . $countries['zone_country_id'] . '") {' . "\n";
      }

      $states_query = xtc_db_query("select zone_name, zone_id from " . TABLE_ZONES . " where zone_country_id = '" . $countries['zone_country_id'] . "' order by zone_name");

      $num_state = 1;
      while ($states = xtc_db_fetch_array($states_query)) {
        if ($num_state == '1') $output_string .= '    ' . $form . '.' . $field . '.options[0] = new Option("' . PLEASE_SELECT . '", "");' . "\n";
        $output_string .= '    ' . $form . '.' . $field . '.options[' . $num_state . '] = new Option("' . $states['zone_name'] . '", "' . $states['zone_id'] . '");' . "\n";
        $num_state++;
      }
      $num_country++;
    }
    $output_string .= '  } else {' . "\n" .
                      '    ' . $form . '.' . $field . '.options[0] = new Option("' . TYPE_BELOW . '", "");' . "\n" .
                      '  }' . "\n";

    return $output_string;
  }

  ////
  // Output a form
  function xtc_draw_form($name, $action, $parameters = '', $method = 'post', $params = '') {
    $form = '<form name="' . $name . '" action="';
    if ($parameters) {
      $form .= xtc_href_link($action, $parameters);
    } else {
      $form .= xtc_href_link($action);
    }
    $form .= '" method="' . $method . '"';
    if ($params) {
      $form .= ' ' . $params;
    }
    $form .= '>';

    return $form;
  }

  ////
  // Output a form input field
  function xtc_draw_input_field($name, $value = '', $parameters = '', $required = false, $type = 'text', $reinsert_value = true) {
    $field = '<input type="' . $type . '" name="' . $name . '"';
    if ( isset($GLOBALS[$name]) and !is_countable($GLOBALS[$name]) && ($reinsert_value) ) {
      $field .= ' value="' . htmlspecialchars(trim($GLOBALS[$name])) . '"';
    } elseif ($value != '') {
      $field .= ' value="' . htmlspecialchars(trim($value)) . '"';
    }
    if ($parameters != '') {
      $field .= ' ' . $parameters;
    }
    $field .= ' />';

    if ($required) $field .= sprintf('&nbsp;<span class="fieldRequired">%s</span>',TEXT_FIELD_REQUIRED);

    return $field;
  }
  // Output a form small input field
  function xtc_draw_small_input_field($name, $value = '', $parameters = '', $required = false, $type = 'text', $reinsert_value = true) {
    $field = '<input type="' . $type . '" size="3" name="' . $name . '"';
    if ( isset($GLOBALS[$name]) && ($reinsert_value) ) {
      $field .= ' value="' . htmlspecialchars(trim($GLOBALS[$name])) . '"';
    } elseif ($value != '') {
      $field .= ' value="' . htmlspecialchars(trim($value)) . '"';
    }
    if ($parameters != '') {
      $field .= ' ' . $parameters;
    }
    $field .= ' />';

    if ($required) {
      $field .= sprintf('&nbsp;<span class="fieldRequired">%s</span>',TEXT_FIELD_REQUIRED);
    }

    return $field;
  }

  ////
  // Output a form password field
  function xtc_draw_password_field($name, $value = '', $required = false) {
    $field = xtc_draw_input_field($name, $value, 'maxlength="40"', $required, 'password', false);

    return $field;
  }

  ////
  // Output a form filefield
  function xtc_draw_file_field($name, $required = false) {
    $field = xtc_draw_input_field($name, '', '', $required, 'file');

    return $field;
  }

  ////
  // Output a selection field - alias function for xtc_draw_checkbox_field() and xtc_draw_radio_field()
  function xtc_draw_selection_field($name, $type, $value = '', $checked = false, $compare = '',$params='') {
    $selection = '<input type="' . $type . '" name="' . $name . '" '.$params;
    if ($value != '') {
      $selection .= ' value="' . $value . '"';
    }
    if ( ($checked == true) || (isset($GLOBALS[$name]) and $GLOBALS[$name] == 'on') || ($value and isset($GLOBALS[$name]) and ($GLOBALS[$name] == $value)) || ($value && ($value == $compare)) ) {
      $selection .= ' checked';
    }
    $selection .= ' />';

    return $selection;
  }

  ////
  // Output a form checkbox field
  function xtc_draw_checkbox_field($name, $value = '', $checked = false, $compare = '',$params='') {
    return xtc_draw_selection_field($name, 'checkbox', $value, $checked, $compare,$params);
  }

  ////
  // Output a form radio field
if(!function_exists('xtc_draw_radio_field')){
    function xtc_draw_radio_field($name, $value = '', $checked = false, $compare = '') {
      return xtc_draw_selection_field($name, 'radio', $value, $checked, $compare);
    }
}
  ////
  // Output a form textarea field
  function xtc_draw_textarea_field($name, $wrap, $width, $height, $text = '', $params = '', $reinsert_value = true) {
    $field = '<textarea id="'.$name.'" name="' . $name . '" wrap="' . $wrap . '" cols="' . $width . '" rows="' . $height . '"';
    if ($params) $field .= ' ' . $params;
    $field .= '>';
    if ( (isset($GLOBALS[$name])) && ($reinsert_value) ) {
      $field .= $GLOBALS[$name];
    } elseif ($text != '') {
      $field .= $text;
    }
    $field .= '</textarea>';

    return $field;
  }

  ////
  // Output a form hidden field
  function xtc_draw_hidden_field($name, $value = '') {
    $field = '<input type="hidden" name="' . $name . '" value="';
    if ($value != '') {
      $field .= trim($value);
    } else {
        if(isset($GLOBALS[$name])){
            if(gettype($GLOBALS[$name])=='string'){
                $field .= trim($GLOBALS[$name]);
            }
        }
    }
    $field .= '" />';

    return $field;
  }

  ////
  // Output a form pull down menu
  function xtc_draw_pull_down_menu($name, $values, $default = '', $params = '', $required = false) {
      if(!is_countable($values)){
          throw new Exception(sprintf(
                'xtc_draw_pull_down_menu() need Array of Values, %s given',
                gettype($values)
          ));
      }
    $field = '<select name="' . $name . '"';
    if ($params) $field .= ' ' . $params;
    $field .= '>';
    for ($i=0; $i<sizeof($values); $i++) {
      $field .= '<option value="' . $values[$i]['id'] . '"';
      if(isset($values[$i]['title'])){
      	$field .= ' title="'.$values[$i]['title'].'" ';
      }

      if ( ((strlen($values[$i]['id']) > 0) && (isset($GLOBALS[$name]) and $GLOBALS[$name] == $values[$i]['id'])) || ($default == $values[$i]['id']) ) {
        $field .= ' selected="selected"';
      }
      $field .= '>' . $values[$i]['text'] . '</option>';
    }
    $field .= '</select>';

    if ($required) $field .= sprintf('&nbsp;<span class="fieldRequired">%s</span>',TEXT_FIELD_REQUIRED);

    return $field;
  }

function get_random_id(){
    for ($i = 0; $i<10; $i++)
    {
        $c .=  dechex(rand(0,15));
    }
    return $c;
}

function yes_draw_href_link($title,$href,$class='',$style='',$id='',$lightbox=false){
	if($lightbox) $class = 'lbOn '.$class;
	$link = sprintf('<a title="%s" class="%s" style="%s"',$title,$class,$style);
	if($id != ''){
		if(!$lightbox)
			$link .= ' id="'.$id.'" href="'.$href.'" ';
		else
			$link .= ' id="'.$href.'" ';
	}else{
		if(!$lightbox)
			$link .= 'href="'.$href.'"';
	}
	if($lightbox){
		$link .= ' href="#" ';
	}
	$link .= sprintf('>%s</a>',$title);
	return $link;
}
/**
 * Enthaelt der Parameter "href" den String "javascript:" und das Flag
 * "target" steht auf false und $type ist "button" dann wird die Aktion
 * onclick="STRING" eingefuegt. Wobei STRING dem Parameter href entspricht
 * bei dem "javascript:" entfernt wurde.
 * So lassen sich Javascript Funktionen aufrufen.
 * Gleiches gilt wenn "target" auf true steht und "type" als "button"
 * definiert ist.
 * 
 * @param string $title
 * @param string $href
 * @param type $style
 * @param type $type
 * @param type $css_class
 * @param type $target
 * @return type
 */
function yes_draw_href_button($title,$href,$style='',$type='button',$css_class='ui-button ui-corner-all ui-state-default',$target=false){
	$style_string = ($style != '') ? ' style="'.$style.'" ' : '';
	$lightbox = false;
	$link_string = '';
	if(!$target){
		if(!strstr($href,'javascript:')){
			if(strstr($css_class,'lbOn')){
				$lightbox = true;
			}else{
				$link_string = ($type == 'button') ? 'onclick="window.location.href=\''.$href.'\';"' : '';
			}
		}else{
			$link_string = ($type == 'button') ? 'onclick="'.str_replace('javascript:','',$href) . '"': '';
		}
	}else{
		$link_string = ($type == 'button') ? 'onclick="window.open(\''.$href.'\');"' : '';
	}
	$button = sprintf('<input title="%s" value="%s" %s %s type="%s" class="%s" />',
		$title,$title,$link_string,$style_string, $type,$css_class);
	if(!$lightbox){
		return $button;
	}else{
		$css_class_string = '';
		/**
		 * wenn mehrer CSS Klassen angegeben wurden - wieder integrieren
		 * ausgenommen lbOn - die werden autom. hinzugefuegt
		 */
		$class_parts = explode(' ',$css_class);
		for($i=0;$i<sizeOf($class_parts);$i++){
			switch($class_parts[$i]){
				case 'lbOn':
				case 'iButton':
					break;
				default:
					$css_class_string .= $class_parts[$i].' ';
					break;
			}
		}
		$css_class_string .= 'lbOn ui-button ui-corner-all ui-state-default';
		return '<input id="'.$href.'" title="'.$title.'" type="button" style="'.$style.'" class="'.$css_class_string.'" value="'.$title.'" />';

	}
  }

  function yes_draw_href_image($img,$title,$href,$lightbox = false,$lightbox_list = false,$id = ''){
	  if(!$lightbox){
		  return '<a title="'.$title.'" href="'.$href.'"><img src="'.$img.'" alt="'.$title.'" border="0" /></a>';
	  }else{
		return '<a style="padding-left:0px;" id="'.$href.'" href="javascript:;" title="'.$title.'" class="lbOn"><img src="'.$img.'" alt="'.$title.'" border="0" /></a>';
	  }
  }

  function yes_draw_order_edit_link($oID, $target = ''){
        $target_str = ($target != '') ? 'target="'.$target.'"' : '';
	return '<a '.$target_str.' title="'.YES_LINKTEXT.'" href="'.xtc_href_link('orders.php','action=edit&oID='.$oID).'"><u>'.$oID.'</u></a>';
  }

  function yes_draw_reclamation_edit_link($rID, $target = ''){
        $target_str = ($target != '') ? 'target="'.$target.'"' : '';
        return '<a '.$target_str.' title="'.YES_LINKTEXT.'" href="'.xtc_href_link('reclamations.php','action=edit&rID='.$rID).'"><u>'.$rID.'</u></a>';
  }

  function yes_draw_rueckerstattung_edit_link($rID){
	return '<a title="'.YES_LINKTEXT.'" href="'.xtc_href_link('rueckerstattungen.php','action=edit&rID='.$rID).'"><u>'.$rID.'</u></a>';
  }

  function yes_draw_retoure_edit_link($rID){
	return '<a title="'.YES_LINKTEXT.'" href="'.xtc_href_link('retoure.php','action=edit&rID='.$rID).'"><u>'.$rID.'</u></a>';
  }

  // output 2 Soring arrows
  function xtc_sorting($page,$sort) {

      switch ($page) {
          case FILENAME_CUSTOMERS:

          $nav='<br><a href="'.xtc_href_link(FILENAME_CUSTOMERS,'sorting='.$sort.'&'.xtc_get_all_get_params(array('action','sorting'))).'">';
          $nav.=xtc_image(DIR_WS_ICONS . 'sort_down.gif', '', '20' ,'20').'</a>';
          $nav.='<a href="'.xtc_href_link(FILENAME_CUSTOMERS,'sorting='.$sort.'-desc&'.xtc_get_all_get_params(array('action','sorting'))).'">';
          $nav.= xtc_image(DIR_WS_ICONS . 'sort_up.gif', '', '20' ,'20').'</a>';

          break;

      }

      return $nav;

  }

  function yes_draw_quicknote($backlink = '',$popup_link = false,$after_function = '',$is_in_modal = false){
	if($backlink == '')
		$backlink = urlencode( current(array_reverse(explode('/admin/',$_SERVER['SCRIPT_NAME']))).'?'.$_SERVER['QUERY_STRING']);

	require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/notiz.php'); 
	require_once(DIR_WS_CLASSES.'class.notiz.php'); 
	$hour_array = array();
	for($i=0;$i<24;$i++){
		$val = (strlen($i)==1)?'0'.$i:$i;
		$hour_array[] = array('id'=>$val,'text'=>$val);
	}
	$minute_array = array();
	for($i=0;$i<60;$i+=15){
		$val = (strlen($i)==1)?'0'.$i:$i;
		$minute_array[] = array('id'=>$val,'text'=>$val);
	}
	$notiz = new notiz(0);

?>
<script type="text/javascript">
$(function() {
	//$('#termin').datepicker({dateFormat:'yy-mm-dd'});
	$('#subm').click(function(){
		$.post('notiz.php?action=quicknoteadd',  $("#quicknoteform").serialize(), function(data) {
			$('#addquicknote').hide();
			alert(data.MSG);
			<?php if($after_function != ''){ ?>
			var Notes_id = data.ID;
			if(Notes_id){
			<?php echo $after_function; ?>
			}
			<?php } ?>
		},'json');
	});
});
</script>
<div id="myspan" class="main" style="visibility: hidden; display: none;position:absolute;<?php if(!$is_in_modal){?>top: 110px;left:250px;z-index:997;<?php } ?>"></div>
<div id="addquicknote" class="ui-widget longDescription" style="position:absolute;<?php if(!$is_in_modal){?>top:150px;left:250px;z-index:998;<?php } ?>border:2px solid #000;padding:6px; background-color: #FFF;">
<form name="quicknoteform"  id="quicknoteform">
<?php
if($backlink != 'NONE'){
?>
    
<input type="hidden" name="src" id="src" value="<?php echo $backlink; ?>" />

<?php
}else{
?>

<input type="hidden" name="no_link_note" id="no_link_note" value="1" />

<?php
}
?>

<table border="0" cellpadding="4" cellspacing="0">
<tr>
	<td><b><?php echo QUICKNOTE_TITLE; ?></b></td>
	<td align="right" width="10"><a href="#" onclick="toggleBox('addquicknote');"><?php echo xtc_image('images/cal_close_small.gif',QUICKNOTEADD_CLOSE); ?></a></td>
</tr>
<tr>
	<td class="main" colspan="2">
		<table border="0" cellpadding="2" cellspacing="0">
		<tr>
			<td class="main"><?php echo NOTE_CAPT; ?> *</td>
			<td class="main"><?php echo xtc_draw_input_field('capt',NOTE_QUICKNOTE_SUBJECT,'size="20" maxlength="100" id="capt"'); ?></td>
		</tr>
		<tr>
			<td class="main" valign="top"><?php echo NOTE_NOTE; ?> *</td>
			<td class="main" valign="top"><?php echo xtc_draw_textarea_field('note','virtual','40','4', ''); ?></td>
		</tr>
		<tr>
			<td class="main" valign="top"><?php echo NOTE_EMPFAENGER; ?> *</td>
			<td class="main" valign="top">
				<div style='font:13.3px sans-serif;width:300px;border-left:1px solid #808080;border-top:1px solid #808080;border-bottom:1px solid #fff; border-right:1px solid #fff;'>
				<div style='background:#fff; overflow:auto;height:7.1em;border-left:1px solid #404040;border-top:1px solid #404040;border-bottom:1px solid #d4d0c8;border-right:1px solid #d4d0c8;'>
				<?php echo $notiz->draw_recipients($_SESSION['customer_id']); ?>
				</div>
				</div>
			</td>
		</tr>
		<tr>
			<td class="main" valign="top"><?php echo NOTE_TERMIN; ?></td>
			<td class="main" valign="top">
				<table border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td><input value="" type="date" size="12" maxlength="12" name="termin" id="termin" /></td>
					<td>&nbsp;</td>
					<td class="main"><?php echo xtc_draw_pull_down_menu('termin_hour',$hour_array,date('H'),'id="termin_hour"'); ?>&nbsp;:&nbsp;<?php echo xtc_draw_pull_down_menu('termin_minute',$minute_array,0,'id="termin_minute"'); ?> Uhr</td>
				</tr>
				<tr>
				    <td colspan="3" class="smallText">
					<?php echo TEXT_NOTICE_REMINDER; ?>
					<select name="reminder">
					    <option value=""><?php echo TEXT_NOTICE_REMINDER_NO_REMINDER; ?></option>
					    <option value="weekly"><?php echo TEXT_NOTICE_REMINDER_WEEKLY; ?></option>
					    <option value="weekly_2"><?php echo TEXT_NOTICE_REMINDER_WEEKLY_2; ?></option>
					    <option value="monthly"><?php echo TEXT_NOTICE_REMINDER_MONTHLY; ?></option>
					</select>
				    </td>
				</tr>
				</table>
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td align="center" colspan="2" class="smallText"><input type="button" id="subm" name="button" value="<?php echo BUTTON_NOTE_SAVE; ?>" />
	<br /><i>* = <?php echo NOTE_PFLICHTFELDER; ?></i>
	</td>
</tr>
</table>
</form>
</div>
<?php
  }

function yes_get_inline_error_message($text){
	$wrap = '<div class="main"><div class="ui-widget"><div class="ui-state-error ui-corner-all" style="padding: 0pt 0.7em;"><p><span class="ui-icon ui-icon-alert" style="float: left; margin-right: 0.3em;"></span><strong>%s</strong> %s</p></div></div></div>';
	return sprintf($wrap,'Error:',$text);
}

function yes_get_inline_info_message($text){
	$wrap = '<div class="ui-widget"><div class="ui-state-highlight ui-corner-all" style="padding: 0pt 0.4em;"><p><span class="ui-icon ui-icon-info" style="float: left; margin-right: 0.3em;"></span><strong>%s</strong> %s</p></div>';
	return sprintf($wrap,'Info:',$text);
}

function xtc_get_products_image_html($image_name,$folder='thumbnail_images',$params=''){
	if($image_name != '' and is_file(DIR_FS_CATALOG.'images/product_images/'.$folder.'/'.$image_name)){
		return sprintf('<img src="../images/%s" border="0" %s alt="%s" />',
			'product_images/'.$folder.'/'.$image_name,$params,$image_name
		);
	}
	return sprintf('<img src="images/cal_close_small.gif" border="0" %s />',$params);
}

function yes_get_marketing_box_select($config_string){
    $boxes_data = array();
    $num_boxes_entries = 0;
    $configs = explode(':',$config_string);
    if(sizeOf($configs)>1){
	$config_string = (isset($configs[1]))?$configs[1]:'';
	$config_meta = $configs[0];
    }else{
	$config_meta = '';
    }
    if(strstr($config_meta,',')){
	$config_meta_parts = explode(',',$config_meta);
	$boxes = explode(';',$config_string);
	$num_boxes = $config_meta_parts[0];
	$num_boxes_entries = $config_meta_parts[1];
    }else{
	$boxes = explode(';',$config_string);
	$num_boxes = (sizeOf($boxes) > 0) ? sizeOf($boxes) : 1;
	if(!sizeOf($boxes)){
	    $boxes = array($config_string);
	    $num_boxes = 1;
	}
    }
    $string = xtc_draw_hidden_field('configuration_value','').'<script type="text/javascript">
	$().ready(function(){
	    // BOF - FORM SUBMIT VIA ENTER VERHINDERN
	    $(\'form[name=configuration]\').keypress(function(event) { return event.keyCode != 13; });
	    // EOF - FORM SUBMIT VIA ENTER VERHINDERN
		$(\'form[name=configuration] input[type=image]\').hide();
	    $(\'#num_boxes_button\').click(function(){
		if( !$(\'form[name=configuration] input[name=num_boxes]\').val().match(\'^(0|[1-9][0-9]*)$\')){
		    alert(\''.TEXT_MARKETINGBOX_NUM_BOXES.': '.JS_ERROR_MARKETING_BOX_ONLY_NUMBERS.'\');
			return false;
		}
		if( !$(\'form[name=configuration] input[name=num_boxes_entries]\').val().match(\'^(0|[1-9][0-9]*)$\')){
		    alert(\''.TEXT_MARKETINGBOX_NUM_BOX_ENTRIES.': '.JS_ERROR_MARKETING_BOX_ONLY_NUMBERS.'\');
			return false;
		}
		num_boxes = $(\'form[name=configuration] input[name=num_boxes]\').val();
		num_boxes_entries = $(\'form[name=configuration] input[name=num_boxes_entries]\').val();
		var configuration_value = num_boxes+\',\'+num_boxes_entries+\':\';
		for(var i=0;i<num_boxes;i++){
		    for(var j=0;j<num_boxes_entries;j++){
			var current_field = 0;
			var _value = \'\';
			$(\'form[name=configuration] input[name="box\\[\'+i+\'\\]"]\').each(function(){
			    if(current_field == j){
				_value = $(this).val();
			    }
			    current_field++;
			});
			configuration_value += _value;
			if((j+1)<num_boxes_entries)
			    configuration_value += \',\';
		    }
		    configuration_value += \';\';
		}
		if(configuration_value.charAt(configuration_value.length-1) == \';\')
		    configuration_value = configuration_value.substr(0,configuration_value.length-1);
		$(\'form[name=configuration] input[name=configuration_value]\').val(configuration_value);
		$(\'form[name=configuration]\').submit();
		
	    });
	});
    </script>';
    if($num_boxes_entries == 0) $num_boxes_entries = 5;
    for($b = 0;$b < $num_boxes;$b++){
	if(isset($boxes[$b])){
	    $box_content = explode(',', $boxes[$b] );
	}else{
	    $box_content = array();
	}
	$inputs = array();
	for($i=0;$i<$num_boxes_entries;$i++){
	    $inputs[] = xtc_draw_input_field('box['.$b.']',((isset($box_content[$i]))?$box_content[$i]:'' ),'size="12" maxlength="8" style="margin:3px;padding:2px;"');
	}
	$boxes_data[] = $inputs;
    }
    $string .= TEXT_MARKETINGBOX_NUM_BOX_ENTRIES.':<br />' . xtc_draw_input_field('num_boxes_entries',$num_boxes_entries,'size="6" maxlength="3"');
    $string .= '<br />'.TEXT_MARKETINGBOX_NUM_BOXES.':<br />' . xtc_draw_input_field('num_boxes',$num_boxes,'size="6" maxlength="3"').'<br /><br />';
    foreach($boxes_data as $b => $inputs){
	$string .= '<div style="float:left;padding:2px;margin-right:4px;margin-bottom:4px;" id="box'.$b.'">';
	$string .= 'Box '.($b+1).'<br />';
	$string .= implode('<br />',$inputs);
	$string .= '</div>';
    }
    $string .= '<br clear="all" /><br /><input type="button" name="num_boxes_button" id="num_boxes_button" class="ui-button ui-corner-all ui-state-default" value="'.IMAGE_UPDATE.'" /></fieldset>';
    return $string;
}


function yes_get_amazon_auth_data(){
    $error = '';
    if(!defined('AMAZONUSER_COUNTER') or AMAZONUSER_COUNTER == 0){
	$error = AMAZONUSER_COUNTER_NO_ACCOUNTS;
    }
    if($error != ''){
	return $error;
    }
    
    // 2023/10 Werte aus JSON Datei
    $secure_path = main::get_secure_path();
    $file = $secure_path.'AMAZON_SP_AUTH.json';
    if(!is_file($file)){
        $json = new stdClass();
        $json->users = [];
        for($i=0;$i<AMAZONUSER_COUNTER; $i++){
            $json->users[$i]->lwaClientId = '';
            $json->users[$i]->lwaClientSecret = '';
            $json->users[$i]->marketplace_id = '';
        }
    }else{
        $json = json_decode(file_get_contents($file));
    }
    
    //$amz_auth = explode(';',MODULE_OTHER_AMAZON_AUTH_DATA);
    $return = array();
    for($i=0;$i<AMAZONUSER_COUNTER;$i++){
        /*
	if(isset($amz_auth[$i])){
	    $amz_auth_parts = explode(',',$amz_auth[$i]);
	}else{
	    $amz_auth_parts = array('','','','');
	}*/
        $clientid = substr($json->users[ $i ]->lwaClientId,0,15);
        $secret = substr($json->users[ $i ]->lwaClientSecret,0,15);
        if(!empty($secret)){
            $secret = $secret . '...';
            $clientid = $clientid . '...';
        }
	$return[] = sprintf(
		'<br /><b>Account #'.($i+1).'</b><br />LWA Client ID: %s<br />LWA Secret ID: %s<br />Marketplace ID: %s',
		$clientid,
		$secret,
       		$json->users[ $i ]->marketplace_id
	);
    }
    return implode('<br /><br />',$return);
}

function yes_cfg_get_amazon_auth_input(){
    $error = '';
    if(!defined('AMAZONUSER_COUNTER') or AMAZONUSER_COUNTER == 0){
	$error = AMAZONUSER_COUNTER_NO_ACCOUNTS;
    }
    if($error != ''){
	return $error;
    }
    // 2023/10 Werte aus JSON Datei
    $secure_path = main::get_secure_path();
    $file = $secure_path.'AMAZON_SP_AUTH.json';
    if(!is_file($file)){
        $json = new stdClass();
        $json->users = [];
        for($i=0;$i<AMAZONUSER_COUNTER; $i++){
            $json->users[$i]->lwaClientId = '';
            $json->users[$i]->lwaClientSecret = '';
            $json->users[$i]->marketplace_id = '';
        }
    }else{
        $json = json_decode(file_get_contents($file));
    }
    //$amz_auth = explode(';',MODULE_OTHER_AMAZON_AUTH_DATA);
    for($i=0;$i<AMAZONUSER_COUNTER;$i++){
        $clientId = (!empty($json->users[$i]->lwaClientId)) ? substr($json->users[$i]->lwaClientId,0,15).'...' : '';
	$return[] = sprintf(
		'<br /><b>Account #'.($i+1).'</b><br />LWA Client ID: %s<br />Marketplace ID:<br />%s<br />',
		$clientId,
		xtc_draw_input_field('marketplace_id['.$i.']',$json->users[$i]->marketplace_id,'size="32"')
	);
    }
    return implode('<br /><br />',$return);
    return '';
}

function yes_get_order_source_title($source, $amazon_prime = false){
    foreach(main::get_order_sources() as $os){
        if($os['id'] == $source){
            if($amazon_prime === True and $source == 'amazon'){
                return 'Amazon Prime';
            }
            return $os['text'];
        }
    }
    return ucfirst($source);
}

function yes_draw_pre_header(){
    printf("<!DOCTYPE html>
	<html %s><head>",HTML_PARAMS);
}

function yes_draw_header($title = TITLE, array $config = []){
    $default_quickpid = intval($_REQUEST['pID']??0);
    if(!isset($_REQUEST['oID']) or (!is_countable($_REQUEST['oID']) and !is_array($_REQUEST['oID']))){
        $default_quickoid = (isset($_REQUEST['oID']) and xtc_not_null($_REQUEST['oID']) and $_REQUEST['oID'] > 0) ? (int)xtc_db_input($_REQUEST['oID']) : '';
    }else{
        $default_quickoid = '';
    }
    $smarty = new yesSmarty;
    $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
    $ui_theme = (isset($_REQUEST['ui_theme'])) ? $_REQUEST['ui_theme'] : 'start';
    

    $jquery_version = (isset($config['jquery_version']))?$config['jquery_version'] : '3.7.1';
    $jquery_ui_version = (isset($config['jquery_ui_version']))?$config['jquery_ui_version'] : '1.13.3';
    
    $ui_css_link = yes_get_cdn_link('jquery-ui-css',$jquery_ui_version,$ui_theme);
    $ui_js_link = yes_get_cdn_link('jquery-ui',$jquery_ui_version);
    
    $smarty->assign(array(
	'TITLE'=>$title,
	'CHARSET'=>CHARSET,
	'IMAGE_AUTH_DENIED'=>IMAGE_AUTH_DENIED,
  'TABLES_EXTENDABLE_NAVIGATION_INFO'=>TABLES_EXTENDABLE_NAVIGATION_INFO,
	'TEXT_SYSTEM_ALERTS'=>TEXT_SYSTEM_ALERTS,
	'TEXT_DIALOG_CONFIRMATION'=>TEXT_DIALOG_CONFIRMATION,
	'IMAGE_CONFIRM_YES'=>IMAGE_CONFIRM_YES,
	'IMAGE_CONFIRM_NO'=>IMAGE_CONFIRM_NO,
	'YES_HELP_CLUETIP_TITLE'=>YES_HELP_CLUETIP_TITLE,
	'default_quickoid'=>(int)$default_quickoid,
	'default_quickpid'=>(int)$default_quickpid,
	'ALLOW_QUICKMESSAGES_TIMER'=>( defined('ALLOW_QUICKMESSAGES_TIMER') and ALLOW_QUICKMESSAGES_TIMER != 'True') ? 'false' : 'true',
  'MODULE_OTHER_YES_HITMEISTER_API_STATUS'=>(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS')) ? MODULE_OTHER_YES_HITMEISTER_API_STATUS : 'false',
	'jquery_ui_css'=>$ui_css_link,
	'jquery'=>yes_get_cdn_link('jquery',$jquery_version),
	'jquery_ui'=>$ui_js_link,
        'local'=>(main::isDev(true))?true:false
    ));
    $smarty->display('header.html5.tpl');
    yes_draw_page_heading($smarty);
}

function yes_draw_page_heading($smarty){
    $smarty->clear_all_assign();
    global $messageStack;
    if(!class_exists('notiz')){
	    require_once(DIR_FS_CATALOG.'admin/includes/classes/class.notiz.php');
    }
    $mn = new main;
    $mn->add_message_stacks();   
    $unread = '';
    $smarty->assign('NOTICE_TERMIN_ARRAY_SIZE',0);
    if(get_session_notice_hidenote() == 0){
	$unread_count = notiz::count_unread_user_messages();
	if( $unread_count > 0){
	    $unread = sprintf(strip_tags(TEXT_HEADER_NOTICE_UNREAD),$unread_count);
	}
        if(isset($_SESSION['display_notizen_termine'])){
            $termin_count = 0;
        }else{
            $termin_count = notiz::count_termin_user_messages();
        }
	if( $termin_count > 0 and !strstr($_SERVER['PHP_SELF'],'notiz.php')){
	    $termin_array = notiz::get_termin_user_messages();
	    foreach($termin_array as $tk=>$tv){
		$termin_array[$tk]['link'] = xtc_href_link('notiz.php','action=view&id='.$tv['notes_id']);
		$termin_array[$tk]['capt'] = xtc_db_prepare_input($tv['capt']);
	    }
	    $smarty->assign(array(
		'NOTICE_TERMIN_INTRO'=>sprintf(TEXT_HEADER_NOTICE_TERMIN,$termin_count),
		'NOTICE_TERMIN_ARRAY_SIZE'=>sizeOf($termin_array),
		'NOTICE_TERMIN_ARRAY'=>$termin_array,
		'NOTICE_TERMIN_LINK_HREF'=>xtc_href_link('notiz.php','menugroup=tools'),
		'NOTICE_TERMIN_LINK_TEXT'=>TEXT_HEADER_MENU_NOTICE.' '.YES_LINKTEXT
	    ));
	}
    } // end if not hide notizen
    
    $messages = array();
    if($messageStack->size > 0){
	    $messages = $messageStack->errors;
    }
    
    // BOF - cron_ebay_order nicht genug V1
    if(STOCK_CHECK !== 'false'){
      $smarty->assign('EBAY_ORDERS_OOS',\YES4Trade\Model\ebay_orders_oos::get_items());
    }
    
    // EOF - cron_ebay_order nicht genug V1
    
    $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
    if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
        $smarty->assign('TEXT_FIBU_SHORT','FiBu Nr');
    }
    $notice_termin_set_read_later_link = '';
    if(isset($_SERVER['SCRIPT_URI'])){
        $notice_termin_set_read_later_link = $_SERVER['SCRIPT_URI'].'?'.xtc_get_all_get_params(array('guid','nt_action')).'nt_action=set_read_later';
    }
    // BOF - email_staff_allocations
    $query = xtc_db_query(sprintf(
            "SELECT count(email_staff_allocation_history_id) as anz FROM email_staff_allocation_history WHERE customers_id='%d' AND read_status=0",
            $_SESSION['customer_id']
    ));
    $record = xtc_db_fetch_array($query);
    $smarty->assign(array(
        'EMAIL_STAFF_ALLOCATION_COMMENTS_TITLE'=>sprintf(MSG_OPEN_EMAIL_STAFF_ALLOCATIONS,$record['anz']),
        'EMAIL_STAFF_ALLOCATION_COMMENTS_COUNT'=>(int)$record['anz']
    ));
    // EOF - EMAIL STAFF ALLOCATION
    $smarty->assign('EBAY_ORDER_RESERVATION_ITEMS_COUNT',\YES4Trade\Model\ebay_order_reservation::count());
    
    $smarty->assign(array(
      'LANGUAGE'=>$_SESSION['language'],
      'TEXT_ORDER_SHORT'=>TEXT_ORDER_SHORT,
      'TEXT_HEADER_CUSTOMERNAME'=>TEXT_HEADER_CUSTOMERNAME,
      'TEXT_HEADER_PRODUCT'=>TEXT_HEADER_PRODUCT,
      'startpage'=>(stristr($_SERVER["SCRIPT_FILENAME"],'start.php'))?'true':'false',
      'TEXT_DIALOG_CONFIRMATION'=>TEXT_DIALOG_CONFIRMATION,
      'CONFIRM_CREATE_NEW_ORDER'=>CONFIRM_CREATE_NEW_ORDER,
      'TEXT_HEADER_FEEDBACK'=>TEXT_HEADER_FEEDBACK,
      'MESSAGES'=>$messages,
      'MESSAGES_NUM'=>$messageStack->size,
      'UNREAD_MESSAGES_COUNT'=>$unread_count,
      'UNREAD_MESSAGES_STRING'=>$unread,
      'TEXT_HEADER_MENU_NOTICE'=>TEXT_HEADER_MENU_NOTICE,
      'IMAGE_PREVIEW'=>IMAGE_PREVIEW,
      'HTTP_SERVER'=>HTTP_SERVER,
      'STORE_NAME'=>STORE_NAME,
      'STORE_NAME_WITHOUT_DOUBLE_QUOTES'=>str_replace('"',"'",STORE_NAME),
      'EDITOR'=>$_SESSION['customer_first_name'].' '.$_SESSION['customer_last_name'],
      'EDITOR_WITHOUT_DOUBLE_QUOTES'=>str_replace('"',"'",$_SESSION['customer_first_name'].' '.$_SESSION['customer_last_name']),
      'LOGOUT_LINK'=>xtc_catalog_href_link('logoff.php'),
      'NAVIGATION'=>$mn->get_navigation( ),
      'TEXT_READ_LATER_INTRO'=>TEXT_READ_LATER_INTRO,
      'TEXT_READ_LATER'=>TEXT_READ_LATER,
      'TEXT_NOTICE_READ_LATER'=>TEXT_NOTICE_READ_LATER,
      'TEXT_MARK_SYSTEMMESSAGE_AS_READ'=>TEXT_MARK_SYSTEMMESSAGE_AS_READ,
      'notice_termin_set_read_later_link'=>$notice_termin_set_read_later_link,
      'TEXT_FIBU_SHORT'=>TEXT_FIBU_SHORT,
      'USE_GOOGLE_TRANSLATION'=>(defined('USE_GOOGLE_TRANSLATION'))?'1':''
    ));
    if(isset($_GET['shop'])){
        $smarty->assign('NO_ADMIN_MENU',1);
    }else{
        $smarty->assign('NO_ADMIN_MENU',false);
    }
    $smarty->display('page_heading.html5.tpl');
}

/**
 * Ueberall verwenden, wo ein delete von products stattfindet
 * Es werden nacheinander alle Artikel geprueft und bei Erfolg der "delete" Button
 * sichtbar geschaltet
 * @param Array $products_array - enthaelt alle zu pruefenden pID
 * @param type $delete_button_id - der eindeutige jquery Selector fuer den Delete button
 * @return html
 */
function yes_draw_multiple_products_delete_check( $products_array, $delete_button_id ){
    $smarty = new yesSmarty();
    $smarty->assign(array(
       'PRODUCTS' => $products_array,
       'MSG_ERROR_DELETE_PRODUCTS_ERRORS'=>MSG_ERROR_DELETE_PRODUCTS_ERRORS,
        'DELETE_BUTTON_ID'=>$delete_button_id,
        'DELETE_PRODUCTS_CHECK_INTRO'=>DELETE_PRODUCTS_CHECK_INTRO
    ));
    return $smarty->fetch('multiple_products_delete_check.tpl');
}
