<?php
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/customers.php');
$smarty->assign(array(
    'CUSTOMERS_ID'=>$crmID,
    'CRM_LINK'=>main::get_crm_link($crmID),
    'CNAME'=>$cInfo->customers_firstname . ' ' . $cInfo->customers_lastname,
    'CTEL'=>$cInfo->customers_telephone,
    'CCOMPANY'=>$cInfo->entry_company,
    'CMAIL'=>$cInfo->customers_email_address,
    'CSTREET'=>$cInfo->entry_street_address,
    'CFAX'=>$cInfo->customers_fax,
    'CZIP'=>$cInfo->entry_postcode,
    'CCITY'=>$cInfo->entry_city,
    'CCOUNTRY'=>xtc_get_country_name($cInfo->entry_country_id),
    'EBAYUSER'=>$cInfo->customers_ebay_userid,
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf'
));    
$main_content= $smarty->fetch(DIR_FS_ADMIN.'templates/crm_customers.html');
echo $main_content;

$rueckerstattung_array = array();
$rueck_query = xtc_db_query("SELECT rueckerstattungs_id FROM rueckerstattungen WHERE customers_id='".$crmID."' ORDER BY date_created DESC");
$num_ruecks = xtc_db_num_rows($rueck_query);
while($ruecks = xtc_db_fetch_array($rueck_query)){
	$rID = $ruecks['rueckerstattungs_id'];
	$rueckerstattung = new rueckerstattung($rID);

	$rueck_array[] = array(
		'RID'=>'<a target="_blank" href="'.xtc_href_link('rueckerstattungen.php','action=edit&rID='.$rueckerstattung->info['id']).'">'.$rueckerstattung->info['id'].'</a>',
		'OID'=>'<a target="_blank" href="'.xtc_href_link('orders.php','action=edit&oID='.$rueckerstattung->info['orders_id']).'">'.$rueckerstattung->info['orders_id'].'</a>',
		'RECID'=>(($rueckerstattung->info['reclamations_id'] > 0)?'<a target="_blank" href="'.xtc_href_link('reclamations.php','action=edit&rID='.$rueckerstattung->info['reclamations_id']).'">'.$rueckerstattung->info['reclamations_id'].'</a>':''),
		'DATE_TITLE'=>ENTRY_DATE_CREATED,
		'DATE'=>yes_strftime('%d.%m.%Y',strtotime( $rueckerstattung->info['date_created']) ),
		'BETRAG'=>number_format($rueckerstattung->info['betrag'],2,',',''),
		'STATUS'=>xtc_get_rueckerstattungen_status_name($rueckerstattung->info['status']),
		'PAYMODE'=>$rueckerstattung->info['paymode']
	);
}
if($num_ruecks > 0){
	$smarty->assign('rueckerstattung_data',$rueck_array);
	echo $smarty->fetch(DIR_FS_ADMIN.'templates/rueckerstattung_list.html');
}


$reclamations_array = array();
$rec_query = xtc_db_query("SELECT reclamations_id FROM reclamations WHERE customers_id='".$crmID."' ORDER BY date_created DESC");
$num_recs = xtc_db_num_rows($rec_query);
while($recs = xtc_db_fetch_array($rec_query)){
	$paydate = '';
	$rID = $recs['reclamations_id'];
	$reclamation = new reclamation($rID);
	$recs_products_array = array();
	for($i=0;$i<count($reclamation->products);$i++){
		$recs_products_array[] = array('QTY'=>$reclamation->products[$i]['qty'],
			'PRODUCTS_NAME'=>$reclamation->products[$i]['name'],
			'PRODUCTS_PRICE'=>number_format($reclamation->products[$i]['final_price'],2,',','.'),
			'PROPERTIES'=>$reclamation->products[$i]['properties']
		);
	}

	$getship_query = xtc_db_query("SELECT versender,DATE_FORMAT(date_finished,'%d.%m.%Y') as datum FROM shippings WHERE reclamations_id='".$rID."'");
	while( $getship = xtc_db_fetch_array($getship_query) ){
		$paydate .= '<br /><br />'.sprintf(TEXT_SHIPPED_WITH,$getship['versender'],$getship['datum']);
	}

	$reclamations_array[] = array(
		'OID'=>'<a target="_blank" href="'.xtc_href_link('orders.php','action=edit&oID='.$reclamation->info['orders_id']).'">'.$reclamation->info['orders_id'].'</a>',
		'RID'=>'<a target="_blank" href="'.xtc_href_link('reclamations.php','action=edit&rID='.$rID).'">'.$rID.'</a>',
		'DATE_CREATED_TITLE'=>ENTRY_DATE_CREATED,
		'DATE_CREATED'=>yes_strftime('%d.%m.%Y',strtotime( $reclamation->info['date_created']) ),
		'DATE_LAST_MODIFIED_TITLE'=>ENTRY_LAST_MODIFIED,
		'DATE_LAST_MODIFIED'=>($reclamation->info['last_modified'] > 0) ? yes_strftime('%d.%m.%Y',strtotime( $reclamation->info['last_modified']) ) : '',
		'STATUS'=>xtc_get_reclamations_status_name($reclamation->info['reclamations_status']),
		'TYPE'=>xtc_get_reclamations_types_name($reclamation->info['reclamations_type']),
		'products'=>$recs_products_array,
		'address'=>xtc_address_format($reclamation->delivery['format_id'], $reclamation->delivery, true,'',', ')
	);
}
if($num_recs > 0){
	$smarty->assign('reclamations_data',$reclamations_array);
	echo $smarty->fetch(DIR_FS_ADMIN.'templates/reclamation_list.html');
}

$retoure_array = array();
$ret_query = xtc_db_query("SELECT retoure_id FROM retouren WHERE customers_id='".$crmID."' ORDER BY date_created DESC");
$num_rets = xtc_db_num_rows($ret_query);
while($rets = xtc_db_fetch_array($ret_query)){
	$rID = $rets['retoure_id'];
	$retoure = new retoure($rID);
	$recs_products_array = array();
	for($i=0;$i<count($retoure->products);$i++){
		$rets_products_array[] = array('QTY'=>$retoure->products[$i]['qty'],
			'PRODUCTS_NAME'=>$retoure->products[$i]['name'],
			'PRODUCTS_PRICE'=>number_format($retoure->products[$i]['final_price'],2,',','.'));
	}

	$retoure_array[] = array(
	    'OID'=>'<a target="_blank" href="'.xtc_href_link('orders.php','action=edit&oID='.$retoure->info['orders_id']).'">'.$retoure->info['orders_id'].'</a>',
	    'recID'=>'<a target="_blank" href="'.xtc_href_link('reclamations.php','action=edit&rID='.$retoure->info['reclamations_id']).'">'.$retoure->info['reclamations_id'].'</a>',
	    'RID'=>'<a target="_blank" href="'.xtc_href_link('retoure.php','action=edit&rID='.$rID).'">'.$rID.'</a>',
	    'DATE_CREATED_TITLE'=>ENTRY_DATE_CREATED,
	    'DATE_CREATED'=>yes_strftime('%d.%m.%Y',strtotime( $retoure->info['date_created']) ),
	    'DATE_INITIATED_TITLE'=>'Eingeleitet:',
	    'DATE_INITIATED'=>($retoure->info['date_initiated'] > 0) ? yes_strftime('%d.%m.%Y',strtotime( $retoure->info['date_initiated']) ) : '',
	    'DATE_FINISHED_TITLE'=>'Geschlossen:',
	    'DATE_FINISHED'=>($retoure->info['date_finished'] > 0) ? yes_strftime('%d.%m.%Y',strtotime( $retoure->info['date_finished']) ) : '',
	    'SHIPPER'=>$retoure->info['versender'],
	    'STATUS'=>xtc_get_retoure_status_name($retoure->info['retoure_status']),
	    'products'=>$rets_products_array,
	    'address'=>xtc_address_format($reclamation->delivery['format_id'], $reclamation->delivery, true,'',', ')
	);
}
if($num_rets > 0){
    $smarty->assign('retoure_data',$retoure_array);
    echo $smarty->fetch(DIR_FS_ADMIN.'templates/retoure_list.html');
}

$orders_sum = array();
$orders_query = yes_query(
	"SELECT orders_id FROM orders WHERE customers_id=:id ORDER BY date_purchased DESC",[
		'id'=>intval($crmID),
	]
);
foreach($orders_query as $orders){
	$oID = $orders['orders_id'];
	$order = new order($oID);
	$orders_products_array = array();
	for($i=0;$i<count($order->products);$i++){
		$orders_products_array[] = array('QTY'=>$order->products[$i]['qty'],
			'PRODUCTS_NAME'=>$order->products[$i]['name'],
			'PRODUCTS_PRICE'=>number_format($order->products[$i]['final_price'],2,',','.'),
			'PRODUCTS_ID'=>$order->products[$i]['id']
		);
	}

	$table = new tableBlock();
	$contents = [];
	$table->table_parameters = ' style="width: auto;"';
	foreach($order->totals as $ot){
		if($ot['class'] == 'ot_total'){
			$orders_sum[ $order->info['orders_status'] ] += floatval($ot['value']);
			$total = $ot['text'];
		}
		$contents[] = [
			['text'=>$ot['title']],
			['text'=>$ot['text']],
		];
	}
	$total_str = $table->tableBlock_draw($contents);

	$table = new tableBlock();
	$table->table_parameters = ' style="width: auto;"';
	$contents = [[
		['text'=>TEXT_SHIPPING_ADDRESS,'params'=>'rowspan="6" valign="top"'],
		['text'=>'Name'],
		['text'=>$order->delivery['name']]
	],[
		['text'=>ENTRY_COMPANY],
		['text'=>$order->delivery['company']]
	],[
		['text'=>ENTRY_STREET_ADDRESS],
		['text'=>$order->delivery['street_address']]
	],[
		['text'=>ENTRY_SUBURB],
		['text'=>$order->delivery['suburb']]
	],[
		['text'=>ENTRY_POST_CODE.' '.ENTRY_CITY],
		['text'=>$order->delivery['postcode'].' '.$order->delivery['city']]
	],[
		['text'=>ENTRY_COUNTRY],
		['text'=>$order->delivery['country']]
	]];
	$delivery = $table->tableBlock_draw($contents);

	if($order->info['date_payment'] !== null and !empty($order->info['date_payment']) and $order->info['date_payment'] != '0000-00-00 00:00:00'){
		$paydate = sprintf('<br /><br />%s:<br />%s',
			DATE_PAYMENT_SAVED,
			yes_strftime('%d.%m.%y',strtotime($order->info['date_payment']))
		);
	}else{
		$paydate = '';
	}

	$getship_query = xtc_db_query("SELECT versender,DATE_FORMAT(date_finished,'%d.%m.%Y') as datum FROM shippings WHERE orders_id='".intval($oID)."'");
	while( $getship = xtc_db_fetch_array($getship_query) ){
		$paydate .= '<br /><br />'.sprintf(ORDER_SHIPPING_SUMMARY,
			$getship['versender'],$getship['datum']
		);
	}

	$MAHN = '';	
	if($order->info['orders_status'] != ORDERS_STATUS_STORNIERT){
		switch($order->info['warning_status']){
			case '0': $color = 'white'; $fcolor = 'black'; break;
			case '1': $color = 'yellow'; $fcolor = 'black'; $MAHN = WARNING_STATE_1; break;
			case '2': $color = 'orange'; $fcolor = 'black'; $MAHN = WARNING_STATE_2; break;
			case '3': $color = 'red'; $fcolor = 'white'; $MAHN = WARNING_STATE_3; break;
		}
	}else{
		$color = 'white';
		$fcolor = 'black';
	}
	$last_modified = yes_date_short($order->info['last_modified'],true);
	$orders_array[] = array('OID'=>'<a target="_blank" href="'.xtc_href_link('orders.php','action=edit&oID='.$oID).'" style="background-color:'.$color.';color:'.$fcolor.';" title="'.$MAHN.'" alt="'.$MAHN.'"><u>'.$oID.'</u></a>',
		'DATE'=>sprintf('<span class=smalltext>%s:<br />%s%s:<br />%s',
			TEXT_DATE_ORDER_PURCHASED,
			yes_date_short($order->info['date_purchased'],true),
			$paydate,
			(!empty($last_modified))?'<br />'.TEXT_DATE_ORDER_LAST_MODIFIED.':<br />'.$last_modified.'</span>' : ''
		),
		'FINAL_PRICE'=>$total_str,
		'SHIPPING_METHOD'=>$order->info['shipping_method'],
		'PAYMENT_METHOD'=>$order->info['payment_method'],
		'EBAYID'=>'<a target="_blank" href="'.xtc_get_ebay_link(xtc_get_auction_site($order->info['ebay_id'])).$order->info['ebay_id'].'">'.$order->info['ebay_id'].'</a>'.$select_str,
		'CHECK1'=>(($order->info['orders_status']=='1') ? 'check.gif' : 'uncheck.gif'),
		'CHECK2'=>(($order->info['orders_status']=='2') ? 'check.gif' : 'uncheck.gif'),
		'CHECK3'=>(($order->info['orders_status']=='3') ? 'check.gif' : 'uncheck.gif'),
		'CHECK4'=>(($order->info['orders_status']=='4') ? 'check.gif' : 'uncheck.gif'),
		'CHECK5'=>(($order->info['orders_status']=='5') ? 'check.gif' : 'uncheck.gif'),
		'CHECK6'=>(($order->info['orders_status']=='6') ? 'check.gif' : 'uncheck.gif'),
		'CHECK7'=>(($order->info['orders_status']=='7') ? 'check.gif' : 'uncheck.gif'),
		'CHECK8'=>(($order->info['orders_status']=='8') ? 'check.gif' : 'uncheck.gif'),

		'products'=>$orders_products_array,
		'address'=>$delivery
	);
	$query = xtc_db_query("SELECT ip.verwendungszweck1,ip.verwendungszweck2,ip.verwendungszweck4,ip.betrag,ip.buchungstag FROM payment_orders po,incoming_payments ip WHERE po.orders_id='".$oID."' and ip.id=po.payment_id");
	while($row = xtc_db_fetch_array($query)){
		$date_mysql = implode( '-', array_reverse( explode( '.', $row['buchungstag'] ) ) ) . ' 00:00:00';
		$msg[] = array('id'=>'payment','title'=>TEXT_INCOMING_PAYMENT_ENTRY.' '.number_format($row['betrag'],2,',','.').' '.DEFAULT_CURRENCY,'text'=>$row['verwendungszweck1'].'<br>'.$row['verwendungszweck2'].'<br>'.$row['verwendungszweck4'],'date'=>strtotime($date_mysql));
	}
}
$sum = '';
if(sizeOf($orders_sum)>0){
	$sum = '<table border="0" class="formArea" width="250">';
	foreach($orders_sum as $ostatus=>$ovalue){
		$sum .= '<tr><td class="main">'.xtc_get_orders_status_name($ostatus).':</td><td align="right" class="main">'.number_format($ovalue,2,',','').'</td></tr>';
	}
	$sum .= '</table>';
}
$smarty->assign('SUM',$sum);

$smarty->assign('order_data',$orders_array);



$items = \YES4Trade\Model\customers_memo::get_by_customers_id((int)$crmID);
$memos_array = [];
foreach($items as $it){
    $memos_array[] = array(
        'DATUM'=>$it->memo_date,
        'TITEL'=>$it->memo_title,
        'TEXT'=>$it->memo_text
    );
}
$smarty->assign('MEMOS',sizeOf($memos_array));
$smarty->assign(array('MEMO'=>$memos_array,
    'orders_paging_link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('orders_paging_link','cID')).'cID='.$crmID.'&orders_page=')
));
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$content = $smarty->fetch(DIR_FS_ADMIN.'templates/order_list.html');
echo $content;

require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/incoming_payments.php');
$rowcount=0;
$msg = array();
$query = xtc_db_query("SELECT ip.verwendungszweck1,ip.verwendungszweck2,ip.verwendungszweck4,ip.betrag,ip.buchungstag FROM payment_orders po,incoming_payments ip WHERE po.orders_id='".$oID."' and ip.id=po.payment_id");
while($row = xtc_db_fetch_array($query)){
	$date_mysql = implode( '-', array_reverse( explode( '.', $row['buchungstag'] ) ) ) . ' 00:00:00';
	$msg[] = array(
		'id'=>'payment',
		'title'=>TEXT_HEADER_MENU_PAYMENTS.' '.number_format($row['betrag'],2,',','.').' '.DEFAULT_CURRENCY,
		'text'=>$row['verwendungszweck1'].'<br>'.$row['verwendungszweck2'].'<br>'.$row['verwendungszweck4'],
		'date'=>strtotime($date_mysql)
	);
}

function masort(array &$data, string $sortby): void
{
	static $sort_funcs = [];

	if (empty($sort_funcs[$sortby])) {
		$keys = explode(',', $sortby);

		$sort_func = function ($a, $b) use ($keys) {
			foreach ($keys as $key) {
				if (!isset($a[$key]) || !isset($b[$key])) {
					continue;
				}

				if (is_numeric($a[$key]) && is_numeric($b[$key])) {
					if ($a[$key] != $b[$key]) {
						return ($a[$key] < $b[$key]) ? 1 : -1;
					}
				} else {
					$cmp = strcasecmp($a[$key], $b[$key]);
					if ($cmp !== 0) {
						return $cmp;
					}
				}
			}
			return 0;
		};

		$sort_funcs[$sortby] = $sort_func;
	}

	uasort($data, $sort_funcs[$sortby]);
}


masort($msg,'date');
$arr = $msg;

$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
$contents = [[
	['text'=>'Type','th'=>true],
	['text'=>TABLE_HEADING_PRICE,'th'=>true],
	['text'=>TABLE_HEADING_VWZ,'th'=>true],
	['text'=>TABLE_HEADING_DAY,'th'=>true],
]];
foreach($arr as $k=>$row){
	$contents[] = [
		['text'=>$row['id']],
		['text'=>$row['title']],
		['text'=>$row['text']],
		['text'=>yes_date_short($row['date'])]
	];
}
if(sizeOf($arr)){
	echo $table->tableBlock_draw($contents);
}
?>

			
		      </td>
		   </tr>
		   </table>
