<?php


/*
 * Meta Klasse um Bestaende in externen Marktplaetzen zu verwalten
 */

/**
 * Description of yes_external_marketplace
 *
 * @author mario
 */
class yes_external_marketplace {
    var $code, $title, $marketplace_class_name, $marketplace_class;
    function getCode() {
        return $this->code;
    }

    function getTitle() {
        return $this->title;
    }

    function setCode($code) {
        $this->code = $code;
    }

    function setTitle($title) {
        $this->title = $title;
    }
    
    function __construct(){
        self::check_requirements();
    }
    
    public function get_products_marketplaces_quantities( $products_id ){
        $SQ = new products_quantity($products_id);
        return array(
            'ebay'=>$SQ->auction_qty,
            'amazon'=>$SQ->amazon_qty,
            'hitmeister'=>$SQ->hitmeister_quantity, // muss erst implementiert werden
        );
    }
    
    function update_item_quantity(){
        
    }
    
    function get_item_quantity( $params ){
        
    }
    
    function update_item_price(){
        
    }
    
    function get_item_price(){
        
    }
    
    function getMarketplace_class_name() {
        return $this->marketplace_class_name;
    }

    function setMarketplace_class_name($marketplace_class_name) {
        $this->marketplace_class_name = $marketplace_class_name;
    }

    function getMarketplace_class() {
        return $this->marketplace_class;
    }

    function setMarketplace_class($marketplace_class) {
        $this->marketplace_class = $marketplace_class;
    }

    private static function check_requirements(){
        if(!class_exists('products_quantity')){
            require_once(realpath(__DIR__). DIRECTORY_SEPARATOR . 'class.storagequantity.php');
        }
        $needed_inc_functions = ['xtc_oe_get_price_o_tax',['xtc_oe_customer_info'=>'xtc_oe_customer_infos']];
        foreach($needed_inc_functions as $nf){
            $fn = is_array($nf) ? current(array_keys($nf)) : $nf;
            if(function_exists($fn)){
                continue;
            }
            $icf = is_array($nf) ? current($nf) : $nf;
            if(is_file(DIR_FS_INC.$icf.".inc.php")){
                require_once(DIR_FS_INC.$icf.".inc.php");
            }else{
                throw new Exception('Cant automatic include function '.$fn);
            }
        }
    }
    public function update_all_marketplaces_to_quantity($products_id, $quantity){
        foreach($this->get_products_marketplaces_quantities($products_id) as $mp=>$mp_qty){
            if($mp_qty > 0){
                $mp_inst_name = "yes_external_marketplace_$mp";
                $mp_inst = new $mp_inst_name;
                $mp_inst->update_marketplace_quantity($products_id, $quantity);
            }
        }
    }
}

$yem = new yes_external_marketplace;
$m = $yem->get_products_marketplaces_quantities(31601);
$yem->update_all_marketplaces_to_quantity(31601,4);

class yes_external_marketplace_ebay extends yes_external_marketplace{
    function __construct(){
        self::check_requirements();
        $this->setCode('ebay');
        $this->setTitle('eBay');
        $this->setMarketplace_class_name('ebayAPI');
        $marketplace_class = new ebayAPI;
        $this->setMarketplace_class($marketplace_class);
    }
    
   
    public function update_marketplace_quantity( int $products_id, int $target_quantity ){
        if($products_id < 1){
            return;
        }
        $in_collies = xtc_get_product_in_collies($products_id);        
        $auction_qty = \products_quantity::get_products_in_auction(intval($products_id));
        if($auction_qty < 1){
            return false;
        }
        
        print_r($in_collies);
        $query = xtc_db_query(sprintf(
                "SELECT id FROM ebay_auctions WHERE products_id='%d' AND status=0",
                $products_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $in_auctions_array[] = $record['id'];
        }
        foreach($in_auctions_array as $eaID){
            $ea = new ebay_auction($eaID);
            if(strtoupper(gettype($ea->getVariations())) != 'NULL' and sizeOf($ea->getVariations())){
                foreach($ea->getVariations() as $eav){
                    if($eav->getProductsId() == $products_id){
                        // HANDLING FUER VARIANTE

                    }else{
                        // HANDLING FUER Variante COLLIS
                        print_r($eav);

                    }
                }
            }else{
                if($ea->getProductsId() == $products_id){
                    // HANDLING FUER NORMALE AUKTION

                }else{
                    // HANDLING FUER COLLIS
                    if(!sizeOf($in_collies)){
                        printf("Error: Fuer pID %d existiert kein Colli und es ist nicht der Main Artikel\r\n",$products_id);
                        continue;
                    }
                    print_r($in_collies);
                    echo $ea->getQuantity()*$qty;
                }
            }
        }
        
    }
    
    private static function get_auction_data_from_ebay_id($ebay_id, $sku = null){
        $select_fields = 'ea.id';
        if($sku != Null and $sku != ''){
            $query = xtc_db_query(sprintf(
                    "SELECT %s FROM ebay_auctions ea LEFT JOIN ebay_auctions_variations eav ON ea.id=eav.ebay_auctions_id WHERE ea.ebay_id='%s' AND eav.sku='%s'",
                    $select_fields,$ebay_id, $sku
            ));
        }else{
            $query = xtc_db_query(sprintf(
                    "SELECT %s FROM ebay_auctions ea WHERE ea.ebay_id='%s'",
                    $select_fields,$ebay_id
            ));
        }
        if(!xtc_db_num_rows($query)){
            return [];
        }
        return xtc_db_fetch_array($query);
    }
    
    function get_item_quantity( $params ){
	// UNTERSCHEIDEN ZWISCHEN VARIATIONS UND/ODER FESTPREIS BZW AUKTION?
	$ea_id = self::get_auction_data_from_ebay_id($params['ebay_id']);
	$auction_info = new ebay_auction($ea_id['id']);
	switch($auction_info->getType()){
		case 'Chinese':
			break;
		default:
			break;
	}
	if($params['live'] === true){
		//$auction = self::get_auction_data_from_ebay_id($params['ebay_id'],$params['sku']);
		if(sizeOf($auction_info->getVariations())){
			if(!isset($params['sku']) or $params['sku'] === Null){
				throw new Exception('get quantity for a Variation Auction needs a sku');
			}
			$ebay_item = $this->marketplace_class->getItemCall(
				$params['ebay_id'], 
				$auction_info->getUser(), 
				$auction_info->getSite(),
				'Item.Quantity,Item.Variations.Variation'
			);
			foreach($ebay_item->Item->Variations->Variation as $v){
				if($v->SKU == $params['sku']){
					return $v->Quantity;
				}
			}
		}else{
			$ebay_item = $this->marketplace_class->getItemCall(
				$params['ebay_id'], 
				$auction_info->getUser(), 
				$auction_info->getSite(), 
				'Item.Quantity'
			);
			return $ebay_item->Item->Quantity;
		}
	}else{
		if(!isset($params['sku']) or $params['sku'] === Null){
			$query = xtc_db_query(sprintf(
				"SELECT quantity FROM ebay_auctions WHERE ebay_id='%s'",
				$params['ebay_id']
			));
		}else{
			$query = xtc_db_query(sprintf(
				"SELECT eav.quantity FROM ebay_auctions ea LEFT JOIN ebay_auctions_variations eav ON ea.id=eav.ebay_auctions_id WHERE ea.ebay_id='%s' and eav.sku='%s'",
				$params['ebay_id'],$params['sku']
			));
		}
		if(!xtc_db_num_rows($query)){
			return 0;
		}
		$record = xtc_db_fetch_array($query);
		return $record['quantity'];
	}
    }
    
    private static function check_requirements(){
        $needed_classes = ['ebayAPI'=>realpath(__DIR__). DIRECTORY_SEPARATOR . 'class.ebay.php',
            'ebay_auction'=>realpath(__DIR__). DIRECTORY_SEPARATOR . 'ebay_auction.php'];
        foreach($needed_classes as $nc=>$ncfile){
            if(!class_exists($nc)){
                $err = yes_getErrorReporting();
                if(file_exists($ncfile)){
                    error_reporting(E_ERROR);
                    require_once($ncfile);
                    error_reporting($err);
                }else{
                    throw new Exception('Cant include '.$ncfile);
                }
            }
        }
     
    }
}
//$eb = new yes_external_marketplace_ebay;
//echo $eb->get_item_quantity(['ebay_id'=>'164178975485', 'sku'=>Null]);

class yes_external_marketplace_amazon extends yes_external_marketplace{
    function __construct(){
        self::check_requirements();
        $this->setCode('amazon');
        $this->setTitle('Amazon');
    }
    
    function get_item_quantity( $params ){
        // da es bei amz keinen call gibt um einzeln bestaende abzufragen
        // sondern nur GetReports wo man den kompletten Bestand aller Artikel
        // bekommt, nehmen wir den lokalen Amazon Bestand in der Hoffnung
        // dass dieser aktuell ist
        $query = xtc_db_query(sprintf(
                "SELECT quantity FROM amazon_products WHERE asin='%d'",
                $params['asin']
        ));
        if(!xtc_db_num_rows($query)){
            return 0;
        }
        $record = xtc_db_fetch_array($query);
        return $record['quantity'];
    }
    
    private static function check_requirements(){
	require_once(realpath(__DIR__). DIRECTORY_SEPARATOR . '../config.amazonmws.inc.php');
        $needed_classes = ['amazon_helper'=>realpath(__DIR__). DIRECTORY_SEPARATOR . 'amz_Helper.php',
            'amazon_service'=>realpath(__DIR__). DIRECTORY_SEPARATOR . 'amz_Service.php'];
        foreach($needed_classes as $nc=>$ncfile){
            if(!class_exists($nc)){
                $err = yes_getErrorReporting();
                if(file_exists($ncfile)){
                    error_reporting(E_ERROR);
                    require_once($ncfile);
                    error_reporting($err);
                }else{
                    throw new Exception('Cant include '.$ncfile);
                }
            }
        }
     
    }
}

//$amz = new yes_external_marketplace_amazon;
//echo $amz->get_item_quantity(['asin'=>'B0831NZH2W']);


class yes_external_marketplace_real extends yes_external_marketplace{
    function __construct(){
        self::check_requirements();
        $this->setCode('real');
        $this->setTitle('Real');
        $this->setMarketplace_class_name('yes_hitmeister');
        $YH = new yes_hitmeister();
        $this->setMarketplace_class($YH->client);
    }
    
    function get_item_quantity( $params ){
        // ES GIBT KEINE LOKALE BESTANDSKOPIE
        $id_item = $this->getMarketplace_class_name()::get_id_item_from_products_id($params['products_id']);
        $unit = $this->getMarketplace_class()->units()->get($id_item);
        if(strtoupper(gettype($unit)) == 'NULL'){
                return 0;
        }
        return $unit->amount;
    }
    
    private static function check_requirements(){
        $needed_classes = ['yes_hitmeister'=>realpath(__DIR__). DIRECTORY_SEPARATOR . 'yes_hitmeister.php'];
        foreach($needed_classes as $nc=>$ncfile){
            if(!class_exists($nc)){
                $err = yes_getErrorReporting();
                if(file_exists($ncfile)){
                    error_reporting(E_ERROR);
                    require_once($ncfile);
                    error_reporting($err);
                }else{
                    throw new Exception('Cant include '.$ncfile);
                }
            }
        }
        $needed_functions = ['xtc_oe_get_price_o_tax','yes_end_auction_add','xtc_oe_customer_infos'];
        foreach($needed_functions as $nf){
            if(function_exists($nf)){
                continue;
            }
            $possible_inc_name = sprintf('%s.inc.php',$nf);
            if(file_exists(DIR_FS_INC.$possible_inc_name)){
                require_once(DIR_FS_INC.$possible_inc_name);
            }else{
                throw new Exception("Cant find&include Function $nf");
            }
        }
    }
}