<?php
class module_attachments {
    var $module;
    var $module_id;
    var $files;
    var $path;
    var $max_filesize_in_bytes = 4194304; // 4mb
    var $allowed_types = array(
	    'application/pdf','image/jpeg','image/pjpeg','image/gif','image/png','text/plain','application/msword','application/excel','application/vnd.ms-excel','application/x-excel','application/x-msexcel','application/x-compressed','application/x-zip-compressed','application/zip','multipart/x-zip','application/x-gzip','multipart/x-gzip','application/vnd.oasis.opendocument.text','application/vnd.ms-office','application/vnd.openxmlformats-officedocument.spreadsheetml.sheet','application/vnd.openxmlformats-officedocument.wordprocessingml.document'
    );
    var $sha1_dir;
    
    public function getModule() {
	return $this->module;
    }

    public function setModule($module) {
	$this->module = $module;
    }

    public function getModule_id() {
	return $this->module_id;
    }

    public function setModule_id($module_id) {
	$this->module_id = $module_id;
    }

    public function getFiles() {
	return $this->files;
    }

    public function setFiles($files) {
	$this->files = $files;
    }

    public function getPath() {
	return $this->path;
    }

    public function setPath($path) {
	$this->path = $path;
    }

    function __construct($module,$module_id){
		$this->setModule($module);
		$this->setModule_id($module_id);
		$this->sha1_dir = yes_get_sha1_from_string($this->getModule_id());
		$this->setPath(
			\main::get_importdata_path().'module_attachments/'.$this->getModule().'/'.$this->sha1_dir
		);
    }
    
    public function get_button_text(){
	$att = $this->get_attachments();
	if(!sizeOf($att))
	    return MODULE_ATTACHMENTS_BUTTON;
	else
	    return sizeOf($att).' '.MODULE_ATTACHMENTS_BUTTON;
    }
    public function get_button_link(){
	return xtc_href_link('start.php','action=module_attachments&module_id='.$this->getModule_id().'&module='.$this->getModule());
    }
    
    public function get_module_name(){
	switch($this->getModule()){
	    case 'distributor_order':
		return TEXT_DISTRIBUTOR_ORDER;
		break;
	    case 'order':
		return TEXT_ORDER;
		break;
	    case 'reclamation':
		return 'Reklamation';
		break;
	    default:
		return $this->getModule();
		break;
	}
    }
    
    private static function get_mime_type($file){
	// MIME TYPE PRUEFEN
	/*
	$finfo = finfo_open(FILEINFO_MIME_TYPE); // return mime type ala mimetype extension
	$mime_type = finfo_file($finfo, $file);
	finfo_close($finfo);
	 * 
	 */
	$filename = escapeshellcmd($file);
	$command = "file -b --mime-type -m /usr/share/misc/magic {$filename}";
	$mimeType = shell_exec($command);
        if($mimeType !== null){
            $mimeType = trim($mimeType);
        }
	return $mimeType;
    }
    public function upload($file){
	$mime_type = $this->get_mime_type($file['tmp_name']);
	if(!in_array($mime_type,$this->allowed_types)){
	    return array('ERROR'=>'File Type "'.$mime_type.'" not allowed');
	}
	// MAX SIZE PRUEFEN
	if($file['size'] > $this->max_filesize_in_bytes){
	    return array('ERROR'=>'File Size '.$this->formatBytes($file['size']).' not allowed (Max: '.$this->formatBytes($this->max_filesize_in_bytes).')');
	}
	$filename = $this->sanitize_filename($file['name']);
	$target_path = $this->get_target_path($filename);
	if (move_uploaded_file($file['tmp_name'], $target_path)){
	    return array('ERROR'=>'','FILE'=>basename($target_path));
	} else {
	    return array('ERROR'=>"Can't upload file $filename");
	}
    }
    private function formatBytes($size, $precision = 2){
	$base = log($size, 1024);
	$suffixes = array('', 'k', 'M', 'G', 'T');   

	return round(pow(1024, $base - floor($base)), $precision) . $suffixes[floor($base)];
    }
    
    private function get_target_path($filename){
		if(!is_dir(\main::get_importdata_path().'module_attachments')){
			mkdir(\main::get_importdata_path().'module_attachments');
		}
		if(!is_dir(\main::get_importdata_path().'module_attachments/'.$this->getModule())){
			mkdir(\main::get_importdata_path().'module_attachments/'.$this->getModule());
		}
		if(!is_dir(\main::get_importdata_path().'module_attachments/'.$this->getModule().'/'.$this->sha1_dir)){
			mkdir(\main::get_importdata_path().'module_attachments/'.$this->getModule().'/'.$this->sha1_dir);
		}
		$save_path = \main::get_importdata_path().'module_attachments/'.$this->getModule().'/'.$this->sha1_dir;
		if(file_exists($save_path.'/'.$filename)){
			$filename = $this->get_alternate_filename($save_path,$filename);
		}
		return $save_path.'/'.$filename;
    }
    
    private static function get_alternate_filename($path,$file){
	if ($pos = strrpos($file, '.')) {
	       $name = substr($file, 0, $pos);
	       $ext = substr($file, $pos);
	} else {
	       $name = $file;
	}
	$newpath = $path.'/'.$file;
	$newname = $file;
	$counter = 0;
	while (file_exists($newpath)) {
	       $newname = $name .'_'. $counter . $ext;
	       $newpath = $path.'/'.$newname;
	       $counter++;
	}
	return $newname;
    }
    
    public function get_attachments(){
	$files = array();
        if(!is_dir($this->getPath())){
            return $files;
        }
	if ($handle = opendir($this->getPath())){
	    while (false !== ($file = readdir($handle))) {
		if ($file != "." && $file != "..") {
		    $files[] = $file;
		}
	    }
	    closedir($handle);
	}
	return $files;
    }
    
    public function download($file){
	$mime_type = $this->get_mime_type($this->getPath().'/'.$file);
	header('Content-type: '.$mime_type);
	header("Content-Disposition: attachment; filename=\"$file\"");
	readfile($this->getPath().'/'.$file);
    }
    
    public function delete($file){
	unlink($this->getPath().'/'.$file);
    }
    
    private static function get_file_size($file){
	return filesize($file);
    }
    
    public function get_attachment_info($file){
	if(!is_file($this->getPath().'/'.$file)){
	    return array();
	}
	return array(
	    'mime_type'=>$this->get_mime_type($this->getPath().'/'.$file),
	    'size'=>$this->get_file_size($this->getPath().'/'.$file),
	    'path'=>$this->getPath().'/'.$file,
	    'file'=>$file
	);
    }
    
    public function get_attachment_content($file){
	return file_get_contents($this->getPath().'/'.$file);
    }
    
    function sanitize_filename($string, $force_lowercase = false, $anal = true) {
	$ext = pathinfo($string, PATHINFO_EXTENSION);
	$string = substr($string,0,strlen($string)-strlen($ext)-1);
	$strip = array("~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "=", "+", "[", "{", "]",
		       "}", "\\", "|", ";", ":", "\"", "'", "&#8216;", "&#8217;", "&#8220;", "&#8221;", "&#8211;", "&#8212;",
		       "�??", "�??", ",", "<", ".", ">", "/", "?");
	$clean = trim(str_replace($strip, "", strip_tags($string)));
	$clean = preg_replace('/\s+/', "-", $clean);
	$clean = ($anal) ? preg_replace("/[^a-zA-Z0-9]/", "", $clean) : $clean ;
	return ($force_lowercase) ?
	    (function_exists('mb_strtolower')) ?
		mb_strtolower($clean.'.'.$ext, 'UTF-8') :
		strtolower($clean.'.'.$ext) :
	    $clean.'.'.$ext;
	}
}