<?php
/* --------------------------------------------------------------
   $Id: message_stack.php,v 1.18 2017/02/14 06:10:22 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(message_stack.php,v 1.5 2002/11/22); www.oscommerce.com 
   (c) 2003	 nextcommerce (message_stack.php,v 1.6 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 

   Example usage:

   $messageStack = new messageStack();
   $messageStack->add('Error: Error 1', 'error');
   $messageStack->add('Error: Error 2', 'warning');
   if ($messageStack->size > 0) echo $messageStack->output();
  
   --------------------------------------------------------------*/

  class messageStack extends tableBlock {
    var $size = 0;

    function __construct() {

      $this->errors = array();

      if (isset($_SESSION['messageToStack'])) {
        for ($i = 0, $n = sizeof($_SESSION['messageToStack']); $i < $n; $i++) {
          $this->add($_SESSION['messageToStack'][$i]['text'], $_SESSION['messageToStack'][$i]['type']);
        }
        unset($_SESSION['messageToStack']);
      }
    }

    function add($message, $type = 'error') {
      if ($type == 'error') {
        $this->errors[] = array('params' => '', 'text' => $message,'ui_class'=>'ui-state-error','type_name'=>ICON_ERROR);
      } elseif ($type == 'warning') {
        $this->errors[] = array('params' => '', 'text' => $message,'ui_class'=>'ui-state-default','type_name'=>ICON_WARNING);
      } elseif ($type == 'success') {
        $this->errors[] = array('params' => '', 'text' => $message,'ui_class'=>'ui-state-highlight','type_name'=>ICON_SUCCESS);
      } else {
        $this->errors[] = array('params' => '', 'text' => $message,'ui_class'=>'ui-state-default','type_name'=>ICON_WARNING);
      }

      $this->size++;
    }

    function add_session($message, $type = 'error') {
      if (!isset($_SESSION['messageToStack'])) {
        $_SESSION['messageToStack'] = array();
      }

      $_SESSION['messageToStack'][] = array('text' => $message, 'type' => $type);
    }

    function reset() {
      $this->errors = array();
      $this->size = 0;
    }

	//mario
	function get_ui_html(){
		$string = '';
		for($i=0;$i<$this->size;$i++){
			$error = $this->errors[$i];
			switch($error['ui_class']){
				case 'ui-state-highlight':
					$ui_icon = 'info';
					break;
				default:
					$ui_icon = 'alert';
					break;
			}
			$hide = '';
			if($i>=3){
				$hide = 'display:none;';
			}
			$string .= sprintf(
				'<div class="messagestackitem %s ui-corner-all" style="padding: 0pt 0.3em;%s">
					<p class="super_smallText" style="margin-top:2px;margin-bottom:3px;"><span id="yesmessagestack_close" class="ui-icon ui-icon-%s" style="float: left; margin-right: 0.2em;"></span>
					%s: %s</p>
				</div>',
				$error['ui_class'],
				$hide,
				$ui_icon,
				$error['type_name'],
				$error['text']
			);
		}
		if($i>=3){
			$string .= '<a href="javascript:;" style="color:#FFF;background-color:#000;border:1px solid #555;" onclick="$(\'.messagestackitem\').show();$(this).hide();">'.TEXT_MESSAGESTACK_SHOW_ALL.'</a>';
			$string .= '&nbsp;';
		}
		return $string;
	}
    function output( $inline = false ) {
		$this->table_data_parameters = '';
		$close = '<a href="javascript:;" style="text-decoration:none;font-size:10px; color:#FFF;padding:1px;margin:1px;opacity:0%;" onclick="$(\'#messagestackcontainer\').hide();">'.TEXT_MESSAGESTACK_HIDE_ALL.'</a>';
		if(!$inline){
		    $string = sprintf('<div id="messagestackcontainer" style="position:absolute;top:40px;left:225px;width:700px;" class="ui-widget">%s%s</div>',
			    $close,$this->get_ui_html()
		    );
		}else{
		    $string = $this->get_ui_html();
		}
		return $string;

//      return $this->tableBlock($this->errors);
    }
  }
?>