<?php
class import_products_groups_allocations {
    const COLUMN_SEPARATOR = "\t";
    const ROW_SEPARATOR = "\r\n";
    var $header, $rows, $groups_id, $language_id, $group_characteristics;
    var $debug = false;
    
    public function __construct($file, $language_id = 2){
        $this->set_groups_id($this->extractGroupsIdFromFilename($file));
        $this->header = array();
        $this->rows = array();
        $this->language_id = $language_id;
        if (($handle = fopen($file, "r")) !== FALSE) {
            $row = 0;
            while (($data = fgetcsv($handle, 10000, self::COLUMN_SEPARATOR)) !== FALSE) {
                foreach($data as $k=>$v){
                    // SPALTE 1 IST DER ARTIKELNAME
                    if($k == 1){
                        continue;
                    }
                    if($row == 0){
                        $this->addHeaderColumn($v);
                    }else{
                        $this->addRowColumn($row,$v);
                    }
                }
                $row++;
            }
            fclose($handle);
        }else{
            throw new Exception('Cant read '.$file);
        }
    }
    
    public function set_group_characteristics(array $group_characteristics){
            $this->group_characteristics = $group_characteristics;
    }
    
    public function get_group_characteristics(){
        return $this->group_characteristics;
    }
    
    private function addHeaderColumn($value){
        $this->header[] = $value;
    }
    
    private function addRowColumn($row,$value){
        if(!isset($this->rows[ $row ])){
            $this->rows[ $row ] = array();
        }
        $this->rows[ $row ][] = $value;
    }
    
    private function extractGroupsIdFromFilename($file){
        $groups_id = (int) xtc_db_input(array_shift(explode('_', str_replace('YES_PRODUKTGRUPPENEXPORT_', '', basename($file)))));
        if ($groups_id < 1) {
            throw new Exception('Invalid filename ' . basename($file));
        }
        return $groups_id;
    }
    
    public function set_groups_id($id){
        $this->groups_id = $id;
    }
    
    public function get_groups_id(){
        return $this->groups_id;
    }
    
    public function get_header(){
        return $this->header;
    }
    
    public function get_rows(){ 
        return $this->rows;
    }
    
    public function checkData(){
        $group_characteristics_array = $this->get_group_characteristics();
        //if(!sizeOf($group_characteristics_array)){
        //    throw new Exception('Missing group_characteristics - use set_group_characteristics() before checkData()');
        //}
        foreach($group_characteristics_array as $k=>$gc){
            $gc_title = $gc->getDescription($this->language_id)->getTitle();
            if($this->header[$k+1] != $gc_title){
                return sprintf('Die Spalte "%s" existiert nicht an Position %s in der Importdatei. Erstellen Sie einen neuen aktuelleren Produktgruppenexport und importieren Sie diesen erneut.',
                        $gc_title, $k+2
                );
            }
        }

        // pruefen ob bei seteintraegen die richtigen Werte gespeichert wurden
        foreach($this->rows as $row_nr=>$row){
            foreach($row as $col_nr=>$column){
                if($col_nr == 0){ // pID
                    continue;
                }
                if(empty($column)){
                    continue;
                }
                if(!sizeOf($group_characteristics_array) or $group_characteristics_array[ $col_nr -1 ]->getNoSets() == 1){
                    continue;
                }

                if($group_characteristics_array[ $col_nr -1 ]->getNoSets() == 0){
                    $match = false;
                    foreach($group_characteristics_array[ $col_nr -1 ]->getSets() as $S){
                        if($S->getDescription($this->language_id)->getTitle() == $column){
                            $match = true;
                        }
                    }
                    if(!$match){
                        return sprintf('<li>pID %d: Unknown Setitem "%s" for "%s"',
                                $row[0],
                                $column,
                                $group_characteristics_array[ $col_nr -1 ]->getDescription($this->language_id)->getTitle()
                        );
                    }
                }
            }
        }
        return '';
    }

    private function import_noset($row_nr, $col_nr){
        if($this->debug) {
            printf('<li>import_noset(%d,%d) with value "%s"</li>',
                $row_nr, $col_nr, $this->rows[$row_nr][$col_nr]
            );
        }
        $group_characteristics = $this->get_group_characteristics();
        if($this->rows[$row_nr][$col_nr] == ''){
            if($this->debug) {
                printf('&nbsp;&nbsp;Eintrag loeschen<br />');
            }else{
                // kein wert, ggf Datensatz loeschen
                xtc_db_query(sprintf(
                    "DELETE FROM products_characteristic_text_values WHERE "
                    ."products_id='%s' "
                    ." AND products_characteristic_id='%s' "
                    ." AND language_id='%s'",
                    $this->rows[$row_nr][0],
                    // $group_characteristics hat eine Spalte weniger als $rows
                    // darum rechne ich -1
                    $group_characteristics[$col_nr-1]->getId(),
                    $this->language_id
                ));
            }
            return true;
        }else{
            // ist bereits ein eintrag vorhanden?
            $query = xtc_db_query(sprintf(
                "SELECT products_characteristic_text_values_id FROM products_characteristic_text_values WHERE "
                ."products_id='%s' "
                ." AND products_characteristic_id='%s' "
                ." AND language_id='%s'",
                $this->rows[$row_nr][0],
                // $group_characteristics hat eine Spalte weniger als $rows
                // darum rechne ich -1
                $group_characteristics[$col_nr-1]->getId(),
                $this->language_id
            ));
            if(!xtc_db_num_rows($query)){
                if($this->debug){
                    printf('&nbsp;&nbsp;<b>Neuer Eintrag</b> pID %d<br />',
                        $this->rows[$row_nr][0]
                    );
                }else{
                    // NEUEN EINTRAG ANLEGEN
                    $insert_sql_array = array(
                        'products_id'=>$this->rows[$row_nr][0],
                        'products_characteristic_id'=>$group_characteristics[$col_nr-1]->getId(),
                        'language_id'=>$this->language_id,
                        'content'=>$this->rows[$row_nr][$col_nr]
                    );
                    xtc_db_perform('products_characteristic_text_values',$insert_sql_array);
                }
                return true;
            }
            // vorhandenen Eintrag aktualisieren
            $record = xtc_db_fetch_array($query);
            $products_characteristic_text_values_id = $record['products_characteristic_text_values_id'];
            if($this->debug){
                printf('&nbsp;&nbsp;<b>Update</b> pID %d<br />',
                    $this->rows[$row_nr][0]
                );
            }else{
                $update_sql_array = array(
                    'content'=>$this->rows[$row_nr][$col_nr]
                );
                xtc_db_perform('products_characteristic_text_values',$update_sql_array, 'update', 
                    "products_id='".$this->rows[$row_nr][0]."' "
                    ." AND products_characteristic_text_values_id='".$products_characteristic_text_values_id."'"
                );
            }
            return true;
        }
    }
    
    private function import_set($row_nr, $col_nr){
        if($this->debug) {
            printf('<li>import_set(%d,%d) with value "%s"</li>',
                $row_nr, $col_nr, $this->rows[$row_nr][$col_nr]
            );
        }
        $group_characteristics = $this->get_group_characteristics();
        $products_characteristic_set_id = 0;
        $products_to_characteristics_id = 0;
        
        if(empty($this->rows[$row_nr][$col_nr])){
            if($this->debug){
                printf('&nbsp;&nbsp;Loesche SET Eintrag fuer pID %d Lang %d<br />',
                        $this->rows[$row_nr][0],
                        $this->language_id
                );
            }else{
                $products_characteristic_set_id_array = array();
                foreach($group_characteristics[$col_nr-1]->getSets() as $s){
                    $products_characteristic_set_id_array[] = $s->getId();
                }
                xtc_db_query(sprintf(
                    "DELETE FROM products_to_characteristics WHERE "
                    ." products_id='%d'"
                    ."AND products_characteristic_set_id IN(%s)",
                    $this->rows[$row_nr][0],
                    implode(',',$products_characteristic_set_id_array)
                ));
            }
            // loeschen
            return true;
        }
        
        // PRUEFEN OB DER EINTRAG BESTANDTEIL DER SETWERTE DES
        // MERKMALS IST
        foreach($group_characteristics[$col_nr-1]->getSets() as $set){
            if($set->getDescription($this->language_id)->getTitle() == $this->rows[$row_nr][$col_nr]){
                $products_characteristic_set_id = $set->getId();
            }
        }
        if($products_characteristic_set_id < 1){
            // darf eigentlich nicht passieren, da wir das vorher checken
            throw new Exception(sprintf(
                'Unbekannte products_characteristic_set_id pID %d Spalte %d',
                $this->rows[$row_nr][0],
                $col_nr
            ));
        }

        $query = xtc_db_query(sprintf(
                "SELECT title FROM products_characteristic_description WHERE language_id='%d' AND products_characteristic_id='%d'",
                $this->language_id,
                $group_characteristics[$col_nr-1]->getId()
        ));
        $record = xtc_db_fetch_array($query);
        $char_title = $record['title'];
        if($this->debug){
                printf('&nbsp;&nbsp;products_characteristic_set_id: %s - %s<br />',
                    $products_characteristic_set_id,$char_title
                );
        }
                    
        $products_characteristic_set_id_array = array();
        $query = xtc_db_query(sprintf(
            "SELECT pcs.products_characteristic_set_id,pcsd.title FROM products_characteristic_set pcs LEFT JOIN products_characteristic_set_description pcsd USING(products_characteristic_set_id) WHERE products_characteristic_id='%d' AND pcsd.language_id='%d'",
            $group_characteristics[$col_nr-1]->getId(),
            $this->language_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $products_characteristic_set_id_array[] = $record['products_characteristic_set_id'];
        }
        if(!sizeOf($products_characteristic_set_id_array)){
            throw new Exception(sprintf(
                'Keine SET Werte fuer pID %d Spalte %d',
                $this->rows[$row_nr][0],
                $col_nr
            ));
        }

        $query = xtc_db_query(sprintf(
                "SELECT products_to_characteristics_id FROM products_to_characteristics WHERE products_id='%d' AND products_characteristic_set_id IN(%d)",
                $this->rows[$row_nr][0],
                implode(',',$products_characteristic_set_id_array)
        ));
        $record = xtc_db_fetch_array($query);
        $products_to_characteristics_id = $record['products_to_characteristics_id'];
        if($products_to_characteristics_id < 1){
            if($this->debug){
                printf('&nbsp;&nbsp;<b>Neuer Seteintrag</b> pID %d',
                    $this->rows[$row_nr][0]
                );
            }else{
                $insert_sql_array = array(
                    'products_characteristic_set_id'=>$products_characteristic_set_id,
                    'products_id'=>$this->rows[$row_nr][0]
                );
                xtc_db_perform('products_to_characteristics',$insert_sql_array);
            }
            return true;
        }
        if($this->debug){
            printf('&nbsp;&nbsp;<b>Update</b> pID %s / %s',
                $this->rows[$row_nr][0],
                $group_characteristics[$col_nr-1]->getDescription($this->language_id)->getTitle()
            );
        }else{
            $update_sql_array = array(
                'products_characteristic_set_id'=>$products_characteristic_set_id
            );
            xtc_db_perform('products_to_characteristics',$update_sql_array,'update',
                    "products_id='".$this->rows[$row_nr][0]
                    ."' AND products_to_characteristics_id='".$products_to_characteristics_id."'"
            );
        }
    }
    
    public function import(){
        $group_characteristics = $this->get_group_characteristics();
        foreach($this->get_rows() as $k=>$row){
            if($this->debug) {
                printf('<b>import() row %d pID %s</b><br />',
                        $k,
                        $row[0]
                );
            }
            foreach($row as $kc=>$column){
                if($kc == 0){
                    continue;
                }
                if($group_characteristics[$kc-1]->getNoSets() == 1){
                    $this->import_noset($k,$kc);
                }else{
                    $this->import_set($k,$kc);
                }
            }
        }
        
    }
}
