<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'distributor_invoice.php');
require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'distributor_order.php');
class distributor {
    var $info,$editor_id,$products;

    function __construct($distributor_id) {
        global $_SESSION;
        $this->info = array();
        $this->query(intval($distributor_id));
        $this->editor_id = $_SESSION['customer_id'];
    }

    function query($distributor_id) {
		$distributor_query = xtc_db_query(sprintf(
            "select * from distributors d where id = '%d'",
            intval($distributor_id)
        ));
        if(!xtc_db_num_rows($distributor_query)){
           throw new Exception("Invalid distributor_id $distributor_id");
        }
	$distributor = xtc_db_fetch_array($distributor_query);

	$this->info = array(
            'id'=>$distributor['id'],
            'name'=>$distributor['name'],
            'telefon'=>$distributor['telefon'],
            'fax'=>$distributor['fax'],
            'email'=>$distributor['email'],
            'homepage'=>$distributor['homepage'],
            'strasse'=>$distributor['strasse'],
            'plz'=>$distributor['plz'],
            'ort'=>$distributor['ort'],
            'land'=>$distributor['land'],
            'memo'=>$distributor['memo'],
            'kundennummer'=>$distributor['kundennummer'],
            'account_type'=>$distributor['account_type'],
            'tax_orders'=>$distributor['tax_orders'],
            'default_delivery_storage_id'=>$distributor['default_delivery_storage_id'],
            'payment_terms'=>$distributor['payment_terms']
        );
    }

    function get_products(){
        $products = array();
	$distributor_products_query = xtc_db_query(sprintf(
            "SELECT pd.*,p.products_quantity FROM `products_distributors` pd JOIN products p USING(products_id) WHERE pd.distributor_id='%d'",
            $this->info['id']
        ));
        $_tmp = [];
	while($distributor_products = xtc_db_fetch_array($distributor_products_query)){
            $_tmp[] = $distributor_products;
        }
        foreach($_tmp as $distributor_products){
            $products[] = array(
                'id'=>$distributor_products['id'],
                'products_id'=>$distributor_products['products_id'],
                'number'=>$distributor_products['distributor_products_number'],
                'comments'=>$distributor_products['comments'],
                'link'=>$distributor_products['distributor_products_link'],
                'mindestbestellmenge'=>$distributor_products['mindestbestellmenge'],
                'ek'=>$this->get_products_ek($distributor_products['products_id']),
                'products_quantity'=>$distributor_products['products_quantity']
            );
        }
        return $products;
    }

    function get_products_ek($pID){
        $ek = array();
        $nr=0;
        $distributor_product_prices_query = xtc_db_query(sprintf(
            "SELECT * FROM distributor_product_prices WHERE distributor_id='%d' and products_id='%d'",
            $this->info['id'], $pID
        ));
        while($distributor_product_prices = xtc_db_fetch_array($distributor_product_prices_query)){
            $ek[$nr] = array(
                'price'=>$distributor_product_prices['price'],
                'conditions'=>$distributor_product_prices['conditions'],
                'shippings'=>$distributor_product_prices['shippings'],
                'vpe'=>$distributor_product_prices['vpe'],
                'vpe_width'=>$distributor_product_prices['vpe_width'],
                'vpe_height'=>$distributor_product_prices['vpe_height'],
                'vpe_depth'=>$distributor_product_prices['vpe_depth'],
                'vse'=>$distributor_product_prices['vse'],
                'is_default'=>$distributor_product_prices['is_default'],
                'date_saved'=>$distributor_product_prices['date_saved']
            );
            $ek[$nr]['shipping_status_id'] = $distributor_product_prices['shipping_status_id'];
            $nr++;
        }
        return $ek;
    }

    function get_default_delivery_storage_address(){
        if($this->info['default_delivery_storage_id'] > 0){
            $query = xtc_db_query(sprintf(
                "SELECT storage_name,storage_street_address,storage_city,storage_postcode,storage_country,storage_telephone,storage_company,storage_suburb FROM storages WHERE id='%d'",
                $this->info['default_delivery_storage_id']
            ));
        }else{
            $query = xtc_db_query(
                "SELECT storage_name,storage_street_address,storage_city,storage_postcode,storage_country,storage_telephone,storage_company,storage_suburb FROM storages ORDER BY default_storage DESC,name ASC LIMIT 1"
            );
        }
        $record = xtc_db_fetch_array($query);
        return $record;
    }
	
	function new_order( $orders_id = 0){
		$delivery_address = $this->get_default_delivery_storage_address();
	        $sql_data_array = array('distributor_id' => $this->info['id'],
			'distributor_name' => $this->info['name'],
			'distributor_street_address' => $this->info['strasse'],
			'distributor_city' => $this->info['ort'],
			'distributor_postcode' => $this->info['plz'],
			'distributor_telephone' => $this->info['telefon'],
			'distributor_country' => $this->info['land'],
			'distributor_email_address' => $this->info['email'],
			'comments' => '',
			'last_modified' => 'now()',
			'date_created' => 'now()',
			'orders_status' => '1',
			'orders_date_finished' => '',
			'currency' => DEFAULT_CURRENCY,
			'currency_value' => '1.0000',
			'account_type' => '0',
			'delivery_company'=>$delivery_address['storage_company'],
			'delivery_name'=>$delivery_address['storage_name'],
			'delivery_street_address'=>$delivery_address['storage_street_address'],
			'delivery_suburb'=>$delivery_address['storage_suburb'],
			'delivery_postcode'=>$delivery_address['storage_postcode'],
			'delivery_city'=>$delivery_address['storage_city'],
			'delivery_country'=>xtc_get_country_name($delivery_address['storage_country']),
			'language' => 'german',
			'orders_id'=>$orders_id,
			'payment_terms'=>$this->info['payment_terms']
		);

		xtc_db_perform('distributor_orders', $sql_data_array);
		$orders_id = xtc_db_insert_id();

		$sql_data_array = array('orders_id' => $orders_id,
			'title' => '<b>Summe</b>:',
			'text' => '0',
			'value' => '0',
			'sort_order' => MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER,
			'class' => 'ot_total');
		xtc_db_perform('distributor_orders_total', $sql_data_array);

		$sql_data_array = array('orders_id' => $orders_id,
			'title' => '<b>Zwischensumme</b>:',
			'text' => '0',
			'value' => '0',
			'sort_order' => MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER,
			'class' => 'ot_subtotal');
		xtc_db_perform('distributor_orders_total', $sql_data_array);

		// MARIO: commentar wers angelegt hat
                \distributor_order::insert_history_static(intval($orders_id), 
                        1, false, 'Neue Bestellung zum Lieferanten angelegt.'
                );
		return $orders_id;
	}

	function new_invoice(){
		$sql_data_array = array('distributor_id' => $this->info['id'],
			'distributor_name' => $this->info['name'],
			'distributor_street_address' => $this->info['strasse'],
			'distributor_city' => $this->info['ort'],
			'distributor_postcode' => $this->info['plz'],
			'distributor_telephone' => $this->info['telefon'],
			'distributor_country' => $this->info['land'],
			'distributor_email_address' => $this->info['email'],
			'last_modified' => 'now()',
			'from_date'=>'now()',
			'currency'=>DEFAULT_CURRENCY,
			'date_created' => 'now()',
			'status' => '1',
		    'payment_terms'=>$this->info['payment_terms']
		);

		xtc_db_perform('distributor_invoices', $sql_data_array);
		$orders_id = xtc_db_insert_id();

		$sql_data_array = array('distributor_invoices_id' => $orders_id,
			'title' => '<b>Summe</b>:',
			'text' => '0',
			'value' => '0',
			'sort_order' => MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER,
			'class' => 'ot_total');
		xtc_db_perform('distributor_invoices_total', $sql_data_array);

		$sql_data_array = array('distributor_invoices_id' => $orders_id,
			'title' => '<b>Zwischensumme</b>:',
			'text' => '0',
			'value' => '0',
			'sort_order' => MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER,
			'class' => 'ot_subtotal');
		xtc_db_perform('distributor_invoices_total', $sql_data_array);
                \distributor_invoice::insert_history_static(intval($orders_id),
                    1, false, 'Neue Rechnung zum Lieferanten angelegt.'
                );
		return $orders_id;
	}

	public function get_open_order_products($valid_orders_statuses){
			//
			// PIDs DER COLLIES IN STKLISTEN ARTIKELN ERMITTELN
			$_collies = array(); // TMP ARRAY UM DOPPELQUERIES ZU VERMEIDEN
			$products_array = array();
			$open_stklisten_query_raw = sprintf("SELECT op.products_id,op.products_quantity
				 FROM orders_products op LEFT JOIN products_collies pc USING(products_id)
				 LEFT JOIN products_distributors pd USING(products_id), orders o
				 WHERE o.orders_id = op.orders_id AND o.orders_status NOT IN (%s) AND
				 pc.products_id IS NOT NULL AND pd.distributor_id='%s'
				 GROUP BY op.orders_products_id",
				$valid_orders_statuses,
				$this->info['id']
			);

			$open_stklisten_query = xtc_db_query($open_stklisten_query_raw);
			while($open_stklisten = xtc_db_fetch_array($open_stklisten_query)){
				$pID = $open_stklisten['products_id'];
				$qty = $open_stklisten['products_quantity'];
				if(!$_collies[$pID]){
					$collies = xtc_get_product_collies($pID);
					$_collies[$pID] = $collies;
				}
				foreach($_collies[$pID] as $colli){
					$products_array[$colli['collie_products_id']] += ($qty*$colli['quantity']);
				}
			}
			$open_query_raw = sprintf("select SUM(op.products_quantity) as open,p.products_id
					 from products p LEFT JOIN orders_products op USING(products_id) LEFT JOIN orders o USING(orders_id),
					 products_distributors pdi
					 LEFT JOIN products_collies pc on pc.products_id=pdi.products_id
					 where p.products_quantity <= p.products_meldebestand and pc.products_id is null
					 and pdi.products_id=p.products_id and pdi.distributor_id='%s'
					 and o.orders_status NOT IN (%s)
					 group by op.products_id",
				$this->info['id'],
				$valid_orders_statuses
			);
			$open_query = xtc_db_query($open_query_raw);
			while($open = xtc_db_fetch_array($open_query)){
				$pID = $open['products_id'];
				$qty = $open['open'];
				$products_array[$pID] += $qty;
			}
			return $products_array;
	}
	function get_distributor_orders_quantity($pID,$valid_orders_statuses,$remove_qty_rueckbuch=false){
		$ordered_query_raw = sprintf("SELECT SUM(dop.products_quantity %s) as ordered
				 FROM distributor_orders_products dop
				 LEFT JOIN distributor_orders do USING(distributor_orders_id)
				 WHERE dop.products_id='%s' AND do.orders_status IN (%s)",
			($remove_qty_rueckbuch) ? '- qty_rueckbuch ' : '',
			$pID,
			implode(',',$valid_orders_statuses)
		);
		$ordered_query = xtc_db_query($ordered_query_raw);
		$ordered_record = xtc_db_fetch_array($ordered_query);
		return (int)$ordered_record['ordered'];
	}

	public function get_orders_count(){
		$query = yes_query(
			"SELECT distributor_orders_id FROM distributor_orders WHERE distributor_id=:did",[
				'did'=>$this->info['id']
			]
		);
		return (is_countable($query))?sizeof($query):0;
	}

	public function get_invoices_count(){
		$query = yes_query(
			"SELECT distributor_invoices_id FROM distributor_invoices WHERE distributor_id=:did",[
				'did'=>$this->info['id']
			]
		);
		return (is_countable($query))?sizeof($query):0;
	}
}
