<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
class products_sql{
  var $customers_id;
  var $search_string;
  var $category_id = 0;
  var $manufacturers_id = -1;
  var $distributors_id = -1;
  var $groups_id = -1;
  var $csets = array();
  var $noset_pcID = array();
  var $excludes = array();
  var $search = false;
  var $length_error;
  var $cart_id = -1;
  var $null_qty = -1;
  var $warengruppe_id = -1;
  var $asin = '';
  var $only_active = false;
  var $fakesets = false;
  var $av_filter = false;
  var $default_storage = -1;
  var $search_in_category = true;
  var $has_cart_items = Null;
  var $un_classifications_id = 0;
  
  function __construct($cid){
  	global $_GET;
	$this->set_customers_id($cid);
	
	if( !defined('SEARCHWORD_MIN_LENGTH') or (int) SEARCHWORD_MIN_LENGTH == 0 ) @define('SEARCHWORD_MIN_LENGTH',5);

	// KATEGORIESUCHE
	if(isset($_GET['cPath']) and $_GET['cPath'] != ''){
		$this->set_category_id( $this->get_category_id_from_cPath($_GET['cPath']) );
	}else{
		$this->set_category_id( -1 );
	}
	
	if(isset($_GET['search_category']) and $_GET['search_category'] != ''){
		$this->search = true;
		$this->set_search_string( $_GET['search_category'] );
		if(strlen(trim($_GET['search_category'])) < SEARCHWORD_MIN_LENGTH )
			$this->length_error = true;
	}
	
	// HERSTELLERSUCHE
	if(isset($_GET['manufacturers_id']) and $_GET['manufacturers_id'] != ''){
		$this->set_manufacturers_id( $_GET['manufacturers_id'] );
		if(!isset($_REQUEST['cPath'])){
			$this->set_category_id( -1 );
		}
	}

	// LIEFERANTENSUCHE
	if(isset($_GET['distributors_id']) and $_GET['distributors_id'] != ''){
		$this->set_distributors_id( $_GET['distributors_id'] );
	}
	
	if(isset($_GET['search_manufacturer']) and $_GET['search_manufacturer'] != ''){
		$this->search = true;
		$this->set_search_string( $_GET['search_manufacturer'] );
		if(strlen(trim($_GET['search_manufacturer'])) < SEARCHWORD_MIN_LENGTH )
			$this->length_error = true;
	}
	
	if(isset($_GET['search_fakeset']) and $_GET['search_fakeset'] != ''){
		$this->search = false;
		$this->set_search_string( $_GET['search_fakeset'] );
		$this->set_fakesets(true);
		if(strlen(trim($_GET['search_fakeset'])) < SEARCHWORD_MIN_LENGTH )
			$this->length_error = true;
	}
	
	if(isset($_GET['search_distributor']) and $_GET['search_distributor'] != ''){
		$this->search = true;
		$this->set_search_string( $_GET['search_distributor'] );
		if(strlen(trim($_GET['search_distributor'])) < SEARCHWORD_MIN_LENGTH )
			$this->length_error = true;
	}

	if(isset($_GET['warengruppe_id']) and $_GET['warengruppe_id']>0){
		$this->set_category_id( -1 );
		$this->warengruppe_id = (int)xtc_db_input($_GET['warengruppe_id']);
	}
	if(isset($_GET['search_warengruppe']) and $_GET['search_warengruppe'] != ''){
		$this->search = true;
		$this->set_category_id( -1 );
		$this->set_search_string( $_GET['search_warengruppe'] );
		if(strlen(trim($_GET['search_warengruppe'])) < SEARCHWORD_MIN_LENGTH )
			$this->length_error = true;
	}
        
	if(isset($_GET['has_cart_items_filter']) and $_GET['has_cart_items_filter'] != '') {
		$hci = ($_GET['has_cart_items_filter'] == 1) ? 1 : 0;
		$this->setHas_cart_items($hci);
	}

	if(isset($_GET['un_classifications_id']) and intval($_GET['un_classifications_id']) > 0){
		$this->un_classifications_id = intval($_GET['un_classifications_id']);
	}
	
	// PRODUKTGRUPPENSUCHE
	if(isset($_GET['groups_id']) and $_GET['groups_id'] != ''){
		$this->set_groups_id( (int)xtc_db_input($_GET['groups_id'] ));
		$chars_query = xtc_db_query("SELECT products_characteristic_id FROM products_characteristic WHERE groups_id='".(int)xtc_db_input($_GET['groups_id'])."'");
		while($chars = xtc_db_fetch_array($chars_query)){
			$C = new products_characteristic($chars['products_characteristic_id']);
			if(sizeOf($C->get_characteristic_sets())>0){
			    if(isset($_GET['set_'.$C->get_products_characteristic_id()]) and !is_array($_GET['set_'.$C->get_products_characteristic_id()]) and $_GET['set_'.$C->get_products_characteristic_id()] > 0){
				foreach($C->get_characteristic_sets() as $k=>$SET){
					$pcsID = $SET->get_products_characteristic_set_id();
					if($pcsID == $_GET['set_'.$C->get_products_characteristic_id()]){
						$this->set_csets($pcsID);
					}
				}
			    }else if(isset($_GET['set_'.$C->get_products_characteristic_id()]) and is_array($_GET['set_'.$C->get_products_characteristic_id()]) and sizeOf($_GET['set_'.$C->get_products_characteristic_id()]) > 0){
				foreach($_GET['set_'.$C->get_products_characteristic_id()] as $setID){
				    $setID = (int)xtc_db_input($setID);
				    foreach($C->get_characteristic_sets() as $k=>$SET){
					    $pcsID = $SET->get_products_characteristic_set_id();
					    if($pcsID == $setID){
						    $this->set_csets($pcsID);
					    }
				    }
				}
			    }
			}
			if(isset($_GET['noset_id']) and sizeOf($_GET['noset_id'])){
			    foreach($_GET['noset_id'] as $noset_id){
				if($noset_id == $C->get_products_characteristic_id() ){
				    $this->noset_pcID[] = $C->get_products_characteristic_id();
				}
			    }
			}
		}
	}
	
	if(isset($_GET['search_groups']) and $_GET['search_groups'] != ''){
		$this->search = false;
		$this->set_search_string( $_GET['search_groups'] );
		if(strlen(trim($_GET['search_groups'])) < SEARCHWORD_MIN_LENGTH )
			$this->length_error = true;
	}
	
	if(isset($_GET['search']) and $_GET['search'] != ''){
		$this->search = true;
		$this->set_category_id( -1 );
		$this->set_search_string( $_GET['search'] );
		if(strlen(trim($_GET['search'])) < SEARCHWORD_MIN_LENGTH )
			$this->length_error = true;
	}
	
	if(isset($_GET['cart_id']) and $_GET['cart_id'] != ''){
		$this->search = false;
		$this->set_category_id( -1 );
		$this->set_cart_id($_GET['cart_id']);
	}
	if(isset($_GET['null_qty_filter'])){
		$this->null_qty = (int)xtc_db_input($_GET['null_qty_filter']);
	}
	
	if(isset($_GET['av_filter']) and $_GET['av_filter'] == 1){
		$this->av_filter = 1;
	}
	
	if(isset($_GET['products_status']) and $_GET['products_status'] == 1){
		$this->only_active = true;
	}
	
	if(isset($_GET['asin']) and $_GET['asin'] != ''){
	    $this->set_category_id( -1 );
	    $this->setAsin( xtc_db_input($_GET['asin']) );
	}
  	if(isset($_GET['default_storage']) and (int)$_GET['default_storage'] >= 0){
            $this->setDefault_storage((int)xtc_db_input($_GET['default_storage']));
	    $this->set_category_id( -1 );
	}
  }
  
  public function getAsin() {
      return $this->asin;
  }

  public function setAsin($asin) {
      $this->asin = $asin;
  }

  function set_manufacturers_id($value){
  	$this->manufacturers_id = (int)$value;
  }
  
  function get_manufacturers_id() {
  	return $this->manufacturers_id;
  }
  
  function set_distributors_id($value){
  	$this->distributors_id = (int)$value;
  }
  
  function get_distributors_id() {
  	return $this->distributors_id;
  }
  
  function set_groups_id($value){
  	$this->groups_id = (int)$value;
  }
  
  function get_groups_id() {
  	return $this->groups_id;
  }
  
  function set_search_string($value){
  	$this->search_string = $value;
  }
  
  function get_search_string() {
  	return $this->search_string;
  }
  
  function set_category_id($value){
  	$this->category_id = (int)$value;
  }
  
  function get_category_id() {
  	return $this->category_id;
  }
  
  function set_show_categories($value){
  	$this->show_categories = $value;
  }
  
  function get_show_categories() {
  	return $this->show_categories;
  }
  
  function set_customers_id($value){
  	$this->customers_id = (int)$value;
  }
  
  function get_customers_id() {
  	return $this->customers_id;
  }
  
  function set_excludes($value){
  	$this->excludes[] = $value;
  }
  
  function get_excludes() {
  	return $this->excludes;
  }
  
  function set_csets($value){
  	$this->csets[] = $value;
  }
  
  function get_csets() {
  	return $this->csets;
  }

  function get_noset_pcID($index=-1){
      if($index < 0)
	  return $this->noset_pcID;
      return $this->noset_pcID;
  }

  function set_noset_pcID($value){
	  $this->noset_pcID[] = $value;
  }
  
  function set_cart_id($cart_id){
	  $this->cart_id = $cart_id;
  }
  
  function get_cart_id(){
	  return $this->cart_id;
  }
  
  function get_null_qty() {
	  return $this->null_qty;
  }

  function set_null_qty($null_qty) {
	  $this->null_qty = $null_qty;
  }
  
  public function get_fakesets() {
      return $this->fakesets;
  }

  public function set_fakesets($fakesets) {
      $this->fakesets = $fakesets;
  }
  
  function getDefault_storage() {
      return $this->default_storage;
  }

  function setDefault_storage($default_storage) {
      $this->default_storage = $default_storage;
  }
  
  function set_search_in_category(bool $search_in_category){
      $this->search_in_category = $search_in_category;
  }
  
  function get_search_in_category(){
      return $this->search_in_category;
  }
  
  function getHas_cart_items() {
      return $this->has_cart_items;
  }

  function setHas_cart_items($has_cart_items) {
      $this->has_cart_items = $has_cart_items;
  }

        
  // EXCLUDET KATEGORIEN AUS DEM RESULT
  function get_excludes_sql(){
	  $excludeC = '';
	$this->set_excludes_from_db(0);
  	$excludes = $this->get_excludes();
	for($i=0;$i<sizeOf( $excludes ); $i++){
		$excludeC .= " p2c.categories_id != '".$excludes[$i]."' and";
	}
	if(strlen($excludeC)>0){
		$excludeC = substr($excludeC,0,(strlen($excludeC)-4));
		$excludeC = ' and ( '.$excludeC.' )';
	}
	return $excludeC;
  }
  
  function set_excludes_from_db($cid){
	$saved_query = xtc_db_query("select categories_id FROM categories_exclude WHERE customers_id='".$this->get_customers_id()."'");
	while( $saved_res = xtc_db_fetch_array($saved_query) ){
		$this->set_excludes($saved_res['categories_id']);
	}
  }
  
  function get_category_id_from_cPath($cPath){
	return current(array_reverse(explode('_',$cPath)));
  }
  
  function create_categories_sql(){
  	global $_SESSION;
	$products_query_raw = "select
		p.products_id,
		p.products_ean,
		pd.products_name,
		pd.slave_title,
		p.products_sort,
		p.products_model,
		p.products_quantity,
		p.products_image,
		p.products_price,
		p.products_discount_allowed,
		p.products_date_added,
		p.products_last_modified,
		p.products_date_available,
		p.products_status,
		p.products_master_status,
		p.products_master,
		p.products_listing_status,
		p.allow_amazon,
		p.comments,
		pd.amazon_flatfile,
		pd.amazon_browse_node_id,
		p.manufacturers_id,
		p.mpn,		
		p.products_conditions_id,
                p.no_yatego_export,
                p.no_google_product_feed_export,
                p.zollwarennummer,
                p.products_shippingtime,
                p.default_storage,
		";
	if(isset($_REQUEST['days']) and $_REQUEST['days'] > 0){
        $this->set_search_in_category(false);
    }
        
    $has_cart_query = '';
	if($this->get_cart_id() > -1 or $this->getHas_cart_items() !== Null){
		$has_cart_query .= " LEFT JOIN ebay_products ep USING(products_id) ";
	}

	if(!sizeOf($this->get_noset_pcID())){
		$products_query_raw .= sprintf(" p2c.categories_id from " . TABLE_PRODUCTS . " p %s, " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c ",
			$has_cart_query		
		);
	}else{
		$products_query_raw .= sprintf(" p2c.categories_id from " . TABLE_PRODUCTS . " p LEFT JOIN " . TABLE_PRODUCTS_DESCRIPTION . " pd USING(products_id) LEFT JOIN " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c USING(products_id) %s ",
			$has_cart_query		
		);
	}	
	if($this->get_groups_id() >= 0){
/*
		if(sizeOf($this->get_csets())>0){
			$products_query_raw .= ", products_to_characteristics ptc ";
		}
*/
		if(sizeOf($this->get_noset_pcID())){
			// VOLLTEXTSUCHE IN products_characteristic_text_values
			$products_query_raw .= ", products_characteristic pc LEFT JOIN products_characteristic_text_values pctv USING(products_characteristic_id) ";
		}
	}
	if($this->search or $this->get_distributors_id()>0){
		$products_query_raw .= " left join products_distributors pdi using(products_id) ";
	}

	if($this->get_groups_id() >= 0){
		if(!sizeOf($this->get_noset_pcID())){
			$products_query_raw .= " left join groups_allocations ga using(products_id) ";
		}
	}
	if($this->get_fakesets()){
	    $products_query_raw .= ", products_fake_sets pfs ";
	}
	
	if($this->getAsin() != ''){
	    $products_query_raw .= ", amazon_products ap ";
	}

	if($this->un_classifications_id > 0){
		$products_query_raw .= ", product_un_classification puc ";
	}
	
	
	$products_query_raw .= " where ";
	
	if(!sizeOf($this->get_noset_pcID())){
		$products_query_raw .= " p.products_id = pd.products_id and pd.language_id = '" . $_SESSION['languages_id'] . "' and ";
	}else{
		$products_query_raw .= " pd.language_id = '" . $_SESSION['languages_id'] . "' and ";
	}


	if($this->get_groups_id() >= 0){
		if(!sizeOf($this->get_noset_pcID())){
			$products_query_raw .= " ga.groups_id = '".$this->get_groups_id()."' and ";
		}
		if(sizeOf($this->get_csets())>0){
		    $products_query_raw .= sprintf(" p.products_id IN (SELECT products_id FROM products_to_characteristics ptc WHERE ptc.products_characteristic_set_id IN (%s) ) and ",
			implode(',',$this->get_csets())
		    );
		}
		if(sizeOf($this->get_noset_pcID())){
			$products_query_raw .= " pc.products_characteristic_id IN(".implode(',',$this->get_noset_pcID()).") and ";
			$products_query_raw .= " pctv.products_id=p.products_id and ";
			$products_query_raw .= " pc.groups_id='".$this->get_groups_id()."' ";
			$products_query_raw .= " and pctv.language_id='".$_SESSION['languages_id']."' ";
			$products_query_raw .= " and pctv.content LIKE '%".$this->get_search_string()."%' ";
		}
	}
	
	if(!sizeOf($this->get_noset_pcID())){
		$products_query_raw .= " p.products_id = p2c.products_id ";
	}
	
	if( $this->get_groups_id() >= 0 and !sizeOf($this->get_noset_pcID())){
		$products_query_raw .= " and ga.groups_id = '".$this->get_groups_id()."' ";
		if($this->get_category_id()){
			$categories = array($this->get_category_id());
			yes_get_subcategories($categories, $this->get_category_id());
			$products_query_raw .= sprintf(" and p2c.categories_id IN(%s)",
				implode(',',$categories)
			);
			//$products_query_raw .= " and p2c.categories_id = '" . $this->get_category_id(). "' ";
		}
	}else if( $this->get_manufacturers_id() >= 0 ){
		$products_query_raw .= " and p.manufacturers_id = '".$this->get_manufacturers_id()."' ";
		if($this->get_category_id() >= 0){
		    if($this->get_search_string() != '' or $this->av_filter == 1){
			    $categories = array($this->get_category_id());
			    yes_get_subcategories($categories, $this->get_category_id());
			    $products_query_raw .= sprintf(" and p2c.categories_id IN(%s)",
				    implode(',',$categories)
			    );
		    }else{
			    $products_query_raw .= sprintf(" and p2c.categories_id = %s",$this->get_category_id());
		    }
		}
	}else if( $this->get_distributors_id() >= 0 ){
		$products_query_raw .= " and pdi.distributor_id = '".$this->get_distributors_id()."' ";
//	}else if($this->get_category_id() >= 0 and !$this->get_noset_pcID()){
	// mario 15.09.10
	}else if($this->get_category_id() >= 0){
		if($this->get_search_string() != '' or $this->av_filter == 1){
			$categories = array($this->get_category_id());
			yes_get_subcategories($categories, $this->get_category_id());
			$products_query_raw .= sprintf(" and p2c.categories_id IN(%s)",
				implode(',',$categories)
			);
		}else{
                    if($this->get_search_in_category() === True){
			$products_query_raw .= sprintf(" and p2c.categories_id = %s",$this->get_category_id());
                    }
		}
	}else if($this->un_classifications_id > 0){
		$products_query_raw .= " and puc.products_id = p.products_id AND puc.un_classifications_id='".$this->un_classifications_id."' ";
	}else{
            if(!$this->search){
                $products_query_raw .= " and p2c.categories_id = 0";
            }
        }
	
	if($this->search){
		$products_query_raw .= " and (pd.products_name like '%" . $this->get_search_string() . "%' or p.products_ean like '%" . $this->get_search_string() . "%' or p.products_model like '%" . $this->get_search_string() . "%' or pdi.distributor_products_number like '%".$this->get_search_string()."%' or pd.ebay_title like '%".$this->get_search_string()."%' or pd.products_extra_text like '%".$this->get_search_string()."%' or p.mpn like '%".$this->get_search_string()."%' or p.zollwarennummer like '%".$this->get_search_string()."%'";
                // BOF TAGSUCHE - ticket 2759
                $products_query_raw .= " or p.products_id IN (SELECT DISTINCT(tp.products_id) FROM `tags` t LEFT JOIN tags_products tp USING(tags_id) WHERE t.tag='".$this->get_search_string()."' AND type='product') ";
                // EOF TAGSUCHE - ticket 2759
		// WENN EINE ZAHL
		if( (int)$this->get_search_string() > 0 ){
			$products_query_raw .= " or p.products_id='" . $this->get_search_string() . "' ";
		}
		$products_query_raw .= ' ) ';
	}
	if($this->get_cart_id() > -1){
            $products_query_raw .= " and ep.ebay_sammler_id = '" . $this->get_cart_id(). "' ";
        }
	if($this->getHas_cart_items() !== Null){
            switch($this->getHas_cart_items()){
                case 0:
                    $products_query_raw .= " and ep.ebay_sammler_id IS NULL ";
                    break;
                case 1:
                    $products_query_raw .= " and ep.ebay_sammler_id IS NOT NULL ";
                    break;
            }
        }
	
	if($this->get_null_qty() == 1){
		$products_query_raw .= " and p.products_quantity <= 0 ";
	}elseif($this->get_null_qty() == '0'){
		$products_query_raw .= " and p.products_quantity > 0 ";
	}
	if($this->av_filter == 1){
	    $products_query_raw .= ' and p.products_date_available > now()';
	}
	
	if(isset($_REQUEST['days']) and $_REQUEST['days'] > 0){
		$new_date_span = date('Y-m-d 00:00:00',time()-(60*60*24*$_REQUEST['days']));
		$_GET['order_by'] = 'products_date_added DESC';
		$products_query_raw .= " and p.products_date_added >= '".$new_date_span."'";
	}
	
	if($this->warengruppe_id > 0){
		$products_query_raw .= ' and lp.warengruppe='.$this->warengruppe_id.' ';
	}
	
	if($this->only_active){
		$products_query_raw .= ' and p.products_status=1 ';
	}
	if($this->get_fakesets()){
	    $products_query_raw_pfs_parts = array();
	    for($i=1;$i<=5;$i++){
		$products_query_raw_pfs_parts[] = "pfs.artnr_".$i." LIKE '%".$this->get_search_string()."%' ";
	    }
	    $products_query_raw .= " and ( ".implode(' or ',$products_query_raw_pfs_parts)." ) and pfs.products_id=p.products_id ";
	}
	
	if($this->getAsin() != ''){
	    $products_query_raw .= " and (ap.products_id=p.products_id and (ap.asin like '%" . $this->getAsin() . "%' or ap.sku like '%" . $this->getAsin() . "%')) ";
	}
        
        if($this->getDefault_storage() >= 0){
            $products_query_raw .= sprintf(
                    " and p.default_storage='%s' ",
                    $this->getDefault_storage()
            );
        }
		
	$products_query_raw .= $this->get_excludes_sql();

	$order_by_pid = 'p.products_id DESC';
	$order_by_default = 'p.products_sort,pd.products_name ASC';
	
	if(isset($_GET['order_by']) and $_GET['order_by'] != ''){
		$parts = explode(' ',xtc_db_input($_GET['order_by']));
		switch($parts[0]){
			case 'products_status':
			case 'products_price':
				$order_by_pid = sprintf('p.%s %s, p.products_id DESC',
					$parts[0],(($parts[1]=='DESC')?'DESC':'ASC')
				);
				$order_by_default = sprintf('p.%s %s, p.products_sort,pd.products_name ASC ',
					$parts[0],(($parts[1]=='DESC')?'DESC':'ASC')
				);
				break;
			case 'lp.discount':
				$order_by_pid = sprintf('%s %s, p.products_id DESC',
					$parts[0],(($parts[1]=='DESC')?'DESC':'ASC')
				);
				$order_by_default = sprintf('%s %s, p.products_sort,pd.products_name ASC ',
					$parts[0],(($parts[1]=='DESC')?'DESC':'ASC')
				);
				break;
			case 'products_date_added':
				$order_by_pid = sprintf('%s %s, p.products_id DESC',
					$parts[0],(($parts[1]=='DESC')?'DESC':'ASC')
				);
				$order_by_default = sprintf('%s %s, p.products_sort,pd.products_name ASC ',
					$parts[0],(($parts[1]=='DESC')?'DESC':'ASC')
				);
				break;
			case 'products_id':
				$order_by_pid = sprintf('%s %s',
					$parts[0],(($parts[1]=='DESC')?'DESC':'ASC')
				);
				$order_by_default = sprintf('%s %s, p.products_sort,pd.products_name ASC ',
					$parts[0],(($parts[1]=='DESC')?'DESC':'ASC')
				);
				break;
		}
		
	}
	
	// BOF - FILTER
	if(isset($_REQUEST['conditions_id']) and $_REQUEST['conditions_id'] > 0){
	    $products_query_raw .= sprintf(" AND p.products_conditions_id='%s' ",
		    (int)xtc_db_input($_REQUEST['conditions_id'])
	    );
	}
	if(isset($_REQUEST['shipping_status_id']) and $_REQUEST['shipping_status_id'] > 0){
	    $products_query_raw .= sprintf(" AND p.products_shippingtime='%s' ",
		    (int)xtc_db_input($_REQUEST['shipping_status_id'])
	    );
	}
	// EOF - FILTER
	
	
	
	if(!sizeOf($this->get_noset_pcID())){
		if(defined('YES_SORT_PRODUCTS_BY_ID') and YES_SORT_PRODUCTS_BY_ID == 'True')
			$products_query_raw .= " group by products_id order by ".$order_by_pid;
		else
			$products_query_raw .= " group by products_id order by ".$order_by_default;
	}else{
		if(defined('YES_SORT_PRODUCTS_BY_ID') and YES_SORT_PRODUCTS_BY_ID == 'True')
			$products_query_raw .= " group by products_id order by ".$order_by_pid;
		else
			$products_query_raw .= " group by products_id order by ".$order_by_default;
	}
	return $products_query_raw;
  }
}
