<?php
/**
 * Project: xt:Commerce - eCommerce Engine
 * @version $Id
 *
 * xt:Commerce - Shopsoftware
 * (c) 2003-2007 xt:Commerce (Winger/Zanier), http://www.xt-commerce.com
 *
 * xt:Commerce ist eine gesch�tzte Handelsmarke und wird vertreten durch die xt:Commerce GmbH (Austria)
 * xt:Commerce is a protected trademark and represented by the xt:Commerce GmbH (Austria)
 *
 * @copyright Copyright 2003-2007 xt:Commerce (Winger/Zanier), www.xt-commerce.com
 * @copyright based on Copyright 2002-2003 osCommerce; www.oscommerce.com
 * @copyright Porttions Copyright 2003-2007 Zen Cart Development Team
 * @copyright Porttions Copyright 2004 DevosC.com
 * @license http://www.xt-commerce.com.com/license/2_0.txt GNU Public License V2.0
 *
 * For questions, help, comments, discussion, etc., please join the
 * xt:Commerce Support Forums at www.xt-commerce.com
 *
 * ab 15.08.2008 Teile vom Hamburger-Internetdienst ge�ndert
 * Stand: 21.11.2008
 * Jetzt auch ohne iconv!
 * Hamburger-Internetdienst Support Forums at www.forum.hamburger-internetdienst.de
 * Stand 29.04.2009
 */
class paypal_admin {

	var $API_UserName,
			$API_Password,
			$API_Signature,
			$API_Endpoint,
			$version,
			$location_error,
			$NOTIFY_URL,
			$EXPRESS_CANCEL_URL,
			$EXPRESS_RETURN_URL,
			$CANCEL_URL,
			$RETURN_URL,
			$GIROPAY_SUCCESS_URL,
			$GIROPAY_CANCEL_URL,
			$BANKTXN_PENDING_URL,
			$EXPRESS_URL,
			$GIROPAY_URL,
			$IPN_URL,
			$ppAPIec,
			$payPalURL,
                $PRE_CANCEL_URL,
                $USE_PROXY;



				function __construct() {
					// Stand: 27.03.2010
					if(PAYPAL_MODE=='sandbox'){
						$this->API_UserName		= PAYPAL_API_SANDBOX_USER;
						$this->API_Password		= PAYPAL_API_SANDBOX_PWD;
						$this->API_Signature	= PAYPAL_API_SANDBOX_SIGNATURE;
						$this->API_Endpoint		= 'https://api-3t.sandbox.paypal.com/nvp';
						$this->EXPRESS_URL		= 'https://www.sandbox.paypal.com/webscr?cmd=_express-checkout&token=';
						$this->GIROPAY_URL		= 'https://www.sandbox.paypal.com/webscr?cmd=_complete-express-checkout&token=';
						$this->IPN_URL				= 'https://www.sandbox.paypal.com/cgi-bin/webscr';
					}elseif(PAYPAL_MODE=='live'){
						$this->API_UserName		= PAYPAL_API_USER;
						$this->API_Password		= PAYPAL_API_PWD;
						$this->API_Signature	= PAYPAL_API_SIGNATURE;
						$this->API_Endpoint		= 'https://api-3t.paypal.com/nvp';
						$this->EXPRESS_URL		= 'https://www.paypal.com/webscr?cmd=_express-checkout&token=';
						$this->GIROPAY_URL		= 'https://www.paypal.com/webscr?cmd=_complete-express-checkout&token=';
						$this->IPN_URL				= 'https://www.paypal.com/cgi-bin/webscr';
					}
					if(!defined('HTTPS_SERVER')){
						define('HTTPS_SERVER',HTTPS_CATALOG_SERVER);
					}
					if(!defined('FILENAME_CHECKOUT_PAYMENT')){
						define('FILENAME_CHECKOUT_PAYMENT','checkout_payment.php');
					}
					if(!defined('PAYPAL_ERROR')){
						define('PAYPAL_ERROR','Paypal Fehler');
					}
					if(!defined('FILENAME_CHECKOUT_PROCESS')){
						define('FILENAME_CHECKOUT_PROCESS','checkout_process.php');
					}
					if(!defined('FILENAME_CHECKOUT_SUCCESS')){
						define('FILENAME_CHECKOUT_SUCCESS','checkout_success.php');
					}
					if(!defined('VERSION')){
						define('VERSION','1.0');
					}
					if(ENABLE_SSL == true){
						$this->NOTIFY_URL = HTTPS_SERVER.DIR_WS_CATALOG.'callback/paypal/ipn.php';
						$this->EXPRESS_CANCEL_URL = HTTPS_SERVER.DIR_WS_CATALOG.FILENAME_SHOPPING_CART.'?XTCsid='.xtc_session_id();
						$this->EXPRESS_RETURN_URL = HTTPS_SERVER.DIR_WS_CATALOG.FILENAME_PAYPAL_CHECKOUT.'?XTCsid='.xtc_session_id();
						$this->PRE_CANCEL_URL = HTTPS_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_PAYMENT.'?XTCsid='.xtc_session_id();
						$this->CANCEL_URL = HTTPS_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_PAYMENT.'?XTCsid='.xtc_session_id().'&error=true&error_message='.PAYPAL_ERROR;
						$this->RETURN_URL = HTTPS_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_PROCESS.'?XTCsid='.xtc_session_id();
						$this->GIROPAY_SUCCESS_URL = HTTPS_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_SUCCESS.'?XTCsid='.xtc_session_id();
						$this->GIROPAY_CANCEL_URL = HTTPS_SERVER.DIR_WS_CATALOG.FILENAME_SHOPPING_CART.'?XTCsid='.xtc_session_id();
						$this->BANKTXN_PENDING_URL = HTTPS_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_SUCCESS.'?XTCsid='.xtc_session_id();
					}else{
						$this->NOTIFY_URL = HTTP_SERVER.DIR_WS_CATALOG.'callback/paypal/ipn.php';
						$this->EXPRESS_CANCEL_URL = HTTP_SERVER.DIR_WS_CATALOG.FILENAME_SHOPPING_CART.'?XTCsid='.xtc_session_id();
						$this->EXPRESS_RETURN_URL = HTTP_SERVER.DIR_WS_CATALOG.FILENAME_PAYPAL_CHECKOUT.'?XTCsid='.xtc_session_id();
						$this->PRE_CANCEL_URL = HTTP_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_PAYMENT.'?XTCsid='.xtc_session_id();
						$this->CANCEL_URL = HTTP_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_PAYMENT.'?XTCsid='.xtc_session_id().'&error=true&error_message='.PAYPAL_ERROR;
						$this->RETURN_URL = HTTP_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_PROCESS.'?XTCsid='.xtc_session_id();
						$this->GIROPAY_SUCCESS_URL = HTTP_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_SUCCESS.'?XTCsid='.xtc_session_id();
						$this->GIROPAY_CANCEL_URL = HTTP_SERVER.DIR_WS_CATALOG.FILENAME_SHOPPING_CART.'?XTCsid='.xtc_session_id();
						$this->BANKTXN_PENDING_URL = HTTP_SERVER.DIR_WS_CATALOG.FILENAME_CHECKOUT_SUCCESS.'?XTCsid='.xtc_session_id();
					}
					$this->version   = VERSION;
					$this->USE_PROXY = FALSE;
					$this->payPalURL = '';
					$this->ppAPIec = $this->buildAPIKey(PAYPAL_API_KEY, 'ec');
					if(ENABLE_SSL == true):
						$hdrImg='templates/'.CURRENT_TEMPLATE.'/img/'.PAYPAL_API_IMAGE;
						if(file_exists(DIR_FS_CATALOG.$hdrImg) AND PAYPAL_API_IMAGE!=''):
							$hdrSize = getimagesize(DIR_FS_CATALOG.$hdrImg);
							if($hdrSize[0]<=750 AND $hdrSize[1]<=90):
								$this->Image = urlencode(HTTPS_SERVER.DIR_WS_CATALOG.$hdrImg);
							endif;
						endif;
					endif;
					// BOF - Hetfield - 2009-11-19 - replaced deprecated function ereg with preg_match to be ready for PHP >= 5.3
					//if(ereg('^(([a-f]|[A-F]|[0-9]){6})$',PAYPAL_API_CO_BACK))
					if(preg_match('/^(([a-f]|[A-F]|[0-9]){6})$/',PAYPAL_API_CO_BACK))
						$this->BackColor = PAYPAL_API_CO_BACK;
					//if(ereg('^(([a-f]|[A-F]|[0-9]){6})$',PAYPAL_API_CO_BORD))
					if(preg_match('/^(([a-f]|[A-F]|[0-9]){6})$/',PAYPAL_API_CO_BORD))
						$this->BorderColor = PAYPAL_API_CO_BORD;
					// EOF - Hetfield - 2009-11-19 - replaced deprecated function ereg with preg_match to be ready for PHP >= 5.3
				}
	function GetTransactionDetails($txn_id) {
		// Stand: 29.04.2009
		$nvpstr = '&TRANSACTIONID=' . urlencode($txn_id);
		$resArray = $this->hash_call("gettransactionDetails", $nvpstr);
		$ack = strtoupper($resArray["ACK"]);
		if($ack != "SUCCESS")
			$this->build_error_message($resArray);
		return $resArray;
	}
/*************************************************************/
	function RefundTransaction($txn_id, $curr, $amount, $refund, $note = '') {
		// Stand: 29.04.2009
		// full refund ?
		if($note != '')
			$note = '&NOTE=' . urlencode($note);
		if($amount != $refund) {
			$refund = str_replace(',', '.', $refund);
			$nvpstr = '&TRANSACTIONID=' . urlencode($txn_id) . '&REFUNDTYPE=Partial&CURRENCYCODE=' . $curr . '&AMT=' . $refund . $note;
		} else {
			$nvpstr = '&TRANSACTIONID=' . urlencode($txn_id) . '&REFUNDTYPE=Full' . $note;
		}
		$resArray = $this->hash_call("RefundTransaction", $nvpstr);
		$ack = strtoupper($resArray["ACK"]);
		if($ack != "SUCCESS")
			$this->build_error_message($resArray);
		return $resArray;
	}
/*************************************************************/
	function DoCapture($txn_id, $curr, $amount, $capture_amount, $note = '') {
		// Stand: 29.04.2009
		if($note != '')
			$note = '&NOTE=' . urlencode($note);
		if($amount != $capture_amount) {
			$capture_amount = str_replace(',', '.', $capture_amount);
			$nvpstr = '&AUTHORIZATIONID=' . urlencode($txn_id) . '&COMPLETETYPE=NotComplete&CURRENCYCODE=' . $curr . '&AMT=' . $capture_amount . $note;
		} else {
			$nvpstr = '&AUTHORIZATIONID=' . urlencode($txn_id) . '&COMPLETETYPE=Complete' . $note;
		}
		$resArray = $this->hash_call("DoCapture", $nvpstr);
		$ack = strtoupper($resArray["ACK"]);
		if($ack != "SUCCESS")
			$this->build_error_message($resArray);
		return $resArray;
	}
/*************************************************************/
	function TransactionSearch($data) {
		// Stand: 29.04.2009
		global $date;
		// date range
		if($data['span'] == 'narrow') {
			// show range
			$startdate = (int) $data['from_y'] . '-' . (int) $data['from_m'] . '-' . (int) $data['from_t'] . 'T00:00:00Z';
			$enddate = (int) $data['to_y'] . '-' . (int) $data['to_m'] . '-' . (int) $data['to_t'] . 'T24:00:00Z';
		} else {
			/*
			* 1 = last day
			* 2 = last week
			* 3 = last month
			* 4 = last year
			*/
			switch($data['for']) {
				case '1' :
					$cal_date = mktime(0, 0, 0, date("m"), date("d") - 1, date("Y"));
					$_date = array();
					$_date['tt'] = date('d', $cal_date);
					$_date['mm'] = date('m', $cal_date);
					$_date['yyyy'] = date('Y', $cal_date);
					$startdate = (int) $_date['yyyy'] . '-' . (int) $_date['mm'] . '-' . (int) $_date['tt'] . 'T00:00:00Z';
					$enddate = $date['actual']['yyyy'] . '-' . $date['actual']['mm'] . '-' . $date['actual']['tt'] . 'T24:00:00Z';
					break;
				case '2' :
					$cal_date = mktime(0, 0, 0, date("m"), date("d") - 7, date("Y"));
					$_date = array();
					$_date['tt'] = date('d', $cal_date);
					$_date['mm'] = date('m', $cal_date);
					$_date['yyyy'] = date('Y', $cal_date);
					$startdate = (int) $_date['yyyy'] . '-' . (int) $_date['mm'] . '-' . (int) $_date['tt'] . 'T00:00:00Z';
					$enddate = $date['actual']['yyyy'] . '-' . $date['actual']['mm'] . '-' . $date['actual']['tt'] . 'T24:00:00Z';
					break;
				case '3' :
					$cal_date = mktime(0, 0, 0, date("m") - 1, date("d"), date("Y"));
					$_date = array();
					$_date['tt'] = date('d', $cal_date);
					$_date['mm'] = date('m', $cal_date);
					$_date['yyyy'] = date('Y', $cal_date);
					$startdate = (int) $_date['yyyy'] . '-' . (int) $_date['mm'] . '-' . (int) $_date['tt'] . 'T00:00:00Z';
					$enddate = $date['actual']['yyyy'] . '-' . $date['actual']['mm'] . '-' . $date['actual']['tt'] . 'T24:00:00Z';
					break;
				case '4' :
					$cal_date = mktime(0, 0, 0, date("m"), date("d"), date("Y") - 1);
					$_date = array();
					$_date['tt'] = date('d', $cal_date);
					$_date['mm'] = date('m', $cal_date);
					$_date['yyyy'] = date('Y', $cal_date);
					$startdate = (int) $_date['yyyy'] . '-' . (int) $_date['mm'] . '-' . (int) $_date['tt'] . 'T00:00:00Z';
					$enddate = $date['actual']['yyyy'] . '-' . $date['actual']['mm'] . '-' . $date['actual']['tt'] . 'T24:00:00Z';
					break;
			}
		}
		// search in details
		$detail_search = '';
		if(isset($data['search_type']) and $data['search_type'] != '') {
			switch($data['search_first_type']) {
				case 'email_alias' :
					$detail_search = '&EMAIL=' . urlencode($data['search_type']);
					break;
				case 'trans_id' :
					$detail_search = '&TRANSACTIONID=' . urlencode($data['search_type']);
					break;
				case 'last_name_only' :
					$detail_search = '&LASTNAME=' . urlencode($data['search_type']);
					break;
				case 'last_name' :
					$search = explode(',', $data['search_type']);
					$detail_search = '&LASTNAME=' . urlencode(trim($search['0'])) . '&FIRSTNAME=' . urlencode(trim($search['1']));
					break;
				case 'invoice_id' :
					$detail_search = '&INVNUM=' . urlencode($data['search_type']);
					break;
			}
		}
		$nvpstr = '&STARTDATE=' . $startdate . '&ENDDATE=' . $enddate . '&CURRENCYCODE=EUR' . $detail_search;
		$resArray = $this->hash_call("TransactionSearch", $nvpstr);
		if($resArray['ACK'] == 'Success') {
			$result = $this->createResultArray($resArray);
		}
		elseif($resArray['ACK'] == 'SuccessWithWarning') {
			$this->SearchError['code'] = $resArray['L_ERRORCODE0'];
			$this->SearchError['shortmessage'] = $resArray['L_SHORTMESSAGE0'];
			$this->SearchError['longmessage'] = $resArray['L_LONGMESSAGE0'];
			$result = $this->createResultArray($resArray);
		} else {
			$this->SearchError['code'] = $resArray['L_ERRORCODE0'];
			$this->SearchError['shortmessage'] = $resArray['L_SHORTMESSAGE0'];
			$this->SearchError['longmessage'] = $resArray['L_LONGMESSAGE0'];
			$result = -1;
		}
		return $result;
	}
/*************************************************************/
	function createResultArray($response) {
		// Stand: 29.04.2009
		$result = array();
		$n = 0;
		$flag = true;
		while($flag) {
			if(!isset($response['L_TIMESTAMP' . $n])) {
				$flag = false;
				return -1;
			}
			$result[$n]['TIMESTAMP'] = $response['L_TIMESTAMP' . $n];
			$result[$n]['TYPE'] = $response['L_TYPE' . $n];
			$result[$n]['NAME'] = $response['L_NAME' . $n];
			$result[$n]['TXNID'] = $response['L_TRANSACTIONID' . $n];
			$result[$n]['STATUS'] = $response['L_STATUS' . $n];
			$result[$n]['AMT'] = $response['L_AMT' . $n];
			$result[$n]['FEEAMT'] = $response['L_FEEAMT' . $n];
			$result[$n]['NETAMT'] = $response['L_NETAMT' . $n];
			$result[$n]['EMAIL'] = $response['L_EMAIL' . $n];
			if(!isset($response['L_TIMESTAMP' . ($n +1)]))
				$flag = false;
			$n++;
		}
		return $result;
	}
/*************************************************************/
	function getStatusSymbol($status, $type = '', $reason = '') {
		// Stand: 29.04.2009
		switch($status) {
			case 'Reversed' :
			case 'Refunded' :
				$symbol = xtc_image(DIR_WS_ICONS . 'action_refresh_blue.gif');
				break;
			case 'Completed' :
			case 'verified' :
			case 'confirmed' :
				$symbol = xtc_image(DIR_WS_ICONS . 'icon_accept.gif');
				break;
			case 'Pending' :
				$symbol = xtc_image(DIR_WS_ICONS . 'icon_clock.gif');
				if($reason == 'authorization')
					$symbol = xtc_image(DIR_WS_ICONS . 'icon_capture.gif');
				if($reason == 'partial-capture')
					$symbol = xtc_image(DIR_WS_ICONS . 'icon_partcapture.png');
				if($reason == 'completed-capture')
					$symbol = xtc_image(DIR_WS_ICONS . 'icon_capture.gif');
				break;
			case 'Denied' :
			case 'unverified' :
			case 'unconfirmed' :
				$symbol = xtc_image(DIR_WS_ICONS . 'exclamation.png');
				break;
			case 'Unconfirmed' :
				$symbol = xtc_image(DIR_WS_ICONS . 'exclamation.png');
				break;
			case 'Payment' :
			case 'Refund';
				switch($type) {
					case 'Completed' :
						$symbol = xtc_image(DIR_WS_ICONS . 'icon_accept.gif');
						break;
					case 'Pending' :
						$symbol = xtc_image(DIR_WS_ICONS . 'icon_clock.gif');
						break;
					case 'Refunded' :
					case 'Partially Refunded';
						$symbol = xtc_image(DIR_WS_ICONS . 'action_refresh_blue.gif');
						break;
					case 'Cancelled' :
						$symbol = xtc_image(DIR_WS_ICONS . 'icon_cancel.png');
						break;
				}
				break;
			case 'Transfer' :
				switch($type) {
					case 'Completed' :
						$symbol = xtc_image(DIR_WS_ICONS . 'icon_arrow_right.gif');
						break;
				}
			case '' :
				if($type == 'new_case')
					$symbol = xtc_image(DIR_WS_ICONS . 'exclamation.png');
				break;
		}
		return $symbol;
	}
/*************************************************************/
	function mapResponse($data) {
		// Stand: 29.04.2009
		$data_array = array(
			'xtc_order_id' => $data['INVNUM'],
			'txn_type' => $data['TRANSACTIONTYPE'],
			'reason_code' => $data['REASONCODE'],
			'payment_type' => $data['PAYMENTTYPE'],
			'payment_status' => $data['PAYMENTSTATUS'],
			'pending_reason' => $data['PENDINGREASON'],
			'invoice' => $data['INVNUM'],
			'mc_currency' => $data['CURRENCYCODE'],
			'first_name' => $this->UTF8decode($data['FIRSTNAME']),
			'last_name' => $this->UTF8decode($data['LASTNAME']),
			'payer_business_name' => $this->UTF8decode($data['BUSINESS']),
			'address_name' => $this->UTF8decode($data['SHIPTONAME']),
			'address_street' => $this->UTF8decode($data['SHIPTOSTREET']),
			'address_city' => $this->UTF8decode($data['SHIPTOCITY']),
			'address_state' => $this->UTF8decode($data['SHIPTOSTATE']),
			'address_zip' => $data['SHIPTOZIP'],
			'address_country' => $this->UTF8decode($data['SHIPTOCOUNTRYNAME']),
			'address_status' => $data['ADDRESSSTATUS'],
			'payer_email' => $data['EMAIL'],
			'payer_id' => $data['PAYERID'],
			'payer_status' => $data['PAYERSTATUS'],
			'payment_date' => $data['TIMESTAMP'],
			'business' => '',
			'receiver_email' => $data['RECEIVEREMAIL'],
			'receiver_id' => $data['RECEIVERID'],
			'txn_id' => $data['TRANSACTIONID'],
			'parent_txn_id' => '',
			'num_cart_items' => '',
			'mc_gross' => $data['AMT'],
			'mc_fee' => $data['FEEAMT'],
			'mc_authorization' => $data['AMT'],
			'payment_gross' => '',
			'payment_fee' => '',
			'settle_amount' => $data['SETTLEAMT'],
			'settle_currency' => '',
			'exchange_rate' => $data['EXCHANGERATE'],
			'notify_version' => $data['VERSION'],
			'verify_sign' => '',
			'last_modified' => '',
			'date_added' => 'now()',
			'memo' => $data['DESC']
		);
		return $data_array;
	}
/*************************************************************/
	function getPaymentType($type) {
		// Stand: 29.04.2009
		if($type == '' OR strtoupper($type)=='NONE')
			return;
		if(defined(TYPE_ . strtoupper($type))):
			return constant(TYPE_ . strtoupper($type));
		else:
			return(ucfirst($type));
		endif;
	}
/*************************************************************/
	function getStatusName($status, $type = '') {
		// Stand: 29.04.2009
		if($type == 'new_case')
			return STATUS_CASE;
		if(defined('STATUS_' . strtoupper($status))):
			return constant('STATUS_' . strtoupper($status));
		else:
			return(ucfirst($status));
		endif;
	}
/*************************************************************/
	function admin_notification($orders_id) {
		// Stand: 29.04.2009
		global $_GET;
		include(DIR_FS_CATALOG . 'lang/' . $_SESSION['language'] . '/admin/paypal.php');
		$db_installed = false;
//BOF - Dokuman - 2009-11-23 - replace mysql_list_tables by mysql_query -> PHP5.3 depricated				
				//$tables = mysql_list_tables(DB_DATABASE);
				$tables = xtc_db_query('SHOW TABLES FROM ' . DB_DATABASE);
//EOF - Dokuman - 2009-11-23 - replace mysql_list_tables by mysql_query -> PHP5.3 depricated							
		while($row = xtc_db_fetch_array($tables)) {
			if(current($row) === TABLE_PAYPAL) $db_installed=true;
		}
		if($db_installed==false)return;
		$query = "SELECT * FROM " . TABLE_PAYPAL . " WHERE xtc_order_id = '" . $orders_id . "'ORDER BY paypal_ipn_id DESC LIMIT 1";
		$query = xtc_db_query($query);
		if(xtc_db_num_rows($query)){
			$data = xtc_db_fetch_array($query);
			if(substr($data['txn_id'],0,6)!="PayPal"):
				$response = $this->GetTransactionDetails($data['txn_id']);
			else:
				$response = array('ACK' => 'PFailure','ERROR' => $data['txn_id']);
			endif;
			// show transaction status
			$output = '<tr>
								<td class="main" valign="top"><b>' . TEXT_PAYPAL_PAYMENT . ':</b><br /></td>
								<td class="main" style="border: 1px solid; border-color: #003366; background: #fff;">';
			// show INFO
			if($response['ACK']=='Failure') {
				$output .= '<table width="300">
									<tr>
										<td class="main" colspan="2">' . $this->getErrorDescription($response['L_ERRORCODE0']) . '</td>
									</tr>';
			} elseif($response['ACK']=='PFailure') {
				$output .= '<table width="300">
										<tr>
											<td class="main" colspan="2">' . $response['ERROR'] . '</td>
										</tr>';
			} else {
				// authorization ?
				if($response['PAYMENTSTATUS'] == 'None' && $response['PENDINGREASON'] == 'other') {
					$response['PAYMENTSTATUS'] = 'Pending';
					$response['PENDINGREASON'] = 'authorization';
					$response['AMT'] = $response['AMT'] . ' ( ' . $data['mc_captured'] . ' Captured) ';
				}
				$output .= '<table width="300">
										<tr>
											<td width="10">' . $this->getStatusSymbol($response['PAYMENTSTATUS'], $response['TRANSACTIONTYPE'], $response['PENDINGREASON']) . '</dt>
											<td class="main">' . $this->getStatusName($response['PAYMENTSTATUS'], $response['TRANSACTIONTYPE']) . ' Total: ' . $response['AMT'] . ' ' . $response['CURRENCYCODE'] . '</td>
										</tr>
										<tr>
											<td width="10">' . $this->getStatusSymbol($response['PAYERSTATUS']) . '</dt>
											<td class="main">' . $response['PAYERSTATUS'] . '(' . $response['EMAIL'] . ')' . '</td>
										</tr>
										<tr>
											<td width="10" valign="top">' . $this->getStatusSymbol($response['ADDRESSSTATUS']) . '</dt>
											<td class="main">(' . $response['ADDRESSSTATUS'] . ')<br>' . $this->mn_iconv("UTF-8", $_SESSION['language_charset'], $response['SHIPTONAME']) . '<br>' . $this->mn_iconv("UTF-8", $_SESSION['language_charset'], $response['SHIPTOSTREET']) . '<br>' . $response['SHIPTOZIP'] . ' ' . $this->mn_iconv("UTF-8", $_SESSION['language_charset'], $response['SHIPTOCITY']) . '<br>' . $this->mn_iconv("UTF-8", $_SESSION['language_charset'], $response['SHIPTOCOUNTRYNAME']) . '</td>
										</tr>
										<tr>
											<td width="10" valign="top">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif') . '</dt>
											<td class="main"><a href="' . xtc_href_link(FILENAME_PAYPAL, 'view=detail&paypal_ipn_id=' . $data['paypal_ipn_id']) . '" target="_blank">' . TEXT_PAYPAL_DETAIL . '</td>
										</tr>';
			}
			$output .= '</table></td>
									</tr>';
			return $output;
		}
	}
/*************************************************************/
	function getErrorDescription($err) {
		// Stand: 29.04.2009
		//return constant(strtoupper($err));
		$err = $_SESSION['reshash']['FORMATED_ERRORS'];
		unset($_SESSION['reshash']['FORMATED_ERRORS']);
		return strtoupper($err);
	}
/*************************************************************/
	function UTF8decode($string){
		// Stand: 29.04.2009
		// Session vorhanden
		if($this->detectUTF8($string))
			$string=$this->mn_iconv('UTF-8', $_SESSION['language_charset'], $string);
		return($string);
  }
/*************************************************************/
	function detectUTF8($string){
		// Stand: 29.04.2009
		return preg_match('%(?:
				[\xC2-\xDF][\x80-\xBF]
				|\xE0[\xA0-\xBF][\x80-\xBF]
				|[\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}
				|\xED[\x80-\x9F][\x80-\xBF]
				|\xF0[\x90-\xBF][\x80-\xBF]{2}
				|[\xF1-\xF3][\x80-\xBF]{3}
				|\xF4[\x80-\x8F][\x80-\xBF]{2}
				)+%xs', $string);
	}
/*************************************************************/
	function mn_iconv($t1,$t2,$string){
		// Stand: 29.04.2009
		if(function_exists('iconv')):
			return iconv($t1, $t2, $string);
		endif;
		/// Kein iconv im PHP
		if($t2 == "UTF-8"):
			// nur als Ersatz f�r das iconv und nur in eine richtung 1251 to UTF8
			//ISO 8859-1 to UTF-8
			if(function_exists('utf8_encode')):
				return utf8_encode($string);
			else:
				$string=preg_replace("/([\x80-\xFF])/e","chr(0xC0|ord('\\1')>>6).chr(0x80|ord('\\1')&0x3F)",$string);
				return($string);
			endif;
		elseif($t1 == "UTF-8"):
			//UTF-8 to ISO 8859-1
			if(function_exists('utf8_decode')):
				return utf8_decode($string);
			else:
				$string=preg_replace("/([\xC2\xC3])([\x80-\xBF])/e","chr(ord('\\1')<<6&0xC0|ord('\\2')&0x3F)",$string);
				return($string);
			endif;
		else:
			// keine Konvertierung m�glich
			return($string);
		endif;
	}

	function hash_call($methodName,$nvpStr,$pp_token=''){
		// Stand: 05.01.2010
		if(function_exists('curl_init')):
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL,$this->API_Endpoint.$pp_token);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			//turning off the server and peer verification(TrustManager Concept).
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
			curl_setopt($ch, CURLOPT_POST, 1);
			//if USE_PROXY constant set to TRUE am Anfang dieser Datei, then only proxy will be enabled.
			//Set proxy name to PROXY_HOST and port number to PROXY_PORT im Anfang dieser Datei
			if($this->USE_PROXY)
				curl_setopt($ch, CURLOPT_PROXY, PROXY_HOST.":".PROXY_PORT);
			//NVPRequest for submitting to server
			$nvpreq="METHOD=".urlencode($methodName)."&VERSION=".urlencode($this->version)."&PWD=".urlencode($this->API_Password)."&USER=".urlencode($this->API_UserName)."&SIGNATURE=".urlencode($this->API_Signature).$nvpStr;
			//setting the nvpreq as POST FIELD to curl
			curl_setopt($ch,CURLOPT_POSTFIELDS,$nvpreq);
			//getting response from server
			$response = curl_exec($ch);
			//convrting NVPResponse to an Associative Array
			$nvpResArray=$this->deformatNVP($response);
			$nvpReqArray=$this->deformatNVP($nvpreq);
			$_SESSION['nvpReqArray']= $nvpReqArray;
			/* Mit cURL Fehleranzeige und nicht Versuch mit file_get_contents
			if(curl_errno($ch)) {
				// moving to display page to display curl errors
				$_SESSION['curl_error_no']=curl_errno($ch) ;
				$_SESSION['curl_error_msg']=curl_error($ch);
				$this->build_error_message($_SESSION['reshash']);
			}
			*/
			$curl_fehler=curl_errno($ch);
			//closing the curl
			curl_close($ch);
			//return $nvpResArray;
			if(!$curl_fehler)
				return $nvpResArray;
			//else:
		endif;
		/// Falls cURL nicht da oder Fehlerhaft
		global $API_Endpoint,$version,$API_UserName,$API_Password,$API_Signature,$nvp_Header;
		$nvpreq="METHOD=".urlencode($methodName)."&VERSION=".urlencode($this->version)."&PWD=".urlencode($this->API_Password)."&USER=".urlencode($this->API_UserName)."&SIGNATURE=".urlencode($this->API_Signature).$nvpStr;
		$request_post = array(
										'http'=>array(
										'method'=>'POST',
										'header'=>"Content-type: application/x-www-form-urlencoded\r\n",
										'content'=>$nvpreq));
		$request = stream_context_create($request_post);
		$response= file_get_contents($this->API_Endpoint.$pp_token, false, $request);
		$nvpResArray=$this->deformatNVP($response);
		$nvpReqArray=$this->deformatNVP($nvpreq);
		$_SESSION['nvpReqArray']= $nvpReqArray;
		return $nvpResArray;
		//endif;
	}
	function deformatNVP($nvpstr){
		// Stand: 29.04.2009
		$intial=0;
		$nvpArray = array();
		while(strlen($nvpstr)){
			//postion of Key
			$keypos= strpos($nvpstr,'=');
			//position of value
			$valuepos = strpos($nvpstr,'&') ? strpos($nvpstr,'&'): strlen($nvpstr);
			// getting the Key and Value values and storing in a Associative Array
			$keyval=substr($nvpstr,$intial,$keypos);
			$valval=substr($nvpstr,$keypos+1,$valuepos-$keypos-1);
			//decoding the respose
			$nvpArray[urldecode($keyval)] =urldecode( $valval);
			$nvpstr=substr($nvpstr,$valuepos+1,strlen($nvpstr));
		}
		return $nvpArray;
	}
	
	function buildAPIKey($key, $pay){
		// Stand: 29.04.2009
		$key_arr=explode(',',$key);
		$k='';
		for($i=0; $i<count($key_arr);$i++) $k.=chr($key_arr[$i]);
		if($pay=='ec'){
			return $k.'EC_MN_53';
		}
	}

}

