<?php
/**
 * Zur Integration von Amazon in das YES System
 *
 * Diverse Funktionen
 *
 * @author mario
 */
class amazon_helper {
	var $amazon_carriers = array(
		"USPS", "UPS", "FedEx", "DHL", "Fastway", "GLS", "GO!", "Hermes Logistik Gruppe", "Royal Mail", "Parcelforce", "City Link", "TNT", "Target","Other"
	);
	var $amazon_schedule_values = array(
		'_15_MINUTES_',	'_30_MINUTES_',	'_1_HOUR_',	'_2_HOURS_','_4_HOURS_','_8_HOURS_','_12_HOURS_','_1_DAY_','_2_DAYS_','_72_HOURS_','_7_DAYS_','_14_DAYS_','_15_DAYS_','_30_DAYS_','_NEVER_'
	);


	/**
	 * Fuer die Versandbestaetigung brauchen wir CarrierCode und ggf CarrierName
	 * Diese Funktion ermittelt die Amazon Auspr�gung f�r die Angabe des Carriers
	 *
	 * @param String $yes_shipper
	 * @return Array
	 */
	public static function get_amazon_carrier_from_yes_shipping($yes_shipper){
		$amazon_carrier_name = '';
		$yes_shipper_low = strtolower($yes_shipper);
                
		switch($yes_shipper_low){
			case 'danzas':
			case 'iloxx':
			case 'dpd':
			case 'mydpd':
			case 'intraship':
			case 'post':
			case 'kurier':
			case 'postpaket':
			case 'internetmarke':
			case 'easytosend':
			case 'spedition':
                        case 'inline':
			case 'stampit':
				$amazon_carrier_code = 'Other';
				$amazon_carrier_name = $yes_shipper;
				break;
			case 'hermesweb':
			case 'hermes':
				$amazon_carrier_code = 'Hermes Logistik Gruppe';
				break;
			case 'ups':
				$amazon_carrier_code = 'UPS';
				break;
			case 'gls':
				$amazon_carrier_code = 'GLS';
				break;
			case 'postpaket':
                        case 'dhl':
			case 'easylog2':
			case 'easylog':
				$amazon_carrier_code = 'DHL';
				break;
		}
		return array(
			'carrier_code'=>$amazon_carrier_code,
			'carrier_name'=>$amazon_carrier_name
		);
	}

	/**
	 * Gibt ein Array fuer Selectboxen der Amazon Schedule Values zurueck
	 *
	 * @return Array
	 */
	public function get_amazon_schedule_values(){
		$array = array();
		foreach($this->amazon_schedule_values  as $val){
			$array[] = array('id'=>$val,'text'=>$val);
		}
		return $array;
	}

	/**
	 * Liefert die DB Eintraege aus der amazon_orders Tabelle fuer eine
	 * bestimmte orders_id
	 *
	 * @param int $orders_id
	 * @return Array
	 */
	public static function get_amazon_order_values($orders_id){
		$data = array();
		if($orders_id < 1)
			return $data;
		$query = yes_db_query(sprintf(
			"SELECT * FROM amazon_orders WHERE orders_id='%s'",$orders_id
		));
		if(yes_db_num_rows($query)){
		    foreach($query as $record){
			$data[] = $record;
		    }
		}
		return $data;
	}

	/**
	 * Gibt einen "lesbaren" Namen der Amazon Versandart zurueck.
	 * Wird zb gebraucht bei der Versandbenachrichtigung
	 *
	 * @param String $shipping_service_level
	 * @return String
	 */
	public static function get_amazon_shipping_method_name($shipping_service_level){
		switch($shipping_service_level){
			case 'Expedited':
				return 'Express';
				break;
			default:
				return $shipping_service_level;
				break;
		}
	}
	
	/*
	 * gibt ein Array aller hinterlegten Amazon User zurueck
	 */
	public function get_auth_user_array(){
	    if(defined('MODULE_OTHER_AMAZON_MERCHANT_ID')){
		// SINGLEUSER - ALTES HANDLING
		return array(
		    MODULE_OTHER_AMAZON_MERCHANT_ID
		);
	    }else{
		// MULTIUSER - NEUES HANDLING
		$array = array();
		$auth_array = explode(';',MODULE_OTHER_AMAZON_AUTH_DATA);
		foreach($auth_array as $auth_data){
		    $auth_data_parts = explode(',',$auth_data);
		    if(!empty($auth_data_parts[0]))
			$array[] = $auth_data_parts[0];
		}
		return $array;
	    }
	}
	/*
	 * gibt das Auth Array des gewaehlten Amazon MerchantID zurueck
	 */
	public function get_auth_data_array( $merchant_id = '' ){
	    if(defined('MODULE_OTHER_AMAZON_MERCHANT_ID')){
		// SINGLEUSER - ALTES HANDLING
		return array(
		    'merchant_id'=>MODULE_OTHER_AMAZON_MERCHANT_ID,
		    'marketplace_id'=>MODULE_OTHER_AMAZON_MARKETPLACE_ID,
		    'merchant_identifier'=>MODULE_OTHER_AMAZON_MERCHANT_IDENTIFIER,
		    'mwsauthtoken'=>(defined('MODULE_OTHER_AMAZON_MWSAUTHTOKEN') and MODULE_OTHER_AMAZON_MWSAUTHTOKEN != '') ? MODULE_OTHER_AMAZON_MWSAUTHTOKEN : ''
		);
	    }else{
		// MULTIUSER - NEUES HANDLING
		$auth_array = explode(';',MODULE_OTHER_AMAZON_AUTH_DATA);
		foreach($auth_array as $auth_data){
		    $auth_data_parts = explode(',',$auth_data);
		    if($auth_data_parts[0] == $merchant_id or $merchant_id == ''){
			return array(
			    'merchant_id'=>$auth_data_parts[0],
			    'marketplace_id'=>$auth_data_parts[1],
			    'merchant_identifier'=>$auth_data_parts[2],
			    'mwsauthtoken'=>$auth_data_parts[3]
			);
		    }
		}
	    }
	}
}
