<?php
require_once(DIR_FS_ADMIN.'includes/classes/amazon_settlement.php');
class amazon_order {
	var $orig_amazon_orders_id;
	var $amazon_orders_id;
	var $orders_id;
	var $settlements = array();
	var $customers_id;
	var $date_created;
	var $buyer_name;
	var $buyer_email_address;
	var $buyer_telephone_number;
	var $shipping_method;
	var $shipping_method_service_level;

	public function getAmazon_orders_id() {
		return $this->amazon_orders_id;
	}

	public function setAmazon_orders_id($amazon_orders_id) {
		$this->amazon_orders_id = $amazon_orders_id;
	}

	public function getOrders_id() {
		return $this->orders_id;
	}

	public function setOrders_id($orders_id) {
		$this->orders_id = $orders_id;
	}

	public function getSettlements() {
		return $this->settlements;
	}

	public function setSettlements($settlements) {
		$this->settlements[] = $settlements;
	}
	public function getOrig_amazon_orders_id() {
		return $this->orig_amazon_orders_id;
	}

	public function setOrig_amazon_orders_id($orig_amazon_orders_id) {
		$this->orig_amazon_orders_id = $orig_amazon_orders_id;
	}

	public function getCustomers_id() {
		return $this->customers_id;
	}

	public function setCustomers_id($customers_id) {
		$this->customers_id = $customers_id;
	}

	public function getDate_created() {
		return $this->date_created;
	}

	public function setDate_created($date_created) {
		$this->date_created = $date_created;
	}

	public function getBuyer_name() {
		return $this->buyer_name;
	}

	public function setBuyer_name($buyer_name) {
		$this->buyer_name = $buyer_name;
	}

	public function getBuyer_email_address() {
		return $this->buyer_email_address;
	}

	public function setBuyer_email_address($buyer_email_address) {
		$this->buyer_email_address = $buyer_email_address;
	}

	public function getBuyer_telephone_number() {
		return $this->buyer_telephone_number;
	}

	public function setBuyer_telephone_number($buyer_telephone_number) {
		$this->buyer_telephone_number = $buyer_telephone_number;
	}

	public function getShipping_method() {
		return $this->shipping_method;
	}

	public function setShipping_method($shipping_method) {
		$this->shipping_method = $shipping_method;
	}

	public function getShipping_method_service_level() {
		return $this->shipping_method_service_level;
	}

	public function setShipping_method_service_level($shipping_method_service_level) {
		$this->shipping_method_service_level = $shipping_method_service_level;
	}

	function __construct($amazon_orders_id){
		if(empty($amazon_orders_id))
			return false;
		$query = xtc_db_query(sprintf(
			"SELECT * FROM amazon_orders WHERE amazon_orders_id=%s",
			$amazon_orders_id
		));
		if(!xtc_db_num_rows($query))
			return false;
		$record = xtc_db_fetch_array($query);
		foreach($record as $key=>$value){
			$this->$key = $value;
		}
		$query = yes_db_query(sprintf(
			"SELECT amazon_settlements_id FROM amazon_settlements WHERE order_id='%s'",
			$this->getOrig_amazon_orders_id()
		));
		while($settlements = xtc_db_fetch_array($query)){
			$this->setSettlements( new amazon_settlement($settlements['amazon_settlements_id']) );
		}
	}
	
	function getSettlementsHTML($smarty){
		if(!sizeOf($this->getSettlements()))
				return '';
		$items = array(
			'main'=>'',
			'prices'=>array(),
			'fees'=>array()
		);
		foreach($this->getSettlements() as $settlement){
			if($settlement->getPrice_type() != ''){
				$items['prices'][] = $settlement;
			}else if($settlement->getItem_related_fee_type() != ''){
				$items['fees'][] = $settlement;
			}else{
				$smarty->assign('amazon_order_id',$settlement->getOrder_id());
			}
		}
		if(!sizeOf($items))
			return '';
		$display_items = array();
		$total = 0;
		foreach($items['prices'] as $price){
			$display_items[] = array(
				'class'=>'price',
				'date'=>$price->getPosted_date(),
				'type'=>$price->getPrice_type(),
				'amount'=>$price->getPrice_amount(true)
			);
			$total += $price->getPrice_amount();
		}
		$display_items[] = array(
			'class'=>'price',
			'type'=>'Gesamt',
			'amount'=>number_format($total,2,',','.')
		);
		$total = 0;
		foreach($items['fees'] as $price){
			$display_items[] = array(
				'class'=>'fee',
				'date'=>$price->getPosted_date(),
				'type'=>$price->getItem_related_fee_type(),
				'amount'=>$price->getItem_related_fee_amount(true)
			);
			$total += $price->getItem_related_fee_amount();
		}
		$display_items[] = array(
			'class'=>'fee',
			'type'=>'Gesamt',
			'amount'=>number_format($total,2,',','.')
		);
		$smarty->assign('items',$display_items);
		return $smarty->fetch('amazon_settlements.html');
	}
}

