<?php
/**
 * AppointmentSlotReport
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Services
 *
 * With the Services API, you can build applications that help service providers get and modify their service orders and manage their resources.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ServiceV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * AppointmentSlotReport Class Doc Comment
 *
 * @category Class
 * @description Availability information as per the service context queried.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class AppointmentSlotReport extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'AppointmentSlotReport';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'scheduling_type' => 'string',
        'start_time' => 'string',
        'end_time' => 'string',
        'appointment_slots' => '\SellingPartnerApi\Model\ServiceV1\AppointmentSlot[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'scheduling_type' => null,
        'start_time' => null,
        'end_time' => null,
        'appointment_slots' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'scheduling_type' => 'schedulingType',
        'start_time' => 'startTime',
        'end_time' => 'endTime',
        'appointment_slots' => 'appointmentSlots'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'scheduling_type' => 'setSchedulingType',
        'start_time' => 'setStartTime',
        'end_time' => 'setEndTime',
        'appointment_slots' => 'setAppointmentSlots'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'scheduling_type' => 'getSchedulingType',
        'start_time' => 'getStartTime',
        'end_time' => 'getEndTime',
        'appointment_slots' => 'getAppointmentSlots'
    ];



    const SCHEDULING_TYPE_REAL_TIME_SCHEDULING = 'REAL_TIME_SCHEDULING';
    const SCHEDULING_TYPE_NON_REAL_TIME_SCHEDULING = 'NON_REAL_TIME_SCHEDULING';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSchedulingTypeAllowableValues()
    {
        $baseVals = [
            self::SCHEDULING_TYPE_REAL_TIME_SCHEDULING,
            self::SCHEDULING_TYPE_NON_REAL_TIME_SCHEDULING,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['scheduling_type'] = $data['scheduling_type'] ?? null;
        $this->container['start_time'] = $data['start_time'] ?? null;
        $this->container['end_time'] = $data['end_time'] ?? null;
        $this->container['appointment_slots'] = $data['appointment_slots'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        $allowedValues = $this->getSchedulingTypeAllowableValues();
        if (
            !is_null($this->container['scheduling_type']) &&
            !in_array(strtoupper($this->container['scheduling_type']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'scheduling_type', must be one of '%s'",
                $this->container['scheduling_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }


    /**
     * Gets scheduling_type
     *
     * @return string|null
     */
    public function getSchedulingType()
    {
        return $this->container['scheduling_type'];
    }

    /**
     * Sets scheduling_type
     *
     * @param string|null $scheduling_type Defines the type of slots.
     *
     * @return self
     */
    public function setSchedulingType($scheduling_type)
    {
        $allowedValues = $this->getSchedulingTypeAllowableValues();
        if (!is_null($scheduling_type) &&!in_array(strtoupper($scheduling_type), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'scheduling_type', must be one of '%s'",
                    $scheduling_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['scheduling_type'] = $scheduling_type;

        return $this;
    }
    /**
     * Gets start_time
     *
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->container['start_time'];
    }

    /**
     * Sets start_time
     *
     * @param string|null $start_time Start Time from which the appointment slots are generated in ISO 8601 format.
     *
     * @return self
     */
    public function setStartTime($start_time)
    {
        $this->container['start_time'] = $start_time;

        return $this;
    }
    /**
     * Gets end_time
     *
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->container['end_time'];
    }

    /**
     * Sets end_time
     *
     * @param string|null $end_time End Time up to which the appointment slots are generated in ISO 8601 format.
     *
     * @return self
     */
    public function setEndTime($end_time)
    {
        $this->container['end_time'] = $end_time;

        return $this;
    }
    /**
     * Gets appointment_slots
     *
     * @return \SellingPartnerApi\Model\ServiceV1\AppointmentSlot[]|null
     */
    public function getAppointmentSlots()
    {
        return $this->container['appointment_slots'];
    }

    /**
     * Sets appointment_slots
     *
     * @param \SellingPartnerApi\Model\ServiceV1\AppointmentSlot[]|null $appointment_slots A list of time windows along with associated capacity in which the service can be performed.
     *
     * @return self
     */
    public function setAppointmentSlots($appointment_slots)
    {
        $this->container['appointment_slots'] = $appointment_slots;

        return $this;
    }
}


