<?php
/**
 * OtherDeliveryAttributes
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools. The Orders API only supports orders that are less than two years old. Orders more than two years old will not show in the API response.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;

use SellingPartnerApi\Model\ModelInterface;

/**
 * OtherDeliveryAttributes Class Doc Comment
 *
 * @category Class
 * @description Miscellaneous delivery attributes associated with the shipping address.
 * @package  SellingPartnerApi
 * @group 
 */
class OtherDeliveryAttributes
{
    public $value;

    /**
     * Possible values of this enum
     */
    const HAS_ACCESS_POINT = 'HAS_ACCESS_POINT';
    const PALLET_ENABLED = 'PALLET_ENABLED';
    const PALLET_DISABLED = 'PALLET_DISABLED';
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public static function getAllowableEnumValues()
    {
        $baseVals = [
            self::HAS_ACCESS_POINT,
            self::PALLET_ENABLED,
            self::PALLET_DISABLED,
        ];
        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        $ucVals = array_map(function ($val) { return strtoupper($val); }, $baseVals);
        return array_merge($baseVals, $ucVals);
    }

    public function __construct($value)
    {
        if (is_null($value) || !in_array($value, self::getAllowableEnumValues(), true)) {
            throw new \InvalidArgumentException(sprintf("Invalid value %s for enum 'OtherDeliveryAttributes', must be one of '%s'", $value, implode("', '", self::getAllowableEnumValues())));
        }

        $this->value = $value;
    }

    /**
     * Convert the enum value to a string.
     *
     * @return string
     */
    public function __toString()
    {
        return $this->value;
    }
}


