<?php
namespace YES4Trade\Model;
class umsatzstatistik_csv
{
    const csv_delimiter = "\t";
    const csv_eol = "\n";

    var $stats;
    public function __construct( $stats ){
        $this->stats = $stats;
    }
    
    public static function get_csv_header(){
        return [
            TEXT_ZEITRAUM,'pID',TEXT_ARTIKELNAME,TEXT_ANZAHL,TEXT_ARTNR,TEXT_WARENWERT_BRUTTO
        ];
    }
    
    public function get_csv_data(){
        $csv = [];
        foreach($this->stats as $s){
            foreach($s->getProducts() as $p ){
                $csv[] = [
                    $s->getTitle(),
                    $p['id'],
                    $p['name'],
                    $p['qty'],
                    $p['model'],
                    $p['final_price']
                ];
            }
        }
        return $csv;
    }
    
    public function get_csv(){
        $csv = implode( self::csv_delimiter, self::get_csv_header()).self::csv_eol;
        foreach( $this->get_csv_data() as $line){
            $csv .= implode( self::csv_delimiter, $line).self::csv_eol;
        }
        return $csv;
    }
}

