<?php

namespace YES4Trade\Model;

class products_distributors extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'products_distributors';
    const TABLE_INDEX = 'id';

    private static $propertyTypes = [
        'id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'distributor_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'distributor_id'
        ],
        'distributor_products_number' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'distributor_products_number'
        ],
        'mindestbestellmenge' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'mindestbestellmenge'
        ],
        'distributor_products_link' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'distributor_products_link'
        ],
        'is_default' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'is_default'
        ],
        'comments' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'comments'
        ],
        'payment_terms' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'payment_terms'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_id(int $id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

        public static function get_by_products_id_and_distributor_id( int $products_id, int $distributor_id, array $select_fields = []){
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                    $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE products_id=:products_id AND distributor_id=:distributor_id",
                        $select_field_string,self::TABLE_NAME
                ),['products_id'=>$products_id,'distributor_id'=>$distributor_id]
            );
            if(!sizeOf($query)){
                return null;
            }
            $record = current($query);
            return new self(self::convert_values($record,self::$propertyTypes));
        }
        
        public static function unset_default_for_products_id( int $products_id){
            yes_query(sprintf(
                "UPDATE %s SET is_default=0 WHERE products_id=:id",
                self::TABLE_NAME
            ),['id'=>$products_id]);
        }
        
        public static function is_default_from_products_id(int $products_id):bool{
            $query = yes_query(sprintf(
                "SELECT id FROM %s WHERE products_id=:id AND is_default=1",
                        self::TABLE_NAME
                ),['id'=>$products_id]
            );
            if(!sizeOf($query)){
                return false;
            }
            return true;
        }
        
        /**
         * gibt ein Array aller distributor_ids zu einem Artikel zurueck
         * @param int $products_id
         * @return array
         */
        public static function get_distributor_id_array_from_products_id(int $products_id):array{
            $items = [];
            $query_raw = yes_query(sprintf(
                "select DISTINCT distributor_id FROM %s WHERE products_id=:id",
                    self::TABLE_NAME,
                ),['id'=>$products_id]
            );
            foreach($query as $record){
                $items[] = $record['distributor_id'];
            }
            return $items;
        }
        
        public static function get_by_products_id(int $products_id, array $select_fields = []):array{
            $items = [];
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                    $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE products_id=:id",
                        $select_field_string,self::TABLE_NAME
                ),['id'=>$products_id]
            );
            foreach($query as $record){
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }
}
